/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.function.parser.common;

import com.geoway.atlas.function.parser.FunctionDSLBaseBaseVisitor;
import com.geoway.atlas.function.parser.FunctionDSLBaseParser;
import com.geoway.atlas.function.parser.common.FunctionParserUtils;
import com.geoway.atlas.function.parser.common.FunctionPlan;
import com.geoway.atlas.function.parser.common.FunctionPlanFactory;
import com.geoway.atlas.function.parser.common.QualifiedName;
import java.math.BigDecimal;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;

public class FunctionDSLAstBuilder
extends FunctionDSLBaseBaseVisitor<Object> {
    @Override
    public FunctionPlan visitSingleStatement(FunctionDSLBaseParser.SingleStatementContext ctx) {
        return (FunctionPlan)this.visit((ParseTree)ctx.functionExpression());
    }

    @Override
    public QualifiedName visitQualifiedNameVal(FunctionDSLBaseParser.QualifiedNameValContext ctx) {
        QualifiedName qualifiedName = new QualifiedName();
        for (FunctionDSLBaseParser.IdentifierContext identifierContext : ctx.qualifiedName().identifier()) {
            qualifiedName.add(((String)this.visit((ParseTree)identifierContext)).toLowerCase());
        }
        return qualifiedName;
    }

    @Override
    public FunctionPlan visitFunctionCall(FunctionDSLBaseParser.FunctionCallContext ctx) {
        String functionName = (String)this.visit((ParseTree)ctx.functionName());
        Object[] args = new Object[ctx.argument.size()];
        for (int i = 0; i < ctx.argument.size(); ++i) {
            args[i] = this.visit((ParseTree)ctx.argument.get(i));
        }
        return FunctionPlanFactory.getFunctionPlan(functionName, args);
    }

    @Override
    public String visitFunctionName(FunctionDSLBaseParser.FunctionNameContext ctx) {
        if (ctx.identFunc != null && StringUtils.isNotBlank((CharSequence)ctx.identFunc.getText())) {
            return ctx.identFunc.getText();
        }
        return String.join((CharSequence)".", this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public QualifiedName visitQualifiedName(FunctionDSLBaseParser.QualifiedNameContext ctx) {
        QualifiedName qualifiedName = new QualifiedName();
        for (FunctionDSLBaseParser.IdentifierContext identifierContext : ctx.identifier()) {
            qualifiedName.add((String)this.visit((ParseTree)identifierContext));
        }
        return qualifiedName;
    }

    @Override
    public String visitUnquotedIdentifier(FunctionDSLBaseParser.UnquotedIdentifierContext ctx) {
        if (ctx != null && ctx.IDENTIFIER() != null) {
            return ctx.IDENTIFIER().getSymbol().getText();
        }
        return null;
    }

    @Override
    public Object visitQuotedIdentifierAlternative(FunctionDSLBaseParser.QuotedIdentifierAlternativeContext ctx) {
        return this.visit((ParseTree)ctx.quotedIdentifier());
    }

    @Override
    public String visitQuotedIdentifier(FunctionDSLBaseParser.QuotedIdentifierContext ctx) {
        if (ctx != null && ctx.BACKQUOTED_IDENTIFIER() != null) {
            return ctx.BACKQUOTED_IDENTIFIER().getSymbol().getText();
        }
        return null;
    }

    @Override
    public Object visitNullLiteral(FunctionDSLBaseParser.NullLiteralContext ctx) {
        return null;
    }

    @Override
    public String visitStringLiteral(FunctionDSLBaseParser.StringLiteralContext ctx) {
        return this.createString(ctx);
    }

    private String createString(FunctionDSLBaseParser.StringLiteralContext ctx) {
        return ctx.stringLit().stream().map(this::visitStringLit).map(FunctionParserUtils::string).collect(Collectors.joining());
    }

    @Override
    public Token visitStringLit(FunctionDSLBaseParser.StringLitContext ctx) {
        if (ctx != null && ctx.STRING_LITERAL() != null) {
            return ctx.STRING_LITERAL().getSymbol();
        }
        return null;
    }

    @Override
    public Boolean visitBooleanValue(FunctionDSLBaseParser.BooleanValueContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Double visitExponentLiteral(FunctionDSLBaseParser.ExponentLiteralContext ctx) {
        return Double.valueOf(this.numericLiteral(ctx, ctx.getText(), new BigDecimal(Double.MIN_VALUE), new BigDecimal(Double.MAX_VALUE), "double"));
    }

    @Override
    public BigDecimal visitDecimalLiteral(FunctionDSLBaseParser.DecimalLiteralContext ctx) {
        return new BigDecimal(ctx.getText());
    }

    @Override
    public Object visitIntegerLiteral(FunctionDSLBaseParser.IntegerLiteralContext ctx) {
        BigDecimal bd = new BigDecimal(ctx.getText());
        if (bd.compareTo(new BigDecimal(Integer.MIN_VALUE)) >= 0 && bd.compareTo(new BigDecimal(Integer.MAX_VALUE)) <= 0) {
            return bd.intValue();
        }
        return bd.longValue();
    }

    @Override
    public Long visitBigIntLiteral(FunctionDSLBaseParser.BigIntLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return Long.valueOf(this.numericLiteral(ctx, rawStrippedQualifier, new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE), "long"));
    }

    @Override
    public Double visitDoubleLiteral(FunctionDSLBaseParser.DoubleLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return Double.valueOf(this.numericLiteral(ctx, rawStrippedQualifier, new BigDecimal(Double.MIN_VALUE), new BigDecimal(Double.MAX_VALUE), "double"));
    }

    @Override
    public Float visitFloatLiteral(FunctionDSLBaseParser.FloatLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return Float.valueOf(this.numericLiteral(ctx, rawStrippedQualifier, new BigDecimal(1.4E-45f), new BigDecimal(3.4028234663852886E38), "float"));
    }

    private String numericLiteral(FunctionDSLBaseParser.NumberContext ctx, String rawStrippedQualifier, BigDecimal minValue, BigDecimal maxValue, String typeName) {
        BigDecimal rawBigDecimal = new BigDecimal(rawStrippedQualifier);
        if (rawBigDecimal.compareTo(minValue) < 0 || rawBigDecimal.compareTo(maxValue) > 0) {
            throw new RuntimeException(String.format("\u503c %s \u8d8a\u754c\uff0c\u5fc5\u987b\u5728\u6570\u636e\u7c7b\u578b %s \u7684\u503c\u57df[%s, %s]\u8303\u56f4\u5185", rawStrippedQualifier, typeName, minValue.toString(), maxValue.toString()));
        }
        return rawStrippedQualifier;
    }
}

