/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.controller.pkg;

import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.service.pkg.GraphAnalysisServer;
import com.geoway.atlas.web.api.v2.utils.MapUtils;
import com.geoway.atlas.web.api.v2.utils.TaskUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u56fe\u8c31\u5206\u6790\u7ec4\u5408\u7b97\u5b50", tags={"\u56fe\u8c31\u5206\u6790\u7ec4\u5408\u7b97\u5b50"})
@RequestMapping(value={"/api/v2/package/analysis/graph"})
@RestController
@CrossOrigin(origins={"*"})
public class GraphAnalysisController {
    @Autowired
    private Constants constants;
    @Autowired
    private GraphAnalysisServer graphAnalysisServer;

    @ApiOperation(value="\u5355\u6e90\u6700\u77ed\u8def\u5f84")
    @ApiImplicitParams(value={@ApiImplicitParam(name="atlas_data_base_identity", value="\u8bbe\u7f6e\u57fa\u7840\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_process_bfs_source_filter", value="\u8bbe\u7f6e\u6e90\u8282\u70b9\u7b5b\u9009\u6761\u4ef6", required=true), @ApiImplicitParam(name="atlas_process_bfs_target_filter", value="\u8bbe\u7f6e\u76ee\u6807\u8282\u70b9\u7b5b\u9009\u6761\u4ef6", required=true), @ApiImplicitParam(name="atlas_process_bfs_edge_filter", value="\u8bbe\u7f6e\u8fb9\u7b5b\u9009\u6761\u4ef6"), @ApiImplicitParam(name="atlas_process_bfs_max_path", value="\u8bbe\u7f6e\u8fd4\u56de\u8def\u5f84\u6700\u591a\u6570\u91cf", defaultValue="10"), @ApiImplicitParam(name="atlas_process_bfs_edge_new_class", value="\u65b0\u589e\u8fb9\u6807\u8bc6"), @ApiImplicitParam(name="atlas_data_result_identity", value="\u8bbe\u7f6e\u7ed3\u679c\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_data_result_persist_disk", value="\u662f\u5426\u6301\u4e45\u5316\u5b58\u50a8"), @ApiImplicitParam(name="atlas_data_result_persist_url", value="\u6301\u4e45\u5316\u5b58\u50a8url"), @ApiImplicitParam(name="atlas_storage_write_is_append", value="\u662f\u5426\u8ffd\u52a0\u5199\u5165"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @RequestMapping(value={"/bfs"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @AsyncDeal
    public Map<String, Object> graphIoProcess(@RequestParam(value="atlas_data_base_identity") String baseIdentity, @RequestParam(value="atlas_process_bfs_source_filter") String sourceFilter, @RequestParam(value="atlas_process_bfs_target_filter") String targetFilter, @RequestParam(value="atlas_process_bfs_edge_filter", required=false) String edgeFilter, @RequestParam(value="atlas_process_bfs_max_path", required=false, defaultValue="10") Integer maxPath, @RequestParam(value="atlas_process_bfs_edge_new_class", required=false) String edgeNewClass, @RequestParam(value="atlas_data_result_identity") String resultIdentity, @RequestParam(value="atlas_data_result_persist_disk", required=false, defaultValue="false") boolean persistDisk, @RequestParam(value="atlas_data_result_persist_url", required=false) String persistUrl, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId, Map<String, String> paramMaps) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        MapUtils.filterKeys(paramMaps, Arrays.asList("atlas.data.base.identity", "atlas.data.result.identity", "atlas.data.result.persist.disk", "atlas.data.result.persist.url", "taskid", "jobid"));
        return this.graphAnalysisServer.commonProcess(baseIdentity, this.constants.bfsProcessName(), paramMaps, resultIdentity, persistDisk, persistUrl, nTaskId, jobId, "\u5b8c\u6210\u8ba1\u7b97\u5355\u6e90\u6700\u77ed\u8def\u5f84");
    }

    @ApiOperation(value="\u6700\u5927\u8fde\u901a\u5b50\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="atlas_data_base_identity", value="\u8bbe\u7f6e\u57fa\u7840\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_process_graph_connected_field", value="\u8bbe\u7f6e\u8fde\u901a\u5206\u91cf\u5b57\u6bb5", required=true), @ApiImplicitParam(name="atlas_data_result_identity", value="\u8bbe\u7f6e\u7ed3\u679c\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_data_result_persist_disk", value="\u662f\u5426\u6301\u4e45\u5316\u5b58\u50a8"), @ApiImplicitParam(name="atlas_data_result_persist_url", value="\u6301\u4e45\u5316\u5b58\u50a8url"), @ApiImplicitParam(name="atlas_storage_write_is_append", value="\u662f\u5426\u8ffd\u52a0\u5199\u5165"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @RequestMapping(value={"/connected-graph"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @AsyncDeal
    public Map<String, Object> connectedGraph(@RequestParam(value="atlas_data_base_identity") String baseIdentity, @RequestParam(value="atlas_process_graph_connected_field") String connectedField, @RequestParam(value="atlas_data_result_identity") String resultIdentity, @RequestParam(value="atlas_data_result_persist_disk", required=false, defaultValue="false") boolean persistDisk, @RequestParam(value="atlas_data_result_persist_url", required=false) String persistUrl, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId, Map<String, String> paramMaps) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        MapUtils.filterKeys(paramMaps, Arrays.asList("atlas.data.base.identity", "atlas.data.result.identity", "atlas.data.result.persist.disk", "atlas.data.result.persist.url", "taskid", "jobid"));
        return this.graphAnalysisServer.commonProcess(baseIdentity, this.constants.connectedGraphProcessName(), paramMaps, resultIdentity, persistDisk, persistUrl, nTaskId, jobId, "\u5b8c\u6210\u8ba1\u7b97\u6700\u5927\u8fde\u901a\u5b50\u56fe");
    }

    @ApiOperation(value="\u6807\u7b7e\u4f20\u64ad\u7b97\u6cd5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="atlas_data_base_identity", value="\u8bbe\u7f6e\u57fa\u7840\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_process_lpa_label_field", value="\u8bbe\u7f6e\u6807\u7b7e\u5b57\u6bb5", required=true), @ApiImplicitParam(name="atlas_process_lpa_max_iter", value="\u8bbe\u7f6e\u6700\u5927\u8fed\u4ee3\u6b21\u6570"), @ApiImplicitParam(name="atlas_data_result_identity", value="\u8bbe\u7f6e\u7ed3\u679c\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_data_result_persist_disk", value="\u662f\u5426\u6301\u4e45\u5316\u5b58\u50a8"), @ApiImplicitParam(name="atlas_data_result_persist_url", value="\u6301\u4e45\u5316\u5b58\u50a8url"), @ApiImplicitParam(name="atlas_storage_write_is_append", value="\u662f\u5426\u8ffd\u52a0\u5199\u5165"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @RequestMapping(value={"/label-propagation"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @AsyncDeal
    public Map<String, Object> labelPropagation(@RequestParam(value="atlas_data_base_identity") String baseIdentity, @RequestParam(value="atlas_process_lpa_label_field") String labelField, @RequestParam(value="atlas_process_lpa_max_iter", required=false, defaultValue="30") Integer maxIter, @RequestParam(value="atlas_data_result_identity") String resultIdentity, @RequestParam(value="atlas_data_result_persist_disk", required=false, defaultValue="false") boolean persistDisk, @RequestParam(value="atlas_data_result_persist_url", required=false) String persistUrl, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId, Map<String, String> paramMaps) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        MapUtils.filterKeys(paramMaps, Arrays.asList("atlas.data.base.identity", "atlas.data.result.identity", "atlas.data.result.persist.disk", "atlas.data.result.persist.url", "taskid", "jobid"));
        return this.graphAnalysisServer.commonProcess(baseIdentity, this.constants.labelPropagationProcessName(), paramMaps, resultIdentity, persistDisk, persistUrl, nTaskId, jobId, "\u5b8c\u6210\u6807\u7b7e\u4f20\u64ad\u7b97\u6cd5!");
    }

    @ApiOperation(value="\u7f51\u9875\u6392\u540d\u7b97\u6cd5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="atlas_data_base_identity", value="\u8bbe\u7f6e\u57fa\u7840\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_process_pagerank_rank_field", value="\u8bbe\u7f6e\u6392\u540d\u5b57\u6bb5", required=true), @ApiImplicitParam(name="atlas_process_pagerank_weight_field", value="\u8bbe\u7f6e\u6743\u91cd\u5b57\u6bb5", required=true), @ApiImplicitParam(name="atlas_process_pagerank_max_iter", value="\u8bbe\u7f6e\u6700\u5927\u8fed\u4ee3\u6b21\u6570"), @ApiImplicitParam(name="atlas_data_result_identity", value="\u8bbe\u7f6e\u7ed3\u679c\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_data_result_persist_disk", value="\u662f\u5426\u6301\u4e45\u5316\u5b58\u50a8"), @ApiImplicitParam(name="atlas_data_result_persist_url", value="\u6301\u4e45\u5316\u5b58\u50a8url"), @ApiImplicitParam(name="atlas_storage_write_is_append", value="\u662f\u5426\u8ffd\u52a0\u5199\u5165"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @RequestMapping(value={"/page-rank"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @AsyncDeal
    public Map<String, Object> pageRank(@RequestParam(value="atlas_data_base_identity") String baseIdentity, @RequestParam(value="atlas_process_pagerank_rank_field") String rankField, @RequestParam(value="atlas_process_pagerank_weight_field") String weightField, @RequestParam(value="atlas_process_pagerank_max_iter", required=false, defaultValue="30") Integer maxIter, @RequestParam(value="atlas_data_result_identity") String resultIdentity, @RequestParam(value="atlas_data_result_persist_disk", required=false, defaultValue="false") boolean persistDisk, @RequestParam(value="atlas_data_result_persist_url", required=false) String persistUrl, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId, Map<String, String> paramMaps) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        MapUtils.filterKeys(paramMaps, Arrays.asList("atlas.data.base.identity", "atlas.data.result.identity", "atlas.data.result.persist.disk", "atlas.data.result.persist.url", "taskid", "jobid"));
        return this.graphAnalysisServer.commonProcess(baseIdentity, this.constants.pageRankProcessName(), paramMaps, resultIdentity, persistDisk, persistUrl, nTaskId, jobId, "\u5b8c\u6210\u7f51\u9875\u6392\u540d\u7b97\u6cd5!");
    }

    @ApiOperation(value="\u8ba1\u6570\u4e09\u89d2\u5f62")
    @ApiImplicitParams(value={@ApiImplicitParam(name="atlas_data_base_identity", value="\u8bbe\u7f6e\u57fa\u7840\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_process_triangle_count_field", value="\u8bbe\u7f6e\u8ba1\u6570\u5b57\u6bb5", required=true), @ApiImplicitParam(name="atlas_data_result_identity", value="\u8bbe\u7f6e\u7ed3\u679c\u56fe\u5c42\u6807\u8bc6", required=true), @ApiImplicitParam(name="atlas_data_result_persist_disk", value="\u662f\u5426\u6301\u4e45\u5316\u5b58\u50a8"), @ApiImplicitParam(name="atlas_data_result_persist_url", value="\u6301\u4e45\u5316\u5b58\u50a8url"), @ApiImplicitParam(name="atlas_storage_write_is_append", value="\u662f\u5426\u8ffd\u52a0\u5199\u5165"), @ApiImplicitParam(name="taskid", defaultValue="", value="\u4f5c\u4e1aid"), @ApiImplicitParam(name="jobid", defaultValue="", value="\u4efb\u52a1\u9879id")})
    @RequestMapping(value={"/triangle-count"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @AsyncDeal
    public Map<String, Object> triangleCount(@RequestParam(value="atlas_data_base_identity") String baseIdentity, @RequestParam(value="atlas_process_triangle_count_field") String countField, @RequestParam(value="atlas_data_result_identity") String resultIdentity, @RequestParam(value="atlas_data_result_persist_disk", required=false, defaultValue="false") boolean persistDisk, @RequestParam(value="atlas_data_result_persist_url", required=false) String persistUrl, @RequestParam(value="taskid", defaultValue="", required=false) String taskId, @RequestParam(value="jobid", defaultValue="", required=false) String jobId, Map<String, String> paramMaps) {
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        MapUtils.filterKeys(paramMaps, Arrays.asList("atlas.data.base.identity", "atlas.data.result.identity", "atlas.data.result.persist.disk", "atlas.data.result.persist.url", "taskid", "jobid"));
        return this.graphAnalysisServer.commonProcess(baseIdentity, this.constants.triangleCountProcessName(), paramMaps, resultIdentity, persistDisk, persistUrl, nTaskId, jobId, "\u5b8c\u6210\u8ba1\u6570\u4e09\u89d2\u5f62\u7b97\u6cd5!");
    }
}

