/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.exception;

import com.geoway.atlas.web.api.v2.exception.ExceptionDeal;
import com.geoway.atlas.web.api.v2.utils.AccessLogBuilder;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class ExceptionAop {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAop.class);

    @Around(value="@annotation(exdel)")
    public Map<String, Object> handleException(ProceedingJoinPoint point, ExceptionDeal exdel) {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        if (exdel.isLog()) {
            log.info(AccessLogBuilder.getLog(request));
        }
        try {
            return (Map)point.proceed(point.getArgs());
        }
        catch (Throwable throwable) {
            return ResponseBuilder.buildFailed(throwable);
        }
    }
}

