/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.job;

import com.geoway.atlas.web.api.v2.utils.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class JobPool {
    @Value(value="${async.job.threads.num}")
    private Integer nThread;

    @Bean(value={"asyncJobPool"}, destroyMethod="shutdownNow")
    public ExecutorService getThreadPool() {
        return Executors.newFixedThreadPool(this.nThread, ThreadFactoryBuilder.getNamedThreadFactory("asyncJobPool"));
    }

    @Bean(value={"rpcClientPool"}, destroyMethod="shutdownNow")
    public ExecutorService getRpcClientPool() {
        return Executors.newFixedThreadPool(this.nThread, ThreadFactoryBuilder.getNamedThreadFactory("rpcClientPool"));
    }

    @Bean(value={"rpcServerPool"}, destroyMethod="shutdownNow")
    public ExecutorService getRpcServerPool() {
        return Executors.newFixedThreadPool(this.nThread, ThreadFactoryBuilder.getNamedThreadFactory("rpcServerPool"));
    }
}

