/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.pkg.impl;

import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.utils.UUIDUtils;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataTag;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.dto.pack.CreateOidLayerInfo;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import com.geoway.atlas.web.api.v2.service.DataServer;
import com.geoway.atlas.web.api.v2.service.ProcessServer;
import com.geoway.atlas.web.api.v2.service.pkg.SpatialStatisticServer;
import com.geoway.atlas.web.api.v2.utils.AtlasTagUtils;
import com.geoway.atlas.web.api.v2.utils.InputParamUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import com.geoway.atlas.web.api.v2.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpatialStatisticServerImpl
implements SpatialStatisticServer {
    private static final Logger log = LoggerFactory.getLogger(SpatialStatisticServerImpl.class);
    @Autowired
    private DataServer dataServer;
    @Autowired
    private ProcessServer processServer;
    @Autowired
    private RpcClientProxy client;
    @Autowired
    private Constants constants;

    @Override
    public Map<String, Object> calculateProcess(String baseIdentity, Map<String, String> calculateAreaParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = this.constants.calculateProcessName();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(calculateAreaParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, calculateAreaParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u9762\u79ef\u8ba1\u7b97\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> groupByProcess(String baseIdentity, String filterSql, Map<String, String> groupByParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(filterSql), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String filterLayerName = this.filter(baseLayerName, filterSql, null, taskId, jobId);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(filterLayerName), this.constants.statisticProcessName(), groupByParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u5206\u7ec4\u7edf\u8ba1\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> byDictProcess(String baseIdentity, String filterSql, Map<String, String> byColParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(filterSql), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String filterLayerName = this.filter(baseLayerName, filterSql, null, taskId, jobId);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(filterLayerName), this.constants.statisticByColumnProcessName(), byColParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u5206\u7ec4\u7edf\u8ba1\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> byShapeProcess(String baseIdentity, String filterSql, String staticIdentity, String rowPropertyField, String valueField, Map<String, String> byShapeParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(filterSql), taskId, UUIDUtils.getUUID());
        String staticLayerName = this.dataServer.loadVectorLayer(staticIdentity, new HashMap<String, String>(), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String baseLayerShapeName = this.getShapeField(baseLayerName, taskId);
        String nAreaName = "area_" + Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)4));
        String calAreaLayer = this.calArea(baseLayerName, taskId, nAreaName);
        String filterBaseLayerName = this.filter(calAreaLayer, filterSql, (baseLayerShapeName + "," + rowPropertyField.trim() + "," + valueField.trim() + "," + nAreaName).toLowerCase(), taskId, UUIDUtils.getUUID());
        String suffix = Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)2));
        String oidName = "oid_" + Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)4));
        CreateOidLayerInfo createOidLayerInfo = this.createOid(staticLayerName, taskId, oidName);
        String overlayOidName = createOidLayerInfo.getOidName() + "_" + suffix;
        this.client.getSparkRpcClientApi().persistData(AtlasTagUtils.getAtlasRpcDataTag(createOidLayerInfo.getLayerName()), taskId, UUIDUtils.getUUID());
        log.info("\u5b8c\u6210" + createOidLayerInfo.getLayerName() + "\u6570\u636e\u6301\u4e45\u5316!");
        String overlayName = this.overlayNoRepair(createOidLayerInfo.getLayerName(), suffix, filterBaseLayerName, null, taskId, UUIDUtils.getUUID());
        String reCalAreaLayer = this.reCalArea(overlayName, nAreaName, valueField.trim(), taskId);
        String nStaticLayerNM = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_st_" + UUIDUtils.getUUID();
        byShapeParams.put(this.constants.staticByColPropertyField(), overlayOidName);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(reCalAreaLayer), this.constants.statisticByColumnProcessName(), byShapeParams, AtlasTagUtils.getAtlasRpcDataTag(nStaticLayerNM), taskId, UUIDUtils.getUUID());
        log.info(message);
        String nJoinLayerNM = createOidLayerInfo.isDelete() ? AtlasDataName.TEMP_LAYER_PREFIX() + "_o_j_" + UUIDUtils.getUUID() : resultLayerName;
        HashMap<String, String> fieldJoinParams = new HashMap<String, String>();
        fieldJoinParams.put(this.constants.fieldJoinLeftBaseFields(), createOidLayerInfo.getOidName());
        fieldJoinParams.put(this.constants.fieldJoinRightBaseFields(), overlayOidName);
        String message2 = this.client.getSparkRpcClientApi().binaryProcess(AtlasTagUtils.getAtlasRpcDataTag(createOidLayerInfo.getLayerName()), AtlasTagUtils.getAtlasRpcDataTag(nStaticLayerNM), this.constants.fieldJoinProcessName(), fieldJoinParams, AtlasTagUtils.getAtlasRpcDataTag(nJoinLayerNM), taskId, UUIDUtils.getUUID());
        log.info(message2);
        if (createOidLayerInfo.isDelete()) {
            HashMap<String, String> fieldRemoveParams = new HashMap<String, String>();
            fieldRemoveParams.put(this.constants.fieldRemoveProcessRmFields(), createOidLayerInfo.getOidName());
            String message3 = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(nJoinLayerNM), this.constants.fieldRemoveProcessName(), fieldRemoveParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
            log.info(message3);
        }
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u5206\u7ec4\u7edf\u8ba1\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> gridStatistic(String baseIdentity, boolean saveShape, Map<String, String> geosotParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(geosotParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        RpcDescDataRespond baseLayerDescResponse = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), taskId, UUIDUtils.getUUID());
        String geoField = (String)baseLayerDescResponse.getDataDescMap().get(this.constants.dataDescDefaultGeometry());
        String geoEnv = (String)baseLayerDescResponse.getDataDescMap().get(this.constants.dataDescBoundary());
        String filterLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_grid_filter_" + RandomStringUtils.randomAlphanumeric((int)6);
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put(this.constants.filterSelectFields(), geoField + "," + geosotParams.get(this.constants.staticByColRowProperty()) + "," + geosotParams.get(this.constants.gridSplitRecomputeFields()));
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), this.constants.filterProcessName(), filterMap, AtlasTagUtils.getAtlasRpcDataTag(filterLayerName), taskId, UUIDUtils.getUUID());
        log.info("\u7f51\u683c\u7edf\u8ba1(1/5):" + message);
        String splitLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_grid_split_" + RandomStringUtils.randomAlphanumeric((int)6);
        message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(filterLayerName), this.constants.gridSplitProcessName(), geosotParams, AtlasTagUtils.getAtlasRpcDataTag(splitLayerName), taskId, UUIDUtils.getUUID());
        log.info("\u7f51\u683c\u7edf\u8ba1(2/5):" + message);
        String splitStaticLayerName = saveShape ? AtlasDataName.TEMP_LAYER_PREFIX() + "_grid_bycol" + RandomStringUtils.randomAlphanumeric((int)6) : resultLayerName;
        message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(splitLayerName), this.constants.statisticByColumnProcessName(), geosotParams, AtlasTagUtils.getAtlasRpcDataTag(splitStaticLayerName), taskId, UUIDUtils.getUUID());
        log.info("\u7f51\u683c\u7edf\u8ba1(3/5):" + message);
        if (saveShape) {
            HashMap<String, String> geoGeneratorParams = new HashMap<String, String>();
            String geomSql = Integer.parseInt(geosotParams.get(this.constants.gridSplitMode())) == this.constants.gridSplitDistinct() ? "ST_GeomFromGwGrid(" + geosotParams.get(this.constants.gridSplitCodeField()) + "," + geosotParams.get(this.constants.gridSplitCodeParam()) + ")" : "ST_GeomFromGeoSot(" + geosotParams.get(this.constants.gridSplitCodeField()) + ")";
            geoGeneratorParams.put(this.constants.geometryGeneratorSqlExpression(), geomSql);
            if (StringUtils.isNotBlank((CharSequence)geoField)) {
                geoGeneratorParams.put(this.constants.geometryGeneratorGeomName(), geoField);
                geoGeneratorParams.put(this.constants.geometryGeneratorGeomSrid(), (String)baseLayerDescResponse.getDataDescMap().get(this.constants.dataDescCrs()));
                if (StringUtils.isNotBlank((CharSequence)geoEnv)) {
                    geoGeneratorParams.put(this.constants.geometryGeneratorGeomBoundary(), geoEnv);
                }
            }
            message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(splitStaticLayerName), this.constants.geometryGeneratorProcessName(), geoGeneratorParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        } else {
            message = "\u8df3\u8fc7\u89e3\u7801\u6b65\u9aa4!";
        }
        log.info("Geosot\u7f51\u683c\u7edf\u8ba1(4/5):" + message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
            log.info("Geosot\u7f51\u683c\u7edf\u8ba1(5/5): \u5b8c\u6210\u6570\u636e\u8f93\u51fa\u5230\u6210\u679c\u5e93!");
        } else {
            log.info("Geosot\u7f51\u683c\u7edf\u8ba1(5/5): \u8df3\u8fc7\u6570\u636e\u8f93\u51fa!");
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210Geosot\u7f51\u683c\u5316\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> sqlProcess(String baseIdentity, String baseSuffix, String otherIdentity, String otherSuffix, Map<String, String> paramMaps, String resultIdentity, boolean persistDisk, String persistUrl, String nTaskId, String jobId) {
        if (StringUtils.isNotBlank((CharSequence)baseIdentity) && baseIdentity.contains(":") && StringUtils.startsWithAny((CharSequence)baseIdentity.toLowerCase(), (CharSequence[])this.constants.getAllFormats())) {
            throw new AtlasException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u76f4\u63a5\u4f5c\u4e3aSQL\u8f93\u5165\u6e90\uff0c\u5fc5\u987b\u901a\u8fc7\u7b97\u5b50\u751f\u6210\u7ed3\u679c\u56fe\u5c42\u540d\u79f0\u540e\u624d\u80fd\u63a5\u5165\uff01");
        }
        String layerName1 = this.dataServer.loadVectorLayer(baseIdentity, new HashMap<String, String>(), nTaskId, UUIDUtils.getUUID());
        AtlasRpcDataTag rpcDataTag1 = AtlasTagUtils.getAtlasRpcDataTag(layerName1);
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        AtlasRpcDataTag rpcDataTag2 = null;
        if (StringUtils.isNotBlank((CharSequence)otherIdentity)) {
            if (otherIdentity.contains(":") && StringUtils.startsWithAny((CharSequence)otherIdentity.toLowerCase(), (CharSequence[])this.constants.getAllFormats())) {
                throw new AtlasException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u76f4\u63a5\u4f5c\u4e3aSQL\u8f93\u5165\u6e90\uff0c\u5fc5\u987b\u901a\u8fc7\u7b97\u5b50\u751f\u6210\u7ed3\u679c\u56fe\u5c42\u540d\u79f0\u540e\u624d\u80fd\u63a5\u5165\uff01");
            }
            String layerName2 = this.dataServer.loadVectorLayer(otherIdentity, new HashMap<String, String>(), nTaskId, UUIDUtils.getUUID());
            rpcDataTag2 = AtlasTagUtils.getAtlasRpcDataTag(layerName2);
        }
        if (StringUtils.isNotBlank((CharSequence)baseSuffix) || StringUtils.isNotBlank((CharSequence)otherSuffix)) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)baseSuffix)) {
                sb.append(baseSuffix.trim());
            }
            if (rpcDataTag2 != null) {
                sb.append(",");
                if (StringUtils.isNotBlank((CharSequence)otherSuffix)) {
                    sb.append(otherSuffix);
                }
            }
            paramMaps.put(this.constants.sqlTableExtentSuffix(), sb.toString());
        }
        if (paramMaps.containsKey(this.constants.runSqlExpression())) {
            paramMaps.put(this.constants.runSqlExpression(), SecurityUtils.dencrypt(paramMaps.get(this.constants.runSqlExpression())));
        }
        ArrayList<AtlasRpcDataTag> atlasRpcDataTags = new ArrayList<AtlasRpcDataTag>();
        atlasRpcDataTags.add(rpcDataTag1);
        if (rpcDataTag2 != null) {
            atlasRpcDataTags.add(rpcDataTag2);
        }
        String message = this.client.getSparkRpcClientApi().listProcess(atlasRpcDataTags, this.constants.runSqlProcessName(), paramMaps, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), nTaskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, persistUrl, nTaskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210SQL\u67e5\u8be2\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> balanceDiffProcess(String baseIdentity, Map<String, String> balanceDiffParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, new HashMap<String, String>(), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), this.constants.statisticBalanceDiffName(), balanceDiffParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u5e73\u5dee\u6d41\u7a0b!");
    }

    private String filter(String layerName, String filterSql, String filterFields, String taskId, String jobId) {
        if (StringUtils.isNotBlank((CharSequence)filterSql) || StringUtils.isNotBlank((CharSequence)filterFields)) {
            String tempLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_f_" + UUIDUtils.getUUID();
            HashMap<String, String> filterParams = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)filterSql)) {
                filterParams.put(this.constants.filterExpression(), filterSql);
            }
            if (StringUtils.isNotBlank((CharSequence)filterFields)) {
                filterParams.put(this.constants.filterSelectFields(), filterFields);
            }
            String message = this.processServer.filterProcess(layerName, filterParams, tempLayerName, taskId, jobId);
            log.info(message);
            return tempLayerName;
        }
        return layerName;
    }

    private String getShapeField(String layerName, String taskId) {
        RpcDescDataRespond rpcDescDataRespond = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(layerName), taskId, UUIDUtils.getUUID());
        String baseLayerShapeName = rpcDescDataRespond.getDataDescMap().getOrDefault(this.constants.dataDescDefaultGeometry(), null);
        if (StringUtils.isBlank((CharSequence)baseLayerShapeName)) {
            throw new NotSupportException("\u4e0d\u652f\u6301\u975e\u7a7a\u95f4\u56fe\u5c42\u8fdb\u884c\u53e0\u52a0\u8d4b\u503c\u64cd\u4f5c", Thread.currentThread(), 3);
        }
        return baseLayerShapeName;
    }

    private CreateOidLayerInfo createOid(String layerName, String taskId, String nOidName) {
        Map descMap = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(layerName), taskId, UUIDUtils.getUUID()).getDataDescMap();
        boolean delete = false;
        String oidFields = "";
        String resultLayer = layerName;
        if (descMap.containsKey(this.constants.dataDescOidFields())) {
            oidFields = (String)descMap.get(this.constants.dataDescOidFields());
            if (oidFields.contains(",")) {
                log.warn("\u4e0d\u652f\u6301\u56fe\u5c42\u5305\u542b\u591a\u4e2aoid,\u9700\u8981\u91cd\u5efaoid!");
                delete = true;
            }
        } else {
            delete = true;
        }
        if (delete) {
            oidFields = nOidName;
            resultLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_id_" + UUIDUtils.getUUID();
            HashMap<String, String> createOidParams = new HashMap<String, String>();
            createOidParams.put(this.constants.createOidFieldName(), oidFields);
            createOidParams.put(this.constants.createOidLongField(), "true");
            this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(layerName), this.constants.createOidProcessName(), createOidParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayer), taskId, UUIDUtils.getUUID());
        }
        return new CreateOidLayerInfo(delete, oidFields, resultLayer);
    }

    private String calArea(String layerName, String taskId, String areaName) {
        String jobId = UUIDUtils.getUUID();
        String resultLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_a_" + jobId;
        HashMap<String, String> calAreaParams = new HashMap<String, String>();
        calAreaParams.put(this.constants.calculateTarget(), this.constants.calculateTargetStArea());
        calAreaParams.put(this.constants.calculateFieldName(), areaName);
        this.processServer.calculatorProcess(layerName, calAreaParams, resultLayer, taskId, jobId);
        return resultLayer;
    }

    private String reCalArea(String layerName, String rawArea, String reCalAreaField, String taskId) {
        String shapeField = this.getShapeField(layerName, taskId);
        String jobId = UUIDUtils.getUUID();
        String resultLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_ra_" + jobId;
        HashMap<String, String> calAreaParams = new HashMap<String, String>();
        String calSql = "st_area(" + shapeField + ") / " + rawArea + " * " + reCalAreaField;
        calAreaParams.put(this.constants.fieldCalculatorExpression(), calSql);
        calAreaParams.put(this.constants.fieldCalculatorFieldName(), reCalAreaField);
        calAreaParams.put(this.constants.fieldCalculatorIsNew(), "false");
        this.processServer.unitaryProcess(layerName, this.constants.fieldCalculatorProcessName(), calAreaParams, resultLayer, taskId, jobId);
        return resultLayer;
    }

    private String overlayNoRepair(String baseLayerName, String baseSuffix, String otherLayerName, String otherSuffix, String taskId, String jobId) {
        String preResultLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_r_" + jobId;
        HashMap<String, String> processParams = new HashMap<String, String>();
        processParams.put(this.constants.intersectionIsRepair(), "false");
        if (StringUtils.isNotBlank((CharSequence)baseSuffix)) {
            processParams.put(this.constants.intersectionLeftSuffix(), baseSuffix);
        }
        if (StringUtils.isNotBlank((CharSequence)otherSuffix)) {
            processParams.put(this.constants.intersectionRightSuffix(), otherSuffix);
        }
        this.processServer.binaryProcess(baseLayerName, otherLayerName, this.constants.intersectionProcessName(), processParams, preResultLayerName, taskId, jobId);
        log.info("\u53e0\u52a0\u6267\u884c\u7ed3\u679c\u56fe\u5c42\u4e3a:" + preResultLayerName);
        return preResultLayerName;
    }
}

