/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.pkg.impl.assigin;

import com.geoway.atlas.function.parser.common.FunctionPlan;
import com.geoway.atlas.function.parser.common.QualifiedName;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssignFunctionPlan
implements FunctionPlan {
    private static final Logger log = LoggerFactory.getLogger(AssignFunctionPlan.class);
    public static final String CURRENT_LAYER = "#0";
    public static final String LEFT_LAYER = "#1";
    public static final String RIGHT_LAYER = "#2";
    public static final String FIXED_ASSIGN_SUFFIX = "g1a2f3d7";
    public static final String FIXED_ASSIGN_LAYER_SUFFIX = "7d3f2a1g";
    private static final Pattern FIELD_PATTERN = Pattern.compile("((#[0-9]+)\\s*\\.\\s*(`.*?`|\\w+))");
    protected String RATE_NAME = "rate_7d3f2a1g";
    protected List<QualifiedName> computeFields = new ArrayList<QualifiedName>();
    protected String intersectShapeAreaName = null;
    protected String baseShapeAreaName = null;
    protected Map<String, String> defaultValueMap;
    protected boolean isConsiderNull;

    public List<QualifiedName> getReComputeFields() {
        return this.computeFields;
    }

    public boolean isNeedShapeArea() {
        return !this.isNeedRecomputeArea();
    }

    public boolean isNeedRecomputeArea() {
        return !this.getReComputeFields().isEmpty();
    }

    public List<String> getLeftRecomputeFields() {
        if (!this.computeFields.isEmpty()) {
            return this.computeFields.stream().filter(qn -> StringUtils.equals((CharSequence)qn.getFirstName(), (CharSequence)LEFT_LAYER)).map(QualifiedName::getSimpleLastName).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public List<String> getRightRecomputeFields() {
        if (!this.computeFields.isEmpty()) {
            return this.computeFields.stream().filter(qn -> StringUtils.equals((CharSequence)qn.getFirstName(), (CharSequence)RIGHT_LAYER)).map(QualifiedName::getSimpleLastName).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public abstract boolean needRepair();

    public List<String> unusedFields(List<String> fields, Map<String, String> assignFieldMap) {
        ArrayList<String> result = new ArrayList<String>(fields);
        result.removeAll(this.getAssignFieldsWithSuffix(assignFieldMap.keySet()));
        if (this.isNeedRecomputeArea()) {
            if (!this.getLeftRecomputeFields().isEmpty()) {
                result.removeAll(this.getLeftRecomputeFields());
            }
            if (!this.getRightRecomputeFields().isEmpty()) {
                result.removeAll(this.getAssignFieldsWithSuffix(this.getRightRecomputeFields()));
            }
        }
        if (this.isNeedShapeArea()) {
            result.remove(this.baseShapeAreaName);
        }
        return result;
    }

    public String getStatisticSql(String middleLayer, Collection<String> assignFields, String oidField) {
        ArrayList<String> groupFields = new ArrayList<String>();
        groupFields.add(oidField);
        groupFields.addAll(this.getAssignFieldsWithSuffix(assignFields));
        ArrayList<String> areaFields = new ArrayList<String>();
        ArrayList<String> anyValueFields = new ArrayList<String>();
        if (this.isNeedRecomputeArea()) {
            areaFields.addAll(this.getLeftRecomputeFields());
            areaFields.addAll(this.getAssignFieldsWithSuffix(this.getRightRecomputeFields()));
        }
        if (this.isNeedShapeArea()) {
            if (StringUtils.isBlank((CharSequence)this.intersectShapeAreaName)) {
                throw new AtlasException("\u6ca1\u6709\u627e\u5230ShapeArea\u5b57\u6bb5!");
            }
            areaFields.add(this.intersectShapeAreaName);
            anyValueFields.add(this.baseShapeAreaName);
        }
        String groupFieldSql = groupFields.stream().map(s -> "`" + s + "`").collect(Collectors.joining(","));
        String areaFieldSql = ", " + areaFields.stream().map(s -> "sum(" + s + ") as " + s).collect(Collectors.joining(","));
        String anyValueFieldSql = anyValueFields.isEmpty() ? "" : "," + anyValueFields.stream().map(s -> "first_value(" + s + ") as " + s).collect(Collectors.joining(","));
        return String.format("select %s %s %s from %s group by %s", groupFieldSql, areaFieldSql, anyValueFieldSql, middleLayer, groupFieldSql);
    }

    public String getAssignFuncSql(String statisticSql, String oidField, Map<String, String> assignFieldMaps) {
        String statisticViewAlias = "a_7d3f2a1g";
        String selectSql = this.getAssignSelectSql(statisticViewAlias, assignFieldMaps);
        String groupByKey = String.format("%s.%s", statisticViewAlias, oidField);
        return String.format("select %s.%s, %s from (%s) %s group by %s", statisticViewAlias, oidField, selectSql, statisticSql, statisticViewAlias, groupByKey);
    }

    protected abstract String getAssignSelectSql(String var1, Map<String, String> var2);

    protected List<String> getAssignFieldsWithSuffix(Collection<String> fieldNames) {
        if (fieldNames != null && !fieldNames.isEmpty()) {
            return fieldNames.stream().map(this::addSuffixName).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    protected String addSuffixName(String name) {
        return name + "_" + FIXED_ASSIGN_SUFFIX;
    }

    protected String replaceSqlFields(String sql, String layerAlias) {
        HashMap<String, Function<String, String>> fieldNameMap = new HashMap<String, Function<String, String>>();
        return this.replaceSqlFields(sql, layerAlias, fieldNameMap);
    }

    protected String replaceSqlFields(String sql, String layerAlias, Map<String, Function<String, String>> fieldNameMap) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = FIELD_PATTERN.matcher(sql);
        int retainStart = 0;
        while (matcher.find()) {
            if (matcher.start(1) != retainStart) {
                sb.append(StringUtils.substring((String)sql, (int)retainStart, (int)matcher.start(1)));
            }
            String layerIdentity = matcher.group(2);
            String fieldName = matcher.group(3).trim();
            if (StringUtils.equals((CharSequence)LEFT_LAYER, (CharSequence)layerIdentity)) {
                sb.append(layerAlias).append(".").append(fieldName);
            }
            if (StringUtils.equals((CharSequence)RIGHT_LAYER, (CharSequence)layerIdentity)) {
                sb.append(layerAlias).append(".");
                if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"`")) {
                    sb.append("`").append(this.addSuffixName(StringUtils.substring((String)fieldName, (int)1, (int)(fieldName.length() - 1)).trim())).append("`");
                } else {
                    sb.append(this.addSuffixName(fieldName));
                }
            }
            if (StringUtils.equals((CharSequence)CURRENT_LAYER, (CharSequence)layerIdentity)) {
                String fieldKey;
                String string = fieldKey = fieldName.startsWith("`") ? fieldName.substring(1, fieldName.length() - 1) : fieldName;
                if (fieldNameMap.containsKey(fieldKey)) {
                    sb.append(fieldNameMap.get(fieldKey).apply(layerAlias));
                } else {
                    throw new AtlasException("\u672a\u627e\u5230\u5f53\u524d\u5217\uff1a" + layerIdentity + "." + fieldName);
                }
            }
            retainStart = matcher.end(1);
        }
        if (retainStart != sql.length()) {
            sb.append(StringUtils.substring((String)sql, (int)retainStart, (int)sql.length()));
        }
        String nSql = sb.toString();
        log.info(String.format("\u539f\u59cb\u8868\u8fbe\u5f0f\u4e3a\uff1a%s\uff0c\u66ff\u6362\u5b57\u6bb5\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%s", sql, nSql));
        return nSql;
    }

    protected String getFieldNameInLayer(QualifiedName qualifiedName) {
        if (StringUtils.equals((CharSequence)LEFT_LAYER, (CharSequence)qualifiedName.getFirstName())) {
            return qualifiedName.getSimpleLastName();
        }
        if (StringUtils.equals((CharSequence)RIGHT_LAYER, (CharSequence)qualifiedName.getFirstName())) {
            return this.addSuffixName(qualifiedName.getSimpleLastName());
        }
        throw new AtlasException("\u4e0d\u652f\u6301\u89e3\u6790\u5176\u4ed6\u56fe\u5c42\u6807\u8bc6\u7684\u5b57\u6bb5\uff01");
    }

    public String getFieldSelectWithDefExpr(String viewName, Collection<String> valueSet) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (String fieldName : valueSet) {
            if (this.defaultValueMap.containsKey(fieldName) && StringUtils.isNotBlank((CharSequence)this.defaultValueMap.get(fieldName))) {
                String defaultValue = this.defaultValueMap.get(fieldName);
                if (StringUtils.equalsIgnoreCase((CharSequence)defaultValue.toString(), (CharSequence)"null")) {
                    sqlList.add(String.format("%s.%s", viewName, fieldName));
                    continue;
                }
                sqlList.add(this.getDefaultValExpr(viewName, fieldName));
                continue;
            }
            sqlList.add(this.getUndefineValExpr(viewName, fieldName));
        }
        return String.join((CharSequence)", ", sqlList);
    }

    protected abstract String getDefaultValExpr(String var1, String var2);

    protected abstract String getUndefineValExpr(String var1, String var2);

    public void setIntersectShapeAreaName(String intersectShapeAreaName) {
        this.intersectShapeAreaName = intersectShapeAreaName;
    }

    public void setBaseShapeAreaName(String baseShapeAreaName) {
        this.baseShapeAreaName = baseShapeAreaName;
    }

    public String getBaseShapeAreaName() {
        return this.baseShapeAreaName;
    }

    public void setDefaultValueMap(Map<String, String> defaultValueMap) {
        this.defaultValueMap = defaultValueMap;
    }

    public void setConsiderNull(boolean isConsiderNull) {
        this.isConsiderNull = isConsiderNull;
    }
}

