/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.common.config.AtlasSystemProperties;
import com.geoway.atlas.web.api.v2.job.JobManager;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginParallelManager {
    private static ConcurrentMap<String, ArrayBlockingQueue<Integer>> parallelManagerMap = new ConcurrentHashMap<String, ArrayBlockingQueue<Integer>>();
    private static Logger logger = LoggerFactory.getLogger(PluginParallelManager.class);
    private static final Integer PARALLEL_NUM = Integer.parseInt(AtlasSystemProperties.getProperty((String)"atlas.plugin.parallel.num", (String)"1"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runPlugin(String pluginName, Function<Object[], T> pluginFunction, Object[] pluginParams, JobManager jobManager, String jobId, String taskId) {
        block12: {
            ArrayBlockingQueue parallerManager = parallelManagerMap.computeIfAbsent(pluginName, s -> new ArrayBlockingQueue(PARALLEL_NUM, true));
            if (PluginParallelManager.checkPluginIsRunning(jobManager, jobId)) {
                try {
                    logger.info("\u5e76\u53d1\u63a7\u5236\u4efb\u52a1:" + jobId + "\u51c6\u5907\u542f\u52a8!");
                    parallerManager.put(1);
                    logger.info("\u5e76\u53d1\u63a7\u5236\u4efb\u52a1:" + jobId + "\u5df2\u542f\u52a8!");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("\u65e0\u6cd5\u6dfb\u52a0\u5230\u8fd0\u884c\u4e2d\u961f\u5217");
                }
                if (!PluginParallelManager.checkPluginIsRunning(jobManager, jobId)) break block12;
                T t = pluginFunction.apply(pluginParams);
                return t;
                finally {
                    try {
                        logger.info("\u5e76\u53d1\u63a7\u5236\u4efb\u52a1:" + jobId + "\u5df2\u5b8c\u6210!");
                        parallerManager.poll();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        throw new RuntimeException("\u4efb\u52a1: " + taskId + ", \u5de5\u4f5c\u9879: " + jobId + " \u5df2\u505c\u6b62!");
    }

    public static boolean checkPluginIsRunning(JobManager jobManager, String jobId) {
        boolean isRunning = false;
        Map<String, Object> jobResponse = jobManager.getJobInfo(jobId);
        if ("running".equals(jobResponse.get("state"))) {
            isRunning = true;
        }
        return isRunning;
    }
}

