/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.GmlObjectStore;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentState;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.LimitingVisitor;
import org.geotools.feature.visitor.UniqueCountVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.CompositePrimaryKeyFinder;
import org.geotools.jdbc.ConnectionLifecycleListener;
import org.geotools.jdbc.CoordinateSequenceDimensionExtractor;
import org.geotools.jdbc.EnumMapper;
import org.geotools.jdbc.HeuristicPrimaryKeyFinder;
import org.geotools.jdbc.Index;
import org.geotools.jdbc.InsertionClassifier;
import org.geotools.jdbc.JDBCCallbackFactory;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCState;
import org.geotools.jdbc.JDBCTransactionState;
import org.geotools.jdbc.JoinInfo;
import org.geotools.jdbc.KeysFetcher;
import org.geotools.jdbc.LifecycleConnection;
import org.geotools.jdbc.MetadataTablePrimaryKeyFinder;
import org.geotools.jdbc.NamePatternEscaping;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.NullPrimaryKey;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.TransformException;

public final class JDBCDataStore
extends ContentDataStore
implements GmlObjectStore {
    private static SoftValueHashMap<Class, Method> AGGREGATE_SETVALUE_CACHE = new SoftValueHashMap(1000);
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.jdbc.trace"));
    public static final String JDBC_NATIVE_SRID = "nativeSRID";
    public static final String JDBC_READ_ONLY = "org.geotools.jdbc.readOnly";
    public static final String JDBC_PRIMARY_KEY_COLUMN = "org.geotools.jdbc.pk.column";
    public static final String JDBC_NATIVE_TYPENAME = "org.geotools.jdbc.nativeTypeName";
    public static final String JDBC_NATIVE_TYPE = "org.geotools.jdbc.nativeType";
    public static final String JDBC_COLUMN_ALIAS = "org.geotools.jdbc.columnAlias";
    public static final String JDBC_ENUM_MAP = "org.geotools.jdbc.enumMap";
    protected static final String GEOMETRY_TABLE = "geometry";
    protected static final String MULTI_GEOMETRY_TABLE = "multi_geometry";
    protected static final String GEOMETRY_ASSOCIATION_TABLE = "geometry_associations";
    protected static final String FEATURE_RELATIONSHIP_TABLE = "feature_relationships";
    protected static final String FEATURE_ASSOCIATION_TABLE = "feature_associations";
    protected static final ReferencedEnvelope EMPTY_ENVELOPE = new ReferencedEnvelope();
    public static final int MAX_IDS_IN_FILTER = 100;
    protected DataSource dataSource;
    private Throwable disposedBy = null;
    public SQLDialect dialect;
    protected String databaseSchema;
    protected HashMap<Integer, Class<?>> sqlTypeToClassMappings;
    protected HashMap<String, Class<?>> sqlTypeNameToClassMappings;
    protected HashMap<Class<?>, Integer> classToSqlTypeMappings;
    protected HashMap<Integer, String> sqlTypeToSqlTypeNameOverrides;
    protected ConcurrentHashMap<Integer, String> dBsqlTypesCache;
    protected HashMap<Class<? extends FeatureVisitor>, String> aggregateFunctions;
    protected HashMap<String, String> supportedFunctions;
    protected boolean associations = false;
    public int fetchSize;
    protected int batchInsertSize = 1;
    protected boolean exposePrimaryKeyColumns = false;
    protected PrimaryKeyFinder primaryKeyFinder = new CompositePrimaryKeyFinder(new MetadataTablePrimaryKeyFinder(), new HeuristicPrimaryKeyFinder());
    protected Map<String, VirtualTable> virtualTables = new ConcurrentHashMap<String, VirtualTable>();
    protected List<ConnectionLifecycleListener> connectionLifecycleListeners = new CopyOnWriteArrayList<ConnectionLifecycleListener>();
    protected JDBCCallbackFactory callbackFactory = JDBCCallbackFactory.NULL;
    private volatile NamePatternEscaping namePatternEscaping;

    public void setCallbackFactory(JDBCCallbackFactory factory) {
        this.callbackFactory = factory;
    }

    public JDBCCallbackFactory getCallbackFactory() {
        return this.callbackFactory;
    }

    public JDBCFeatureSource getAbsoluteFeatureSource(String typeName) throws IOException {
        ContentFeatureSource featureSource = this.getFeatureSource(typeName);
        if (featureSource instanceof JDBCFeatureSource) {
            return (JDBCFeatureSource)featureSource;
        }
        return ((JDBCFeatureStore)featureSource).getFeatureSource();
    }

    public void createVirtualTable(VirtualTable vtable) throws IOException {
        try {
            this.virtualTables.put(vtable.getName(), new VirtualTable(vtable));
            this.entries.remove(new NameImpl(this.namespaceURI, vtable.getName()));
            this.getSchema(vtable.getName());
        }
        catch (IOException e) {
            this.virtualTables.remove(vtable.getName());
            throw e;
        }
    }

    public List<ConnectionLifecycleListener> getConnectionLifecycleListeners() {
        return this.connectionLifecycleListeners;
    }

    public VirtualTable dropVirtualTable(String name) {
        VirtualTable vt = this.virtualTables.remove(name);
        if (vt != null) {
            this.entries.remove(new NameImpl(this.namespaceURI, name));
        }
        return vt;
    }

    public Map<String, VirtualTable> getVirtualTables() {
        HashMap<String, VirtualTable> result = new HashMap<String, VirtualTable>();
        for (String key : this.virtualTables.keySet()) {
            result.put(key, new VirtualTable(this.virtualTables.get(key)));
        }
        return Collections.unmodifiableMap(result);
    }

    public PrimaryKeyFinder getPrimaryKeyFinder() {
        return this.primaryKeyFinder;
    }

    public void setPrimaryKeyFinder(PrimaryKeyFinder primaryKeyFinder) {
        this.primaryKeyFinder = primaryKeyFinder;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getBatchInsertSize() {
        return this.batchInsertSize;
    }

    public void setBatchInsertSize(int batchInsertSize) {
        this.batchInsertSize = batchInsertSize;
    }

    public boolean isExposePrimaryKeyColumns() {
        return this.exposePrimaryKeyColumns;
    }

    public void setExposePrimaryKeyColumns(boolean exposePrimaryKeyColumns) {
        if (this.exposePrimaryKeyColumns != exposePrimaryKeyColumns) {
            this.entries.clear();
        }
        this.exposePrimaryKeyColumns = exposePrimaryKeyColumns;
    }

    public SQLDialect getSQLDialect() {
        return this.dialect;
    }

    public void setSQLDialect(SQLDialect dialect) {
        if (dialect == null) {
            throw new NullPointerException();
        }
        this.dialect = dialect;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            if (TRACE_ENABLED.booleanValue()) {
                if (this.disposedBy == null) {
                    this.LOGGER.log(Level.WARNING, "JDBCDataStore was never given a DataSource.");
                    throw new IllegalStateException("DataSource not available as it was never set.");
                }
                this.LOGGER.log(Level.WARNING, "JDBCDataStore was disposed:" + this.disposedBy, this.disposedBy);
                throw new IllegalStateException("DataSource not available after calling dispose().");
            }
            throw new IllegalStateException("DataSource not available after calling dispose() or before being set.");
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.dataSource != null) {
            this.LOGGER.log(Level.FINE, "Setting DataSource on JDBCDataStore that already has DataSource set");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("JDBCDataStore's DataSource should not be set to null");
        }
        this.dataSource = dataSource;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public FilterCapabilities getFilterCapabilities() {
        if (this.dialect instanceof PreparedStatementSQLDialect) {
            return ((PreparedStatementSQLDialect)this.dialect).createPreparedFilterToSQL().getCapabilities();
        }
        return ((BasicSQLDialect)this.dialect).createFilterToSQL().getCapabilities();
    }

    public boolean isAssociations() {
        return this.associations;
    }

    public void setAssociations(boolean foreignKeyGeometries) {
        this.associations = foreignKeyGeometries;
    }

    public Map<Integer, Class<?>> getSqlTypeToClassMappings() {
        if (this.sqlTypeToClassMappings == null) {
            this.sqlTypeToClassMappings = new HashMap();
            this.dialect.registerSqlTypeToClassMappings(this.sqlTypeToClassMappings);
        }
        return this.sqlTypeToClassMappings;
    }

    public Map<String, Class<?>> getSqlTypeNameToClassMappings() {
        if (this.sqlTypeNameToClassMappings == null) {
            this.sqlTypeNameToClassMappings = new HashMap();
            this.dialect.registerSqlTypeNameToClassMappings(this.sqlTypeNameToClassMappings);
        }
        return this.sqlTypeNameToClassMappings;
    }

    public Map<Class<?>, Integer> getClassToSqlTypeMappings() {
        if (this.classToSqlTypeMappings == null) {
            HashMap classToSqlTypeMappings = new HashMap();
            this.dialect.registerClassToSqlMappings(classToSqlTypeMappings);
            this.classToSqlTypeMappings = classToSqlTypeMappings;
        }
        return this.classToSqlTypeMappings;
    }

    public Map<Integer, String> getSqlTypeToSqlTypeNameOverrides() {
        if (this.sqlTypeToSqlTypeNameOverrides == null) {
            this.sqlTypeToSqlTypeNameOverrides = new HashMap();
            this.dialect.registerSqlTypeToSqlTypeNameOverrides(this.sqlTypeToSqlTypeNameOverrides);
        }
        return this.sqlTypeToSqlTypeNameOverrides;
    }

    public ConcurrentHashMap<Integer, String> getDBsqlTypesCache() {
        if (this.dBsqlTypesCache == null) {
            this.dBsqlTypesCache = new ConcurrentHashMap();
        }
        return this.dBsqlTypesCache;
    }

    public Map<Class<? extends FeatureVisitor>, String> getAggregateFunctions() {
        if (this.aggregateFunctions == null) {
            this.aggregateFunctions = new HashMap();
            this.dialect.registerAggregateFunctions(this.aggregateFunctions);
        }
        return this.aggregateFunctions;
    }

    public Class<?> getMapping(int sqlType) {
        return this.getSqlTypeToClassMappings().get(sqlType);
    }

    public Class<?> getMapping(String sqlTypeName) {
        Class<?> columnClass = this.getSqlTypeNameToClassMappings().get(sqlTypeName);
        if (columnClass == null) {
            return this.dialect.getMapping(sqlTypeName);
        }
        return columnClass;
    }

    public Integer getMapping(Class<?> clazz) {
        Integer mapping = this.getClassToSqlTypeMappings().get(clazz);
        if (mapping == null && clazz.isArray()) {
            mapping = 2003;
        }
        if (mapping == null) {
            ArrayList matches = new ArrayList();
            for (Map.Entry<Class<?>, Integer> e : this.getClassToSqlTypeMappings().entrySet()) {
                if (!e.getKey().isAssignableFrom(clazz)) continue;
                matches.add(e);
            }
            if (!matches.isEmpty()) {
                if (matches.size() == 1) {
                    mapping = (Integer)((Map.Entry)matches.get(0)).getValue();
                } else {
                    Collections.sort(matches, (o1, o2) -> {
                        if (((Class)o1.getKey()).isAssignableFrom((Class)o2.getKey())) {
                            return 1;
                        }
                        if (((Class)o2.getKey()).isAssignableFrom((Class)o1.getKey())) {
                            return -1;
                        }
                        return 0;
                    });
                    if (((Class)((Map.Entry)matches.get(1)).getKey()).isAssignableFrom((Class)((Map.Entry)matches.get(0)).getKey())) {
                        mapping = (Integer)((Map.Entry)matches.get(0)).getValue();
                    }
                }
            }
        }
        if (mapping == null) {
            mapping = 1111;
            this.LOGGER.warning("No mapping for " + clazz.getName());
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        if (this.entry(featureType.getName()) != null) {
            String msg = "Schema '" + featureType.getName() + "' already exists";
            throw new IllegalArgumentException(msg);
        }
        Connection cx = this.createConnection();
        try {
            String sql = this.createTableSQL(featureType, cx);
            this.LOGGER.log(Level.FINE, "Create schema: {0}", sql);
            Statement st = cx.createStatement();
            try {
                st.execute(sql);
            }
            finally {
                this.closeSafe(st);
            }
            this.dialect.postCreateTable(this.databaseSchema, featureType, cx);
        }
        catch (Exception e) {
            String msg = "Error occurred creating table";
            throw (IOException)new IOException(msg).initCause(e);
        }
        finally {
            this.closeSafe(cx);
        }
    }

    public void removeSchema(String typeName) throws IOException {
        this.removeSchema(this.name(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchema(Name typeName) throws IOException {
        if (this.entry(typeName) == null) {
            String msg = "Schema '" + typeName + "' does not exist";
            throw new IllegalArgumentException(msg);
        }
        if (this.virtualTables.containsKey(typeName.getLocalPart())) {
            this.dropVirtualTable(typeName.getLocalPart());
            return;
        }
        SimpleFeatureType featureType = this.getSchema(typeName);
        Connection cx = this.createConnection();
        try {
            this.dialect.preDropTable(this.databaseSchema, featureType, cx);
            String sql = this.dropTableSQL(featureType, cx);
            this.LOGGER.log(Level.FINE, "Drop schema: {0}", sql);
            Statement st = cx.createStatement();
            try {
                st.execute(sql);
            }
            finally {
                this.closeSafe(st);
            }
            this.dialect.postDropTable(this.databaseSchema, featureType, cx);
            this.removeEntry(typeName);
        }
        catch (Exception e) {
            String msg = "Error occurred dropping table";
            throw (IOException)new IOException(msg).initCause(e);
        }
        finally {
            this.closeSafe(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object getGmlObject(GmlObjectId id, Hints hints) throws IOException {
        int i;
        if (this.isAssociations()) {
            Connection cx = this.createConnection();
            try {
                ResultSet rs;
                Statement st;
                block29: {
                    st = null;
                    rs = null;
                    if (this.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                        st = this.selectGeometrySQLPS(id.getID(), cx);
                        rs = st.executeQuery();
                    } else {
                        String sql = this.selectGeometrySQL(id.getID());
                        this.LOGGER.log(Level.FINE, "Get GML object: {0}", sql);
                        st = cx.createStatement();
                        rs = st.executeQuery(sql);
                    }
                    if (!rs.next()) break block29;
                    Geometry g = this.getSQLDialect().decodeGeometryValue(null, rs, GEOMETRY_TABLE, this.getGeometryFactory(), cx, hints);
                    String name = rs.getString("name");
                    String desc = rs.getString("description");
                    this.setGmlProperties(g, id.getID(), name, desc);
                    Geometry geometry = g;
                    this.closeSafe(rs);
                    this.closeSafe(st);
                    return geometry;
                    {
                        catch (Throwable throwable) {
                            this.closeSafe(rs);
                            this.closeSafe(st);
                            throw throwable;
                        }
                    }
                }
                try {
                    this.closeSafe(rs);
                    this.closeSafe(st);
                }
                catch (SQLException e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
            finally {
                this.closeSafe(cx);
            }
        }
        if ((i = id.getID().indexOf(46)) == -1) {
            this.LOGGER.info("Unable to determine feature type for GmlObjectId:" + id);
            return null;
        }
        String featureTypeName = id.getID().substring(0, i);
        SimpleFeatureType featureType = this.getSchema(featureTypeName);
        if (featureType == null) {
            throw new IllegalArgumentException("No such feature type: " + featureTypeName);
        }
        Id filter = this.getFilterFactory().id(Collections.singleton(id));
        Query query = new Query(featureTypeName);
        query.setFilter((Filter)filter);
        query.setHints(hints);
        ContentFeatureCollection features = this.getFeatureSource(featureTypeName).getFeatures(query);
        if (!features.isEmpty()) {
            try (SimpleFeatureIterator fi = features.features();){
                if (fi.hasNext()) {
                    Feature feature = fi.next();
                    return feature;
                }
            }
        }
        return null;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        Object readOnlyMarker;
        SimpleFeatureType schema = entry.getState(Transaction.AUTO_COMMIT).getFeatureType();
        if (schema == null) {
            schema = new JDBCFeatureSource(entry, null).buildFeatureType();
            entry.getState(Transaction.AUTO_COMMIT).setFeatureType(schema);
        }
        if (Boolean.TRUE.equals(readOnlyMarker = schema.getUserData().get(JDBC_READ_ONLY))) {
            return new JDBCFeatureSource(entry, null);
        }
        return new JDBCFeatureStore(entry, null);
    }

    protected ContentState createContentState(ContentEntry entry) {
        JDBCState state = new JDBCState(entry);
        state.setExposePrimaryKeyColumns(this.exposePrimaryKeyColumns);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Name> createTypeNames() throws IOException {
        Connection cx = this.createConnection();
        ArrayList<Name> typeNames = new ArrayList<Name>();
        try {
            DatabaseMetaData metaData = cx.getMetaData();
            HashSet<String> availableTableTypes = new HashSet<String>();
            ResultSet tableTypes = null;
            try {
                tableTypes = metaData.getTableTypes();
                while (tableTypes.next()) {
                    availableTableTypes.add(tableTypes.getString("TABLE_TYPE"));
                }
            }
            finally {
                this.closeSafe(tableTypes);
            }
            HashSet<String> queryTypes = new HashSet<String>();
            for (String desiredTableType : this.dialect.getDesiredTablesType()) {
                if (!availableTableTypes.contains(desiredTableType)) continue;
                queryTypes.add(desiredTableType);
            }
            if (availableTableTypes.contains("PARTITIONED TABLE")) {
                queryTypes.add("PARTITIONED TABLE");
            }
            ResultSet tables = metaData.getTables(null, this.escapeNamePattern(metaData, this.databaseSchema), "%", queryTypes.toArray(new String[0]));
            try {
                if (this.fetchSize > 1) {
                    tables.setFetchSize(this.fetchSize);
                }
                while (tables.next()) {
                    String tableName;
                    String schemaName = tables.getString("TABLE_SCHEM");
                    if (!this.dialect.includeTable(schemaName, tableName = tables.getString("TABLE_NAME"), cx)) continue;
                    typeNames.add((Name)new NameImpl(this.namespaceURI, tableName));
                }
            }
            finally {
                this.closeSafe(tables);
            }
        }
        catch (SQLException e) {
            throw (IOException)new IOException("Error occurred getting table name list.").initCause(e);
        }
        finally {
            this.closeSafe(cx);
        }
        for (String virtualTable : this.virtualTables.keySet()) {
            typeNames.add((Name)new NameImpl(this.namespaceURI, virtualTable));
        }
        return typeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrimaryKey getPrimaryKey(ContentEntry entry) throws IOException {
        JDBCState state = (JDBCState)entry.getState(Transaction.AUTO_COMMIT);
        if (state.getPrimaryKey() == null) {
            JDBCDataStore jDBCDataStore = this;
            synchronized (jDBCDataStore) {
                if (state.getPrimaryKey() == null) {
                    Connection cx = this.createConnection();
                    try {
                        PrimaryKey pkey = null;
                        String tableName = entry.getName().getLocalPart();
                        if (this.virtualTables.containsKey(tableName)) {
                            VirtualTable vt = this.virtualTables.get(tableName);
                            if (vt.getPrimaryKeyColumns().size() == 0) {
                                pkey = new NullPrimaryKey(tableName);
                            } else {
                                List<ColumnMetadata> metas = JDBCFeatureSource.getColumnMetadata(cx, vt, this.dialect, this);
                                ArrayList<PrimaryKeyColumn> kcols = new ArrayList<PrimaryKeyColumn>();
                                for (String pkName : vt.getPrimaryKeyColumns()) {
                                    Class binding = null;
                                    for (ColumnMetadata meta : metas) {
                                        if (!meta.name.equals(pkName)) continue;
                                        binding = meta.binding;
                                    }
                                    kcols.add(new NonIncrementingPrimaryKeyColumn(pkName, binding));
                                }
                                pkey = new PrimaryKey(tableName, kcols);
                            }
                        } else {
                            try {
                                pkey = this.primaryKeyFinder.getPrimaryKey(this, this.databaseSchema, tableName, cx);
                            }
                            catch (SQLException e) {
                                this.LOGGER.log(Level.WARNING, "Failure occurred while looking up the primary key with finder: " + this.primaryKeyFinder, e);
                            }
                            if (pkey == null) {
                                String msg = "No primary key or unique index found for " + tableName + ".";
                                this.LOGGER.info(msg);
                                pkey = new NullPrimaryKey(tableName);
                            }
                        }
                        state.setPrimaryKey(pkey);
                    }
                    catch (SQLException e) {
                        String msg = "Error looking up primary key";
                        throw (IOException)new IOException(msg).initCause(e);
                    }
                    finally {
                        this.closeSafe(cx);
                    }
                }
            }
        }
        return state.getPrimaryKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isView(DatabaseMetaData metaData, String databaseSchema, String tableName) throws SQLException {
        ResultSet tables = null;
        try {
            tables = metaData.getTables(null, this.escapeNamePattern(metaData, databaseSchema), this.escapeNamePattern(metaData, tableName), new String[]{"VIEW"});
            boolean bl = tables.next();
            this.closeSafe(tables);
            return bl;
        }
        catch (Throwable throwable) {
            this.closeSafe(tables);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrimaryKey createPrimaryKey(ResultSet index, DatabaseMetaData metaData, String tableName, Connection cx) throws SQLException {
        ArrayList<PrimaryKeyColumn> cols = new ArrayList<PrimaryKeyColumn>();
        while (index.next()) {
            String columnName = index.getString("COLUMN_NAME");
            if (columnName == null) continue;
            Class columnType = this.getColumnType(metaData, this.databaseSchema, tableName, columnName);
            PrimaryKeyColumn col = null;
            Statement st = cx.createStatement();
            try {
                st.setFetchSize(1);
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ");
                this.dialect.encodeColumnName(null, columnName, sql);
                sql.append(" FROM ");
                this.encodeTableName(tableName, sql, null);
                sql.append(" WHERE 0=1");
                this.LOGGER.log(Level.FINE, "Grabbing table pk metadata: {0}", sql);
                ResultSet rs = st.executeQuery(sql.toString());
                try {
                    if (rs.getMetaData().isAutoIncrement(1)) {
                        col = new AutoGeneratedPrimaryKeyColumn(columnName, columnType);
                    }
                }
                finally {
                    this.closeSafe(rs);
                }
            }
            finally {
                this.closeSafe(st);
            }
            if (col == null) {
                try {
                    String sequenceName = this.dialect.getSequenceForColumn(this.databaseSchema, tableName, columnName, cx);
                    if (sequenceName != null) {
                        col = new SequencedPrimaryKeyColumn(columnName, columnType, sequenceName);
                    }
                }
                catch (Exception e) {
                    this.LOGGER.log(Level.WARNING, "Error occured determining sequence for " + columnName + ", " + tableName, e);
                }
            }
            if (col == null) {
                col = new NonIncrementingPrimaryKeyColumn(columnName, columnType);
            }
            cols.add(col);
        }
        if (!cols.isEmpty()) {
            return new PrimaryKey(tableName, cols);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getColumnType(DatabaseMetaData metaData, String databaseSchema2, String tableName, String columnName) throws SQLException {
        ResultSet columns = null;
        try {
            columns = metaData.getColumns(null, this.escapeNamePattern(metaData, this.databaseSchema), this.escapeNamePattern(metaData, tableName), this.escapeNamePattern(metaData, columnName));
            if (!columns.next()) {
                throw new SQLException("Could not find metadata for column");
            }
            int binding = columns.getInt("DATA_TYPE");
            Class<Object> columnType = this.getMapping(binding);
            if (columnType == null) {
                this.LOGGER.warning("No class for sql type " + binding);
                columnType = Object.class;
            }
            Class<?> clazz = columnType;
            this.closeSafe(columns);
            return clazz;
        }
        catch (Throwable throwable) {
            this.closeSafe(columns);
            throw throwable;
        }
    }

    public PrimaryKey getPrimaryKey(SimpleFeatureType featureType) throws IOException {
        return this.getPrimaryKey(this.ensureEntry(featureType.getName()));
    }

    protected boolean isExposePrimaryKeyColumns(SimpleFeatureType featureType) throws IOException {
        ContentEntry entry = this.ensureEntry(featureType.getName());
        JDBCState state = (JDBCState)entry.getState(Transaction.AUTO_COMMIT);
        return state.isExposePrimaryKeyColumns();
    }

    protected ReferencedEnvelope getBounds(SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        ReferencedEnvelope bounds;
        ResultSet rs;
        Statement st;
        block11: {
            List<ReferencedEnvelope> result;
            if (featureType.getGeometryDescriptor() == null) {
                return EMPTY_ENVELOPE;
            }
            st = null;
            rs = null;
            bounds = ReferencedEnvelope.create((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem());
            if (!this.isFullBoundsQuery(query, featureType) || (result = this.dialect.getOptimizedBounds(this.databaseSchema, featureType, cx)) == null || result.isEmpty()) break block11;
            for (ReferencedEnvelope envelope : result) {
                bounds = this.mergeEnvelope(bounds, envelope);
            }
            ReferencedEnvelope referencedEnvelope = bounds;
            this.closeSafe(rs);
            this.closeSafe(st);
            return referencedEnvelope;
        }
        try {
            if (this.dialect instanceof PreparedStatementSQLDialect) {
                st = this.selectBoundsSQLPS(featureType, query, cx);
                rs = st.executeQuery();
            } else {
                String sql = this.selectBoundsSQL(featureType, query);
                this.LOGGER.log(Level.FINE, "Retrieving bounding box: {0}", sql);
                st = cx.createStatement();
                rs = st.executeQuery(sql);
            }
            SingleCRS flatCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem());
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= columns; ++i) {
                    Envelope envelope = this.dialect.decodeGeometryEnvelope(rs, i, st.getConnection());
                    if (envelope == null) continue;
                    bounds = envelope instanceof ReferencedEnvelope ? this.mergeEnvelope(bounds, (ReferencedEnvelope)envelope) : this.mergeEnvelope(bounds, new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)flatCRS));
                }
            }
            this.closeSafe(rs);
            this.closeSafe(st);
        }
        catch (Exception e) {
            try {
                String msg = "Error occured calculating bounds for " + featureType.getTypeName();
                throw (IOException)new IOException(msg).initCause(e);
            }
            catch (Throwable throwable) {
                this.closeSafe(rs);
                this.closeSafe(st);
                throw throwable;
            }
        }
        return bounds;
    }

    private boolean isFullBoundsQuery(Query query, SimpleFeatureType schema) {
        if (query == null) {
            return true;
        }
        if (!query.isMaxFeaturesUnlimited()) {
            return false;
        }
        if (query.getStartIndex() != null && query.getStartIndex() > 0) {
            return false;
        }
        if (!Filter.INCLUDE.equals(query.getFilter())) {
            return false;
        }
        if (query.getProperties() == Query.ALL_PROPERTIES) {
            return true;
        }
        List<String> names = Arrays.asList(query.getPropertyNames());
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor) || names.contains(ad.getLocalName())) continue;
            return false;
        }
        return true;
    }

    ReferencedEnvelope mergeEnvelope(ReferencedEnvelope base, ReferencedEnvelope merge) throws TransformException, FactoryException {
        if (base == null || base.isNull()) {
            return merge;
        }
        if (merge == null || merge.isNull()) {
            return base;
        }
        CoordinateReferenceSystem crsBase = base.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crsMerge = merge.getCoordinateReferenceSystem();
        if (crsBase == null) {
            merge.expandToInclude((Envelope)base);
            return merge;
        }
        if (crsMerge == null) {
            base.expandToInclude((Envelope)base);
            return base;
        }
        if (!CRS.equalsIgnoreMetadata((Object)crsBase, (Object)crsMerge)) {
            merge = merge.transform(crsBase, true);
        }
        base.expandToInclude((Envelope)merge);
        return base;
    }

    protected int getCount(SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        CountVisitor v = new CountVisitor();
        this.getAggregateValue((FeatureVisitor)v, featureType, query, cx);
        return v.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAggregateValue(FeatureVisitor visitor, SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        if (!(!this.isGroupByVisitor(visitor) || this.dialect.isGroupBySupported() && this.isSupportedGroupBy(featureType, (GroupByVisitor)visitor))) {
            return null;
        }
        String function = this.matchAggregateFunction(visitor);
        if (function == null) {
            return null;
        }
        FilterCapabilities caps = this.getFilterCapabilities();
        PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(caps, featureType, null);
        query.getFilter().accept((FilterVisitor)splitter, null);
        if (!splitter.getFilterPost().equals(Filter.INCLUDE)) {
            return null;
        }
        List<Expression> aggregateExpressions = null;
        if (!this.isCountVisitor(visitor) && (aggregateExpressions = this.getAggregateExpression(visitor)) != null && !this.fullySupports(aggregateExpressions)) {
            return null;
        }
        LimitingVisitor limitingVisitor = null;
        if (visitor instanceof LimitingVisitor) {
            limitingVisitor = (LimitingVisitor)visitor;
        }
        List<Expression> groupByExpressions = this.extractGroupByExpressions(visitor);
        try {
            Object result = null;
            List<Object> results = new ArrayList();
            Statement st = null;
            ResultSet rs = null;
            try {
                if (this.dialect instanceof PreparedStatementSQLDialect) {
                    st = this.selectAggregateSQLPS(function, aggregateExpressions, groupByExpressions, featureType, query, limitingVisitor, cx);
                    rs = st.executeQuery();
                } else {
                    String sql = this.selectAggregateSQL(function, aggregateExpressions, groupByExpressions, featureType, query, limitingVisitor);
                    this.LOGGER.fine(sql);
                    st = cx.createStatement();
                    st.setFetchSize(this.fetchSize);
                    rs = st.executeQuery(sql);
                }
                Function<Object, Object> converter = this.dialect.getAggregateConverter(visitor, featureType);
                if (visitor.getClass().equals(UniqueVisitor.class)) {
                    UniqueVisitor uniqueVisitor = (UniqueVisitor)visitor;
                    results = this.getUniqueResult(uniqueVisitor, cx, featureType, rs, groupByExpressions, converter, query.getHints());
                } else {
                    results = this.getListValues(cx, featureType, rs, groupByExpressions, converter, query.getHints());
                }
                if (results.size() == 1 && !(results.get(0) instanceof List)) {
                    result = results.get(0);
                }
                this.closeSafe(rs);
                this.closeSafe(st);
            }
            catch (Throwable throwable) {
                this.closeSafe(rs);
                this.closeSafe(st);
                throw throwable;
            }
            if (groupByExpressions != null && !groupByExpressions.isEmpty()) {
                this.setResult(visitor, results);
                return results;
            }
            if (this.setResult(visitor, result == null ? results : result)) {
                return result == null ? results : result;
            }
            return null;
        }
        catch (SQLException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    private boolean isSupportedGroupBy(SimpleFeatureType featureType, GroupByVisitor visitor) {
        return visitor.getGroupByAttributes().stream().allMatch(xp -> {
            if (!this.fullySupports((Expression)xp)) {
                return false;
            }
            Class type = (Class)xp.accept((ExpressionVisitor)new ExpressionTypeVisitor((FeatureType)featureType), null);
            if (type == null || !Geometry.class.isAssignableFrom(type)) {
                return true;
            }
            return this.getGeometryDescriptor(featureType, (Expression)xp) != null && this.dialect.canGroupOnGeometry();
        });
    }

    private boolean fullySupports(List<Expression> expressions) {
        return expressions.stream().allMatch(e -> this.fullySupports((Expression)e));
    }

    private boolean fullySupports(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Null expression can not be unpacked");
        }
        FilterCapabilities filterCapabilities = this.getFilterCapabilities();
        if (!filterCapabilities.supports(expression.getClass())) {
            return false;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expression;
            return this.fullySupports(be.getExpression1()) && this.fullySupports(be.getExpression2());
        }
        if (expression instanceof org.opengis.filter.expression.Function) {
            org.opengis.filter.expression.Function function = (org.opengis.filter.expression.Function)expression;
            for (Expression fe : function.getParameters()) {
                if (this.fullySupports(fe)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isCountVisitor(FeatureVisitor visitor) {
        if (visitor instanceof CountVisitor) {
            return true;
        }
        return this.isGroupByVisitor(visitor) && ((GroupByVisitor)visitor).getAggregateVisitor() instanceof CountVisitor;
    }

    protected boolean isGroupByVisitor(FeatureVisitor visitor) {
        return visitor instanceof GroupByVisitor;
    }

    protected String matchAggregateFunction(FeatureVisitor visitor) {
        String function = null;
        for (Class<?> visitorClass = this.isGroupByVisitor(visitor) ? ((GroupByVisitor)visitor).getAggregateVisitor().getClass() : visitor.getClass(); function == null && visitorClass != null; visitorClass = visitorClass.getSuperclass()) {
            function = this.getAggregateFunctions().get(visitorClass);
        }
        if (function == null) {
            this.LOGGER.info("Unable to find aggregate function matching visitor: " + visitor.getClass());
        }
        return function;
    }

    private List<Expression> getAggregateExpression(FeatureVisitor visitor) {
        FeatureVisitor aggregateVisitor = this.isGroupByVisitor(visitor) ? ((GroupByVisitor)visitor).getAggregateVisitor() : visitor;
        List<Expression> expressions = this.getExpressions(aggregateVisitor);
        if (expressions == null || expressions.isEmpty()) {
            this.LOGGER.info("Visitor " + visitor.getClass() + " has no aggregate attribute.");
            return null;
        }
        return expressions;
    }

    protected List<Expression> extractGroupByExpressions(FeatureVisitor visitor) {
        ArrayList<Expression> expressions = this.isGroupByVisitor(visitor) ? ((GroupByVisitor)visitor).getGroupByAttributes() : new ArrayList();
        return expressions;
    }

    private List<Object> getUniqueResult(UniqueVisitor uniqueVisitor, Connection cx, SimpleFeatureType featureType, ResultSet rs, List<Expression> groupBy, Function<Object, Object> converter, Hints hints) throws SQLException, IOException {
        List<Object> results = uniqueVisitor.getExpressions().size() > 1 ? this.getUniqueMultiAttr(uniqueVisitor.getAttrNames(), rs, converter) : this.getListValues(cx, featureType, rs, groupBy, converter, hints);
        return results;
    }

    private List<Object> getUniqueMultiAttr(List<String> attributeNames, ResultSet resultSet, Function<Object, Object> converter) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (resultSet.next()) {
            LinkedList<Object> uniqueValues = new LinkedList<Object>();
            for (String attr : attributeNames) {
                Object object = resultSet.getObject(attr);
                object = converter.apply(object);
                uniqueValues.add(object);
            }
            result.add(uniqueValues);
        }
        return result;
    }

    private List<Object> getListValues(Connection cx, SimpleFeatureType featureType, ResultSet rs, List<Expression> groupBy, Function<Object, Object> converter, Hints hints) throws SQLException, IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        Object result = null;
        while (rs.next()) {
            if (groupBy == null || groupBy.isEmpty()) {
                Object value = rs.getObject(1);
                result = converter.apply(value);
                results.add(result);
                continue;
            }
            results.add(this.extractValuesFromResultSet(cx, featureType, rs, groupBy, converter, hints));
        }
        return results;
    }

    protected GroupByVisitor.GroupByRawResult extractValuesFromResultSet(Connection cx, SimpleFeatureType featureType, ResultSet resultSet, List<Expression> groupBy, Function<Object, Object> converter, Hints hints) throws SQLException, IOException {
        ArrayList<Object> groupByValues = new ArrayList<Object>();
        int numberOfGroupByAttributes = groupBy.size();
        for (int i = 0; i < numberOfGroupByAttributes; ++i) {
            GeometryDescriptor gd = this.getGeometryDescriptor(featureType, groupBy.get(i));
            Object result = gd != null ? this.dialect.decodeGeometryValue(gd, resultSet, i + 1, new GeometryFactory(), cx, hints) : resultSet.getObject(i + 1);
            groupByValues.add(result);
        }
        Object aggregated = resultSet.getObject(numberOfGroupByAttributes + 1);
        Object converted = converter.apply(aggregated);
        return new GroupByVisitor.GroupByRawResult(groupByValues, converted);
    }

    List<Expression> getExpressions(FeatureVisitor visitor) {
        if (visitor instanceof CountVisitor) {
            return null;
        }
        List<Expression> result = null;
        if (visitor instanceof UniqueVisitor) {
            result = ((UniqueVisitor)visitor).getExpressions();
        } else {
            try {
                Object expr;
                Method g = visitor.getClass().getMethod("getExpression", null);
                if (g != null && (expr = g.invoke((Object)visitor, null)) instanceof Expression) {
                    result = Arrays.asList((Expression)expr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    boolean setResult(FeatureVisitor visitor, Object result) {
        try {
            Method s = null;
            if (AGGREGATE_SETVALUE_CACHE.containsKey(visitor.getClass())) {
                s = (Method)AGGREGATE_SETVALUE_CACHE.get(visitor.getClass());
            } else {
                try {
                    s = visitor.getClass().getMethod("setValue", result.getClass());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (s == null) {
                    for (Method m : visitor.getClass().getMethods()) {
                        if (!"setValue".equals(m.getName()) || m.getParameterCount() != 1) continue;
                        s = m;
                        break;
                    }
                }
                AGGREGATE_SETVALUE_CACHE.put(visitor.getClass(), (Object)s);
            }
            if (s != null) {
                Class<?> type = s.getParameterTypes()[0];
                if (!type.isInstance(result)) {
                    Object converted = Converters.convert((Object)result, type);
                    if (converted != null) {
                        result = converted;
                    } else {
                        return false;
                    }
                }
                s.invoke((Object)visitor, result);
                return true;
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.INFO, "Failed to set optimized result, will fall back on full collection visit", e);
        }
        return false;
    }

    protected void insert(SimpleFeature feature, SimpleFeatureType featureType, Connection cx) throws IOException {
        this.insert(Collections.singletonList(feature), featureType, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Collection<? extends SimpleFeature> features, SimpleFeatureType featureType, Connection cx) throws IOException {
        PrimaryKey key = this.getPrimaryKey(featureType);
        JDBCDataStore jDBCDataStore = this;
        synchronized (jDBCDataStore) {
            try {
                if (this.dialect instanceof PreparedStatementSQLDialect) {
                    Map<InsertionClassifier, Collection<SimpleFeature>> kinds = InsertionClassifier.classify(featureType, features);
                    for (InsertionClassifier kind : kinds.keySet()) {
                        this.insertPS(kinds.get(kind), kind, featureType, cx, key);
                    }
                } else {
                    ArrayList<SimpleFeature> useExistings = new ArrayList<SimpleFeature>();
                    ArrayList notUseExistings = new ArrayList();
                    for (SimpleFeature simpleFeature : features) {
                        (InsertionClassifier.useExisting(simpleFeature) ? useExistings : notUseExistings).add(simpleFeature);
                    }
                    this.insertNonPS(useExistings, featureType, cx, key, true);
                    this.insertNonPS(notUseExistings, featureType, cx, key, false);
                }
            }
            catch (SQLException e) {
                String msg = "Error inserting features";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPS(Collection<SimpleFeature> features, InsertionClassifier kind, SimpleFeatureType featureType, Connection cx, PrimaryKey key) throws IOException, SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        KeysFetcher keysFetcher = KeysFetcher.create(this, cx, kind.useExisting, key);
        String sql = this.buildInsertPS(kind, featureType, keysFetcher, dialect);
        this.LOGGER.log(Level.FINE, "Inserting new features with ps: {0}", sql);
        PreparedStatement ps = keysFetcher.isPostInsert() ? cx.prepareStatement(sql, keysFetcher.getColumnNames()) : cx.prepareStatement(sql);
        try {
            for (SimpleFeature feature : features) {
                int i = 1;
                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                    String colName = att.getLocalName();
                    if (keysFetcher.isKey(colName)) continue;
                    Class<Integer> binding = att.getType().getBinding();
                    EnumMapper mapper = (EnumMapper)att.getUserData().get(JDBC_ENUM_MAP);
                    Object value = feature.getAttribute(colName);
                    if (value == null && !att.isNillable()) {
                        throw new IOException("Cannot set a NULL value on the not null column " + colName);
                    }
                    if (Geometry.class.isAssignableFrom(binding)) {
                        Geometry g = (Geometry)value;
                        int srid = this.getGeometrySRID(g, att);
                        int dimension = this.getGeometryDimension(g, att);
                        dialect.setGeometryValue(g, dimension, srid, binding, ps, i);
                    } else if (this.dialect.isArray(att)) {
                        dialect.setArrayValue(value, att, ps, i, cx);
                    } else {
                        if (mapper != null) {
                            value = mapper.fromString((String)value);
                            binding = Integer.class;
                        }
                        dialect.setValue(value, binding, ps, i, cx);
                    }
                    if (this.LOGGER.isLoggable(Level.FINE)) {
                        this.LOGGER.fine(i + " = " + value);
                    }
                    ++i;
                }
                keysFetcher.setKeyValues(dialect, ps, cx, featureType, feature, i);
                dialect.onInsert(ps, cx, featureType);
                ps.addBatch();
            }
            int[] inserts = ps.executeBatch();
            JDBCDataStore.checkAllInserted(inserts, features.size());
            keysFetcher.postInsert(featureType, features, ps);
        }
        finally {
            this.closeSafe(ps);
        }
    }

    static void checkAllInserted(int[] inserts, int size) throws IOException {
        int sum = 0;
        for (int cur : inserts) {
            if (cur == -2) {
                return;
            }
            if (cur == -3) {
                throw new IOException("Failed to insert some features");
            }
            sum += cur;
        }
        if (sum != size) {
            throw new IOException("Failed to insert some features");
        }
    }

    private String buildInsertPS(InsertionClassifier kind, SimpleFeatureType featureType, KeysFetcher keysFetcher, PreparedStatementSQLDialect dialect) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" ( ");
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            String colName = featureType.getDescriptor(i).getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            dialect.encodeColumnName(null, colName, sql);
            sql.append(",");
        }
        keysFetcher.addKeyColumns(sql);
        sql.setLength(sql.length() - 1);
        sql.append(" ) VALUES ( ");
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            String colName = att.getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            if (att instanceof GeometryDescriptor) {
                Class<? extends Geometry> geometryClass = kind.geometryTypes.get(att.getName().getLocalPart());
                dialect.prepareGeometryValue(geometryClass, this.getDescriptorDimension(att), this.getDescriptorSRID(att), att.getType().getBinding(), sql);
            } else {
                sql.append("?");
            }
            sql.append(",");
        }
        keysFetcher.addKeyBindings(sql);
        sql.setLength(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNonPS(Collection<? extends SimpleFeature> features, SimpleFeatureType featureType, Connection cx, PrimaryKey key, boolean useExisting) throws IOException, SQLException {
        if (features.isEmpty()) {
            return;
        }
        Statement st = cx.createStatement();
        KeysFetcher keysFetcher = KeysFetcher.create(this, cx, useExisting, key);
        try {
            for (SimpleFeature simpleFeature : features) {
                String sql = this.insertSQL(featureType, simpleFeature, keysFetcher, cx);
                ((BasicSQLDialect)this.dialect).onInsert(st, cx, featureType);
                this.LOGGER.log(Level.FINE, "Inserting new feature: {0}", sql);
                if (keysFetcher.hasAutoGeneratedKeys()) {
                    st.executeUpdate(sql, 1);
                } else {
                    st.executeUpdate(sql);
                }
                keysFetcher.postInsert(featureType, simpleFeature, cx, st);
            }
        }
        finally {
            this.closeSafe(st);
        }
    }

    protected void update(SimpleFeatureType featureType, List<AttributeDescriptor> attributes, List<Object> values, Filter filter, Connection cx) throws IOException, SQLException {
        this.update(featureType, attributes.toArray(new AttributeDescriptor[attributes.size()]), values.toArray(new Object[values.size()]), filter, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(SimpleFeatureType featureType, AttributeDescriptor[] attributes, Object[] values, Filter filter, Connection cx) throws IOException, SQLException {
        block16: {
            if (attributes == null || attributes.length == 0) {
                this.LOGGER.warning("Update called with no attributes, doing nothing.");
                return;
            }
            PrimaryKey key = null;
            try {
                key = this.getPrimaryKey(featureType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            LinkedHashSet<String> pkColumnNames = JDBCDataStore.getColumnNames(key);
            boolean nonPkeyColumn = false;
            for (AttributeDescriptor att : attributes) {
                if (pkColumnNames.contains(att.getLocalName())) continue;
                nonPkeyColumn = true;
            }
            if (!nonPkeyColumn) {
                throw new IllegalArgumentException("Illegal update, must include at least one non primary key column, all primary key columns are ignored.");
            }
            if (this.dialect instanceof PreparedStatementSQLDialect) {
                try {
                    PreparedStatement ps = this.updateSQLPS(featureType, attributes, values, filter, pkColumnNames, cx);
                    try {
                        ((PreparedStatementSQLDialect)this.dialect).onUpdate(ps, cx, featureType);
                        ps.execute();
                        break block16;
                    }
                    finally {
                        this.closeSafe(ps);
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            String sql = this.updateSQL(featureType, attributes, values, filter, pkColumnNames);
            try {
                Statement st = cx.createStatement();
                try {
                    ((BasicSQLDialect)this.dialect).onUpdate(st, cx, featureType);
                    this.LOGGER.log(Level.FINE, "Updating feature: {0}", sql);
                    st.execute(sql);
                }
                finally {
                    this.closeSafe(st);
                }
            }
            catch (SQLException e) {
                String msg = "Error occured updating features";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
    }

    protected void delete(SimpleFeatureType featureType, String fid, Connection cx) throws IOException {
        Id filter = this.filterFactory.id(Collections.singleton(this.filterFactory.featureId(fid)));
        this.delete(featureType, (Filter)filter, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(SimpleFeatureType featureType, Filter filter, Connection cx) throws IOException {
        Statement st = null;
        try {
            try {
                if (this.dialect instanceof PreparedStatementSQLDialect) {
                    st = this.deleteSQLPS(featureType, filter, cx);
                    PreparedStatement ps = st;
                    ((PreparedStatementSQLDialect)this.dialect).onDelete(ps, cx, featureType);
                    ps.execute();
                } else {
                    String sql = this.deleteSQL(featureType, filter);
                    st = cx.createStatement();
                    ((BasicSQLDialect)this.dialect).onDelete(st, cx, featureType);
                    this.LOGGER.log(Level.FINE, "Removing feature(s): {0}", sql);
                    st.execute(sql);
                }
                this.closeSafe(st);
            }
            catch (Throwable throwable) {
                this.closeSafe(st);
                throw throwable;
            }
        }
        catch (SQLException e) {
            String msg = "Error occured during delete";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public Connection getConnection(Transaction t) throws IOException {
        Objects.requireNonNull(t);
        if (t == Transaction.AUTO_COMMIT) {
            Connection cx = this.createConnection();
            try {
                if (!cx.getAutoCommit()) {
                    cx.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                throw (IOException)new IOException().initCause(e);
            }
            return cx;
        }
        JDBCTransactionState tstate = (JDBCTransactionState)t.getState((Object)this);
        if (tstate != null) {
            return tstate.cx;
        }
        Connection cx = this.createConnection();
        try {
            cx.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw (IOException)new IOException().initCause(e);
        }
        tstate = new JDBCTransactionState(cx, this);
        t.putState((Object)this, (Transaction.State)tstate);
        return cx;
    }

    protected final Connection getConnection(JDBCState state) throws IOException {
        return this.getConnection(state.getTransaction());
    }

    protected final Connection createConnection() {
        try {
            this.LOGGER.fine("CREATE CONNECTION");
            Connection cx = this.getDataSource().getConnection();
            this.dialect.initializeConnection(cx);
            if (!this.connectionLifecycleListeners.isEmpty()) {
                ArrayList<ConnectionLifecycleListener> locals = new ArrayList<ConnectionLifecycleListener>(this.connectionLifecycleListeners);
                return new LifecycleConnection(this, cx, locals);
            }
            return cx;
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to obtain connection: " + e.getMessage(), e);
        }
    }

    protected final void releaseConnection(Connection cx, JDBCState state) {
        if (state.getTransaction() == Transaction.AUTO_COMMIT) {
            this.closeSafe(cx);
        }
    }

    protected String encodeFID(PrimaryKey pkey, ResultSet rs) throws SQLException, IOException {
        return this.encodeFID(pkey, rs, 0);
    }

    protected String encodeFID(PrimaryKey pkey, ResultSet rs, int offset) throws SQLException, IOException {
        List<PrimaryKeyColumn> columns = pkey.getColumns();
        if (columns.isEmpty()) {
            return SimpleFeatureBuilder.createDefaultFeatureId();
        }
        if (columns.size() == 1) {
            return this.dialect.getPkColumnValue(rs, columns.get(0), offset + 1);
        }
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (int i = 0; i < columns.size(); ++i) {
            String o = this.dialect.getPkColumnValue(rs, columns.get(0), offset + i + 1);
            keyValues.add(o);
        }
        return JDBCDataStore.encodeFID(keyValues);
    }

    protected static String encodeFID(List<Object> keyValues) {
        StringBuffer fid = new StringBuffer();
        for (Object o : keyValues) {
            fid.append(o).append(".");
        }
        fid.setLength(fid.length() - 1);
        return fid.toString();
    }

    public static List<Object> decodeFID(PrimaryKey key, String FID, boolean strict) {
        if (FID.startsWith(key.getTableName() + ".")) {
            FID = FID.substring(key.getTableName().length() + 1);
        }
        try {
            FID = URLDecoder.decode(FID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> values = null;
        if (key.getColumns().size() > 1) {
            String[] split = FID.split("\\.");
            values = new ArrayList(split.length);
            for (String s : split) {
                values.add(s);
            }
        } else {
            values = new ArrayList<Object>();
            values.add(FID);
        }
        if (values.size() != key.getColumns().size()) {
            throw new IllegalArgumentException("Illegal fid: " + FID + ". Expected " + key.getColumns().size() + " values but got " + values.size());
        }
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            Class type = key.getColumns().get(i).getType();
            Object converted = Converters.convert(value, (Class)type);
            if (converted != null) {
                values.set(i, converted);
            }
            if (!strict || type.isInstance(values.get(i))) continue;
            throw new IllegalArgumentException("Value " + values.get(i) + " illegal for type " + type.getName());
        }
        return values;
    }

    protected boolean isGenerated(PrimaryKey pkey) {
        for (PrimaryKeyColumn col : pkey.getColumns()) {
            if (col instanceof AutoGeneratedPrimaryKeyColumn) continue;
            return false;
        }
        return true;
    }

    protected String createTableSQL(SimpleFeatureType featureType, Connection cx) throws Exception {
        String[] columnNames = new String[featureType.getAttributeCount()];
        Class[] classes = new Class[featureType.getAttributeCount()];
        boolean[] nillable = new boolean[featureType.getAttributeCount()];
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = featureType.getDescriptor(i);
            columnNames[i] = attributeType.getLocalName();
            classes[i] = attributeType.getType().getBinding();
            nillable[i] = attributeType.getMinOccurs() <= 0 || attributeType.isNillable();
        }
        String[] sqlTypeNames = this.getSQLTypeNames(featureType.getAttributeDescriptors(), cx);
        for (int i = 0; i < sqlTypeNames.length; ++i) {
            if (sqlTypeNames[i] != null) continue;
            String msg = "Unable to map " + columnNames[i] + "( " + classes[i].getName() + ")";
            throw new RuntimeException(msg);
        }
        return this.createTableSQL(featureType.getTypeName(), columnNames, sqlTypeNames, nillable, this.findPrimaryKeyColumnName(featureType), featureType);
    }

    protected String findPrimaryKeyColumnName(SimpleFeatureType featureType) {
        String[] base;
        String[] suffix = new String[]{"", "_1", "_2"};
        for (String b : base = new String[]{"fid", "id", "gt_id", "ogc_fid"}) {
            block1: for (String s : suffix) {
                String name = b + s;
                for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
                    if (!ad.getLocalName().equalsIgnoreCase(name)) continue;
                    continue block1;
                }
                return name;
            }
        }
        return "fid";
    }

    protected String dropTableSQL(SimpleFeatureType featureType, Connection cx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("DROP TABLE ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureAuthorization(SimpleFeatureType featureType, Filter filter, Transaction tx, Connection cx) throws IOException, SQLException {
        InProcessLockingManager lm = (InProcessLockingManager)this.getLockingManager();
        Map locks = lm.locks(featureType.getTypeName());
        if (!locks.isEmpty()) {
            if (locks.size() <= 100) {
                Set<FeatureId> ids = this.getLockedIds(locks);
                Id lockFilter = this.getFilterFactory().id(ids);
                filter = this.getFilterFactory().and(filter, (Filter)lockFilter);
            }
            Query query = new Query(featureType.getTypeName(), filter, Query.NO_NAMES);
            Statement st = null;
            try {
                ResultSet rs = null;
                if (this.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                    st = this.selectSQLPS(featureType, query, cx);
                    PreparedStatement ps = st;
                    ((PreparedStatementSQLDialect)this.getSQLDialect()).onSelect(ps, cx, featureType);
                    rs = ps.executeQuery();
                } else {
                    String sql = this.selectSQL(featureType, query);
                    st = cx.createStatement();
                    st.setFetchSize(this.fetchSize);
                    ((BasicSQLDialect)this.getSQLDialect()).onSelect(st, cx, featureType);
                    this.LOGGER.fine(sql);
                    rs = st.executeQuery(sql);
                }
                try {
                    PrimaryKey key = this.getPrimaryKey(featureType);
                    while (rs.next()) {
                        String fid = featureType.getTypeName() + "." + this.encodeFID(key, rs);
                        lm.assertAccess(featureType.getTypeName(), fid, tx);
                    }
                }
                finally {
                    this.closeSafe(rs);
                }
                this.closeSafe(st);
            }
            catch (Throwable throwable) {
                this.closeSafe(st);
                throw throwable;
            }
        }
    }

    private Set<FeatureId> getLockedIds(Map locks) {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        for (Object lock : locks.keySet()) {
            ids.add(this.getFilterFactory().featureId(lock.toString()));
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureAssociationTablesExist(Connection cx) throws IOException, SQLException {
        block34: {
            Statement st;
            String sql;
            ResultSet tables;
            DatabaseMetaData metadata;
            block33: {
                block32: {
                    block31: {
                        block30: {
                            metadata = cx.getMetaData();
                            tables = metadata.getTables(null, this.escapeNamePattern(metadata, this.databaseSchema), this.escapeNamePattern(metadata, FEATURE_RELATIONSHIP_TABLE), null);
                            try {
                                if (tables.next()) break block30;
                                sql = this.createRelationshipTableSQL(cx);
                                this.LOGGER.log(Level.FINE, "Creating relationship table: {0}", sql);
                                st = cx.createStatement();
                                try {
                                    st.execute(sql);
                                }
                                finally {
                                    this.closeSafe(st);
                                }
                            }
                            finally {
                                this.closeSafe(tables);
                            }
                        }
                        tables = metadata.getTables(null, this.escapeNamePattern(metadata, this.databaseSchema), this.escapeNamePattern(metadata, FEATURE_ASSOCIATION_TABLE), null);
                        try {
                            if (tables.next()) break block31;
                            sql = this.createAssociationTableSQL(cx);
                            this.LOGGER.log(Level.FINE, "Creating association table: {0}", sql);
                            st = cx.createStatement();
                            try {
                                st.execute(sql);
                            }
                            finally {
                                this.closeSafe(st);
                            }
                        }
                        finally {
                            this.closeSafe(tables);
                        }
                    }
                    tables = metadata.getTables(null, this.escapeNamePattern(metadata, this.databaseSchema), this.escapeNamePattern(metadata, GEOMETRY_TABLE), null);
                    try {
                        if (tables.next()) break block32;
                        sql = this.createGeometryTableSQL(cx);
                        this.LOGGER.log(Level.FINE, "Creating geometry table: {0}", sql);
                        st = cx.createStatement();
                        try {
                            st.execute(sql);
                        }
                        finally {
                            this.closeSafe(st);
                        }
                    }
                    finally {
                        this.closeSafe(tables);
                    }
                }
                tables = metadata.getTables(null, this.escapeNamePattern(metadata, this.databaseSchema), this.escapeNamePattern(metadata, MULTI_GEOMETRY_TABLE), null);
                try {
                    if (tables.next()) break block33;
                    sql = this.createMultiGeometryTableSQL(cx);
                    this.LOGGER.log(Level.FINE, "Creating multi-geometry table: {0}", sql);
                    st = cx.createStatement();
                    try {
                        st.execute(sql);
                    }
                    finally {
                        this.closeSafe(st);
                    }
                }
                finally {
                    this.closeSafe(tables);
                }
            }
            tables = metadata.getTables(null, this.escapeNamePattern(metadata, this.databaseSchema), this.escapeNamePattern(metadata, GEOMETRY_ASSOCIATION_TABLE), null);
            try {
                if (tables.next()) break block34;
                sql = this.createGeometryAssociationTableSQL(cx);
                this.LOGGER.log(Level.FINE, "Creating geometry association table: {0}", sql);
                st = cx.createStatement();
                try {
                    st.execute(sql);
                }
                finally {
                    this.closeSafe(st);
                }
            }
            finally {
                this.closeSafe(tables);
            }
        }
    }

    protected String createRelationshipTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(this.descriptors(String.class, String.class), cx);
        String[] columnNames = new String[]{"table", "col"};
        return this.createTableSQL(FEATURE_RELATIONSHIP_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String createAssociationTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(this.descriptors(String.class, String.class, String.class, String.class), cx);
        String[] columnNames = new String[]{"fid", "rtable", "rcol", "rfid"};
        return this.createTableSQL(FEATURE_ASSOCIATION_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String createGeometryTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(this.descriptors(String.class, String.class, String.class, String.class, Geometry.class), cx);
        String[] columnNames = new String[]{"id", "name", "description", "type", GEOMETRY_TABLE};
        return this.createTableSQL(GEOMETRY_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String createMultiGeometryTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(this.descriptors(String.class, String.class, Boolean.class), cx);
        String[] columnNames = new String[]{"id", "mgid", "ref"};
        return this.createTableSQL(MULTI_GEOMETRY_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    private List<AttributeDescriptor> descriptors(Class<?> ... classes) {
        AttributeTypeBuilder tb = new AttributeTypeBuilder();
        ArrayList<AttributeDescriptor> result = new ArrayList<AttributeDescriptor>();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> aClass = classes[i];
            AttributeDescriptor ad = tb.name("a" + i).binding(aClass).buildDescriptor("a" + i);
            result.add(ad);
        }
        return result;
    }

    protected String selectRelationshipSQL(String table, String column) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "table", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "col", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_RELATIONSHIP_TABLE, sql, null);
        if (table != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "table", sql);
            sql.append(" = ");
            dialect.encodeValue(table, String.class, sql);
        }
        if (column != null) {
            if (table == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName(null, "col", sql);
            sql.append(" = ");
            dialect.encodeValue(column, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectRelationshipSQLPS(String table, String column, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "table", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "col", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_RELATIONSHIP_TABLE, sql, null);
        if (table != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "table", sql);
            sql.append(" = ? ");
        }
        if (column != null) {
            if (table == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName(null, "col", sql);
            sql.append(" = ? ");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (table != null) {
            ps.setString(1, table);
        }
        if (column != null) {
            ps.setString(table != null ? 2 : 1, column);
        }
        return ps;
    }

    protected String selectAssociationSQL(String fid) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "fid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "rtable", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "rcol", sql);
        sql.append(", ");
        dialect.encodeColumnName(null, "rfid", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "fid", sql);
            sql.append(" = ");
            dialect.encodeValue(fid, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectAssociationSQLPS(String fid, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "fid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "rtable", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "rcol", sql);
        sql.append(", ");
        dialect.encodeColumnName(null, "rfid", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "fid", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (fid != null) {
            ps.setString(1, fid);
        }
        return ps;
    }

    protected String selectGeometrySQL(String gid) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "id", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "name", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "description", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "type", sql);
        sql.append(",");
        dialect.encodeColumnName(null, GEOMETRY_TABLE, sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "id", sql);
            sql.append(" = ");
            dialect.encodeValue(gid, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectGeometrySQLPS(String gid, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "id", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "name", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "description", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "type", sql);
        sql.append(",");
        dialect.encodeColumnName(null, GEOMETRY_TABLE, sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "id", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (gid != null) {
            ps.setString(1, gid);
        }
        return ps;
    }

    protected String selectMultiGeometrySQL(String gid) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "id", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "mgid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(MULTI_GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "id", sql);
            sql.append(" = ");
            dialect.encodeValue(gid, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectMultiGeometrySQLPS(String gid, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "id", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "mgid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(MULTI_GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "id", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (gid != null) {
            ps.setString(1, gid);
        }
        return ps;
    }

    protected String createGeometryAssociationTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(this.descriptors(String.class, String.class, String.class, Boolean.class), cx);
        String[] columnNames = new String[]{"fid", "gname", "gid", "ref"};
        return this.createTableSQL(GEOMETRY_ASSOCIATION_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String selectGeometryAssociationSQL(String fid, String gid, String gname) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "fid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "gid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "gname", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "fid", sql);
            sql.append(" = ");
            dialect.encodeValue(fid, String.class, sql);
        }
        if (gid != null) {
            if (fid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName(null, "gid", sql);
            sql.append(" = ");
            dialect.encodeValue(gid, String.class, sql);
        }
        if (gname != null) {
            if (fid == null && gid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName(null, "gname", sql);
            sql.append(" = ");
            dialect.encodeValue(gname, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectGeometryAssociationSQLPS(String fid, String gid, String gname, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName(null, "fid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "gid", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "gname", sql);
        sql.append(",");
        dialect.encodeColumnName(null, "ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName(null, "fid", sql);
            sql.append(" = ? ");
        }
        if (gid != null) {
            if (fid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName(null, "gid", sql);
            sql.append(" = ? ");
        }
        if (gname != null) {
            if (fid == null && gid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName(null, "gname", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (fid != null) {
            ps.setString(1, fid);
        }
        if (gid != null) {
            ps.setString(fid != null ? 2 : 1, gid);
        }
        if (gname != null) {
            ps.setString(fid != null ? (gid != null ? 3 : 2) : (gid != null ? 2 : 1), gname);
        }
        return ps;
    }

    private String createTableSQL(String tableName, String[] columnNames, String[] sqlTypeNames, boolean[] nillable, String pkeyColumn, SimpleFeatureType featureType) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.dialect.encodeCreateTable(sql);
        this.encodeTableName(tableName, sql, null);
        sql.append(" ( ");
        if (pkeyColumn != null) {
            this.dialect.encodePrimaryKey(pkeyColumn, sql);
            sql.append(", ");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            AttributeDescriptor att;
            this.dialect.encodeColumnName(null, columnNames[i], sql);
            sql.append(" ");
            int length = -1;
            if (sqlTypeNames[i].toUpperCase().startsWith("VARCHAR") && featureType != null) {
                att = featureType.getDescriptor(columnNames[i]);
                length = this.findVarcharColumnLength(att);
            }
            if (length == -1) {
                this.dialect.encodeColumnType(sqlTypeNames[i], sql);
            } else {
                this.dialect.encodeColumnType(sqlTypeNames[i] + "(" + length + ")", sql);
            }
            if (nillable != null && !nillable[i]) {
                sql.append(" NOT NULL ");
            }
            if (featureType != null) {
                att = featureType.getDescriptor(columnNames[i]);
                this.dialect.encodePostColumnCreateTable(att, sql);
            }
            if (i >= sqlTypeNames.length - 1) continue;
            sql.append(", ");
        }
        sql.append(" ) ");
        this.dialect.encodePostCreateTable(tableName, sql);
        return sql.toString();
    }

    private Integer findVarcharColumnLength(AttributeDescriptor att) {
        for (Filter r : att.getType().getRestrictions()) {
            Integer length;
            PropertyIsLessThanOrEqualTo c;
            if (!(r instanceof PropertyIsLessThanOrEqualTo) || !((c = (PropertyIsLessThanOrEqualTo)r).getExpression1() instanceof org.opengis.filter.expression.Function) || !((org.opengis.filter.expression.Function)c.getExpression1()).getName().toLowerCase().endsWith("length") || !(c.getExpression2() instanceof Literal) || (length = (Integer)c.getExpression2().evaluate(null, Integer.class)) == null) continue;
            return length;
        }
        return this.dialect.getDefaultVarcharSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSQLTypeNames(List<AttributeDescriptor> descriptors, Connection cx) throws SQLException {
        boolean allTypesFound;
        int[] sqlTypes = new int[descriptors.size()];
        Object[] sqlTypeNames = new String[sqlTypes.length];
        for (int i = 0; i < descriptors.size(); ++i) {
            String sqlTypeDBName;
            String sqlTypeName;
            AttributeDescriptor ad = descriptors.get(i);
            Object nativeTypeName = ad.getUserData().get(JDBC_NATIVE_TYPENAME);
            if (nativeTypeName instanceof String) {
                sqlTypeNames[i] = (String)nativeTypeName;
                continue;
            }
            Class clazz = ad.getType().getBinding();
            Object nativeType = ad.getUserData().get(JDBC_NATIVE_TYPE);
            Integer sqlType = nativeType instanceof Integer ? (Integer)nativeType : this.dialect.getSQLType(ad);
            if (sqlType == null) {
                sqlType = this.getMapping(clazz);
            }
            if (sqlType == null) {
                this.LOGGER.warning("No sql type mapping for: " + ad.getLocalName() + " of type " + clazz);
                sqlType = 1111;
            }
            sqlTypes[i] = sqlType;
            if (Geometry.class.isAssignableFrom(clazz) && (sqlTypeName = this.dialect.getGeometryTypeName(sqlType)) != null) {
                sqlTypeNames[i] = sqlTypeName;
            }
            if ((sqlTypeDBName = this.getDBsqlTypesCache().get(sqlType)) == null) continue;
            sqlTypeNames[i] = sqlTypeDBName;
        }
        boolean bl = allTypesFound = !ArrayUtils.contains((Object[])sqlTypeNames, null);
        if (!allTypesFound) {
            this.LOGGER.log(Level.WARNING, "Fetching fields from Database");
            DatabaseMetaData metaData = cx.getMetaData();
            ResultSet types = metaData.getTypeInfo();
            try {
                while (types.next()) {
                    int sqlType = types.getInt("DATA_TYPE");
                    String sqlTypeName = types.getString("TYPE_NAME");
                    for (int i = 0; i < sqlTypes.length; ++i) {
                        if (sqlTypeNames[i] != null || sqlType != sqlTypes[i]) continue;
                        sqlTypeNames[i] = sqlTypeName;
                        this.getDBsqlTypesCache().putIfAbsent(sqlType, sqlTypeName);
                    }
                }
            }
            finally {
                this.closeSafe(types);
            }
        }
        Map<Integer, String> overrides = this.getSqlTypeToSqlTypeNameOverrides();
        for (int i = 0; i < sqlTypes.length; ++i) {
            String override = overrides.get(sqlTypes[i]);
            if (override == null) continue;
            sqlTypeNames[i] = override;
        }
        return sqlTypeNames;
    }

    protected String selectSQL(SimpleFeatureType featureType, Query query) throws IOException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, null, query, sql);
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, VirtualTable.setKeepWhereClausePlaceHolderHint(query));
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            sql.append(" WHERE ");
            this.filter(featureType, filter, sql);
        }
        this.sort(featureType, query.getSortBy(), null, sql);
        this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
        this.applySearchHints(featureType, query, sql);
        return sql.toString();
    }

    private void applySearchHints(SimpleFeatureType featureType, Query query, StringBuffer sql) {
        if (this.virtualTables.containsKey(featureType.getTypeName()) && !this.dialect.applyHintsOnVirtualTables()) {
            return;
        }
        this.dialect.handleSelectHints(sql, featureType, query);
    }

    protected String selectJoinSQL(SimpleFeatureType featureType, JoinInfo join, Query query) throws IOException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, join.getPrimaryAlias(), query, sql);
        for (JoinInfo.JoinPart part : join.getParts()) {
            this.selectColumns(part.getQueryFeatureType(), part.getAlias(), query, sql);
        }
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableJoin(featureType, join, query, sql);
        this.encodeWhereJoin(featureType, join, sql);
        this.sort(featureType, query.getSortBy(), join.getPrimaryAlias(), sql);
        this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
        return sql.toString();
    }

    void selectColumns(SimpleFeatureType featureType, String prefix, Query query, StringBuffer sql) throws IOException {
        PrimaryKey key = null;
        try {
            key = this.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet<String> pkColumnNames = JDBCDataStore.getColumnNames(key);
        for (PrimaryKeyColumn col : key.getColumns()) {
            this.dialect.encodeColumnName(prefix, col.getName(), sql);
            if (prefix != null) {
                this.dialect.encodeColumnAlias(prefix + "_" + col.getName(), sql);
            }
            sql.append(",");
        }
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            String columnName = att.getLocalName();
            if (pkColumnNames.contains(columnName)) continue;
            String alias = null;
            if (att.getUserData().containsKey(JDBC_COLUMN_ALIAS)) {
                alias = (String)att.getUserData().get(JDBC_COLUMN_ALIAS);
            }
            if (att instanceof GeometryDescriptor) {
                this.encodeGeometryColumn((GeometryDescriptor)att, prefix, sql, query.getHints());
                if (alias == null) {
                    alias = columnName;
                }
            } else {
                this.dialect.encodeColumnName(prefix, columnName, sql);
            }
            if (alias != null) {
                this.dialect.encodeColumnAlias(alias, sql);
            }
            sql.append(",");
        }
    }

    FilterToSQL filter(SimpleFeatureType featureType, Filter filter, StringBuffer sql) throws IOException {
        SimpleFeatureType fullSchema = this.getSchema(featureType.getTypeName());
        FilterToSQL toSQL = this.getFilterToSQL(fullSchema);
        return this.filter(featureType, filter, sql, toSQL);
    }

    FilterToSQL filter(SimpleFeatureType featureType, Filter filter, StringBuffer sql, FilterToSQL toSQL) throws IOException {
        try {
            toSQL.setInline(true);
            String filterSql = toSQL.encodeToString(filter);
            int whereClauseIndex = sql.indexOf(VirtualTable.WHERE_CLAUSE_PLACE_HOLDER);
            if (whereClauseIndex != -1) {
                sql.replace(whereClauseIndex, whereClauseIndex + VirtualTable.WHERE_CLAUSE_PLACE_HOLDER_LENGTH, "AND " + filterSql);
                sql.append("1 = 1");
            } else {
                sql.append(filterSql);
            }
            return toSQL;
        }
        catch (FilterToSQLException e) {
            throw new RuntimeException(e);
        }
    }

    private FilterToSQL getFilterToSQL(SimpleFeatureType fullSchema) {
        return this.dialect instanceof PreparedStatementSQLDialect ? this.createPreparedFilterToSQL(fullSchema) : this.createFilterToSQL(fullSchema);
    }

    void sort(SimpleFeatureType featureType, SortBy[] sort, String prefix, StringBuffer sql) throws IOException {
        if (sort != null && sort.length > 0) {
            PrimaryKey key = this.getPrimaryKey(featureType);
            sql.append(" ORDER BY ");
            for (SortBy sortBy : sort) {
                String order = sortBy.getSortOrder() == SortOrder.DESCENDING ? " DESC" : " ASC";
                if (SortBy.NATURAL_ORDER.equals(sortBy) || SortBy.REVERSE_ORDER.equals(sortBy)) {
                    if (key instanceof NullPrimaryKey) {
                        throw new IOException("Cannot do natural order without a primary key, please add it or specify a manual sort over existing attributes");
                    }
                    for (PrimaryKeyColumn col : key.getColumns()) {
                        this.dialect.encodeColumnName(prefix, col.getName(), sql);
                        sql.append(order);
                        sql.append(",");
                    }
                    continue;
                }
                this.dialect.encodeColumnName(prefix, this.getPropertyName(featureType, sortBy.getPropertyName()), sql);
                sql.append(order);
                sql.append(",");
            }
            sql.setLength(sql.length() - 1);
        }
    }

    protected PreparedStatement selectSQLPS(SimpleFeatureType featureType, Query query, Connection cx) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, null, query, sql);
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, VirtualTable.setKeepWhereClausePlaceHolderHint(query));
        PreparedFilterToSQL toSQL = null;
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            sql.append(" WHERE ");
            toSQL = (PreparedFilterToSQL)this.filter(featureType, filter, sql);
        }
        this.sort(featureType, query.getSortBy(), null, sql);
        this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
        this.applySearchHints(featureType, query, sql);
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(this.fetchSize);
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, 0, cx);
        }
        return ps;
    }

    protected PreparedStatement selectJoinSQLPS(SimpleFeatureType featureType, JoinInfo join, Query query, Connection cx) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, join.getPrimaryAlias(), query, sql);
        for (JoinInfo.JoinPart part : join.getParts()) {
            this.selectColumns(part.getQueryFeatureType(), part.getAlias(), query, sql);
        }
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableJoin(featureType, join, query, sql);
        List<FilterToSQL> toSQLs = this.encodeWhereJoin(featureType, join, sql);
        this.sort(featureType, query.getSortBy(), join.getPrimaryAlias(), sql);
        this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(this.fetchSize);
        this.setPreparedFilterValues(ps, toSQLs, cx);
        return ps;
    }

    protected void setPreparedFilterValues(PreparedStatement ps, List<FilterToSQL> toSQLs, Connection cx) throws SQLException {
        int offset = 0;
        for (FilterToSQL fts : toSQLs) {
            PreparedFilterToSQL toSQL = (PreparedFilterToSQL)fts;
            this.setPreparedFilterValues(ps, toSQL, offset, cx);
            offset += toSQL.getLiteralValues().size();
        }
    }

    public void setPreparedFilterValues(PreparedStatement ps, PreparedFilterToSQL toSQL, int offset, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        for (int i = 0; i < toSQL.getLiteralValues().size(); ++i) {
            Object value = toSQL.getLiteralValues().get(i);
            Class binding = toSQL.getLiteralTypes().get(i);
            Integer srid = toSQL.getSRIDs().get(i);
            Integer dimension = toSQL.getDimensions().get(i);
            AttributeDescriptor ad = toSQL.getDescriptors().get(i);
            if (srid == null) {
                srid = -1;
            }
            if (dimension == null) {
                dimension = 2;
            }
            if (binding != null && Geometry.class.isAssignableFrom(binding)) {
                dialect.setGeometryValue((Geometry)value, dimension, srid, binding, ps, offset + i + 1);
            } else if (ad != null && this.dialect.isArray(ad)) {
                dialect.setArrayValue(value, ad, ps, offset + i + 1, cx);
            } else {
                dialect.setValue(value, binding, ps, offset + i + 1, cx);
            }
            if (!this.LOGGER.isLoggable(Level.FINE)) continue;
            this.LOGGER.fine(i + 1 + " = " + value);
        }
    }

    protected String getPropertyName(SimpleFeatureType featureType, PropertyName propertyName) {
        AttributeDescriptor att = (AttributeDescriptor)propertyName.evaluate((Object)featureType);
        if (att != null) {
            return att.getLocalName();
        }
        return propertyName.getPropertyName();
    }

    protected String selectBoundsSQL(SimpleFeatureType featureType, Query query) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean offsetLimit = this.checkLimitOffset(query.getStartIndex(), query.getMaxFeatures());
        if (offsetLimit) {
            sql.append(" SELECT *");
        } else {
            sql.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sql);
        }
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, VirtualTable.setKeepWhereClausePlaceHolderHint(query));
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                FilterToSQL toSQL = this.createFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (offsetLimit) {
            this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sb);
            sb.append("FROM (");
            sql.insert(0, sb.toString());
            sql.append(")");
            this.dialect.encodeTableAlias("GT2_BOUNDS_", sql);
        }
        this.applySearchHints(featureType, query, sql);
        return sql.toString();
    }

    protected PreparedStatement selectBoundsSQLPS(SimpleFeatureType featureType, Query query, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean offsetLimit = this.checkLimitOffset(query.getStartIndex(), query.getMaxFeatures());
        if (offsetLimit) {
            sql.append(" SELECT *");
        } else {
            sql.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sql);
        }
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, VirtualTable.setKeepWhereClausePlaceHolderHint(query));
        PreparedFilterToSQL toSQL = null;
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                toSQL = this.createPreparedFilterToSQL(featureType);
                int whereClauseIndex = sql.indexOf(VirtualTable.WHERE_CLAUSE_PLACE_HOLDER);
                if (whereClauseIndex != -1) {
                    toSQL.setInline(true);
                    sql.replace(whereClauseIndex, whereClauseIndex + VirtualTable.WHERE_CLAUSE_PLACE_HOLDER_LENGTH, "AND " + toSQL.encodeToString(filter));
                    toSQL.setInline(false);
                } else {
                    sql.append(" ").append(toSQL.encodeToString(filter));
                }
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (offsetLimit) {
            this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sb);
            sb.append("FROM (");
            sql.insert(0, sb.toString());
            sql.append(")");
            this.dialect.encodeTableAlias("GT2_BOUNDS_", sql);
        }
        this.applySearchHints(featureType, query, sql);
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, 0, cx);
        }
        return ps;
    }

    void buildEnvelopeAggregates(SimpleFeatureType featureType, StringBuffer sql) {
        for (AttributeDescriptor attribute : featureType.getAttributeDescriptors()) {
            if (!(attribute instanceof GeometryDescriptor)) continue;
            String geometryColumn = attribute.getLocalName();
            this.dialect.encodeGeometryEnvelope(featureType.getTypeName(), geometryColumn, sql);
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
    }

    protected String selectAggregateSQL(String function, List<Expression> attributes, List<Expression> groupByExpressions, SimpleFeatureType featureType, Query query, LimitingVisitor visitor) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        this.doSelectAggregateSQL(function, attributes, groupByExpressions, featureType, query, visitor, sql);
        return sql.toString();
    }

    protected PreparedStatement selectAggregateSQLPS(String function, List<Expression> attributes, List<Expression> groupByExpressions, SimpleFeatureType featureType, Query query, LimitingVisitor visitor, Connection cx) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        List<FilterToSQL> toSQL = this.doSelectAggregateSQL(function, attributes, groupByExpressions, featureType, query, visitor, sql);
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(this.fetchSize);
        this.setPreparedFilterValues(ps, toSQL, cx);
        return ps;
    }

    List<FilterToSQL> doSelectAggregateSQL(String function, List<Expression> expressions, List<Expression> groupByExpressions, SimpleFeatureType featureType, Query query, LimitingVisitor visitor, StringBuffer sql) throws SQLException, IOException {
        JoinInfo join = !query.getJoins().isEmpty() ? JoinInfo.create(query, featureType, this) : null;
        ArrayList<FilterToSQL> toSQL = new ArrayList<FilterToSQL>();
        boolean queryLimitOffset = this.checkLimitOffset(query.getStartIndex(), query.getMaxFeatures());
        boolean visitorLimitOffset = visitor == null ? false : visitor.hasLimits() && this.dialect.isLimitOffsetSupported();
        boolean groupByComplexExpressions = this.hasComplexExpressions(groupByExpressions);
        if (queryLimitOffset && !visitorLimitOffset && !groupByComplexExpressions) {
            if (join != null) {
                sql.append("SELECT ");
                this.dialect.encodeColumnName(null, join.getPrimaryAlias(), sql);
                sql.append(".* FROM ");
            } else {
                sql.append("SELECT * FROM ");
            }
        } else {
            sql.append("SELECT ");
            FilterToSQL filterToSQL = this.getFilterToSQL(featureType);
            if (groupByExpressions != null && !groupByExpressions.isEmpty()) {
                try {
                    int i = 1;
                    for (Expression expression : groupByExpressions) {
                        GeometryDescriptor gd = this.getGeometryDescriptor(featureType, expression);
                        if (gd != null) {
                            this.dialect.encodeGeometryColumn(gd, null, this.getDescriptorSRID((AttributeDescriptor)gd), null, sql);
                        } else {
                            sql.append(filterToSQL.encodeToString(expression));
                        }
                        if (groupByComplexExpressions) {
                            sql.append(" as ").append(this.getAggregateExpressionAlias(i++));
                        }
                        sql.append(", ");
                    }
                }
                catch (FilterToSQLException e) {
                    throw new RuntimeException("Failed to encode group by expressions", e);
                }
            }
            if (groupByComplexExpressions) {
                if (expressions != null) {
                    int size = expressions.size();
                    for (int i = 0; i < size; ++i) {
                        Expression expr = expressions.get(i);
                        try {
                            String colName = filterToSQL.encodeToString(expr);
                            sql.append(colName);
                            sql.append(" as gt_agg_src_").append(colName.replaceAll("\"", ""));
                            if (i >= size - 1) continue;
                            sql.append(",");
                            continue;
                        }
                        catch (FilterToSQLException e) {
                            throw new RuntimeException("Failed to encode group by expressions", e);
                        }
                    }
                } else {
                    sql.setLength(sql.length() - 2);
                }
            } else {
                this.encodeFunction(function, expressions, sql, filterToSQL);
            }
            toSQL.add(filterToSQL);
            sql.append(" FROM ");
        }
        if (join != null) {
            this.encodeTableJoin(featureType, join, query, sql);
        } else {
            this.encodeTableName(featureType.getTypeName(), sql, VirtualTable.setKeepWhereClausePlaceHolderHint(query));
        }
        if (join != null) {
            toSQL.addAll(this.encodeWhereJoin(featureType, join, sql));
        } else {
            Filter filter = query.getFilter();
            if (filter != null && !Filter.INCLUDE.equals(filter)) {
                sql.append(" WHERE ");
                toSQL.add(this.filter(featureType, filter, sql));
            }
        }
        if (this.dialect.isAggregatedSortSupported(function)) {
            this.sort(featureType, query.getSortBy(), null, sql);
        }
        if (visitorLimitOffset) {
            this.applyLimitOffset(sql, visitor.getStartIndex(), visitor.getMaxFeatures());
        } else if (queryLimitOffset) {
            this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
        }
        boolean isUniqueCount = visitor instanceof UniqueCountVisitor;
        if (queryLimitOffset || groupByComplexExpressions || isUniqueCount) {
            boolean countQuery;
            StringBuffer sql2 = new StringBuffer("SELECT ");
            try {
                if (groupByExpressions != null && !groupByExpressions.isEmpty()) {
                    FilterToSQL filterToSQL = this.getFilterToSQL(featureType);
                    int i = 1;
                    for (Expression expression : groupByExpressions) {
                        if (groupByComplexExpressions) {
                            sql2.append(this.getAggregateExpressionAlias(i++));
                        } else {
                            sql2.append(filterToSQL.encodeToString(expression));
                        }
                        sql2.append(",");
                    }
                    toSQL.add(filterToSQL);
                }
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException("Failed to encode group by expressions", e);
            }
            FilterToSQL filterToSQL = this.getFilterToSQL(featureType);
            boolean bl = countQuery = isUniqueCount || groupByComplexExpressions && "count".equals(function);
            if (countQuery) {
                sql2.append("count(*)");
            } else if (groupByComplexExpressions) {
                sql2.append(function).append("(");
                int size = expressions.size();
                for (int i = 0; i < size; ++i) {
                    Expression expr = expressions.get(i);
                    try {
                        String aliasSuffix = filterToSQL.encodeToString(expr).replaceAll("\"", "");
                        sql2.append("gt_agg_src_").append(aliasSuffix);
                        if (i >= size - 1) continue;
                        sql2.append(",");
                        continue;
                    }
                    catch (FilterToSQLException e) {
                        throw new RuntimeException("Failed to encode column alias in group by.", e);
                    }
                }
                sql2.append(")");
            } else {
                this.encodeFunction(function, expressions, sql2, filterToSQL);
            }
            toSQL.add(filterToSQL);
            sql2.append(" AS gt_result_");
            sql2.append(" FROM (");
            sql.insert(0, sql2);
            sql.append(") gt_limited_");
        }
        FilterToSQL filterToSQL = this.getFilterToSQL(featureType);
        this.encodeGroupByStatement(groupByExpressions, sql, filterToSQL, groupByComplexExpressions);
        toSQL.add(filterToSQL);
        this.applySearchHints(featureType, query, sql);
        return toSQL;
    }

    private GeometryDescriptor getGeometryDescriptor(SimpleFeatureType featureType, Expression expression) {
        if (!(expression instanceof PropertyName)) {
            return null;
        }
        PropertyName pn = (PropertyName)expression;
        AttributeDescriptor ad = featureType.getDescriptor(pn.getPropertyName());
        if (ad instanceof GeometryDescriptor) {
            return (GeometryDescriptor)ad;
        }
        return null;
    }

    private String getAggregateExpressionAlias(int idx) {
        return "gt_agg_" + idx;
    }

    private boolean hasComplexExpressions(List<Expression> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return false;
        }
        return expressions.stream().anyMatch(x -> !(x instanceof PropertyName));
    }

    protected void encodeGroupByStatement(List<Expression> groupByExpressions, StringBuffer sql, FilterToSQL filterToSQL, boolean aggregateOnExpression) {
        if (groupByExpressions == null || groupByExpressions.isEmpty()) {
            return;
        }
        sql.append(" GROUP BY ");
        int i = 1;
        for (Expression groupByExpression : groupByExpressions) {
            if (aggregateOnExpression) {
                sql.append("gt_agg_" + i++);
            } else {
                try {
                    sql.append(filterToSQL.encodeToString(groupByExpression));
                }
                catch (FilterToSQLException e) {
                    throw new RuntimeException(e);
                }
            }
            sql.append(", ");
        }
        sql.setLength(sql.length() - 2);
    }

    protected void encodeFunction(String function, Expression expression, StringBuffer sql, FilterToSQL filterToSQL) {
        this.encodeFunction(function, Arrays.asList(expression), sql, filterToSQL);
    }

    protected void encodeFunction(String function, List<Expression> expressions, StringBuffer sql, FilterToSQL filterToSQL) {
        if (expressions == null || expressions.isEmpty()) {
            sql.append(function);
            sql.append("(");
            sql.append("*");
            sql.append(")");
        } else {
            try {
                int size = expressions.size();
                boolean encodeOnce = this.isEncodeOnceFunction(function);
                if (encodeOnce) {
                    sql.append(function);
                }
                for (int i = 0; i < expressions.size(); ++i) {
                    if (!encodeOnce) {
                        sql.append(function);
                    }
                    Expression e = expressions.get(i);
                    sql.append("(");
                    sql.append(filterToSQL.encodeToString(e));
                    sql.append(")");
                    if (i >= size - 1) continue;
                    sql.append(",");
                }
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isEncodeOnceFunction(String function) {
        Map<Class<? extends FeatureVisitor>, String> functions = this.getAggregateFunctions();
        return Objects.equals(function, functions.get(UniqueVisitor.class));
    }

    protected String deleteSQL(SimpleFeatureType featureType, Filter filter) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                FilterToSQL toSQL = this.createFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        return sql.toString();
    }

    protected PreparedStatement deleteSQLPS(SimpleFeatureType featureType, Filter filter, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        PreparedFilterToSQL toSQL = null;
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                toSQL = this.createPreparedFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, 0, cx);
        }
        return ps;
    }

    protected String insertSQL(SimpleFeatureType featureType, SimpleFeature feature, KeysFetcher keysFetcher, Connection cx) throws SQLException, IOException {
        int i;
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" ( ");
        for (i = 0; i < featureType.getAttributeCount(); ++i) {
            String colName = featureType.getDescriptor(i).getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            dialect.encodeColumnName(null, colName, sql);
            sql.append(",");
        }
        keysFetcher.addKeyColumns(sql);
        sql.setLength(sql.length() - 1);
        sql.append(" ) VALUES ( ");
        for (i = 0; i < featureType.getAttributeCount(); ++i) {
            AttributeDescriptor att = featureType.getDescriptor(i);
            String colName = att.getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            Class<Integer> binding = att.getType().getBinding();
            EnumMapper mapper = (EnumMapper)att.getUserData().get(JDBC_ENUM_MAP);
            Object value = feature.getAttribute(colName);
            if (value == null) {
                if (!att.isNillable()) {
                    throw new IOException("Cannot set a NULL value on the not null column " + colName);
                }
                sql.append("null");
            } else if (Geometry.class.isAssignableFrom(binding)) {
                try {
                    Geometry g = (Geometry)value;
                    int srid = this.getGeometrySRID(g, att);
                    int dimension = this.getGeometryDimension(g, att);
                    dialect.encodeGeometryValue(g, dimension, srid, sql);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                if (mapper != null) {
                    value = mapper.fromString((String)value);
                    binding = Integer.class;
                }
                dialect.encodeValue(value, binding, sql);
            }
            sql.append(",");
        }
        keysFetcher.setKeyValues(this, cx, featureType, feature, sql);
        sql.setLength(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    protected static LinkedHashSet<String> getColumnNames(PrimaryKey key) {
        LinkedHashSet<String> pkColumnNames = new LinkedHashSet<String>();
        for (PrimaryKeyColumn pkcol : key.getColumns()) {
            pkColumnNames.add(pkcol.getName());
        }
        return pkColumnNames;
    }

    protected int getGeometrySRID(Geometry g, AttributeDescriptor descriptor) throws IOException {
        int srid = this.getDescriptorSRID(descriptor);
        if (g == null) {
            return srid;
        }
        if (srid <= 0 && g.getSRID() > 0) {
            srid = g.getSRID();
        }
        if (srid <= 0 && g.getUserData() instanceof CoordinateReferenceSystem) {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)g.getUserData();
            try {
                Integer candidate = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                if (candidate != null) {
                    srid = candidate;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return srid;
    }

    protected int getGeometryDimension(Geometry g, AttributeDescriptor descriptor) throws IOException {
        int dimension = this.getDescriptorDimension(descriptor);
        if (g == null || dimension > 0) {
            return dimension;
        }
        CoordinateSequenceDimensionExtractor dex = new CoordinateSequenceDimensionExtractor();
        g.apply((CoordinateSequenceFilter)dex);
        return dex.getDimension();
    }

    protected int getDescriptorSRID(AttributeDescriptor descriptor) {
        int srid = -1;
        if (descriptor.getUserData().get(JDBC_NATIVE_SRID) != null) {
            srid = (Integer)descriptor.getUserData().get(JDBC_NATIVE_SRID);
        }
        return srid;
    }

    protected int getDescriptorDimension(AttributeDescriptor descriptor) {
        int dimension = -1;
        if (descriptor.getUserData().get(JDBC_NATIVE_SRID) != null) {
            dimension = (Integer)descriptor.getUserData().get(Hints.COORDINATE_DIMENSION);
        }
        return dimension;
    }

    protected String updateSQL(SimpleFeatureType featureType, AttributeDescriptor[] attributes, Object[] values, Filter filter, Set<String> pkColumnNames) throws IOException, SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" SET ");
        for (int i = 0; i < attributes.length; ++i) {
            AttributeDescriptor att = attributes[i];
            String attName = att.getLocalName();
            if (pkColumnNames.contains(attName)) continue;
            dialect.encodeColumnName(null, attName, sql);
            sql.append(" = ");
            Class<Integer> binding = att.getType().getBinding();
            Object value = values[i];
            if (Geometry.class.isAssignableFrom(binding)) {
                try {
                    Geometry g = (Geometry)value;
                    int srid = this.getGeometrySRID(g, att);
                    int dimension = this.getGeometryDimension(g, att);
                    dialect.encodeGeometryValue(g, dimension, srid, sql);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                EnumMapper mapper = (EnumMapper)att.getUserData().get(JDBC_ENUM_MAP);
                if (mapper != null) {
                    value = mapper.fromString((String)Converters.convert((Object)value, String.class));
                    binding = Integer.class;
                }
                dialect.encodeValue(value, binding, sql);
            }
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ");
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                FilterToSQL toSQL = this.createFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        return sql.toString();
    }

    protected PreparedStatement updateSQLPS(SimpleFeatureType featureType, AttributeDescriptor[] attributes, Object[] values, Filter filter, Set<String> pkColumnNames, Connection cx) throws IOException, SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" SET ");
        for (int i = 0; i < attributes.length; ++i) {
            AttributeDescriptor att = attributes[i];
            String attName = att.getLocalName();
            if (pkColumnNames.contains(attName)) continue;
            dialect.encodeColumnName(null, attName, sql);
            sql.append(" = ");
            if (attributes[i] instanceof GeometryDescriptor) {
                Geometry geometry = (Geometry)values[i];
                Class binding = att.getType().getBinding();
                dialect.prepareGeometryValue(geometry, this.getDescriptorDimension(att), this.getDescriptorSRID(att), binding, sql);
            } else {
                sql.append("?");
            }
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ");
        PreparedFilterToSQL toSQL = null;
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                toSQL = this.createPreparedFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        this.LOGGER.log(Level.FINE, "Updating features with prepared statement: {0}", sql);
        int j = 0;
        for (int i = 0; i < attributes.length; ++i) {
            AttributeDescriptor att = attributes[i];
            String attName = att.getLocalName();
            if (pkColumnNames.contains(attName)) continue;
            Class<Integer> binding = att.getType().getBinding();
            Object value = values[i];
            if (Geometry.class.isAssignableFrom(binding)) {
                Geometry g = (Geometry)value;
                dialect.setGeometryValue(g, this.getDescriptorDimension(att), this.getDescriptorSRID(att), binding, ps, j + 1);
            } else {
                EnumMapper mapper = (EnumMapper)att.getUserData().get(JDBC_ENUM_MAP);
                if (mapper != null) {
                    value = mapper.fromString((String)Converters.convert((Object)value, String.class));
                    binding = Integer.class;
                }
                dialect.setValue(value, binding, ps, j + 1, cx);
            }
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.fine(j + 1 + " = " + value);
            }
            ++j;
        }
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, j, cx);
        }
        return ps;
    }

    public FilterToSQL createFilterToSQL(SimpleFeatureType featureType) {
        return this.initializeFilterToSQL(((BasicSQLDialect)this.dialect).createFilterToSQL(), featureType);
    }

    public PreparedFilterToSQL createPreparedFilterToSQL(SimpleFeatureType featureType) {
        return this.initializeFilterToSQL(((PreparedStatementSQLDialect)this.dialect).createPreparedFilterToSQL(), featureType);
    }

    protected <F extends FilterToSQL> F initializeFilterToSQL(F toSQL, SimpleFeatureType featureType) {
        toSQL.setSqlNameEscape(this.dialect.getNameEscape());
        if (featureType != null) {
            PrimaryKey key;
            try {
                key = this.getPrimaryKey(featureType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            toSQL.setFeatureType(featureType);
            toSQL.setPrimaryKey(key);
            toSQL.setDatabaseSchema(this.databaseSchema);
        }
        return toSQL;
    }

    public void encodeTableName(String tableName, StringBuffer sql, Hints hints) throws SQLException {
        this.encodeAliasedTableName(tableName, sql, hints, null);
    }

    public void encodeAliasedTableName(String tableName, StringBuffer sql, Hints hints, String alias) throws SQLException {
        VirtualTable vtDefinition = this.virtualTables.get(tableName);
        if (vtDefinition != null) {
            sql.append("(").append(vtDefinition.expandParameters(hints)).append(")");
            if (alias == null) {
                alias = "vtable";
            }
            this.dialect.encodeTableAlias(alias, sql);
        } else {
            if (this.databaseSchema != null) {
                this.dialect.encodeSchemaName(this.databaseSchema, sql);
                sql.append(".");
            }
            this.dialect.encodeTableName(tableName, sql);
            if (alias != null) {
                this.dialect.encodeTableAlias(alias, sql);
            }
        }
    }

    protected void encodeTableJoin(SimpleFeatureType featureType, JoinInfo join, Query query, StringBuffer sql) throws SQLException {
        this.encodeAliasedTableName(featureType.getTypeName(), sql, query.getHints(), join.getPrimaryAlias());
        for (JoinInfo.JoinPart part : join.getParts()) {
            sql.append(" ");
            this.dialect.encodeJoin(part.getJoin().getType(), sql);
            sql.append(" ");
            this.encodeAliasedTableName(part.getQueryFeatureType().getTypeName(), sql, VirtualTable.setKeepWhereClausePlaceHolderHint(null, true), part.getAlias());
            sql.append(" ON ");
            Filter j = part.getJoinFilter();
            FilterToSQL toSQL = this.getFilterToSQL(null);
            toSQL.setInline(true);
            try {
                sql.append(" ").append(toSQL.encodeToString(j));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (sql.indexOf(VirtualTable.WHERE_CLAUSE_PLACE_HOLDER) >= 0) {
            throw new RuntimeException("Joins between virtual tables that provide a :where_placeholder: are not supported: " + sql);
        }
    }

    protected List<FilterToSQL> encodeWhereJoin(SimpleFeatureType featureType, JoinInfo join, StringBuffer sql) throws IOException {
        ArrayList<FilterToSQL> toSQL = new ArrayList<FilterToSQL>();
        boolean whereEncoded = false;
        Filter filter = join.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            sql.append(" WHERE ");
            whereEncoded = true;
            toSQL.add(this.filter(featureType, filter, sql));
        }
        for (JoinInfo.JoinPart part : join.getParts()) {
            filter = part.getPreFilter();
            if (filter == null || Filter.INCLUDE.equals(filter)) continue;
            if (!whereEncoded) {
                sql.append(" WHERE ");
                whereEncoded = true;
            } else {
                sql.append(" AND ");
            }
            toSQL.add(this.filter(part.getQueryFeatureType(), filter, sql));
        }
        return toSQL;
    }

    protected void setGmlProperties(Geometry g, String gid, String name, String description) {
        Map<String, String> userData = null;
        if (g.getUserData() != null) {
            if (g.getUserData() instanceof Map) {
                Map cast = (Map)g.getUserData();
                userData = cast;
            } else {
                userData = new HashMap();
                userData.put((String)((Object)g.getUserData().getClass()), (String)g.getUserData());
            }
        } else {
            userData = new HashMap<Object, Object>();
        }
        if (gid != null) {
            userData.put("gml:id", gid);
        }
        if (name != null) {
            userData.put("gml:name", name);
        }
        if (description != null) {
            userData.put("gml:description", description);
        }
        g.setUserData(userData);
    }

    void applyLimitOffset(StringBuffer sql, Integer offset, int limit) {
        if (this.checkLimitOffset(offset, limit)) {
            this.dialect.applyLimitOffset(sql, limit, offset != null ? offset : 0);
        }
    }

    public void applyLimitOffset(StringBuffer sql, Query query) {
        this.applyLimitOffset(sql, query.getStartIndex(), query.getMaxFeatures());
    }

    boolean checkLimitOffset(Integer offset, int limit) {
        if (!this.dialect.isLimitOffsetSupported()) {
            return false;
        }
        return limit != Integer.MAX_VALUE || offset != null && offset > 0;
    }

    public void closeSafe(ResultSet rs) {
        block3: {
            if (rs == null) {
                return;
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                String msg = "Error occurred closing result set";
                this.LOGGER.warning(msg);
                if (!this.LOGGER.isLoggable(Level.FINER)) break block3;
                this.LOGGER.log(Level.FINER, msg, e);
            }
        }
    }

    public void closeSafe(Statement st) {
        block3: {
            if (st == null) {
                return;
            }
            try {
                st.close();
            }
            catch (SQLException e) {
                String msg = "Error occurred closing statement";
                this.LOGGER.warning(msg);
                if (!this.LOGGER.isLoggable(Level.FINER)) break block3;
                this.LOGGER.log(Level.FINER, msg, e);
            }
        }
    }

    public void closeSafe(Connection cx) {
        block3: {
            if (cx == null) {
                return;
            }
            try {
                cx.close();
                this.LOGGER.fine("CLOSE CONNECTION");
            }
            catch (SQLException e) {
                String msg = "Error occurred closing connection";
                this.LOGGER.warning(msg);
                if (!this.LOGGER.isLoggable(Level.FINER)) break block3;
                this.LOGGER.log(Level.FINER, msg, e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.dataSource != null) {
            this.LOGGER.severe("There's code using JDBC based datastore and not disposing them. This may lead to temporary loss of database connections. Please make sure all data access code calls DataStore.dispose() before freeing all references to it");
            this.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.dataSource != null && this.dataSource instanceof ManageableDataSource) {
            try {
                ManageableDataSource mds = (ManageableDataSource)this.dataSource;
                mds.close();
            }
            catch (SQLException e) {
                this.LOGGER.log(Level.FINE, "Could not close dataSource", e);
            }
        }
        if (TRACE_ENABLED.booleanValue()) {
            this.disposedBy = new RuntimeException("DataSource disposed by thread " + Thread.currentThread().getName());
        }
        this.dataSource = null;
    }

    protected boolean isGeneralizationRequired(Hints hints, GeometryDescriptor gatt) {
        return this.isGeometryReduceRequired(hints, gatt, Hints.GEOMETRY_GENERALIZATION);
    }

    protected boolean isSimplificationRequired(Hints hints, GeometryDescriptor gatt) {
        return this.isGeometryReduceRequired(hints, gatt, Hints.GEOMETRY_SIMPLIFICATION);
    }

    protected boolean isGeometryReduceRequired(Hints hints, GeometryDescriptor gatt, Hints.Key param) {
        if (hints == null) {
            return false;
        }
        if (!hints.containsKey((Object)param)) {
            return false;
        }
        return gatt.getType().getBinding() != Point.class || this.dialect.canSimplifyPoints();
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, StringBuffer sql, Hints hints) {
        this.encodeGeometryColumn(gatt, null, sql, hints);
    }

    protected void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, StringBuffer sql, Hints hints) {
        int srid = this.getDescriptorSRID((AttributeDescriptor)gatt);
        if (this.isGeneralizationRequired(hints, gatt)) {
            Double distance = (Double)hints.get((Object)Hints.GEOMETRY_GENERALIZATION);
            this.dialect.encodeGeometryColumnGeneralized(gatt, prefix, srid, sql, distance);
            return;
        }
        if (this.isSimplificationRequired(hints, gatt)) {
            Double distance = (Double)hints.get((Object)Hints.GEOMETRY_SIMPLIFICATION);
            this.dialect.encodeGeometryColumnSimplified(gatt, prefix, srid, sql, distance);
            return;
        }
        this.dialect.encodeGeometryColumn(gatt, prefix, srid, hints, sql);
    }

    public Transaction buildTransaction(Connection cx) {
        DefaultTransaction tx = new DefaultTransaction();
        JDBCTransactionState state = new JDBCTransactionState(cx, this, true);
        tx.putState((Object)this, (Transaction.State)state);
        return tx;
    }

    public void createIndex(Index index) throws IOException {
        SimpleFeatureType schema = this.getSchema(index.typeName);
        Connection cx = null;
        try {
            cx = this.getConnection(Transaction.AUTO_COMMIT);
            this.dialect.createIndex(cx, schema, this.databaseSchema, index);
        }
        catch (SQLException e) {
            throw new IOException("Failed to create index", e);
        }
        finally {
            this.closeSafe(cx);
        }
    }

    public void dropIndex(String typeName, String indexName) throws IOException {
        SimpleFeatureType schema = this.getSchema(typeName);
        Connection cx = null;
        try {
            cx = this.getConnection(Transaction.AUTO_COMMIT);
            this.dialect.dropIndex(cx, schema, this.databaseSchema, indexName);
        }
        catch (SQLException e) {
            throw new IOException("Failed to drop index", e);
        }
        finally {
            this.closeSafe(cx);
        }
    }

    public List<Index> getIndexes(String typeName) throws IOException {
        this.getSchema(typeName);
        Connection cx = null;
        try {
            cx = this.getConnection(Transaction.AUTO_COMMIT);
            List<Index> list = this.dialect.getIndexes(cx, this.databaseSchema, typeName);
            return list;
        }
        catch (SQLException e) {
            throw new IOException("Failed to get indexes", e);
        }
        finally {
            this.closeSafe(cx);
        }
    }

    public String escapeNamePattern(DatabaseMetaData metaData, String name) throws SQLException {
        if (this.namePatternEscaping == null) {
            this.namePatternEscaping = new NamePatternEscaping(metaData.getSearchStringEscape());
        }
        return this.namePatternEscaping.escape(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Name> getTypeNames(Name name) throws IOException {
        Connection cx = this.createConnection();
        ArrayList<Name> typeNames = new ArrayList<Name>();
        try {
            DatabaseMetaData metaData = cx.getMetaData();
            HashSet<String> availableTableTypes = new HashSet<String>();
            ResultSet tableTypes = null;
            try {
                tableTypes = metaData.getTableTypes();
                while (tableTypes.next()) {
                    availableTableTypes.add(tableTypes.getString("TABLE_TYPE"));
                }
            }
            finally {
                this.closeSafe(tableTypes);
            }
            HashSet<String> queryTypes = new HashSet<String>();
            for (String desiredTableType : this.dialect.getDesiredTablesType()) {
                if (!availableTableTypes.contains(desiredTableType)) continue;
                queryTypes.add(desiredTableType);
            }
            if (availableTableTypes.contains("PARTITIONED TABLE")) {
                queryTypes.add("PARTITIONED TABLE");
            }
            ResultSet tables = metaData.getTables(null, this.escapeNamePattern(metaData, this.databaseSchema), this.escapeNamePattern(metaData, name.getLocalPart()), queryTypes.toArray(new String[0]));
            try {
                if (this.fetchSize > 1) {
                    tables.setFetchSize(this.fetchSize);
                }
                while (tables.next()) {
                    String tableName;
                    String schemaName = tables.getString("TABLE_SCHEM");
                    if (!this.dialect.includeTable(schemaName, tableName = tables.getString("TABLE_NAME"), cx)) continue;
                    typeNames.add((Name)new NameImpl(this.namespaceURI, tableName));
                }
            }
            finally {
                this.closeSafe(tables);
            }
        }
        catch (SQLException e) {
            throw (IOException)new IOException("Error occurred getting table name list.").initCause(e);
        }
        finally {
            this.closeSafe(cx);
        }
        for (String virtualTable : this.virtualTables.keySet()) {
            typeNames.add((Name)new NameImpl(this.namespaceURI, virtualTable));
        }
        return typeNames;
    }
}

