/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.config;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.geoway.config.AtlasSsoClientConfig;
import com.uc.sso.UserCenterClient;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="uc-sso-client")
public class UcSsoClientConfig {
    @Resource
    private AtlasSsoClientConfig atlasSsoClientConfig;
    private String certPath = "35bdb393-a84c-427c-9d55-c5aaf143ee27.cer";
    private String webAuthBaseUrl;
    private String separator = "#";
    private String loginPath = "/uc/sso/login";
    private String logoutPath = "/uc/sso/logout";

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getWebAuthBaseUrl() {
        return this.webAuthBaseUrl;
    }

    public void setWebAuthBaseUrl(String webAuthBaseUrl) {
        this.webAuthBaseUrl = webAuthBaseUrl;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public void setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
    }

    public String getLoginUrl() {
        String baseUrl = this.checkBaseUrl();
        return baseUrl + this.loginPath;
    }

    public String getLogoutUrl() {
        String baseUrl = this.checkBaseUrl();
        return baseUrl + this.logoutPath;
    }

    private String checkBaseUrl() {
        Assert.state((boolean)StrUtil.isNotEmpty((CharSequence)this.webAuthBaseUrl), (String)"\u8ba4\u8bc1\u8def\u5f84\u4e3a\u7a7a", (Object[])new Object[0]);
        String baseUrl = this.webAuthBaseUrl;
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        baseUrl = baseUrl + this.separator;
        return baseUrl;
    }

    @PostConstruct
    private void initUc() {
        if (this.atlasSsoClientConfig.isUcMode()) {
            UserCenterClient.init((String)this.certPath);
        }
    }
}

