/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import com.geoway.po.Tenant;
import com.geoway.util.ServerPushUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

public class TenantListener {
    private Function<Tenant, Void> onAddFunction;
    private Function<Tenant, Void> onDeleteFunction;
    private String schedulingPattern = "* * * * ?";
    private boolean configSchedulingPattern = false;
    private List<Tenant> tenants = new ArrayList<Tenant>();

    public static TenantListener newInstance() {
        return new TenantListener();
    }

    private TenantListener() {
    }

    public void start() {
        if (CronUtil.getScheduler().isMatchSecond() && !this.configSchedulingPattern) {
            this.schedulingPattern = "0/10 * * * * ?";
        }
        CronUtil.schedule((String)this.schedulingPattern, this::checkTenant);
        if (!CronUtil.getScheduler().isStarted()) {
            CronUtil.start((boolean)true);
        }
    }

    private void checkTenant() {
        List<Tenant> nowTenants = ServerPushUtil.getAllTenants();
        if (this.onAddFunction != null) {
            HashSet<Tenant> addTenants = new HashSet<Tenant>(nowTenants);
            addTenants.removeAll(new HashSet<Tenant>(this.tenants));
            addTenants.forEach(t -> this.onAddFunction.apply((Tenant)t));
        }
        if (this.onDeleteFunction != null) {
            HashSet<Tenant> deleteTenants = new HashSet<Tenant>(this.tenants);
            deleteTenants.removeAll(new HashSet<Tenant>(nowTenants));
            deleteTenants.forEach(t -> this.onDeleteFunction.apply((Tenant)t));
        }
        this.tenants = nowTenants;
    }

    public TenantListener withSchedulingPattern(String schedulingPattern) {
        this.schedulingPattern = schedulingPattern;
        if (StrUtil.isNotEmpty((CharSequence)schedulingPattern)) {
            this.configSchedulingPattern = true;
        }
        return this;
    }

    public TenantListener withAddFunction(Function<Tenant, Void> onAddFunction) {
        this.onAddFunction = onAddFunction;
        return this;
    }

    public TenantListener withDeleteFunction(Function<Tenant, Void> onDeleteFunction) {
        this.onDeleteFunction = onDeleteFunction;
        return this;
    }

    public TenantListener withTenants(List<Tenant> tenants) {
        if (tenants == null) {
            tenants = new ArrayList<Tenant>();
        }
        this.tenants = tenants;
        return this;
    }
}

