/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.controller;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.processor.SaSsoClientProcessor;
import cn.dev33.satoken.sso.template.SaSsoClientTemplate;
import cn.dev33.satoken.sso.template.SaSsoClientUtil;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.util.SaResult;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SsoClientController {
    @GetMapping(value={"/sso/isLogin"})
    public SaResult isLogin() {
        return SaResult.data((Object)StpUtil.isLogin());
    }

    @GetMapping(value={"/sso/user"})
    public SaResult userinfo() {
        if (!StpUtil.isLogin()) {
            return SaResult.data(Collections.emptyList());
        }
        Object loginId = StpUtil.getLoginId();
        SaSsoMessage message = new SaSsoMessage();
        message.setType("userinfo");
        message.set("loginId", loginId);
        return SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message);
    }

    @GetMapping(value={"/sso/tenants"})
    public SaResult tenants() {
        if (!StpUtil.isLogin()) {
            return SaResult.data(Collections.emptyList());
        }
        Object loginId = StpUtil.getLoginId();
        SaSsoMessage message = new SaSsoMessage();
        message.setType("tenantInfo");
        message.set("loginId", loginId);
        return SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message);
    }

    @GetMapping(value={"/sso/token"})
    public SaResult token() {
        if (!StpUtil.isLogin()) {
            return SaResult.data(Collections.emptyList());
        }
        return SaResult.data((Object)StpUtil.getTokenInfo());
    }

    @GetMapping(value={"/sso/*"})
    public Object ssoRequest() {
        return SaSsoClientProcessor.instance.dister();
    }

    @Autowired
    private void configSso(SaSsoClientTemplate ssoClientTemplate) {
        ssoClientTemplate.strategy.ticketResultHandle = (ctr, back) -> {
            StpLogic stpLogic = ssoClientTemplate.getStpLogicOrGlobal();
            stpLogic.login(ctr.loginId, new SaLoginParameter().setTimeout(ctr.remainTokenTimeout.longValue()).setDeviceId(ctr.deviceId).setToken(ctr.tokenValue));
            SaResponse res = SaHolder.getResponse();
            return res.redirect(back);
        };
    }

    @RequestMapping(value={"/sso/logoutByAlone"})
    public Object logoutByAlone() {
        StpUtil.logout();
        return SaSsoClientProcessor.instance._ssoLogoutBack(SaHolder.getRequest(), SaHolder.getResponse());
    }
}

