/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.controller;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.processor.SaSsoClientProcessor;
import cn.dev33.satoken.sso.template.SaSsoClientTemplate;
import cn.dev33.satoken.sso.template.SaSsoClientUtil;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.geoway.po.SsoUser;
import com.geoway.po.UisTenant;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SsoClientController {
    public static final String CURR_TENANT = "currTenant";
    private static final TimedCache<String, Object> AUTH_CACHE = CacheUtil.newTimedCache((long)600000L);

    @GetMapping(value={"/sso/isLogin"})
    public SaResult isLogin() {
        return SaResult.data((Object)StpUtil.isLogin());
    }

    @GetMapping(value={"/sso/user"})
    public SaResult userinfo() {
        if (!StpUtil.isLogin()) {
            return SaResult.data(null);
        }
        SsoUser user = SsoClientController.getUser();
        if (user == null) {
            return SaResult.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return SaResult.data((Object)user);
    }

    public static SsoUser getUser() {
        Object loginId = StpUtil.getLoginId();
        SaSsoMessage message = new SaSsoMessage();
        message.setType("userinfo");
        message.set("loginId", loginId);
        Object data = SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message).getData();
        if (data == null) {
            return null;
        }
        SsoUser ssoUser = (SsoUser)BeanUtil.toBean((Object)data, SsoUser.class);
        Object tenants = SsoClientController.getTenants().getData();
        List uisTenants = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)tenants), UisTenant.class);
        ssoUser.setTenants(uisTenants);
        ssoUser.setCurrTenant(SsoClientController.getCurrTenant(uisTenants));
        return ssoUser;
    }

    @GetMapping(value={"/sso/tenants"})
    public SaResult tenants() {
        if (!StpUtil.isLogin()) {
            return SaResult.data(Collections.emptyList());
        }
        return SsoClientController.getTenants();
    }

    private static SaResult getTenants() {
        Object loginId = StpUtil.getLoginId();
        SaSsoMessage message = new SaSsoMessage();
        message.setType("tenantInfo");
        message.set("loginId", loginId);
        return SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message);
    }

    @RequestMapping(value={"/sso/currTenant"}, method={RequestMethod.GET, RequestMethod.POST})
    public SaResult currTenant(@RequestParam(required=false) String currTenant) {
        if (!StpUtil.isLogin()) {
            return SaResult.data(null);
        }
        Object data = this.tenants().getData();
        if (data == null) {
            return SaResult.error((String)"\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25");
        }
        List uisTenants = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)data), UisTenant.class);
        if (uisTenants.isEmpty()) {
            return SaResult.error((String)"\u7528\u6237\u79df\u6237\u4e3a\u7a7a");
        }
        if (StrUtil.isNotEmpty((CharSequence)currTenant)) {
            UisTenant uisTenant = uisTenants.stream().filter(u -> currTenant.equals(u.getName())).findFirst().orElse(null);
            if (uisTenant == null) {
                return SaResult.error((String)("\u79df\u6237\u4e0d\u5b58\u5728 : " + currTenant));
            }
            StpUtil.getSession().set(CURR_TENANT, (Object)uisTenant);
            return SaResult.data((Object)uisTenant);
        }
        return SaResult.data((Object)SsoClientController.getCurrTenant(uisTenants));
    }

    private static UisTenant getCurrTenant(List<UisTenant> uisTenants) {
        UisTenant uisTenant;
        if (CollectionUtil.isEmpty(uisTenants)) {
            return null;
        }
        SaSession session = StpUtil.getSession();
        if (session.has(CURR_TENANT)) {
            uisTenant = (UisTenant)BeanUtil.toBean((Object)session.get(CURR_TENANT), UisTenant.class);
            boolean exist = uisTenants.stream().anyMatch(u -> uisTenant.getName().equals(u.getName()));
            if (exist) {
                return uisTenant;
            }
        }
        uisTenant = uisTenants.get(0);
        session.set(CURR_TENANT, (Object)uisTenant);
        return uisTenant;
    }

    @GetMapping(value={"/sso/token"})
    public SaResult token(@RequestParam(required=false) String authId) {
        if (!StpUtil.isLogin()) {
            if (StrUtil.isNotEmpty((CharSequence)authId)) {
                Object o = AUTH_CACHE.get((Object)authId, false);
                if (o != null) {
                    AUTH_CACHE.remove((Object)authId);
                }
                return SaResult.data((Object)o);
            }
            return SaResult.data(null);
        }
        return SaResult.data((Object)StpUtil.getTokenInfo());
    }

    @GetMapping(value={"/sso/*"})
    public Object ssoRequest() {
        return SaSsoClientProcessor.instance.dister();
    }

    @Autowired
    private void configSso(SaSsoClientTemplate ssoClientTemplate) {
        ssoClientTemplate.strategy.ticketResultHandle = (ctr, back) -> {
            StpLogic stpLogic = ssoClientTemplate.getStpLogicOrGlobal();
            stpLogic.login(ctr.loginId, new SaLoginParameter().setTimeout(ctr.remainTokenTimeout.longValue()).setDeviceId(ctr.deviceId).setToken(ctr.tokenValue));
            String authId = IdUtil.fastSimpleUUID();
            AUTH_CACHE.put((Object)authId, (Object)stpLogic.getTokenInfo());
            SaResponse res = SaHolder.getResponse();
            return res.redirect(SaFoxUtil.joinParam((String)back, (String)"authId", (Object)authId));
        };
    }

    @RequestMapping(value={"/sso/logoutByAlone"})
    public Object logoutByAlone() {
        StpUtil.logout();
        return SaSsoClientProcessor.instance._ssoLogoutBack(SaHolder.getRequest(), SaHolder.getResponse());
    }
}

