/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.controller;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sso.processor.SaSsoClientProcessor;
import cn.dev33.satoken.sso.template.SaSsoClientTemplate;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.config.AtlasSsoClientConfig;
import com.geoway.po.UisTenant;
import com.geoway.po.UisUser;
import com.geoway.uc.UcSsoClientProcessor;
import com.geoway.util.ClientCacheUtil;
import com.geoway.util.ServerPushUtil;
import com.uc.sso.UserCenterClient;
import com.uc.sso.dto.UserSyncPushDTO;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SsoClientController {
    @Resource
    private AtlasSsoClientConfig atlasSsoClientConfig;
    @Resource
    private UcSsoClientProcessor ucSsoClientProcessor;
    public static final String CURR_TENANT = "currTenant";

    @GetMapping(value={"/sso/isLogin"})
    public SaResult isLogin() {
        return SaResult.data((Object)StpUtil.isLogin());
    }

    @GetMapping(value={"/sso/user"})
    public SaResult userinfo() {
        String loginId;
        UisUser cacheUser;
        if (!StpUtil.isLogin()) {
            return SaResult.data(null);
        }
        if (this.atlasSsoClientConfig.isUcMode() && (cacheUser = ClientCacheUtil.getUser(loginId = String.valueOf(StpUtil.getLoginId()))) != null) {
            return SaResult.data((Object)cacheUser);
        }
        UisUser user = SsoClientController.getUser();
        if (user == null) {
            return SaResult.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return SaResult.data((Object)user);
    }

    public static UisUser getUser() {
        UisUser user = ServerPushUtil.getUser();
        if (user == null) {
            return null;
        }
        List<UisTenant> tenants = ServerPushUtil.getTenants();
        user.setTenants(tenants);
        user.setCurrTenant(SsoClientController.getCurrTenant(tenants));
        return user;
    }

    @GetMapping(value={"/sso/tenants"})
    public SaResult tenants() {
        if (!StpUtil.isLogin()) {
            return SaResult.data(Collections.emptyList());
        }
        return SaResult.data(ServerPushUtil.getTenants());
    }

    @RequestMapping(value={"/sso/currTenant"}, method={RequestMethod.GET, RequestMethod.POST})
    public SaResult currTenant(@RequestParam(required=false) String currTenant) {
        if (!StpUtil.isLogin()) {
            return SaResult.data(null);
        }
        List<UisTenant> uisTenants = ServerPushUtil.getTenants();
        if (StrUtil.isNotEmpty((CharSequence)currTenant)) {
            UisTenant uisTenant = uisTenants.stream().filter(u -> currTenant.equals(u.getName())).findFirst().orElse(null);
            if (uisTenant == null) {
                return SaResult.error((String)("\u79df\u6237\u4e0d\u5b58\u5728 : " + currTenant));
            }
            StpUtil.getSession().set(CURR_TENANT, (Object)uisTenant);
            return SaResult.data((Object)uisTenant);
        }
        return SaResult.data((Object)SsoClientController.getCurrTenant(uisTenants));
    }

    private static UisTenant getCurrTenant(List<UisTenant> uisTenants) {
        UisTenant uisTenant;
        if (CollectionUtil.isEmpty(uisTenants)) {
            return null;
        }
        SaSession session = StpUtil.getSession();
        if (session.has(CURR_TENANT)) {
            uisTenant = (UisTenant)BeanUtil.toBean((Object)session.get(CURR_TENANT), UisTenant.class);
            boolean exist = uisTenants.stream().anyMatch(u -> uisTenant.getName().equals(u.getName()));
            if (exist) {
                return uisTenant;
            }
        }
        uisTenant = uisTenants.get(0);
        session.set(CURR_TENANT, (Object)uisTenant);
        return uisTenant;
    }

    @GetMapping(value={"/sso/token"})
    public SaResult token(@RequestParam(required=false) String authId) {
        if (!StpUtil.isLogin()) {
            if (StrUtil.isNotEmpty((CharSequence)authId)) {
                return SaResult.data((Object)ClientCacheUtil.getToken(authId));
            }
            return SaResult.data(null);
        }
        return SaResult.data((Object)StpUtil.getTokenInfo());
    }

    @GetMapping(value={"/sso/*"})
    public Object ssoRequest() {
        if (this.atlasSsoClientConfig.isUcMode()) {
            return this.ucSsoClientProcessor.dister();
        }
        return SaSsoClientProcessor.instance.dister();
    }

    @PostMapping(value={"/sso/uc/logout"})
    public Object ucLogoutCall(@RequestBody String encryptedData) {
        UserCenterClient ucClient = UserCenterClient.getInstance();
        String s = ucClient.decryptData(encryptedData);
        String token = JSONUtil.parseObj((String)s).getStr((Object)"token");
        Assert.state((boolean)StrUtil.isNotEmpty((CharSequence)token), (String)"\u5355\u70b9\u6ce8\u9500\u56de\u8c03\u5931\u8d25 : token\u4e3a\u7a7a", (Object[])new Object[0]);
        StpUtil.logoutByTokenValue((String)token);
        return SaResult.code((int)0);
    }

    @PostMapping(value={"/sso/uc/syncUser"})
    public Object syncUser(@RequestBody String encryptedData) {
        UserCenterClient ucClient = UserCenterClient.getInstance();
        String s = ucClient.decryptData(encryptedData);
        UserSyncPushDTO userSyncPushDTO = (UserSyncPushDTO)JSONUtil.toBean((String)s, UserSyncPushDTO.class);
        UisUser user = this.toUisUser(userSyncPushDTO);
        boolean success = ServerPushUtil.syncUser(user);
        if (success) {
            return SaResult.code((int)0);
        }
        return SaResult.error((String)"\u540c\u6b65\u7528\u6237\u56de\u8c03\u5931\u8d25");
    }

    private UisUser toUisUser(UserSyncPushDTO userInfo) {
        UisUser user = new UisUser();
        user.setId(userInfo.getUserCode());
        user.setRealName(userInfo.getRealname());
        user.setUsername(userInfo.getUsername());
        user.setPassword("Aa@123456");
        user.setMobilePhone(userInfo.getTelPhone());
        user.setCreateTime(LocalDateTime.now());
        return user;
    }

    @Autowired
    private void configSso(SaSsoClientTemplate ssoClientTemplate) {
        ssoClientTemplate.strategy.ticketResultHandle = (ctr, back) -> {
            StpLogic stpLogic = ssoClientTemplate.getStpLogicOrGlobal();
            stpLogic.login(ctr.loginId, new SaLoginParameter().setTimeout(ctr.remainTokenTimeout.longValue()).setDeviceId(ctr.deviceId).setToken(ctr.tokenValue));
            SaResponse res = SaHolder.getResponse();
            URL reqUrl = URLUtil.url((String)SaHolder.getRequest().getUrl());
            URL backUrl = URLUtil.url((String)back);
            if (StrUtil.equals((CharSequence)reqUrl.getProtocol(), (CharSequence)backUrl.getProtocol()) && StrUtil.equals((CharSequence)reqUrl.getAuthority(), (CharSequence)backUrl.getAuthority())) {
                return res.redirect(back);
            }
            String authId = IdUtil.fastSimpleUUID();
            ClientCacheUtil.saveToken(authId, stpLogic.getTokenInfo());
            return res.redirect(SaFoxUtil.joinParam((String)back, (String)"authId", (Object)authId));
        };
    }

    @RequestMapping(value={"/sso/logoutByAlone"})
    public Object logoutByAlone() {
        StpUtil.logout();
        return SaSsoClientProcessor.instance._ssoLogoutBack(SaHolder.getRequest(), SaHolder.getResponse());
    }
}

