/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.util;

import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.template.SaSsoClientUtil;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.util.SaResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.StaticLog;
import com.geoway.po.Tenant;
import com.geoway.po.User;
import java.util.Collections;
import java.util.List;

public class ServerPushUtil {
    public static final String CURR_TENANT = "currTenant";

    public static User getSimpleUser() {
        if (!StpUtil.isLogin()) {
            return null;
        }
        Object loginId = StpUtil.getLoginId();
        SaSsoMessage message = new SaSsoMessage();
        message.setType("userinfo");
        message.set("loginId", loginId);
        SaResult saResult = SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message);
        Object data = saResult.getData();
        if (data == null) {
            StaticLog.error((String)saResult.getMsg(), (Object[])new Object[0]);
            return null;
        }
        return (User)BeanUtil.toBean((Object)data, User.class);
    }

    public static List<Tenant> getAllTenants() {
        SaSsoMessage message = new SaSsoMessage();
        message.setType("tenantInfo");
        SaResult saResult = SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message);
        if (saResult.getData() == null) {
            StaticLog.error((String)saResult.getMsg(), (Object[])new Object[0]);
            return Collections.emptyList();
        }
        return JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)saResult.getData()), Tenant.class);
    }

    public static Tenant getCurrTenant(List<Tenant> Tenants) {
        Tenant Tenant2;
        if (CollectionUtil.isEmpty(Tenants)) {
            return null;
        }
        SaSession session = StpUtil.getSession();
        if (session.has(CURR_TENANT)) {
            Tenant2 = (Tenant)BeanUtil.toBean((Object)session.get(CURR_TENANT), Tenant.class);
            boolean exist = Tenants.stream().anyMatch(u -> Tenant2.getName().equals(u.getName()));
            if (exist) {
                return Tenant2;
            }
        }
        Tenant2 = Tenants.get(0);
        session.set(CURR_TENANT, (Object)Tenant2);
        return Tenant2;
    }

    public static User getUser() {
        User user = ServerPushUtil.getSimpleUser();
        if (user == null) {
            return null;
        }
        List<Tenant> tenants = ServerPushUtil.getTenants();
        user.setTenants(tenants);
        user.setCurrTenant(ServerPushUtil.getCurrTenant(tenants));
        return user;
    }

    public static Tenant currTenant(String currTenant) {
        if (!StpUtil.isLogin()) {
            return null;
        }
        List<Tenant> Tenants = ServerPushUtil.getTenants();
        if (StrUtil.isNotEmpty((CharSequence)currTenant)) {
            Tenant tenant = Tenants.stream().filter(u -> currTenant.equals(u.getName())).findFirst().orElse(null);
            if (tenant == null) {
                throw new RuntimeException("\u79df\u6237\u4e0d\u5b58\u5728 : " + currTenant);
            }
            StpUtil.getSession().set(CURR_TENANT, (Object)tenant);
            return tenant;
        }
        return ServerPushUtil.getCurrTenant(Tenants);
    }

    public static List<Tenant> getTenants() {
        SaResult saResult;
        Object data;
        SaSsoMessage message = new SaSsoMessage();
        message.setType("tenantInfo");
        if (StpUtil.isLogin()) {
            Object loginId = StpUtil.getLoginId();
            message.set("loginId", loginId);
        }
        if ((data = (saResult = SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message)).getData()) == null) {
            StaticLog.error((String)saResult.getMsg(), (Object[])new Object[0]);
            return Collections.emptyList();
        }
        return JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)data), Tenant.class);
    }

    public static boolean syncUser(User user) {
        SaSsoMessage message = new SaSsoMessage();
        message.setType("saveUser");
        message.set("User", (Object)JSONUtil.toJsonStr((Object)user));
        SaResult saResult = SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message);
        return saResult.getCode() == 200;
    }

    public static SaResult implicitLogin(String username, String password) {
        SaSsoMessage message = new SaSsoMessage();
        message.setType("restLogin");
        message.set("username", (Object)username);
        message.set("password", (Object)password);
        return SaSsoClientUtil.pushMessageAsSaResult((SaSsoMessage)message);
    }
}

