/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.uc;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoClientConfig;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.model.SaCheckTicketResult;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.sso.processor.SaSsoProcessorHelper;
import cn.dev33.satoken.sso.template.SaSsoClientTemplate;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.stp.parameter.SaLogoutParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.geoway.config.UcSsoClientConfig;
import com.geoway.po.User;
import com.geoway.util.ClientCacheUtil;
import com.geoway.util.ServerPushUtil;
import com.uc.sso.UserCenterClient;
import com.uc.sso.entity.UserCenterResponse;
import com.uc.sso.entity.request.UserCenterRequest;
import com.uc.sso.entity.response.TokenInfo;
import com.uc.sso.entity.response.UserInfo;
import java.net.URL;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class UcSsoClientProcessor {
    @Resource
    private UcSsoClientConfig ucClientConfig;
    public SaSsoClientTemplate ssoClientTemplate = new SaSsoClientTemplate();

    public Object dister() {
        ApiName apiName = this.ssoClientTemplate.apiName;
        SaRequest req = SaHolder.getRequest();
        if (req.isPath(apiName.ssoLogin)) {
            return this.ssoLogin();
        }
        if (req.isPath(apiName.ssoLogout)) {
            return this._ssoLogout();
        }
        if (req.isPath(apiName.ssoPushC)) {
            return this.ssoPushC();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoLogin() {
        SaRequest req = SaHolder.getRequest();
        ParamName paramName = this.ssoClientTemplate.paramName;
        String ticket = req.getParam(paramName.ticket);
        if (ticket == null) {
            return this._goServerAuth();
        }
        return this._loginByTicket();
    }

    public Object ssoPushC() {
        SaSsoClientConfig ssoClientConfig = this.ssoClientTemplate.getClientConfig();
        Map paramMap = SaHolder.getRequest().getParamMap();
        if (ssoClientConfig.getIsCheckSign().booleanValue()) {
            this.ssoClientTemplate.getSignTemplate().checkParamMap(paramMap);
        } else {
            SaSsoManager.printNoCheckSignWarningByRuntime();
        }
        SaSsoMessage message = new SaSsoMessage(paramMap);
        return this.ssoClientTemplate.handleMessage(message);
    }

    public Object _goServerAuth() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogicOrGlobal();
        ParamName paramName = this.ssoClientTemplate.paramName;
        String back = req.getParam(paramName.back, "/");
        if (stpLogic.isLogin()) {
            return res.redirect(back);
        }
        back = back == null ? "" : back;
        back = SaFoxUtil.encodeUrl((String)back);
        String currSsoLoginUrl = cfg.getCurrSsoLogin();
        if (SaFoxUtil.isEmpty((Object)currSsoLoginUrl)) {
            currSsoLoginUrl = SaHolder.getRequest().getUrl();
        }
        if (!currSsoLoginUrl.contains(paramName.back + "=")) {
            currSsoLoginUrl = SaFoxUtil.joinParam((String)currSsoLoginUrl, (String)paramName.back, (Object)back);
        }
        String url = SaFoxUtil.joinParam((String)this.ucClientConfig.getLoginUrl(), (String)"backUrl", (Object)currSsoLoginUrl);
        return res.redirect(url);
    }

    public Object _loginByTicket() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        ParamName paramName = this.ssoClientTemplate.paramName;
        String back = req.getParam(paramName.back, "/");
        String ticket = req.getParam(paramName.ticket);
        String code = req.getParam("code");
        Assert.state((boolean)"1".equals(code), (String)"\u767b\u5f55\u5931\u8d25", (Object[])new Object[0]);
        SaCheckTicketResult ctr = this.checkTicket(ticket);
        StpUtil.login((Object)ctr.loginId, (SaLoginParameter)new SaLoginParameter().setTimeout(ctr.remainTokenTimeout.longValue()).setDeviceId(ctr.deviceId).setToken(ctr.tokenValue));
        ThreadUtil.execute(() -> this.syncUser(ctr.tokenValue));
        URL reqUrl = URLUtil.url((String)SaHolder.getRequest().getUrl());
        URL backUrl = URLUtil.url((String)back);
        if (StrUtil.equals((CharSequence)reqUrl.getProtocol(), (CharSequence)backUrl.getProtocol()) && StrUtil.equals((CharSequence)reqUrl.getAuthority(), (CharSequence)backUrl.getAuthority())) {
            return res.redirect(back);
        }
        String authId = IdUtil.fastSimpleUUID();
        ClientCacheUtil.saveToken(authId, StpUtil.getTokenInfo());
        return res.redirect(SaFoxUtil.joinParam((String)back, (String)"authId", (Object)authId));
    }

    private void syncUser(String tokenValue) {
        UserCenterClient ucClient = UserCenterClient.getInstance();
        UserCenterRequest request = new UserCenterRequest();
        request.setToken(tokenValue);
        UserCenterResponse response = ucClient.getUserInfo(request);
        Assert.state((boolean)response.getSuccess(), (String)"\u83b7\u53d6uc\u7528\u6237\u5931\u8d25!", (Object[])new Object[0]);
        User user = this.toUser((UserInfo)response.getData());
        ClientCacheUtil.saveUser(user.getId(), user);
        try {
            boolean success = ServerPushUtil.syncUser(user);
            Assert.state((boolean)success, (String)"\u540c\u6b65\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ClientCacheUtil.removeUser(user.getId());
        }
    }

    private User toUser(UserInfo userInfo) {
        User user = new User();
        user.setId(userInfo.getUserCode());
        user.setUsername(userInfo.getUsername());
        user.setAlias(userInfo.getRealname());
        return user;
    }

    public Object _ssoLogout() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogicOrGlobal();
        if (!stpLogic.isLogin()) {
            return this._ssoLogoutBack(req, res);
        }
        String code = req.getParam("code");
        if ("0".equals(code)) {
            SaLogoutParameter logoutParameter = stpLogic.createSaLogoutParameter();
            boolean singleDeviceIdLogout = SaHolder.getRequest().isParam(this.ssoClientTemplate.paramName.singleDeviceIdLogout, "true");
            if (singleDeviceIdLogout) {
                logoutParameter.setDeviceId(stpLogic.getLoginDeviceId());
            }
            if (stpLogic.isLogin()) {
                stpLogic.logout(stpLogic.getLoginId(), logoutParameter);
            }
            return this._ssoLogoutBack(req, res);
        }
        return this._goLogoutUrl();
    }

    private Object _goLogoutUrl() {
        String backParam;
        String back;
        SaRequest req = SaHolder.getRequest();
        String currLogoutUrl = req.getUrl();
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        String loginUrl = cfg.getCurrSsoLogin();
        if (StrUtil.isNotEmpty((CharSequence)loginUrl)) {
            currLogoutUrl = loginUrl.replace("/sso/login", "/sso/logout");
        }
        back = (back = req.getParam(backParam = "back", "/")) == null ? "" : back;
        back = SaFoxUtil.encodeUrl((String)back);
        if (!currLogoutUrl.contains(backParam + "=")) {
            currLogoutUrl = SaFoxUtil.joinParam((String)currLogoutUrl, (String)backParam, (Object)back);
        }
        String url = SaFoxUtil.joinParam((String)this.ucClientConfig.getLogoutUrl(), (String)"backUrl", (Object)currLogoutUrl);
        return SaHolder.getResponse().redirect(url);
    }

    public SaCheckTicketResult checkTicket(String ticket) {
        UserCenterClient ucClient = UserCenterClient.getInstance();
        UserCenterRequest request = new UserCenterRequest();
        request.setTicket(ticket);
        UserCenterResponse response = ucClient.getTokenByTicket(request);
        Assert.state((boolean)response.getSuccess(), (String)"\u83b7\u53d6token\u5931\u8d25!", (Object[])new Object[0]);
        TokenInfo tokenInfo = (TokenInfo)response.getData();
        SaCheckTicketResult ctr = new SaCheckTicketResult();
        ctr.loginId = tokenInfo.getUserCode();
        ctr.tokenValue = tokenInfo.getToken();
        ctr.remainTokenTimeout = (long)tokenInfo.getExeptime();
        ctr.remainSessionTimeout = (long)tokenInfo.getExeptime();
        ctr.result = null;
        return ctr;
    }

    public Object _ssoLogoutBack(SaRequest req, SaResponse res) {
        return SaSsoProcessorHelper.ssoLogoutBack((SaRequest)req, (SaResponse)res, (ParamName)this.ssoClientTemplate.paramName);
    }
}

