/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.util;

import cn.dev33.satoken.stp.SaTokenInfo;
import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import com.geoway.po.User;

public class ClientCacheUtil {
    private static final TimedCache<String, Object> AUTH_CACHE = CacheUtil.newTimedCache((long)600000L);
    private static final TimedCache<String, User> USER_CACHE = CacheUtil.newTimedCache((long)600000L);

    public static void saveToken(String authId, SaTokenInfo token) {
        AUTH_CACHE.put((Object)authId, (Object)token);
    }

    public static Object getToken(String authId) {
        Object o = AUTH_CACHE.get((Object)authId, false);
        if (o != null) {
            AUTH_CACHE.remove((Object)authId);
        }
        return o;
    }

    public static void saveUser(String loginId, User user) {
        USER_CACHE.put((Object)loginId, (Object)user);
    }

    public static void removeUser(String loginId) {
        USER_CACHE.remove((Object)loginId);
    }

    public static User getUser(String loginId) {
        return (User)USER_CACHE.get((Object)loginId, false);
    }
}

