/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import com.geoway.atlas.ssoserver.po.App;
import com.geoway.atlas.ssoserver.po.Tenant;
import com.geoway.atlas.ssoserver.po.User;
import com.geoway.atlas.ssoserver.po.UserTenant;
import com.geoway.atlas.ssoserver.service.BusinessService;
import com.geoway.atlas.ssoserver.service.DbHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UisService
implements BusinessService {
    @Resource
    private DbHelper dbHelper;
    public static final String userTable = "uis_user";
    private static final String tenantTable = "uis_tenant";
    private static final String appTable = "uis_application";
    private static final String userTenantTable = "uis_tenant_target";
    private static final String userOrgDeptTable = "uis_user_org_dept";
    private static final String defaultPwd = "Aa@123456";
    private static final Map<String, String> userFieldsMapping = Collections.singletonMap("real_name", "alias");
    private static final Map<String, String> appFieldsMapping = new HashMap<String, String>(){
        {
            this.put("f_id", "appId");
            this.put("f_key", "appSecret");
        }
    };

    @Override
    public User findByUsername(String username) {
        return this.dbHelper.find(userTable, Collections.singletonMap("username", username), User.class, userFieldsMapping);
    }

    @Override
    public User findUserById(String userId) {
        return this.dbHelper.find(userTable, Collections.singletonMap("id", userId), User.class, userFieldsMapping);
    }

    @Override
    public int insertUser(User user) {
        Entity entity = Entity.create((String)userTable);
        entity.set("id", (Object)user.getId());
        entity.set("username", (Object)user.getUsername());
        entity.set("password", (Object)defaultPwd);
        entity.set("real_name", (Object)user.getAlias());
        entity.set("mobile_phone", (Object)("151" + RandomUtil.randomNumbers((int)8)));
        return this.dbHelper.insert(entity);
    }

    @Override
    public List<Tenant> findTenantByClient(String client) {
        String sql = " select ut.id, ut.name from uis_tenant ut    left join uis_application ua on ut.app_id = ua.id    where ua.code = ?";
        return this.dbHelper.query(sql, Tenant.class, client);
    }

    @Override
    public List<UserTenant> findUserTenantByUserId(String userId) {
        String sql = "  select tenant_id, target_id from uis_tenant_target where target_type = 1  and target_id = ?";
        return this.dbHelper.query(sql, UserTenant.class, userId);
    }

    @Override
    public boolean isPwdValid(User user, String pwd) {
        return ObjectUtil.isAllNotEmpty((Object[])new Object[]{user.getPassword(), pwd}) && StrUtil.equals((CharSequence)user.getPassword(), (CharSequence)pwd);
    }

    @Override
    public List<App> listApp() {
        return this.dbHelper.list(appTable, Collections.emptyMap(), App.class, appFieldsMapping);
    }

    public long countUserTenant(String userId, String tenantId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("target_id", userId);
        param.put("target_type", 1);
        param.put("tenant_id", tenantId);
        return this.dbHelper.count(userTenantTable, param);
    }

    public long insertUserTenant(String userId, String tenantId) {
        Entity entity = Entity.create((String)userTenantTable);
        entity.set("target_id", (Object)userId);
        entity.set("tenant_id", (Object)tenantId);
        entity.set("target_type", (Object)1);
        entity.set("type", (Object)1);
        return this.dbHelper.insertForGeneratedKey(entity);
    }

    public long insertUserOrgDept(String userId, String orgId, String deptId) {
        Entity entity = Entity.create((String)userOrgDeptTable);
        entity.set("user_id", (Object)userId);
        entity.set("org_id", (Object)orgId);
        entity.set("dept_id", (Object)deptId);
        return this.dbHelper.insertForGeneratedKey(entity);
    }

    public long countUserOrgDept(String userId, String orgId, String deptId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", userId);
        param.put("org_id", orgId);
        param.put("dept_id", deptId);
        return this.dbHelper.count(userOrgDeptTable, param);
    }
}

