/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.service;

import cn.hutool.cron.CronUtil;
import com.geoway.atlas.ssoserver.po.App;
import com.geoway.atlas.ssoserver.service.BusinessFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class AppListener {
    @Resource
    private BusinessFactory businessFactory;
    private List<App> apps = new ArrayList<App>();

    @PostConstruct
    private void init() {
        String schedulingPattern = "0/1 * * * ?";
        if (CronUtil.getScheduler().isMatchSecond()) {
            schedulingPattern = "0/15 * * * * ?";
        }
        CronUtil.schedule((String)schedulingPattern, this::checkApp);
        if (!CronUtil.getScheduler().isStarted()) {
            CronUtil.start((boolean)true);
        }
    }

    private void checkApp() {
        List<App> nowApps = this.businessFactory.listApp();
        HashSet<App> addTenants = new HashSet<App>(nowApps);
        addTenants.removeAll(new HashSet<App>(this.apps));
        addTenants.forEach(app -> this.businessFactory.addClient((App)app));
        HashSet<App> deleteTenants = new HashSet<App>(this.apps);
        deleteTenants.removeAll(new HashSet<App>(nowApps));
        deleteTenants.forEach(app -> this.businessFactory.removeClient((App)app));
        this.apps = nowApps;
    }
}

