/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.controller;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VerifyCodeController {
    @Resource
    ServerProperties serverProperties;
    private int width = 88;
    private int height = 22;
    char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    @RequestMapping(value={"/verifyCode"})
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (ServletOutputStream out = resp.getOutputStream();){
            String w = req.getParameter("w");
            String h = req.getParameter("h");
            if (w != null) {
                this.width = Integer.parseInt(w);
            }
            if (h != null) {
                this.height = Integer.parseInt(h);
            }
            int codeCount = 4;
            int xx = this.width / (codeCount + 1);
            BufferedImage buffImg = new BufferedImage(this.width, this.height, 1);
            Graphics2D gd = buffImg.createGraphics();
            Random random = new Random();
            gd.setColor(Color.WHITE);
            gd.fillRect(0, 0, this.width, this.height);
            Font font = new Font("Fixedsys", 0, this.height - 2);
            gd.setFont(font);
            gd.setColor(Color.BLACK);
            for (int i = 0; i < 4; ++i) {
                int x = random.nextInt(this.width);
                int y = random.nextInt(this.height);
                int xl = random.nextInt(12);
                int yl = random.nextInt(12);
                gd.drawLine(x, y, x + xl, y + yl);
            }
            StringBuilder randomCode = new StringBuilder();
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int i = 0; i < codeCount; ++i) {
                String strRand = String.valueOf(this.codeSequence[random.nextInt(36)]);
                red = random.nextInt(255);
                green = random.nextInt(255);
                blue = random.nextInt(255);
                gd.setColor(new Color(red, green, blue));
                gd.drawString(strRand, (i + 1) * xx, this.height - 4);
                randomCode.append(strRand);
            }
            req.getSession().setAttribute("verifyCode", (Object)randomCode.toString());
            ImageIO.write((RenderedImage)buffImg, "png", (OutputStream)out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verificationBaseDir() {
        File file = this.serverProperties.getTomcat().getBasedir();
        if (!file.exists() && !file.isDirectory()) {
            file.mkdir();
            System.out.println("\u4e34\u65f6\u6587\u4ef6\u5939\u4e0d\u5b58\u5728,\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939" + file.getAbsolutePath());
        }
    }
}

