/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.license.authorize;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import com.geoway.atlas.license.authorize.LicenseCheckException;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bouncycastle.crypto.engines.SM2Engine;

public class LicenseCheck {
    private static String privateKeyHex = "B10157E05DDE155D3ED5D1D28B0AAC7124E4FB915456E68D3151778C152F080D";
    private static String publicKeyHex = "0439C3071A57F23AAAA3D85B9449189C7009717D51D81918E218982351AF68EB174561A649E267321B7C05035BF07C995EA174B4DD31F7844248CB3B46AB765B9C";
    private static ConcurrentMap<String, Boolean> licenses = new ConcurrentHashMap<String, Boolean>();

    public static boolean isValid(int mainID) {
        LocalDate today;
        String moduleName = "MODULE" + mainID;
        if (licenses.containsKey(moduleName)) {
            return (Boolean)licenses.get(moduleName);
        }
        String machineId = null;
        String mac = null;
        try {
            machineId = LicenseCheck.getMachineId();
            mac = LicenseCheck.getRealMac().toUpperCase();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LicenseCheckException("\u73af\u5883\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u6388\u6743\u4fe1\u606f");
        }
        if (machineId == null || machineId.isEmpty()) {
            throw new LicenseCheckException("\u73af\u5883\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u6388\u6743\u4fe1\u606f");
        }
        if (mac == null || mac.isEmpty()) {
            throw new LicenseCheckException("\u73af\u5883\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u6388\u6743\u4fe1\u606f");
        }
        System.out.println("\u673a\u5668\u6307\u7eb9: " + HexUtil.encodeHexStr((String)(machineId + "|" + mac)));
        String licenseFile = "/app/atlas/host.lic";
        String liceninfo = null;
        Path path = Paths.get(licenseFile, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            try {
                byte[] bytes = Files.readAllBytes(path);
                liceninfo = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new LicenseCheckException("host.lic\u4e0d\u5b58\u5728\u6216\u5f02\u5e38");
            }
        } else {
            throw new LicenseCheckException("host.lic\u4e0d\u5b58\u5728\u6216\u5f02\u5e38");
        }
        String encrypted_base64 = Base64.encode((byte[])HexUtil.decodeHex((String)liceninfo));
        SM2 sm2 = new SM2(privateKeyHex, publicKeyHex);
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String decryptedText = sm2.decryptStr(encrypted_base64, KeyType.PrivateKey);
        String[] parts = decryptedText.split("\\|");
        if (parts.length < 3) {
            throw new LicenseCheckException("host.lic\u4fe1\u606f\u5f02\u5e38");
        }
        if (!StrUtil.equals((CharSequence)parts[0], (CharSequence)machineId) || !StrUtil.equals((CharSequence)parts[1], (CharSequence)mac)) {
            throw new LicenseCheckException("\u6388\u6743\u4fe1\u606f\u9519\u8bef");
        }
        String dateStr = parts[2];
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate targetDate = LocalDate.parse(dateStr, formatter);
        if (targetDate.isBefore(today = LocalDate.now())) {
            throw new LicenseCheckException("\u6388\u6743\u5df2\u5230\u671f\uff0c\u622a\u6b62\u65f6\u95f4" + dateStr);
        }
        System.out.println("\u6388\u6743\u6210\u529f\uff0c\u622a\u6b62\u65e5\u671f " + dateStr);
        licenses.put(moduleName, true);
        return true;
    }

    public static boolean checkModule(int module) {
        String moduleName = "MODULE" + module;
        if (licenses.containsKey(moduleName)) {
            return (Boolean)licenses.get(moduleName);
        }
        boolean login = LicenseCheck.isValid(module);
        licenses.put(moduleName, true);
        return true;
    }

    public static boolean checkModuleNoException(int module) {
        String moduleName = "MODULE" + module;
        if (licenses.containsKey(moduleName)) {
            return (Boolean)licenses.get(moduleName);
        }
        boolean login = LicenseCheck.isValid(module);
        licenses.put(moduleName, true);
        return true;
    }

    private static byte[] concat(byte[] ... arrays) {
        int len = 0;
        for (byte[] arr : arrays) {
            len += arr.length;
        }
        byte[] result = new byte[len];
        int pos = 0;
        for (byte[] arr : arrays) {
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    private static byte[] fixTo32(byte[] arr) {
        if (arr.length == 32) {
            return arr;
        }
        if (arr.length > 32) {
            return Arrays.copyOfRange(arr, arr.length - 32, arr.length);
        }
        byte[] result = new byte[32];
        System.arraycopy(arr, 0, result, 32 - arr.length, arr.length);
        return result;
    }

    public static String getMachineId() throws IOException {
        Path path = Paths.get("/etc/machine-id", new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            byte[] data = Files.readAllBytes(path);
            return new String(data, "UTF-8").trim();
        }
        return "";
    }

    public static String getRealMac() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            byte[] mac;
            NetworkInterface ni = interfaces.nextElement();
            String name = ni.getName();
            if (ni.isLoopback() || !ni.isUp() || ni.isVirtual() || name.startsWith("lo") || name.startsWith("docker") || name.startsWith("veth") || name.startsWith("br-") || name.startsWith("virbr") || name.startsWith("tap") || name.startsWith("tun") || (mac = ni.getHardwareAddress()) == null || mac.length != 6) continue;
            boolean allZero = true;
            for (byte b : mac) {
                if (b == 0) continue;
                allZero = false;
                break;
            }
            if (allZero) continue;
            return LicenseCheck.formatMac(mac);
        }
        return null;
    }

    private static String formatMac(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X", mac[i]));
            if (i >= mac.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.setProperty("jna.debug_load", "true");
        try {
            System.out.println(HexUtil.encodeHexStr((String)"hjbjjbjbj|B3:T4", (Charset)StandardCharsets.UTF_8));
            System.out.println(HexUtil.decodeHexStr((String)HexUtil.encodeHexStr((String)"hjbjjbjbj|B3:T4", (Charset)StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

