/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.api.action;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.dgt.onecode.dto.EntityClassEditDTO;
import com.geoway.dgt.onecode.entity.CodeEntityClass;
import com.geoway.dgt.onecode.manager.GraphDatabaseManager;
import com.geoway.dgt.onecode.service.CodeEntityClassService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dgt/coding"})
@Api(tags={"06-\u5b9e\u4f53\u8d4b\u7801"})
public class GeoCodingController {
    @Resource
    private GraphDatabaseManager graphDatabaseManager;
    @Resource
    private CodeEntityClassService codeEntityClassService;

    @ApiOperation(value="01-\u83b7\u53d6\u5f85\u5165\u56fe\u5e93\u7684\u5b9e\u4f53csv\u6587\u4ef6", hidden=true)
    @GetMapping(value={"/csv"})
    public void getEntityCsv(@RequestParam String path, @RequestParam String fileName) {
        String csvPath = this.graphDatabaseManager.getTempPath(path) + File.separator + fileName + ".csv";
        DownloadUtil.downloadFile((String)csvPath);
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5b9e\u4f53\u5206\u7c7b\u6811")
    @GetMapping(value={"/entityClass/tree"})
    public Response<List<CodeEntityClass>> tree() {
        return Response.ok((Object)this.codeEntityClassService.tree());
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @GetMapping(value={""})
    public Response<List<CodeEntityClass>> getEntityClassTree(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.codeEntityClassService.getEntityClassTree(keyword));
    }

    @ApiOperation(value="04-\u5bfc\u5165")
    @UploadFileCheck(supportedSuffixes={".xls", ".xlsx", ".csv"})
    @PostMapping(value={"/import/excel"})
    public Response<Boolean> importScheme(@RequestPart MultipartFile file) {
        return Response.ok((Object)this.codeEntityClassService.importEntityClass(file));
    }

    @ApiOperation(value="05-\u5bfc\u51fa")
    @GetMapping(value={"/export/excel"})
    public void getEntityClassTree() {
        this.codeEntityClassService.exportEntityClass();
    }

    @ApiOperation(value="06-\u7f16\u8f91\u5b9e\u4f53\u5206\u7c7b\u4ee3\u7801\u5c5e\u6027")
    @PostMapping(value={"/entityClass/save"})
    public Response saveEntityClass(@RequestBody EntityClassEditDTO codeEntityClass) {
        this.codeEntityClassService.saveEntityClass(codeEntityClass);
        return Response.ok();
    }
}

