/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.api.action;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Encoder;

@RestController
@RequestMapping(value={"/dgt/globe/model"})
@Api(tags={"04-\u4e09\u7ef4\u6a21\u578b"})
public class GlobeModelController {
    @Resource
    private GeoDatabaseService geoDatabaseService;

    @ApiOperation(value="\u83b7\u53d6\u56fe\u7247")
    @GetMapping(value={"/img"})
    public Response<String> getImage(@RequestParam String path) {
        File file = new File(path);
        if (file.exists()) {
            String fileName = path.toUpperCase(Locale.ROOT);
            if (!(fileName.endsWith(".PNG") || fileName.endsWith(".SVG") || fileName.endsWith(".JPG") || fileName.endsWith(".JPEG"))) {
                throw new RuntimeException("\u56fe\u7247\u683c\u5f0f\u652f\u6301\uff1apng\u3001jpg\u3001jpeg\u6216svg");
            }
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                byte[] buff = new byte[inputStream.available()];
                inputStream.read(buff);
                BASE64Encoder encoder = new BASE64Encoder();
                String picture = encoder.encodeBuffer(buff).trim();
                picture = picture.replaceAll("\n", "").replaceAll("\r", "");
                String format = "image/png";
                if (fileName.endsWith(".PNG")) {
                    format = "image/png";
                } else if (fileName.endsWith(".SVG")) {
                    format = "image/svg+xml";
                } else if (fileName.endsWith(".JPG") || fileName.endsWith(".JPEG")) {
                    format = "image/jpeg";
                }
                picture = "data:" + format + ";base64," + picture;
                Response response = Response.ok((Object)picture);
                return response;
            }
            catch (Exception e) {
                throw new RuntimeException("\u56fe\u7247\u89e3\u6790\u5931\u8d25\uff01", e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        throw new RuntimeException("\u672a\u77e5\u7684\u56fe\u7247\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6shp\u552f\u4e00\u503c")
    @GetMapping(value={"shp/distinct"})
    public Response<List<Object>> queryDistinct(@RequestParam String path, @RequestParam String field, @RequestParam Integer limit) {
        Path fileFullPath = UploadPathConfig.getFullPath((String)path);
        Assert.isTrue((boolean)fileFullPath.toFile().exists(), (String)("\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + path));
        ArrayList<Object> results = new ArrayList<Object>();
        ICursor cursor = null;
        try (IFeatureWorkspace workspace = null;){
            workspace = WorkspaceUtil.openLocalFileGeodatabase((String)fileFullPath.toString());
            IFeatureClass geoDataset = workspace.openFeatureClass(FileUtil.getFileNameWithoutExtension((String)path));
            ITable table = (ITable)geoDataset;
            int index = table.getFields().findFieldIndex(field);
            cursor = table.searchRow(null);
            IRow row = cursor.nextRow();
            while (row != null) {
                Object value = row.getValue(index);
                if (!results.contains(value)) {
                    results.add(value);
                }
                row = cursor.nextRow();
                if (limit <= 0 || results.size() != limit.intValue()) continue;
                break;
            }
            Response response = Response.ok(results);
            return response;
        }
    }

    @ApiOperation(value="\u7edf\u8ba1shp\u6700\u503c")
    @GetMapping(value={"shp/min/max"})
    public Response<List<Double>> queryMinMax(@RequestParam String path, @RequestParam String field) {
        Path fileFullPath = UploadPathConfig.getFullPath((String)path);
        Assert.isTrue((boolean)fileFullPath.toFile().exists(), (String)("\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + path));
        ArrayList<Double> results = new ArrayList<Double>();
        ICursor cursor = null;
        try (IFeatureWorkspace workspace = null;){
            workspace = WorkspaceUtil.openLocalFileGeodatabase((String)fileFullPath.toString());
            IFeatureClass geoDataset = workspace.openFeatureClass(FileUtil.getFileNameWithoutExtension((String)path));
            ITable table = (ITable)geoDataset;
            IField iField = table.getFields().findField(field);
            int index = table.getFields().findFieldIndex(field);
            switch (iField.getFieldType()) {
                case OID: 
                case Decimal: 
                case Double: 
                case Short: 
                case Int: 
                case Long: 
                case Float: {
                    break;
                }
                default: {
                    throw new RuntimeException("\u5b57\u6bb5\u7c7b\u578b" + iField.getFieldType().name() + "\u65e0\u6cd5\u7edf\u8ba1\u6700\u5927\u6700\u5c0f\u503c\uff01");
                }
            }
            double min = Double.MAX_VALUE;
            double max = -4.9E-324;
            cursor = table.searchRow(null);
            IRow row = cursor.nextRow();
            while (row != null) {
                Object value = row.getValue(index);
                if (value != null) {
                    double doubleValue = Double.parseDouble(value.toString());
                    if (doubleValue > max) {
                        max = doubleValue;
                    }
                    if (doubleValue < min) {
                        min = doubleValue;
                    }
                }
                row = cursor.nextRow();
            }
            results.add(min);
            results.add(max);
            Response response = Response.ok(results);
            return response;
        }
    }

    @ApiOperation(value="\u7edf\u8ba1\u6570\u636e\u96c6\u6700\u503c")
    @GetMapping(value={"min/max"})
    public Response<List<Double>> queryDatasetMinMax(@RequestParam String datasetId, @RequestParam String field) {
        field = field.toLowerCase(Locale.ROOT);
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
        DatabaseDTO dataSource = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        IFeatureWorkspace workspace = null;
        ArrayList<Double> results = new ArrayList<Double>();
        ICursor cursor = null;
        try {
            workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);
            IFeatureClass featureClass = workspace.openFeatureClass(datasetNameInfo.getName());
            ITable table = (ITable)featureClass;
            SpatialQueryFilter queryFilter = new SpatialQueryFilter();
            queryFilter.setSubFields(String.format("Min(%s), Max(%s)", field, field));
            cursor = table.searchRow((IQueryFilter)queryFilter);
            IRow row = cursor.nextRow();
            while (row != null) {
                Object minValue = row.getValue(0);
                Object maxValue = row.getValue(1);
                if (minValue != null) {
                    results.add(Double.parseDouble(minValue.toString()));
                    results.add(Double.parseDouble(maxValue.toString()));
                }
                row = cursor.nextRow();
            }
            if (results.size() == 0) {
                results.add((Double)Double.MAX_VALUE);
                results.add(-4.9E-324);
            }
            Response response = Response.ok(results);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(datasetNameInfo.getName() + " \u7edf\u8ba1\u6700\u503c\u5931\u8d25\uff01", e);
        }
        finally {
            if (workspace != null) {
                workspace.close();
            }
        }
    }
}

