/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.frame.manager;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.constants.TaskStatusEnum;
import com.geoway.dgt.frame.constants.TaskTypeEnum;
import com.geoway.dgt.frame.dao.DgtTaskDao;
import com.geoway.dgt.frame.dao.DgtTaskItemDao;
import com.geoway.dgt.frame.dao.DgtTaskLogDao;
import com.geoway.dgt.frame.dao.DgtTaskSubItemDao;
import com.geoway.dgt.frame.dao.DgtToolDao;
import com.geoway.dgt.frame.dto.FlowTaskCreateDTO;
import com.geoway.dgt.frame.dto.FlowTaskParam;
import com.geoway.dgt.frame.dto.FlowToolParam;
import com.geoway.dgt.frame.dto.TaskCreateDTO;
import com.geoway.dgt.frame.dto.TaskParam;
import com.geoway.dgt.frame.entity.DgtTask;
import com.geoway.dgt.frame.entity.DgtTaskItem;
import com.geoway.dgt.frame.entity.DgtTaskLog;
import com.geoway.dgt.frame.entity.DgtTaskSubItem;
import com.geoway.dgt.frame.entity.DgtTool;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import com.geoway.dgt.frame.tools.ITool;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.frame.util.VectorFileUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ToolTaskManager {
    private static final Logger log = LoggerFactory.getLogger(ToolTaskManager.class);
    @Resource
    private DgtToolDao toolDao;
    @Resource
    private DgtTaskDao taskDao;
    @Resource
    private DgtTaskItemDao taskItemDao;
    @Resource
    private DgtTaskLogDao taskLogDao;
    @Resource
    private DgtTaskSubItemDao taskSubItemDao;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    private static final Map<String, RunningTask> runningTasks = new ConcurrentHashMap<String, RunningTask>();
    @Value(value="${project.temp-path:temp}")
    private String flowTempFolder;

    @Transactional(rollbackFor={Exception.class})
    public DgtTask createTask(TaskCreateDTO taskCreateDTO) {
        DgtTool dgtTool = this.toolDao.selectByPrimaryKey(taskCreateDTO.getTaskParam().getToolId());
        if (dgtTool == null) {
            throw new RuntimeException("\u5de5\u5177\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        String userName = "admin";
        String taskId = UUID.randomUUID().toString();
        DgtTask dgtTask = new DgtTask();
        dgtTask.setId(taskId);
        dgtTask.setName(taskCreateDTO.getName());
        dgtTask.setToolId(dgtTool.getId());
        dgtTask.setToolName(dgtTool.getName());
        dgtTask.setParams(JSONObject.toJSONString((Object)taskCreateDTO.getTaskParam()));
        dgtTask.setCreateTime(new Date());
        dgtTask.setCreateUser(userName);
        dgtTask.setStatus(TaskStatusEnum.Ready.getValue());
        dgtTask.setType(TaskTypeEnum.Tool.getValue());
        dgtTask.setTotalCount(0L);
        dgtTask.setSuccessCount(0L);
        dgtTask.setFailCount(0L);
        this.taskDao.insert(dgtTask);
        RefObject itemCount = new RefObject((Object)0);
        try {
            ITool tool = this.createToolPlugin(dgtTool.getClassName());
            IToolParam toolParam = this.createToolParam(dgtTool.getParamClassName(), taskCreateDTO.getTaskParam().getToolParam());
            tool.batchDataStriping(taskCreateDTO.getTaskParam().getInDataParam(), taskCreateDTO.getTaskParam().getOutDataParam(), toolParam, data -> {
                DgtTaskItem taskItem = new DgtTaskItem();
                taskItem.setId(UUID.randomUUID().toString());
                taskItem.setTaskId(taskId);
                taskItem.setName(data.getName());
                taskItem.setStatus(TaskStatusEnum.Ready.getValue());
                taskItem.setPriority(data.getPriority());
                taskItem.setFailRedoTimes(data.getFailRetryNumber());
                TaskParam taskItemParam = new TaskParam();
                taskItemParam.setToolId(dgtTool.getId());
                taskItemParam.setInDataParam(data.getInputData());
                taskItemParam.setOutDataParam(data.getOutputData());
                taskItemParam.setToolParam(JSONObject.toJSONString((Object)data.getToolExecuteParam()));
                taskItem.setParams(JSONObject.toJSONString((Object)taskItemParam));
                this.taskItemDao.insert(taskItem);
                itemCount.set((Object)((Integer)itemCount.get() + 1));
            });
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u4efb\u52a1\u5f02\u5e38," + e.getMessage(), e);
        }
        if ((Integer)itemCount.get() == 0) {
            throw new RuntimeException("\u672a\u8bfb\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u4e0e\u5bfc\u51fa\u8303\u56f4\u662f\u5426\u76f8\u4ea4\uff01");
        }
        dgtTask.setTotalCount((long)((Integer)itemCount.get()));
        this.taskDao.updateByPrimaryKeySelective(dgtTask);
        return dgtTask;
    }

    @Transactional(rollbackFor={Exception.class})
    public DgtTask createFlowTask(FlowTaskCreateDTO flowTaskCreateDTO) {
        String userName = "admin";
        String taskId = UUID.randomUUID().toString();
        DgtTask dgtTask = new DgtTask();
        dgtTask.setId(taskId);
        dgtTask.setName(flowTaskCreateDTO.getName());
        dgtTask.setToolName("\u6d41\u7a0b\u642d\u5efa");
        dgtTask.setParams(JSONUtil.toJsonStr((Object)flowTaskCreateDTO.getFlowParam()));
        dgtTask.setCreateTime(new Date());
        dgtTask.setCreateUser(userName);
        dgtTask.setStatus(TaskStatusEnum.Ready.getValue());
        dgtTask.setType(TaskTypeEnum.Flow.getValue());
        dgtTask.setTotalCount(0L);
        dgtTask.setSuccessCount(0L);
        dgtTask.setFailCount(0L);
        this.taskDao.insert(dgtTask);
        RefObject itemCount = new RefObject((Object)0);
        try {
            FlowTaskParam flowParam = flowTaskCreateDTO.getFlowParam();
            DataParam inDataParam = flowParam.getInDataParam();
            DataParam outDataParam = flowParam.getOutDataParam();
            List<VectorFormatEnum> vectorFormats = flowParam.getVectorFormats();
            List<File> files = VectorFileUtil.getVectorFilesByEnums(new File(inDataParam.getFilePath()), 1, vectorFormats);
            Assert.state((!files.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u683c\u5f0f\u8f93\u5165\u6570\u636e");
            List<FlowToolParam> flowToolParamList = flowParam.getToolParamList();
            FlowToolParam lastTool = flowToolParamList.get(flowToolParamList.size() - 1);
            Assert.state((StrUtil.isEmpty((CharSequence)lastTool.getSavePath()) || "sameAsInput".equals(lastTool.getSavePath()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u6700\u540e\u4e00\u4e2a\u5de5\u5177\u7ed3\u679c\u65e0\u6cd5\u53e6\u5b58");
            int toolNum = flowToolParamList.size();
            for (File file : files) {
                ArrayList<TaskParam> toolParamList = new ArrayList<TaskParam>();
                ArrayList<DgtTaskSubItem> subItems = new ArrayList<DgtTaskSubItem>();
                DataParam preOutParam = new DataParam();
                preOutParam.setFilePath(file.getAbsolutePath());
                DataParam outParam = new DataParam();
                try {
                    for (int i = 0; i < toolNum; ++i) {
                        FlowToolParam taskFlowParam = flowToolParamList.get(i);
                        DgtTool dgtTool = this.toolDao.selectByPrimaryKey(taskFlowParam.getToolId());
                        if (dgtTool == null) {
                            throw new RuntimeException(taskFlowParam.getToolId() + "\u5de5\u5177\u63d2\u4ef6\u4e0d\u5b58\u5728");
                        }
                        ITool tool = this.createToolPlugin(dgtTool.getClassName());
                        IToolParam toolParam = this.createToolParam(dgtTool.getParamClassName(), taskFlowParam.getToolParam());
                        if (i == toolNum - 1) {
                            outParam.setFilePath(outDataParam.getFilePath());
                        } else if ("sameAsInput".equals(taskFlowParam.getSavePath())) {
                            outParam.setFilePath(preOutParam.getFilePath());
                        } else if (StrUtil.isNotEmpty((CharSequence)taskFlowParam.getSavePath())) {
                            outParam.setFilePath(taskFlowParam.getSavePath());
                        } else {
                            String tempPath = Paths.get(this.flowTempFolder, taskId, dgtTool.getId()).toString();
                            FileUtil.mkdirs((String)tempPath);
                            outParam.setFilePath(tempPath);
                        }
                        ExecuteParam executeParam = tool.buildExecuteParam(preOutParam, outParam, toolParam);
                        TaskParam realToolParam = new TaskParam();
                        realToolParam.setToolId(dgtTool.getId());
                        realToolParam.setToolParam(JSONUtil.toJsonStr((Object)executeParam.getToolExecuteParam()));
                        realToolParam.setInDataParam(executeParam.getInputData().clone());
                        realToolParam.setOutDataParam(executeParam.getOutputData().clone());
                        toolParamList.add(realToolParam);
                        DgtTaskSubItem subItem2 = new DgtTaskSubItem();
                        subItem2.setId(UUID.randomUUID().toString());
                        subItem2.setTaskId(taskId);
                        subItem2.setStatus(TaskStatusEnum.Ready.getValue());
                        subItem2.setName(dgtTool.getName());
                        subItem2.setToolId(dgtTool.getId());
                        subItem2.setParams(JSONUtil.toJsonStr((Object)realToolParam));
                        subItems.add(subItem2);
                        preOutParam.setFilePath(realToolParam.getOutDataParam().getFilePath());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                DgtTaskItem taskItem = new DgtTaskItem();
                taskItem.setId(UUID.randomUUID().toString());
                taskItem.setTaskId(taskId);
                String name = VectorFileUtil.mainName(file);
                taskItem.setName(name);
                taskItem.setPriority(0);
                taskItem.setFailRedoTimes(0);
                taskItem.setStatus(TaskStatusEnum.Ready.getValue());
                taskItem.setParams(JSONUtil.toJsonStr(toolParamList));
                subItems.forEach(subItem -> subItem.setTaskItemId(taskItem.getId()));
                this.taskSubItemDao.batchInsert(subItems);
                this.taskItemDao.insert(taskItem);
                itemCount.set((Object)((Integer)itemCount.get() + 1));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u6d41\u7a0b\u4efb\u52a1\u5f02\u5e38," + e.getMessage(), e);
        }
        if ((Integer)itemCount.get() == 0) {
            throw new RuntimeException("\u672a\u8bfb\u53d6\u5230\u6570\u636e");
        }
        dgtTask.setTotalCount((long)((Integer)itemCount.get()));
        this.taskDao.updateByPrimaryKeySelective(dgtTask);
        return dgtTask;
    }

    public synchronized void execute(DgtTask dgtTask) {
        if (runningTasks.size() >= this.threadPoolTaskExecutor.getCorePoolSize()) {
            throw new RuntimeException("\u6b63\u5728\u8fd0\u884c\u7684\u4efb\u52a1\u5df2\u8fbe\u6700\u5927\u6570\u91cf");
        }
        DgtTool dgtTool = null;
        if (StringUtil.isNotEmpty((String)dgtTask.getToolId()) && (dgtTool = this.toolDao.selectByPrimaryKey(dgtTask.getToolId())) == null) {
            throw new RuntimeException("\u5de5\u5177\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        dgtTask.setStatus(TaskStatusEnum.Waitting.getValue());
        this.taskDao.updateStatus(dgtTask);
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes, (boolean)true);
        RunningTask runningDataTask = new RunningTask();
        runningDataTask.dgtTask = dgtTask;
        runningDataTask.dgtTool = dgtTool;
        this.threadPoolTaskExecutor.execute(() -> this.executeTask(runningDataTask));
    }

    public void stopTask(String taskId) {
        if (runningTasks.containsKey(taskId)) {
            RunningTask runningDataTask = runningTasks.get(taskId);
            runningDataTask.isAborted = true;
            for (RunningItem item : runningDataTask.runningItems) {
                if (item.dataTools == null) continue;
                for (ITool tool : item.dataTools) {
                    tool.abort();
                }
            }
        } else {
            DgtTask dgtTask = this.taskDao.selectByPrimaryKey(taskId);
            if (dgtTask != null) {
                dgtTask.setStatus(TaskStatusEnum.FinishedFailed.getValue());
                dgtTask.setFailMsg("\u4efb\u52a1\u4e2d\u6b62");
                this.taskDao.updateStatus(dgtTask);
                this.taskItemDao.resetStatus(taskId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(RunningTask runningTask) {
        block26: {
            boolean success = true;
            String errorMessage = null;
            DgtTask dgtTask = runningTask.dgtTask;
            try {
                dgtTask.setStatus(TaskStatusEnum.Processing.getValue());
                dgtTask.setStartTime(new Date());
                dgtTask.setEndTime(null);
                dgtTask.setFailCount(0L);
                dgtTask.setFailMsg(null);
                this.taskDao.updateStatus(dgtTask);
                runningTask.failCount = 0L;
                runningTask.successCount = dgtTask.getSuccessCount();
                runningTasks.put(dgtTask.getId(), runningTask);
                List<DgtTaskItem> taskItems = this.taskItemDao.selectByTaskId(dgtTask.getId(), Arrays.asList(TaskStatusEnum.Ready.getValue(), TaskStatusEnum.FinishedFailed.getValue()), null);
                Map<Integer, List<DgtTaskItem>> taskItemGroup = taskItems.stream().collect(Collectors.groupingBy(DgtTaskItem::getPriority));
                List priorityList = taskItemGroup.keySet().stream().sorted().collect(Collectors.toList());
                Collections.reverse(priorityList);
                for (Integer priority : priorityList) {
                    List<DgtTaskItem> groupItems = taskItemGroup.get(priority);
                    AtomicInteger finishedCount = new AtomicInteger(0);
                    AtomicBoolean hasFailed = new AtomicBoolean(false);
                    for (DgtTaskItem taskItem : groupItems) {
                        if (runningTask.isAborted) {
                            success = false;
                            errorMessage = "\u4efb\u52a1\u4e2d\u6b62";
                            return;
                        }
                        RunningItem runningItem = new RunningItem();
                        runningItem.runningTask = runningTask;
                        runningItem.taskItem = taskItem;
                        boolean andPoolSuccess = false;
                        while (!andPoolSuccess) {
                            if (runningTask.isAborted) {
                                success = false;
                                errorMessage = "\u4efb\u52a1\u4e2d\u6b62";
                                return;
                            }
                            try {
                                if (this.threadPoolTaskExecutorData.getThreadPoolExecutor().getQueue().remainingCapacity() <= 0) {
                                    Thread.sleep(1000L);
                                }
                                this.threadPoolTaskExecutorData.execute(() -> {
                                    ExecuteResult result = new ExecuteResult();
                                    if (runningTask.isAborted) {
                                        result = new ExecuteResult("\u4efb\u52a1\u4e2d\u6b62");
                                    } else if (dgtTask.getType().intValue() == TaskTypeEnum.Tool.getValue()) {
                                        result = this.executeItem(runningItem);
                                        if (!result.getSuccess().booleanValue() && runningItem.taskItem.getFailRedoTimes() > 0) {
                                            for (int retryTimes = 0; retryTimes <= runningItem.taskItem.getFailRedoTimes() && !(result = this.executeItem(runningItem)).getSuccess().booleanValue(); ++retryTimes) {
                                            }
                                        }
                                    } else if (dgtTask.getType().intValue() == TaskTypeEnum.Flow.getValue()) {
                                        result = this.executeFlowItem(runningItem);
                                    }
                                    if (!result.getSuccess().booleanValue()) {
                                        hasFailed.set(true);
                                    }
                                    finishedCount.getAndIncrement();
                                    this.updateTaskProgress(runningTask, result);
                                });
                                andPoolSuccess = true;
                            }
                            catch (RejectedExecutionException executionException) {
                                Thread.sleep(1000L);
                            }
                            catch (Exception e) {
                                log.error(dgtTask.getName() + "\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
                            }
                        }
                    }
                    while (finishedCount.get() < groupItems.size()) {
                        if (runningTask.isAborted) {
                            success = false;
                            errorMessage = "\u4efb\u52a1\u4e2d\u6b62";
                            break;
                        }
                        Thread.sleep(1000L);
                    }
                    if (!hasFailed.get() || priorityList.size() <= 1) continue;
                    success = false;
                    errorMessage = "\u4e0a\u4e00\u4f18\u5148\u7ea7\u4efb\u52a1\u9879\u6267\u884c\u5931\u8d25";
                    break;
                }
                while (success && runningTask.successCount + runningTask.failCount < dgtTask.getTotalCount()) {
                    if (runningTask.isAborted) {
                        success = false;
                        errorMessage = "\u4efb\u52a1\u4e2d\u6b62";
                        break;
                    }
                    Thread.sleep(1000L);
                }
                boolean bl = success = success && runningTask.failCount <= 0L;
                if (!success) break block26;
                try {
                    File tempFolder = new File(this.flowTempFolder, dgtTask.getId());
                    if (tempFolder.exists()) {
                        FileUtil.deleteDir((String)tempFolder.getAbsolutePath());
                    }
                }
                catch (Exception exception) {
                    log.error("\u5220\u9664\u4e34\u65f6\u6570\u636e\u5931\u8d25", (Throwable)exception);
                }
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
                log.error(dgtTask.getName() + "\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (runningTasks.containsKey(dgtTask.getId())) {
                    runningTasks.remove(dgtTask.getId());
                }
                if (success) {
                    dgtTask.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
                } else {
                    dgtTask.setStatus(TaskStatusEnum.FinishedFailed.getValue());
                }
                dgtTask.setEndTime(new Date());
                dgtTask.setFailMsg(errorMessage);
                this.taskDao.updateStatus(dgtTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecuteResult executeItem(RunningItem runningItem) {
        IToolParam executeParam;
        ITool tool;
        RunningTask runningTask = runningItem.runningTask;
        DgtTaskItem taskItem = runningItem.taskItem;
        runningTask.runningItems.add(runningItem);
        TaskParam taskItemParam = null;
        ExecuteResult result = new ExecuteResult();
        try {
            taskItemParam = (TaskParam)JSONObject.parseObject((String)taskItem.getParams(), TaskParam.class);
            tool = this.createToolPlugin(runningTask.dgtTool.getClassName());
            executeParam = this.createToolParam(runningTask.dgtTool.getParamClassName(), taskItemParam.getToolParam());
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorMessage("\u5de5\u5177\u53c2\u6570\u521d\u59cb\u5316\u5931\u8d25");
            log.error(runningTask.dgtTool.getId() + "\u5de5\u5177\u53c2\u6570\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            this.writeLog(runningItem, TaskLogLevelEnum.Error, "\u5de5\u5177\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage());
            ExecuteResult executeResult = result;
            runningTask.runningItems.remove(runningItem);
            if (result.getSuccess().booleanValue()) {
                taskItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
            } else {
                taskItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
            }
            taskItem.setEndTime(new Date());
            taskItem.setFailMsg(result.getErrorMessage());
            this.taskItemDao.updateStatus(taskItem);
            this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s %s \u6267\u884c%s", taskItem.getName(), runningTask.dgtTool.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
            return executeResult;
        }
        try {
            runningItem.dataTools = Collections.singletonList(tool);
            tool.setExecuteLogCallback(executeLog -> this.writeLog(runningItem, executeLog.getLevel(), executeLog.getMessage()));
            this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s %s \u5f00\u59cb\u6267\u884c...", taskItem.getName(), runningTask.dgtTool.getName()));
            taskItem.setStatus(TaskStatusEnum.Processing.getValue());
            taskItem.setStartTime(new Date());
            taskItem.setEndTime(null);
            taskItem.setFailMsg(null);
            this.taskItemDao.updateStatus(taskItem);
            result = tool.execute(taskItemParam.getInDataParam(), taskItemParam.getOutDataParam(), executeParam);
        }
        catch (Exception e) {
            try {
                result.setSuccess(false);
                result.setErrorMessage(e.getMessage());
                log.error(runningItem.runningTask.dgtTask.getName() + "-" + taskItem.getName() + "\u6267\u884c\u5931\u8d25", (Throwable)e);
                this.writeLog(runningItem, TaskLogLevelEnum.Error, e.getMessage());
            }
            catch (Throwable throwable) {
                runningTask.runningItems.remove(runningItem);
                if (result.getSuccess().booleanValue()) {
                    taskItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
                } else {
                    taskItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
                }
                taskItem.setEndTime(new Date());
                taskItem.setFailMsg(result.getErrorMessage());
                this.taskItemDao.updateStatus(taskItem);
                this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s %s \u6267\u884c%s", taskItem.getName(), runningTask.dgtTool.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
                throw throwable;
            }
            runningTask.runningItems.remove(runningItem);
            if (result.getSuccess().booleanValue()) {
                taskItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
            } else {
                taskItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
            }
            taskItem.setEndTime(new Date());
            taskItem.setFailMsg(result.getErrorMessage());
            this.taskItemDao.updateStatus(taskItem);
            this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s %s \u6267\u884c%s", taskItem.getName(), runningTask.dgtTool.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
        }
        runningTask.runningItems.remove(runningItem);
        if (result.getSuccess().booleanValue()) {
            taskItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
        } else {
            taskItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
        }
        taskItem.setEndTime(new Date());
        taskItem.setFailMsg(result.getErrorMessage());
        this.taskItemDao.updateStatus(taskItem);
        this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s %s \u6267\u884c%s", taskItem.getName(), runningTask.dgtTool.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecuteResult executeFlowItem(RunningItem runningItem) {
        RunningTask runningTask = runningItem.runningTask;
        DgtTaskItem taskItem = runningItem.taskItem;
        List<DgtTaskSubItem> subItems = this.taskSubItemDao.selectByTaskItemId(taskItem.getId());
        boolean allSuccess = true;
        runningItem.dataTools = new ArrayList<ITool>();
        runningTask.runningItems.add(runningItem);
        ExecuteResult result = new ExecuteResult();
        try {
            List toolParamList = JSONUtil.toList((String)taskItem.getParams(), TaskParam.class);
            taskItem.setStatus(TaskStatusEnum.Processing.getValue());
            taskItem.setStartTime(new Date());
            taskItem.setEndTime(null);
            taskItem.setFailMsg(null);
            this.taskItemDao.updateStatus(taskItem);
            for (int i = 0; i < toolParamList.size(); ++i) {
                TaskParam flowToolParam = (TaskParam)toolParamList.get(i);
                DgtTaskSubItem toolItem = null;
                try {
                    DgtTool dgtTool = this.toolDao.selectByPrimaryKey(flowToolParam.getToolId());
                    if (dgtTool == null) {
                        throw new RuntimeException(flowToolParam.getToolId() + "\u5de5\u5177\u63d2\u4ef6\u4e0d\u5b58\u5728");
                    }
                    toolItem = (DgtTaskSubItem)ListUtil.find(subItems, f -> dgtTool.getId().equals(f.getToolId()));
                    toolItem.setStartTime(new Date());
                    toolItem.setEndTime(null);
                    toolItem.setStatus(TaskStatusEnum.Processing.getValue());
                    toolItem.setResult(null);
                    this.taskSubItemDao.updateStatus(toolItem);
                    ITool tool = this.createToolPlugin(dgtTool.getClassName());
                    IToolParam toolParam = this.createToolParam(dgtTool.getParamClassName(), flowToolParam.getToolParam());
                    runningItem.dataTools.add(tool);
                    String subItemId = toolItem.getId();
                    tool.setExecuteLogCallback(executeLog -> this.writeFlowItemLog(taskItem.getTaskId(), subItemId, dgtTool.getId(), executeLog.getLevel(), executeLog.getMessage()));
                    this.writeLog(runningItem, flowToolParam.getToolId(), TaskLogLevelEnum.Info, String.format("%s %s \u5f00\u59cb\u6267\u884c...", taskItem.getName(), dgtTool.getName()));
                    result = tool.execute(flowToolParam.getInDataParam(), flowToolParam.getOutDataParam(), toolParam);
                    this.writeLog(runningItem, flowToolParam.getToolId(), TaskLogLevelEnum.Info, String.format("%s %s \u6267\u884c%s", taskItem.getName(), dgtTool.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
                    continue;
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setErrorMessage(e.getMessage());
                    log.error(runningItem.runningTask.dgtTask.getName() + "-" + taskItem.getName() + "\u6267\u884c\u5931\u8d25", (Throwable)e);
                    if (toolItem != null) {
                        this.writeFlowItemLog(taskItem.getTaskId(), toolItem.getId(), flowToolParam.getToolId(), TaskLogLevelEnum.Error, e.getMessage());
                        continue;
                    }
                    this.writeLog(runningItem, flowToolParam.getToolId(), TaskLogLevelEnum.Error, e.getMessage());
                    continue;
                }
                finally {
                    if (toolItem != null) {
                        toolItem.setEndTime(new Date());
                        if (result.getSuccess().booleanValue()) {
                            toolItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
                        } else {
                            toolItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
                            allSuccess = false;
                        }
                        this.taskSubItemDao.updateStatus(toolItem);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                result.setSuccess(false);
                result.setErrorMessage(e.getMessage());
                log.error(runningItem.runningTask.dgtTask.getName() + "-" + taskItem.getName() + "\u6267\u884c\u5931\u8d25", (Throwable)e);
                this.writeLog(runningItem, TaskLogLevelEnum.Error, e.getMessage());
            }
            catch (Throwable throwable) {
                runningTask.runningItems.remove(runningItem);
                if (allSuccess) {
                    taskItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
                } else {
                    taskItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
                }
                taskItem.setEndTime(new Date());
                taskItem.setFailMsg(result.getErrorMessage());
                this.taskItemDao.updateStatus(taskItem);
                result.setSuccess(allSuccess);
                this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s \u6267\u884c%s", taskItem.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
                throw throwable;
            }
            runningTask.runningItems.remove(runningItem);
            if (allSuccess) {
                taskItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
            } else {
                taskItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
            }
            taskItem.setEndTime(new Date());
            taskItem.setFailMsg(result.getErrorMessage());
            this.taskItemDao.updateStatus(taskItem);
            result.setSuccess(allSuccess);
            this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s \u6267\u884c%s", taskItem.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
        }
        runningTask.runningItems.remove(runningItem);
        if (allSuccess) {
            taskItem.setStatus(TaskStatusEnum.FinishedSuccessed.getValue());
        } else {
            taskItem.setStatus(TaskStatusEnum.FinishedFailed.getValue());
        }
        taskItem.setEndTime(new Date());
        taskItem.setFailMsg(result.getErrorMessage());
        this.taskItemDao.updateStatus(taskItem);
        result.setSuccess(allSuccess);
        this.writeLog(runningItem, TaskLogLevelEnum.Info, String.format("%s \u6267\u884c%s", taskItem.getName(), result.getSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskProgress(RunningTask runningTask, ExecuteResult result) {
        runningTask.lock.lock();
        try {
            long successCount = runningTask.successCount;
            long failCount = runningTask.failCount;
            if (result.getSuccess().booleanValue()) {
                ++successCount;
            } else {
                ++failCount;
            }
            runningTask.dgtTask.setSuccessCount(successCount);
            runningTask.dgtTask.setFailCount(failCount);
            this.taskDao.updateStatus(runningTask.dgtTask);
            runningTask.successCount = successCount;
            runningTask.failCount = failCount;
        }
        finally {
            runningTask.lock.unlock();
        }
    }

    private ITool createToolPlugin(String className) throws Exception {
        Class<?> aClass = Class.forName(className);
        ITool governanceTool = (ITool)aClass.newInstance();
        return governanceTool;
    }

    private IToolParam createToolParam(String className, String paramStr) throws Exception {
        if (StringUtil.isEmpty((String)paramStr)) {
            return null;
        }
        Class<?> aClass = Class.forName(className);
        return (IToolParam)JSONObject.parseObject((String)paramStr, aClass);
    }

    private void writeFlowItemLog(String taskId, String subItemId, String toolId, TaskLogLevelEnum logLevelEnum, String content) {
        RunningItem runningItem = new RunningItem();
        runningItem.taskItem = new DgtTaskItem();
        runningItem.taskItem.setTaskId(taskId);
        runningItem.taskItem.setId(subItemId);
        this.writeLog(runningItem, toolId, logLevelEnum, content);
    }

    private void writeLog(RunningItem runningItem, TaskLogLevelEnum logLevelEnum, String content) {
        this.writeLog(runningItem, runningItem.runningTask.dgtTool == null ? null : runningItem.runningTask.dgtTool.getId(), logLevelEnum, content);
    }

    private void writeLog(RunningItem runningItem, String toolId, TaskLogLevelEnum logLevelEnum, String content) {
        switch (logLevelEnum) {
            case Error: {
                log.error(content);
                break;
            }
            case Warning: {
                log.warn(content);
                break;
            }
            case Info: {
                log.info(content);
                break;
            }
            default: {
                log.info(content);
            }
        }
        DgtTaskLog taskLog = new DgtTaskLog();
        taskLog.setTaskId(runningItem.taskItem.getTaskId());
        taskLog.setItemId(runningItem.taskItem.getId());
        taskLog.setToolId(toolId);
        taskLog.setLevel(logLevelEnum.getValue());
        taskLog.setTime(new Date());
        taskLog.setContent(content);
        this.taskLogDao.insert(taskLog);
    }

    class RunningItem {
        public RunningTask runningTask;
        public DgtTaskItem taskItem;
        public List<ITool> dataTools;

        RunningItem() {
        }
    }

    class RunningTask {
        public Lock lock = new ReentrantLock();
        public DgtTask dgtTask;
        public DgtTool dgtTool;
        public long successCount;
        public long failCount;
        public boolean isAborted = false;
        public Queue<RunningItem> runningItems = new ConcurrentLinkedQueue<RunningItem>();

        RunningTask() {
        }
    }
}

