/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.frame.tools;

import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.ITool;
import com.geoway.dgt.frame.tools.model.ExecuteLog;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToolBase
implements ITool {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private Consumer<ExecuteLog> executeLogCallback;
    protected boolean isAborted = false;

    protected boolean isAborted() {
        return this.isAborted;
    }

    @Override
    public void abort() {
        this.isAborted = true;
    }

    @Override
    public void setExecuteLogCallback(Consumer<ExecuteLog> callback) {
        this.executeLogCallback = callback;
    }

    protected void invokeExcuteLog(String logMsg) {
        if (this.executeLogCallback != null) {
            this.executeLogCallback.accept(new ExecuteLog(logMsg));
        }
    }

    protected void invokeExcuteLog(String logMsg, TaskLogLevelEnum logLevelEnum) {
        if (this.executeLogCallback != null) {
            this.executeLogCallback.accept(new ExecuteLog(logMsg, logLevelEnum));
        }
    }

    protected void invokeExcuteLog(Throwable exceptionThrow) {
        this.log.error(exceptionThrow.getMessage(), exceptionThrow);
        if (this.executeLogCallback != null) {
            this.executeLogCallback.accept(new ExecuteLog(exceptionThrow.getMessage(), TaskLogLevelEnum.Error));
        }
    }

    protected void invokeExcuteLog(String logMsg, Throwable exceptionThrow) {
        this.log.error(logMsg, exceptionThrow);
        if (this.executeLogCallback != null) {
            this.executeLogCallback.accept(new ExecuteLog(logMsg + "\uff0c" + exceptionThrow.getMessage(), TaskLogLevelEnum.Error));
        }
    }
}

