/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.frame.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import java.io.File;
import java.nio.file.Paths;
import org.springframework.util.Assert;

public class VectorPathUtil {
    public static VectorFormatEnum vectorFormat(String path) {
        Assert.state((boolean)StrUtil.isNotEmpty((CharSequence)path), (String)"\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String fileName = FileUtil.getName((String)path);
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".mdb")) {
            return VectorFormatEnum.MDB;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".gpkg")) {
            return VectorFormatEnum.GeoPackage;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".gdb")) {
            return VectorFormatEnum.FileGDB;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".shp")) {
            return VectorFormatEnum.Shapefile;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".xls") || StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".xlsx") || StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".csv")) {
            return VectorFormatEnum.Excel;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".mif")) {
            return VectorFormatEnum.MapInfo;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".geojson")) {
            return VectorFormatEnum.GeoJson;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".000")) {
            return VectorFormatEnum.S57;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".e00")) {
            return VectorFormatEnum.E00;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".dxf")) {
            return VectorFormatEnum.DXF;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".wat") || StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".wal") || StrUtil.endWithIgnoreCase((CharSequence)fileName, (CharSequence)".wap")) {
            return VectorFormatEnum.S57;
        }
        if (new File(path).isFile()) {
            throw new RuntimeException("\u672a\u77e5\u77e2\u91cf\u7c7b\u578b : " + path);
        }
        return VectorFormatEnum.Shapefile;
    }

    public static String getOutputFilePath(String name, String outputPath, VectorFormatEnum outFormat) {
        switch (outFormat) {
            case MDB: 
            case FileGDB: {
                return Paths.get(outputPath, name + ".gdb").toAbsolutePath().toString();
            }
            case Shapefile: {
                return Paths.get(outputPath, name).toAbsolutePath().toString();
            }
            case GeoPackage: {
                return Paths.get(outputPath, name + ".gpkg").toAbsolutePath().toString();
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff1a" + (Object)((Object)outFormat));
    }

    public static boolean exactlyMatch(String path, VectorFormatEnum vectorFormatEnum) {
        try {
            VectorFormatEnum formatEnum = VectorPathUtil.vectorFormat(path);
            return vectorFormatEnum == null || vectorFormatEnum == formatEnum;
        }
        catch (Exception e) {
            return false;
        }
    }
}

