/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.grid.extent.impl;

import com.geoway.dgt.geodata.annosimplify.model.BaseObject;

public abstract class AbstractExtent
extends BaseObject {
    public double bottom;
    public double left;
    public double right;
    public double top;
    protected String wkt;
    protected String BBOX;

    public AbstractExtent(String BBOX) {
        String[] boxs = BBOX.split(",");
        this.BBOX = BBOX;
        double left = Double.valueOf(boxs[0]);
        double bottom = Double.valueOf(boxs[1]);
        double right = Double.valueOf(boxs[2]);
        double top = Double.valueOf(boxs[3]);
        this.init(left, bottom, right, top);
    }

    public AbstractExtent(double left, double bottom, double right, double top) {
        this.BBOX = left + "," + bottom + "," + right + "," + top;
        this.init(left, bottom, right, top);
    }

    private void init(double left, double bottom, double right, double top) {
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
        this.wkt = this.doWkt(left, bottom, right, top);
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getTop() {
        return this.top;
    }

    public String getBBOX() {
        return this.BBOX;
    }

    public String getWkt() {
        return this.wkt;
    }

    protected String doWkt(double left, double bottom, double right, double top) {
        String wkt = "POLYGON ((";
        wkt = wkt + left + " " + bottom + ",";
        wkt = wkt + right + " " + bottom + ",";
        wkt = wkt + right + " " + top + ",";
        wkt = wkt + left + " " + top + ",";
        wkt = wkt + left + " " + bottom + "))";
        return wkt;
    }
}

