/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.grid.impl;

import com.geoway.dgt.geodata.annosimplify.grid.Grid;
import com.geoway.dgt.geodata.annosimplify.grid.GridUnitManager;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import com.geoway.dgt.geodata.annosimplify.grid.extent.impl.GridExtentImpl;

public abstract class AbstractGrid
implements Grid {
    protected GridUnitManager.GridUnit unit;
    protected int base;
    protected double resolutionLevelBegin;
    protected int minX;
    protected int minY;
    protected int maxX;
    protected int maxY;
    protected int beginLevel;

    @Override
    public GridUnitManager.GridUnit getUnit() {
        return this.unit;
    }

    @Override
    public GridExtent getExtent(int level, int x, int y) {
        double resolution = this.getResolution(level);
        double standard = (double)this.base * resolution;
        double left = (double)this.minX + (double)x * standard;
        double right = (double)this.minX + (double)(x + 1) * standard;
        double top = (double)this.maxY - (double)y * standard;
        double bottom = (double)this.maxY - (double)(y + 1) * standard;
        return new GridExtentImpl(left, bottom, right, top, level, this, x, y);
    }

    @Override
    public int getBeginLevel() {
        return this.beginLevel;
    }

    public double getBeginResolution() {
        return this.resolutionLevelBegin;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public double calculateX(double resolution, double x) {
        return (x - (double)this.getMinX()) / resolution / (double)this.getBase();
    }

    @Override
    public double calculateY(double resolution, double y) {
        return ((double)this.getMaxY() - y) / resolution / (double)this.getBase();
    }

    @Override
    public String getBBox() {
        return this.minX + "," + this.minY + "," + this.maxX + "," + this.maxY;
    }
}

