/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.check;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultItemDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDatasetDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateFieldDTO;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.ScanFileResultParam;
import com.geoway.adf.dms.config.service.FileModelService;
import com.geoway.adf.dms.config.service.GeoTemplateService;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.check.EntityDataCheckParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class EntityDataCheckTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName("\u5b9e\u4f53\u6570\u636e\u68c0\u67e5");
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setPriority(100);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        EntityDataCheckParam entityDataCheckParam = (EntityDataCheckParam)executeParam;
        FileModelService fileModelService = (FileModelService)SpringContextUtil.getBean(FileModelService.class);
        GeoTemplateService geoTemplateService = (GeoTemplateService)SpringContextUtil.getBean(GeoTemplateService.class);
        DataPackage dataPackage = fileModelService.getDataPackage(entityDataCheckParam.getModelId());
        GeoTemplateDTO geoTemplate = geoTemplateService.getGeoTemplate(entityDataCheckParam.getTemplateId(), null);
        ScanResultDTO scanResult = dataPackage.scanFile(inputDataParam.getFilePath(), Boolean.valueOf(true));
        this.invokeExcuteLog("\u626b\u63cf\u5230\u4ee5\u4e0b\u4e3b\u6570\u636e\uff1a");
        for (ScanResultItemDTO scanResultItem : scanResult.getScanResultItems()) {
            this.invokeExcuteLog(scanResultItem.getMainFilePath() + ";" + scanResultItem.getCheckStatus());
        }
        if (scanResult.getDataCount() - scanResult.getInvalidCount() == 0L) {
            this.invokeExcuteLog("\u65e0\u7b26\u5408\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u7684\u6570\u636e\uff01", TaskLogLevelEnum.Error);
            executeResult.setSuccess(Boolean.valueOf(false));
            return executeResult;
        }
        boolean success = true;
        this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\u77e2\u91cf\u6570\u636e\u89c4\u8303\u6027...");
        for (ScanFileResultParam scanFileResult : dataPackage.getScanFileResultParams()) {
            if (!scanFileResult.getScanResult().booleanValue()) continue;
            for (FileDataUnit fileDataUnit : scanFileResult.getData().getFiles()) {
                String dbPath = fileDataUnit.getFileSourceLocation();
                this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + dbPath);
                if (!dbPath.toLowerCase(Locale.ROOT).endsWith(".gdb") && !dbPath.toLowerCase(Locale.ROOT).endsWith(".mdb")) continue;
                IFeatureWorkspace workspace = null;
                try {
                    workspace = WorkspaceUtil.openLocalFileGeodatabase((String)dbPath);
                    List datasetList = workspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.FeatureClass, GeoDatasetType.Table});
                    for (IGeoDataset geoDataset : datasetList) {
                        if (this.isAborted()) {
                            throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                        }
                        GeoTemplateDatasetDTO templateDataset = (GeoTemplateDatasetDTO)ListUtil.find((List)geoTemplate.getDatasets(), f -> f.getName().equalsIgnoreCase(geoDataset.getName()));
                        if (templateDataset == null) {
                            success = false;
                            this.invokeExcuteLog(geoDataset.getName() + "\u672a\u5728\u6a21\u677f\u627e\u5230\u5bf9\u5e94\u5339\u914d\u56fe\u5c42\uff01", TaskLogLevelEnum.Error);
                            continue;
                        }
                        FeatureType datasetFeatureType = FeatureType.getByValue((Integer)templateDataset.getType());
                        String typeStr = "\u56fe\u5c42";
                        switch (datasetFeatureType) {
                            case Point: 
                            case Polyline: 
                            case Polygon: {
                                break;
                            }
                            default: {
                                typeStr = "\u8868";
                            }
                        }
                        ITable table = (ITable)geoDataset;
                        IFields featureClassFields = table.getFields();
                        if (table instanceof IFeatureClass && ((IFeatureClass)table).getFeatureType() != datasetFeatureType) {
                            this.invokeExcuteLog("\u8981\u7d20\u7c7b\u578b\u4e0d\u5339\u914d! \u56fe\u5c42 : " + ((IFeatureClass)table).getFeatureType() + " , \u6a21\u677f : " + datasetFeatureType, TaskLogLevelEnum.Warning);
                            success = false;
                            continue;
                        }
                        List fields = templateDataset.getFields();
                        ArrayList<String> featureFieldNames = new ArrayList<String>();
                        for (IField featureClassField : featureClassFields) {
                            FieldType fieldType = featureClassField.getFieldType();
                            if (fieldType == FieldType.Shape || fieldType == FieldType.OID) continue;
                            featureFieldNames.add(featureClassField.getName());
                        }
                        int fieldDiff = featureFieldNames.size() - fields.size();
                        if (fieldDiff != 0) {
                            List templateFieldNames = fields.stream().map(FieldDTO::getName).collect(Collectors.toList());
                            if (fieldDiff < 0) {
                                templateFieldNames.removeAll(featureFieldNames);
                                this.invokeExcuteLog("" + typeStr + " " + geoDataset.getName() + " \u5b57\u6bb5\u7f3a\u5c11\u5b57\u6bb5 " + Arrays.toString(templateFieldNames.toArray()), TaskLogLevelEnum.Warning);
                            } else {
                                featureFieldNames.removeAll(templateFieldNames);
                                this.invokeExcuteLog("" + typeStr + " " + geoDataset.getName() + " \u5b57\u6bb5\u591a\u4f59\u5b57\u6bb5 " + Arrays.toString(featureFieldNames.toArray()), TaskLogLevelEnum.Warning);
                            }
                            success = false;
                            continue;
                        }
                        for (GeoTemplateFieldDTO tField : fields) {
                            int fieldLengthDiff;
                            String fieldName = tField.getName();
                            IField iField = featureClassFields.findField(fieldName);
                            if (iField == null) {
                                this.invokeExcuteLog("\u6e90" + typeStr + " : " + geoDataset.getName() + " \u4e0d\u5b58\u5728\u5b57\u6bb5 : " + fieldName, TaskLogLevelEnum.Warning);
                                success = false;
                                continue;
                            }
                            FieldType templateFieldType = FieldType.getByValue((Integer)tField.getFieldType());
                            if (iField.getFieldType() != templateFieldType) {
                                success = false;
                                this.invokeExcuteLog("\u6e90" + typeStr + " : " + geoDataset.getName() + " \u5b57\u6bb5 " + fieldName + " \u7c7b\u578b\u4e0d\u5339\u914d", TaskLogLevelEnum.Warning);
                                this.invokeExcuteLog("\u6a21\u677f\u5b57\u6bb5\u7c7b\u578b : " + templateFieldType + " <>  \u6570\u636e\u5b57\u6bb5\u7c7b\u578b " + iField.getFieldType(), TaskLogLevelEnum.Warning);
                                continue;
                            }
                            Integer tLength = tField.getLength();
                            Integer iLength = iField.getLength();
                            if (iLength > 0 && (fieldLengthDiff = iLength - tLength) != 0) {
                                this.invokeExcuteLog(typeStr + " " + geoDataset.getName() + " \u5b57\u6bb5 " + fieldName + " \u957f\u5ea6\u4e0d\u4e00\u81f4, \u76f8\u5dee " + fieldLengthDiff, TaskLogLevelEnum.Warning);
                                success = false;
                                continue;
                            }
                            if (!StrUtil.equals((CharSequence)iField.getAliasName(), (CharSequence)iField.getAliasName())) {
                                this.invokeExcuteLog(typeStr + " " + geoDataset.getName() + " \u5b57\u6bb5 " + fieldName + " \u522b\u540d\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                                success = false;
                                continue;
                            }
                            if (!ObjectUtil.equals((Object)iField.getNullable(), (Object)iField.getNullable())) {
                                this.invokeExcuteLog(typeStr + " " + geoDataset.getName() + " \u5b57\u6bb5 " + fieldName + " \u975e\u7a7a\u9650\u5236\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                                success = false;
                                continue;
                            }
                            if (!ObjectUtil.equals((Object)iField.getScale(), (Object)iField.getScale())) {
                                this.invokeExcuteLog(typeStr + " " + geoDataset.getName() + " \u5b57\u6bb5 " + fieldName + " \u7cbe\u5ea6\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                                success = false;
                                continue;
                            }
                            if (ObjectUtil.equals((Object)iField.getDefaultValue(), (Object)iField.getDefaultValue())) continue;
                            this.invokeExcuteLog(typeStr + " " + geoDataset.getName() + " \u5b57\u6bb5 " + fieldName + " \u9ed8\u8ba4\u503c\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                            success = false;
                        }
                    }
                    this.invokeExcuteLog(dbPath + "\u68c0\u67e5\u5b8c\u6210\uff01");
                }
                catch (Exception e) {
                    success = false;
                    this.invokeExcuteLog(dbPath + "\u68c0\u67e5\u5931\u8d25\uff01" + e.getMessage(), TaskLogLevelEnum.Error);
                }
                finally {
                    if (workspace == null) continue;
                    workspace.close();
                }
            }
        }
        executeResult.setSuccess(Boolean.valueOf(success));
        return executeResult;
    }
}

