/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.attribute;

import com.geoway.adf.dms.common.gis.FeatureClassUtil;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.clean.attribute.FieldValueByRelatedTableParam;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FieldValueByRelatedTableTool
extends ToolBase {
    private GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    private FileStorageService fileStorageService = (FileStorageService)SpringContextUtil.getBean(FileStorageService.class);

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        FieldValueByRelatedTableParam param = (FieldValueByRelatedTableParam)toolParam;
        if (param.getLayerList() == null || param.getLayerList().size() == 0 || !ListUtil.exist(param.getLayerList(), f -> Boolean.TRUE.equals(f.getChecked()))) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5f85\u5904\u7406\u56fe\u5c42");
        }
        if (param.getRelatedTableParam() == null) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5173\u8054\u6570\u636e");
        }
        if (batchOutputData == null || StringUtil.isEmptyOrWhiteSpace((String)batchOutputData.getFilePath())) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8f93\u51fa\u6570\u636e");
        }
        String name = batchInputData.getName();
        if (StringUtil.isEmptyOrWhiteSpace((String)name)) {
            name = FileUtil.getFileNameWithoutExtension((String)batchInputData.getFilePath());
        }
        DataStripingResult dataStripingResult = new DataStripingResult();
        dataStripingResult.setName(name);
        dataStripingResult.setInputData(batchInputData);
        dataStripingResult.setOutputData(batchOutputData);
        dataStripingResult.setToolExecuteParam(toolParam);
        oneDataCallback.accept(dataStripingResult);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        IFeatureWorkspace srcWorkspace = null;
        IFeatureWorkspace relatedWorkspace = null;
        IFeatureWorkspace targetWorkspace = null;
        try {
            String relatedFile;
            String relatedLayerName;
            FieldValueByRelatedTableParam param = (FieldValueByRelatedTableParam)executeParam;
            srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)inputDataParam.getFilePath());
            if (srcWorkspace == null) {
                executeResult.setErrorMessage("\u6253\u5f00\u6570\u636e\u5931\u8d25:" + inputDataParam.getFilePath());
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)param.getRelatedTableParam().getFilePath())) {
                relatedWorkspace = this.geoDatabaseService.openGeoWorkspace(param.getRelatedTableParam().getDsKey());
                relatedLayerName = param.getRelatedTableParam().getName();
            } else {
                relatedFile = param.getRelatedTableParam().getFilePath();
                relatedWorkspace = this.fileStorageService.openFileLayerWorkspace(relatedFile);
                relatedLayerName = FileUtil.getFileNameWithoutExtension((String)relatedFile);
            }
            if (relatedWorkspace == null) {
                executeResult.setErrorMessage("\u6253\u5f00\u5173\u8054\u6570\u636e\u5931\u8d25");
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                relatedFile = executeResult;
                return relatedFile;
            }
            IFeatureClass relatedFeatClass = relatedWorkspace.openFeatureClass(relatedLayerName);
            if (relatedFeatClass == null) {
                executeResult.setErrorMessage("\u6253\u5f00\u5173\u8054\u6570\u636e\u8868\u5931\u8d25:%s" + relatedLayerName);
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                ExecuteResult executeResult3 = executeResult;
                return executeResult3;
            }
            String outputName = FileUtil.getFileNameWithoutExtension((String)inputDataParam.getFilePath()) + ".gdb";
            File outputFile = new File(outputDataParam.getFilePath(), outputName);
            if (outputFile.isDirectory() && outputFile.exists()) {
                targetWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)outputFile.getAbsolutePath());
                if (targetWorkspace == null) {
                    executeResult.setErrorMessage("\u6253\u5f00\u8f93\u51fa\u6570\u636e\u5931\u8d25:" + outputFile.getAbsolutePath());
                    executeResult.setSuccess(Boolean.valueOf(false));
                    this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                    ExecuteResult executeResult4 = executeResult;
                    return executeResult4;
                }
            } else {
                targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)outputFile.getAbsolutePath());
                if (targetWorkspace == null) {
                    executeResult.setErrorMessage("\u521b\u5efa\u8f93\u51fa\u6570\u636e\u5931\u8d25:" + outputFile.getAbsolutePath());
                    executeResult.setSuccess(Boolean.valueOf(false));
                    this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                    ExecuteResult executeResult5 = executeResult;
                    return executeResult5;
                }
            }
            this.invokeExcuteLog("\u8f93\u51fa\u6570\u636e\u5230\uff1a" + outputFile.getAbsolutePath());
            boolean success = true;
            for (FieldValueByRelatedTableParam.LayerRelationship layer : param.getLayerList()) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u7ec8\u6b62");
                }
                if (!Boolean.TRUE.equals(layer.getChecked())) continue;
                this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\uff1a" + layer.getSrcLayerName());
                IFeatureClass srcFeatureClass = srcWorkspace.openFeatureClass(layer.getSrcLayerName());
                if (srcFeatureClass == null) {
                    this.invokeExcuteLog("\u6e90\u56fe\u5c42\u6253\u5f00\u5931\u8d25\uff1a" + layer.getSrcLayerName(), TaskLogLevelEnum.Warning);
                    continue;
                }
                if (layer.getValueFields() == null || layer.getValueFields().size() == 0) {
                    this.invokeExcuteLog("\u672a\u914d\u7f6e\u8d4b\u503c\u5b57\u6bb5", TaskLogLevelEnum.Warning);
                    continue;
                }
                ArrayList<FieldValueByRelatedTableParam.ValueField> valueFields = new ArrayList<FieldValueByRelatedTableParam.ValueField>();
                ArrayList<IField> newFields = new ArrayList<IField>();
                for (FieldValueByRelatedTableParam.ValueField valueField : layer.getValueFields()) {
                    IField field = relatedFeatClass.getFields().findField(valueField.getRelatedField());
                    if (field == null) {
                        this.invokeExcuteLog("\u5173\u8054\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + valueField.getRelatedField(), TaskLogLevelEnum.Warning);
                        continue;
                    }
                    IField targetField = srcFeatureClass.getFields().findField(valueField.getTargetField());
                    if (targetField == null) {
                        IField newField = field.clone();
                        newField.setName(valueField.getTargetField());
                        newField.setAliasName(valueField.getTargetField());
                        newField.setNullable(Boolean.valueOf(true));
                        newFields.add(newField);
                    } else if (!field.getFieldType().equals((Object)targetField.getFieldType())) {
                        this.invokeExcuteLog("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff1a" + valueField.getTargetField(), TaskLogLevelEnum.Warning);
                        continue;
                    }
                    valueFields.add(valueField);
                }
                IFeatureClass targetFeatureClass = FeatureClassUtil.createFeatureClass((IFeatureClass)srcFeatureClass, (IFeatureWorkspace)targetWorkspace, (String)layer.getSrcLayerName(), (IFields)new Fields(newFields), (String)srcFeatureClass.getOidFieldName(), (String)srcFeatureClass.getShapeFieldName(), (ISpatialReferenceSystem)srcFeatureClass.getSpatialReferenceSystem(), (String)srcFeatureClass.getParentDatasetName());
                if (targetFeatureClass == null) {
                    this.invokeExcuteLog("\u521b\u5efa\u76ee\u6807\u56fe\u5c42\u5931\u8d25\uff1a" + layer.getSrcLayerName(), TaskLogLevelEnum.Error);
                    continue;
                }
                IFeatureCursor srcFeatureCursor = null;
                IFeatureCursor targetFeatureCursor = null;
                targetWorkspace.beginTransaction();
                try {
                    int sCount = 0;
                    targetFeatureCursor = targetFeatureClass.insertFeature();
                    srcFeatureCursor = srcFeatureClass.searchFeature(null);
                    IFeature feature = srcFeatureCursor.nextFeature();
                    while (feature != null) {
                        if (this.isAborted()) {
                            throw new RuntimeException("\u4efb\u52a1\u5df2\u7ec8\u6b62");
                        }
                        IFeatureCursor relatedFeatureCursor = null;
                        IFeature targetFeature = targetFeatureClass.createFeature();
                        try {
                            targetFeature.setGeometry(feature.getGeometry());
                            for (int i = 0; i < feature.getFields().getFieldCount(); ++i) {
                                targetFeature.setValue(feature.getFields().getField(i).getName(), feature.getValue(i));
                            }
                            Object targetMatchValue = feature.getValue(layer.getSrcMatchField());
                            if (targetMatchValue == null) {
                                this.invokeExcuteLog("\u5339\u914d\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff1a" + layer.getSrcMatchField(), TaskLogLevelEnum.Warning);
                            } else {
                                QueryFilter queryFilter = new QueryFilter();
                                queryFilter.setSubFields(valueFields.stream().map(FieldValueByRelatedTableParam.ValueField::getRelatedField).collect(Collectors.joining(",")));
                                queryFilter.setWhereClause(String.format("%s = '%s'", layer.getRelatedMatchField(), targetMatchValue));
                                relatedFeatureCursor = relatedFeatClass.searchFeature((IQueryFilter)queryFilter);
                                IFeature relatedFeature = relatedFeatureCursor.nextFeature();
                                if (relatedFeature == null) {
                                    this.invokeExcuteLog(String.format("[%s]\u672a\u5339\u914d\u5230\u6570\u636e[%s]->[%s]\uff1a%s", feature.getObjectId(), layer.getSrcMatchField(), layer.getRelatedMatchField(), targetMatchValue), TaskLogLevelEnum.Warning);
                                } else {
                                    for (FieldValueByRelatedTableParam.ValueField valueField : valueFields) {
                                        Object value = relatedFeature.getValue(valueField.getRelatedField());
                                        targetFeature.setValue(valueField.getTargetField(), value);
                                    }
                                }
                            }
                            targetFeatureCursor.insertFeature(targetFeature);
                            ++sCount;
                        }
                        catch (Exception e) {
                            this.log.error(String.format("[%s]\u5904\u7406\u5f02\u5e38", feature.getObjectId()), (Throwable)e);
                            this.invokeExcuteLog(String.format("[%s]\u5904\u7406\u5f02\u5e38\uff1a%s", feature.getObjectId(), e.getMessage()), TaskLogLevelEnum.Error);
                            success = false;
                        }
                        finally {
                            if (relatedFeatureCursor != null) {
                                relatedFeatureCursor.release();
                            }
                        }
                        feature = srcFeatureCursor.nextFeature();
                    }
                    targetFeatureCursor.release();
                    targetFeatureCursor = null;
                    targetWorkspace.commitTransaction();
                    this.invokeExcuteLog(String.format("[%s]\u5904\u7406\u5b8c\u6210\uff0c\u6570\u636e\u5171%d\u6761", layer.getSrcLayerName(), sCount));
                }
                catch (Exception e) {
                    success = false;
                    this.log.error(String.format("[%s]\u5904\u7406\u5f02\u5e38", layer.getSrcLayerName()), (Throwable)e);
                    this.invokeExcuteLog(String.format("[%s]\u5904\u7406\u5f02\u5e38\uff1a%s", layer.getSrcLayerName(), e.getMessage()), TaskLogLevelEnum.Error);
                }
                finally {
                    if (srcFeatureCursor != null) {
                        srcFeatureCursor.release();
                    }
                    if (targetFeatureCursor != null) {
                        targetFeatureCursor.release();
                    }
                    if (!targetWorkspace.getInTransaction()) continue;
                    targetWorkspace.commitTransaction();
                }
            }
            executeResult.setSuccess(Boolean.valueOf(success));
        }
        catch (Exception e) {
            this.log.error("\u5904\u7406\u5f02\u5e38", (Throwable)e);
            executeResult.setErrorMessage("\u5904\u7406\u5931\u8d25:" + e.getMessage());
            executeResult.setSuccess(Boolean.valueOf(false));
            this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
        }
        finally {
            if (relatedWorkspace != null) {
                relatedWorkspace.close();
            }
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
        return executeResult;
    }
}

