/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.vector;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.func.Supplier4;
import cn.hutool.core.map.MapUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.vector.OverlappedDataParam;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class OverlappedDataTool
extends ToolBase {
    private boolean hasCheckError = false;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        OverlappedDataParam param = (OverlappedDataParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(batchInputData, batchOutputData, !param.isRepair());
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, param, vectorReadWriteEnum);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        OverlappedDataParam param = (OverlappedDataParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isRepair());
        return ToolHelper.buildExecuteParam(inputData, outputData, param, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            OverlappedDataParam param = (OverlappedDataParam)executeParam;
            VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isRepair());
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, vectorReadWriteEnum);
            switch (vectorReadWriteEnum) {
                case D: 
                case F: {
                    ToolHelper.handleFeatureClass(inputData.getName(), param, workspaceDTO.getSourceWorkspace(), (p, f) -> this.checkFeatureClass((OverlappedDataParam)p, (IFeatureClass)f));
                    ToolHelper.copyWhenFlowLast(inputData, outputData);
                    break;
                }
                case D2F: 
                case F2D: 
                case F2F: 
                case D2D: {
                    ToolHelper.handleAndSaveFeatureClass(inputData.getName(), outputData.getName(), param, workspaceDTO.getSourceWorkspace(), workspaceDTO.getTargetWorkspace(), (Supplier4<Boolean, IFeatureClass, FeatureClassMeta, IToolParam, String>)((Supplier4)(f, m, p, n) -> this.checkAndCopyFeature((IFeatureClass)f, (FeatureClassMeta)m, (OverlappedDataParam)p, (String)n)));
                    break;
                }
                default: {
                    throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
                }
            }
            executeResult.setSuccess(Boolean.valueOf(!this.hasCheckError));
            executeResult.setOutDataParam(outputData);
        }
        return executeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndCopyFeature(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, OverlappedDataParam param, String outputName) {
        IFeatureWorkspace targetWorkspace = featureClassMeta.getWorkspace();
        IFeatureCursor insertCursor = null;
        IFeatureCursor searchCursor = null;
        IFeatureWorkspace searchWorkspace = null;
        try {
            IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, outputName);
            targetWorkspace.beginTransaction();
            insertCursor = targetFeatureClass.batchInsertFeature();
            searchCursor = srcFeatureClass.searchFeature(null);
            this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + srcFeatureClass.getName());
            IFeature feature = searchCursor.nextFeature();
            HashSet<Object> invalidIds = new HashSet<Object>();
            boolean hasInvalid = false;
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                Object objectId = feature.getObjectId();
                if (invalidIds.contains(objectId) && param.isRepair()) {
                    feature = searchCursor.nextFeature();
                    continue;
                }
                IFeature newFeature = targetFeatureClass.createFeature();
                for (IField field : newFeature.getFields()) {
                    if (field.getFieldType() == FieldType.OID || field.getFieldType() == FieldType.Shape) continue;
                    newFeature.setValue(field.getName(), feature.getValue(field.getName()));
                }
                IGeometry geometry = feature.getGeometry();
                if (geometry == null || geometry.isEmpty()) {
                    this.invokeExcuteLog("\u56fe\u5c42 " + srcFeatureClass.getName() + " \u5b58\u5728\u8981\u7d20\u51e0\u4f55\u5b57\u6bb5\u4e3a\u7a7a, oid \u4e3a " + objectId, TaskLogLevelEnum.Warning);
                    feature = searchCursor.nextFeature();
                    continue;
                }
                searchWorkspace = srcFeatureClass.getWorkspace().clone();
                IFeatureClass searchFeatureClass = searchWorkspace.openFeatureClass(srcFeatureClass.getName());
                OverlappedData overlappedData = this.getOverlappedData(objectId, geometry, searchFeatureClass);
                if (overlappedData.isEmpty()) {
                    newFeature.setGeometry(geometry.clone());
                    insertCursor.insertFeature(newFeature);
                    feature = searchCursor.nextFeature();
                    continue;
                }
                hasInvalid = true;
                if (IterUtil.isNotEmpty(overlappedData.getContainIds())) {
                    invalidIds.addAll(overlappedData.getContainIds());
                }
                if (IterUtil.isNotEmpty(overlappedData.getWithinIds())) {
                    feature = searchCursor.nextFeature();
                    continue;
                }
                if (MapUtil.isNotEmpty(overlappedData.getOverlappedGeos())) {
                    for (Map.Entry<Object, IGeometry> entry : overlappedData.getOverlappedGeos().entrySet()) {
                        IGeometry iGeometry = entry.getValue();
                        Object id = entry.getKey();
                        this.invokeExcuteLog("\u56fe\u5c42 " + srcFeatureClass.getName() + objectId + " \u64e6\u9664\u4e0e " + id + "\u91cd\u53e0\u90e8\u5206", TaskLogLevelEnum.Warning);
                        if (geometry == null) break;
                        geometry = geometry.difference(iGeometry);
                    }
                }
                newFeature.setGeometry(geometry.clone());
                insertCursor.insertFeature(newFeature);
                feature = searchCursor.nextFeature();
            }
            if (!hasInvalid) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + srcFeatureClass.getName() + " \u65e0\u91cd\u53e0\u51e0\u4f55");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.invokeExcuteLog("\u62f7\u8d1d\u8981\u7d20\u5931\u8d25", e);
            targetWorkspace.rollbackTransaction();
            boolean bl = false;
            return bl;
        }
        finally {
            if (searchCursor != null) {
                searchCursor.release();
            }
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (searchWorkspace != null) {
                searchWorkspace.close();
            }
        }
    }

    private void checkFeatureClass(OverlappedDataParam param, IFeatureClass featureClass) {
        featureClass.getWorkspace().beginTransaction();
        IFeatureCursor featureCursor = null;
        IFeatureWorkspace searchWorkspace = null;
        try {
            searchWorkspace = featureClass.getWorkspace().clone();
            featureCursor = featureClass.searchFeature(null);
            this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + featureClass.getName());
            IFeature feature = featureCursor.nextFeature();
            HashSet<Object> invalidIds = new HashSet<Object>();
            boolean hasInvalid = false;
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IGeometry geometry = feature.getGeometry();
                Object objectId = feature.getObjectId();
                if (geometry == null || geometry.isEmpty()) {
                    this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + " \u5b58\u5728\u8981\u7d20\u51e0\u4f55\u5b57\u6bb5\u4e3a\u7a7a, oid \u4e3a " + objectId, TaskLogLevelEnum.Warning);
                    feature = featureCursor.nextFeature();
                    continue;
                }
                if (invalidIds.contains(objectId)) {
                    feature = featureCursor.nextFeature();
                    continue;
                }
                IFeatureClass searchFeatureClass = searchWorkspace.openFeatureClass(featureClass.getName());
                OverlappedData overlappedData = this.getOverlappedData(objectId, geometry, searchFeatureClass);
                if (overlappedData.isEmpty()) {
                    feature = featureCursor.nextFeature();
                    continue;
                }
                hasInvalid = true;
                this.hasCheckError = true;
                if (param.isRepair()) {
                    Set<Object> withinIds = overlappedData.getWithinIds();
                    Set<Object> containIds = overlappedData.getContainIds();
                    Map<Object, IGeometry> overlappedGeos = overlappedData.getOverlappedGeos();
                    if (IterUtil.isNotEmpty(containIds)) {
                        invalidIds.addAll(containIds);
                    }
                    if (IterUtil.isNotEmpty(withinIds)) {
                        invalidIds.add(objectId);
                    } else if (MapUtil.isNotEmpty(overlappedGeos)) {
                        for (Map.Entry<Object, IGeometry> entry : overlappedGeos.entrySet()) {
                            IGeometry iGeometry = entry.getValue();
                            Object id = entry.getKey();
                            if (geometry == null) break;
                            geometry = geometry.difference(iGeometry);
                            this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + objectId + " \u64e6\u9664\u4e0e " + id + "\u91cd\u53e0\u90e8\u5206", TaskLogLevelEnum.Warning);
                            feature.setGeometry(geometry);
                            featureCursor.updateFeature(feature);
                        }
                    }
                }
                feature = featureCursor.nextFeature();
            }
            featureCursor.release();
            featureClass.getWorkspace().commitTransaction();
            if (!hasInvalid) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + featureClass.getName() + " \u65e0\u91cd\u53e0\u51e0\u4f55");
            } else if (!invalidIds.isEmpty() && param.isRepair()) {
                this.deleteByIds(featureClass, invalidIds);
            }
        }
        catch (Exception e) {
            featureClass.getWorkspace().rollbackTransaction();
            throw new RuntimeException(e);
        }
        finally {
            if (featureCursor != null) {
                featureCursor.release();
            }
            if (searchWorkspace != null) {
                searchWorkspace.close();
            }
        }
    }

    private void deleteByIds(IFeatureClass featureClass, Set<Object> invalidIds) {
        QueryFilter queryFilter = new QueryFilter();
        String collect = invalidIds.stream().map(String::valueOf).collect(Collectors.joining("."));
        queryFilter.setWhereClause(featureClass.getOidFieldName() + " in (" + collect + ")");
        featureClass.deleteFeature((IQueryFilter)queryFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OverlappedData getOverlappedData(Object objectId, IGeometry geo, IFeatureClass featureClass) {
        SpatialQueryFilter spatialQueryFilter = new SpatialQueryFilter();
        spatialQueryFilter.setGeometry(geo);
        spatialQueryFilter.setGeometryField(featureClass.getShapeFieldName());
        IFeatureCursor searchFeatureCursor = featureClass.searchFeature((IQueryFilter)spatialQueryFilter);
        OverlappedData overlappedData = new OverlappedData();
        try {
            IFeature feature = searchFeatureCursor.nextFeature();
            while (feature != null) {
                if (objectId.equals(feature.getObjectId())) {
                    feature = searchFeatureCursor.nextFeature();
                    continue;
                }
                IGeometry overlappedGeo = feature.getGeometry();
                if (!geo.touches(overlappedGeo)) {
                    if (geo.within(overlappedGeo)) {
                        overlappedData.addWithin(objectId);
                        this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + "\u53d1\u73b0 " + objectId + " \u88ab " + feature.getObjectId() + "\u5305\u542b", TaskLogLevelEnum.Warning);
                    } else if (geo.contains(overlappedGeo)) {
                        this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + "\u53d1\u73b0 " + objectId + " \u5305\u542b " + feature.getObjectId(), TaskLogLevelEnum.Warning);
                        overlappedData.addContain(objectId);
                    } else {
                        this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + "\u53d1\u73b0 " + objectId + " \u548c " + feature.getObjectId() + " \u91cd\u53e0", TaskLogLevelEnum.Warning);
                        overlappedData.addOverlapped(feature.getObjectId(), overlappedGeo);
                    }
                }
                feature = searchFeatureCursor.nextFeature();
            }
            searchFeatureCursor.release();
            OverlappedData overlappedData2 = overlappedData;
            return overlappedData2;
        }
        finally {
            if (searchFeatureCursor != null) {
                searchFeatureCursor.release();
            }
        }
    }

    static class OverlappedData {
        Set<Object> withinIds;
        Set<Object> containIds;
        Map<Object, IGeometry> overlappedGeos;

        OverlappedData() {
        }

        public Set<Object> getWithinIds() {
            return this.withinIds;
        }

        public void setWithinIds(Set<Object> withinIds) {
            this.withinIds = withinIds;
        }

        public Set<Object> getContainIds() {
            return this.containIds;
        }

        public void setContainIds(Set<Object> containIds) {
            this.containIds = containIds;
        }

        public Map<Object, IGeometry> getOverlappedGeos() {
            return this.overlappedGeos;
        }

        public void setOverlappedGeos(Map<Object, IGeometry> overlappedGeos) {
            this.overlappedGeos = overlappedGeos;
        }

        void addWithin(Object id) {
            if (this.withinIds == null) {
                this.withinIds = new HashSet<Object>();
            }
            this.withinIds.add(id);
        }

        void addContain(Object id) {
            if (this.containIds == null) {
                this.containIds = new HashSet<Object>();
            }
            this.containIds.add(id);
        }

        void addOverlapped(Object objectId, IGeometry geo) {
            if (this.overlappedGeos == null) {
                this.overlappedGeos = new HashMap<Object, IGeometry>();
            }
            this.overlappedGeos.put(objectId, geo);
        }

        boolean isEmpty() {
            return IterUtil.isEmpty(this.withinIds) && IterUtil.isEmpty(this.containIds) && MapUtil.isEmpty(this.overlappedGeos);
        }
    }
}

