/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.srs;

import cn.hutool.core.io.FileUtil;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.RasterFormatEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.srs.RasterSpatialRefDefineParam;
import com.geoway.dgt.geodata.util.RasterImportScan;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.springframework.util.Assert;

public class RasterSpatialRefDefineTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        RasterSpatialRefDefineParam defineParam = (RasterSpatialRefDefineParam)toolParam;
        if (defineParam.getTargetSrid() == null) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u5b9a\u4e49\u7684\u5750\u6807\u7cfb");
        }
        if (StringUtils.isNotBlank((CharSequence)batchInputData.getName())) {
            String[] nameArray;
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            for (String name : nameArray = batchInputData.getName().split(",")) {
                batchInputData.setName(null);
                batchInputData.setFilePath(new File(batchInputData.getFilePath(), name).getAbsolutePath());
                ToolHelper.callbackOne(batchInputData, new DataParam(), toolParam, oneDataCallback);
            }
        } else {
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            ArrayList<RasterFormatEnum> formats = new ArrayList<RasterFormatEnum>(0);
            formats.add(RasterFormatEnum.IMG);
            formats.add(RasterFormatEnum.TIF);
            formats.add(RasterFormatEnum.GRID);
            RasterImportScan rasterImportScan = new RasterImportScan(batchInputData.getFilePath(), formats, null);
            rasterImportScan.scan(data -> {
                DataParam dataParam = new DataParam();
                dataParam.setFilePath(new File((String)data).getAbsolutePath());
                dataParam.setName(FileUtil.getName((String)data));
                ToolHelper.callbackOne(dataParam, new DataParam(), toolParam, oneDataCallback);
            });
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputDataPath);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        RasterSpatialRefDefineParam defineParam = (RasterSpatialRefDefineParam)executeParam;
        Dataset dataset = gdal.Open((String)inputDataParam.getFilePath(), (int)gdalconstConstants.GA_Update);
        if (dataset == null) {
            this.invokeExcuteLog("\u65e0\u6cd5\u6253\u5f00\u6805\u683c\u6570\u636e\uff01", TaskLogLevelEnum.Error);
            executeResult.setSuccess(Boolean.valueOf(false));
            return executeResult;
        }
        ISpatialReferenceSystem targetSpf = SpatialReferenceSystemFunc.createSpatialReference((int)defineParam.getTargetSrid());
        int errCode = dataset.SetProjection(targetSpf.getWkt());
        if (errCode == gdalconstConstants.CE_None) {
            this.invokeExcuteLog("\u5750\u6807\u7cfb\u5b9a\u4e49\u6210\u529f!");
            dataset.FlushCache();
            String actualProj = dataset.GetProjection();
            this.invokeExcuteLog("\u5f53\u524d\u5750\u6807\u7cfb:" + actualProj);
        } else {
            this.invokeExcuteLog("\u6295\u5f71\u5750\u6807\u7cfb\u5931\u8d25! \u9519\u8bef\u7801: " + errCode);
            this.invokeExcuteLog("GDAL\u9519\u8bef: " + gdal.GetLastErrorMsg());
        }
        dataset.delete();
        return executeResult;
    }
}

