/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.config.dataset.impl;

import com.geoway.dgt.geodata.annosimplify.common.serialize.Json.JsonWriter;
import com.geoway.dgt.geodata.annosimplify.common.serialize.Json.JsonWriterImpl;
import com.geoway.dgt.geodata.annosimplify.config.dataset.DataSet;
import com.geoway.dgt.geodata.annosimplify.config.dataset.impl.DataSetConfigField;
import com.geoway.dgt.geodata.annosimplify.config.datasource.DataSource;
import com.geoway.dgt.geodata.annosimplify.config.datasource.impl.DbDataSource;
import com.geoway.dgt.geodata.annosimplify.model.BaseObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DbDataSet
extends BaseObject
implements DataSet {
    protected DbDataSource dbDataSource;
    protected String tablename;
    protected String idField;
    protected String shapeField;
    protected Integer srid;
    protected String filter;
    protected String sortFiled;
    protected String sort;
    protected JsonWriter jsonWriter = new JsonWriterImpl();
    protected String fieldsPropertyGetterConfig = null;
    protected String id;
    protected Boolean isCaseSensitive;
    protected String oriFields;
    protected String refFields;
    protected Map<String, DataSetConfigField> oriFieldsMap;
    protected Map<String, DataSetConfigField> refFieldsMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFieldsPropertyGetterConfig() {
        if (this.fieldsPropertyGetterConfig == null) {
            DbDataSet dbDataSet = this;
            synchronized (dbDataSet) {
                if (this.fieldsPropertyGetterConfig != null) {
                    return this.fieldsPropertyGetterConfig;
                }
                String[] fieldArr = this.refFields.split(",");
                ArrayList<DataSetConfigField> i = new ArrayList<DataSetConfigField>();
                for (String field : fieldArr) {
                    i.add(this.refFieldsMap.get(field));
                }
                this.fieldsPropertyGetterConfig = this.getFieldsPropertyGetterConfig(i);
            }
        }
        return this.fieldsPropertyGetterConfig;
    }

    public String getSortFiled() {
        return this.sortFiled;
    }

    public void setSortFiled(String sortFiled) {
        this.sortFiled = sortFiled;
    }

    public DbDataSet(DbDataSource dbDataSource) {
        this.dbDataSource = dbDataSource;
        this.isCaseSensitive = this.dbDataSource.getType() == DataSource.TYPE.oracle ? Boolean.valueOf(false) : Boolean.valueOf(true);
    }

    public void setOriFieldsMap(Map<String, DataSetConfigField> oriFieldsMap) {
        this.oriFieldsMap = oriFieldsMap;
    }

    public void setRefFieldsMap(Map<String, DataSetConfigField> refFieldsMap) {
        this.refFieldsMap = refFieldsMap;
    }

    @Override
    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public String getOriFields() {
        return this.oriFields;
    }

    public void setOriFields(String oriFields) {
        this.oriFields = oriFields;
    }

    @Override
    public String getRefFields() {
        return this.refFields;
    }

    public void setRefFields(String refFields) {
        this.refFields = refFields;
    }

    @Override
    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    @Override
    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    @Override
    public String getShapeField() {
        return this.shapeField;
    }

    public void setShapeField(String shapeField) {
        this.shapeField = shapeField;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Map<String, DataSetConfigField> getOriFieldsMap() {
        return this.oriFieldsMap;
    }

    @Override
    public Map<String, DataSetConfigField> getRefFieldsMap() {
        return this.refFieldsMap;
    }

    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public DataSource getDataSource() {
        return this.dbDataSource;
    }

    protected String getFieldsPropertyGetterConfig(List<DataSetConfigField> configFields) {
        StringBuilder sb = new StringBuilder();
        if (configFields.isEmpty()) {
            return null;
        }
        this.jsonWriter.setPropertyName("fieldsConfig", sb);
        this.jsonWriter.arrayBegin(sb);
        for (int i = 0; i < configFields.size(); ++i) {
            DataSetConfigField lf = configFields.get(i);
            String fieldName = lf.getRefFieldName();
            this.jsonWriter.objectBegin(sb);
            this.jsonWriter.setPropertyName("index", sb);
            this.jsonWriter.setPropertyWraper(Integer.class, String.valueOf(i), sb);
            this.jsonWriter.propertyEnd(sb);
            this.jsonWriter.setPropertyName("name", sb);
            this.jsonWriter.setPropertyWraper(String.class, fieldName, sb);
            this.jsonWriter.propertyEnd(sb);
            this.jsonWriter.setPropertyName("type", sb);
            this.jsonWriter.setPropertyWraper(String.class, String.valueOf(lf.getType()), sb);
            this.jsonWriter.propertyEnd(sb);
            if (fieldName.equalsIgnoreCase(this.idField)) {
                this.jsonWriter.setPropertyName("id", sb);
                this.jsonWriter.setPropertyWraper(Boolean.class, "true", sb);
                this.jsonWriter.propertyEnd(sb);
            }
            this.jsonWriter.objectEnd(sb);
            this.jsonWriter.arrayNextElement(sb);
        }
        this.jsonWriter.arrayEnd(sb);
        return sb.toString();
    }
}

