/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.supplier;

import com.geoway.dgt.geodata.annosimplify.AnnoLog;
import com.geoway.dgt.geodata.annosimplify.AnnoSimplify;
import com.geoway.dgt.geodata.annosimplify.AnnoType;
import com.geoway.dgt.geodata.annosimplify.dao.WorkspaceUtil;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import com.geoway.dgt.geodata.annosimplify.supplier.AnnoSupplier;
import com.geoway.dgt.geodata.annosimplify.supplier.ISupplier;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class SimplifySupplier
extends AnnoSupplier<String, Boolean>
implements ISupplier<String> {
    protected static final AnnoLog logger = new AnnoLog(SimplifySupplier.class);

    private SimplifySupplier() {
        this.at = AnnoType.SIMPLIFY;
    }

    public static ISupplier<String> getSimplifySupplier() {
        return InstanceHolder.ss;
    }

    @Override
    public BiFunction<String, String, String> combineSupplier() {
        BiFunction<String, String, String> combinSullier = (result1, result2) -> {
            String sb = null;
            if (result1 != null && !result1.isEmpty()) {
                sb = result1;
            }
            if (result2 != null && !result2.isEmpty()) {
                sb = sb != null ? sb + result2 : result2;
            }
            if (sb != null) {
                String[] sbArr = sb.split(",");
                if (logger.isDebugEnabled()) {
                    logger.debug(this.at.getName() + "-\u6267\u884c\u67e5\u8be2 \uff1a \u8fdb\u5165 cfBase " + sb);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(this.at.getName() + "-\u6267\u884c\u66f4\u65b0\uff1a \u6267\u884c\u67e5\u8be2\u7ed3\u679c\u5408\u5e76 \uff0c\u5408\u5e76\u540e\u5171  " + sbArr.length + " \u6761\u8981\u7d20");
                }
                if (sbArr.length > 1000) {
                    this._updateLevel(AnnoSimplify.annoParas.scroll.getLevel(), sb);
                    return "";
                }
                return sb;
            }
            return "";
        };
        return combinSullier;
    }

    private void _updateLevel(int level, String ids) {
        String updateSql;
        block5: {
            Object[] idsArr = ids.split(",");
            ids = StringUtils.join((Object[])idsArr, (String)",");
            updateSql = AnnoSimplify.annoParas.updateSqlBase.replaceFirst("\\?", String.valueOf(level));
            if (logger.isTraceEnabled()) {
                logger.trace(this.at.getName() + "-\u6267\u884c\u66f4\u65b0 \uff1a " + updateSql);
            }
            if (logger.isInfoEnabled()) {
                logger.info(this.at.getName() + "-\u6267\u884c\u66f4\u65b0 \uff1a \u7b2c" + level + "\u5c42\uff1a " + ids.split(",").length + " \u6761\u8981\u7d20\u6267\u884csql update");
            }
            updateSql = updateSql.replaceFirst("\\?", ids);
            try {
                WorkspaceUtil.excuteSql(AnnoSimplify.annoParas.newDsKey, updateSql);
            }
            catch (Exception exx) {
                exx.printStackTrace();
                if (!logger.isErrorEnabled()) break block5;
                logger.error("updateSql  " + updateSql);
                logger.error("ids  " + ids);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(this.at.getName() + "-\u6267\u884c\u66f4\u65b0 \uff1a \u7b2c" + level + "\u5c42 --  \u66f4\u65b0\u8981\u7d20\u4e2a\u6570\uff1a " + ids.split(",").length + " | " + (updateSql.split("\\?").length - 1));
        }
    }

    @Override
    protected Boolean handleFeature(int gridAtomMaxPoint, int[][] simplifiedGridNum, int leftNum, int rightNum, Map m, StringBuffer sb) {
        boolean isfull = false;
        if (gridAtomMaxPoint < 0) {
            sb.append(m.get(AnnoSimplify.annoParas.idField.toLowerCase()).toString()).append(",");
        } else if (simplifiedGridNum[leftNum][rightNum] < gridAtomMaxPoint) {
            int[] nArray = simplifiedGridNum[leftNum];
            int n = rightNum;
            nArray[n] = nArray[n] + 1;
            sb.append(m.get(AnnoSimplify.annoParas.idField.toLowerCase()).toString()).append(",");
        } else {
            isfull = true;
            int sizej = simplifiedGridNum.length;
            for (int j = 0; j < sizej; ++j) {
                int sizek = simplifiedGridNum[j].length;
                for (int k = 0; k < sizek; ++k) {
                    if (simplifiedGridNum[j][k] >= gridAtomMaxPoint) continue;
                    isfull = false;
                    break;
                }
                if (!isfull) break;
            }
            if (isfull) {
                return isfull;
            }
        }
        return isfull;
    }

    @Override
    protected String endCirculateFeatures(int[][] simplifiedGridNum, StringBuffer sb, GridExtent extent, int gridAtomMaxPoint) {
        return sb.toString();
    }

    @Override
    protected Boolean handlerK(Boolean k) {
        return k;
    }

    private static class InstanceHolder {
        public static ISupplier<String> ss = new SimplifySupplier();

        private InstanceHolder() {
        }
    }
}

