/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.func.Supplier4;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.ogr.OgrWorkspaceFactory;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.util.VectorFileUtil;
import com.geoway.dgt.frame.util.VectorPathUtil;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import com.geoway.dgt.geodata.util.VectorDbUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ToolHelper {
    private static final Logger log = LoggerFactory.getLogger(ToolHelper.class);

    public static void strip(DataParam batchInputData, DataParam batchOutputData, Consumer<DataStripingResult> oneDataCallback, IToolParam param, VectorReadWriteEnum vectorReadWriteEnum) {
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, param, vectorReadWriteEnum, null, null);
    }

    public static void strip(DataParam batchInputData, DataParam batchOutputData, Consumer<DataStripingResult> oneDataCallback, IToolParam param, VectorReadWriteEnum vectorReadWriteEnum, VectorFormatEnum inputFormat, VectorFormatEnum outputFormat) {
        String inputDsKey = batchInputData.getDsKey();
        String inputFilePath = batchInputData.getFilePath();
        String inputName = batchInputData.getName();
        String outputDsKey = batchOutputData.getDsKey();
        String outputFilePath = batchOutputData.getFilePath();
        ToolHelper.completeOutputName(batchOutputData, inputName);
        String outputName = batchOutputData.getName();
        switch (vectorReadWriteEnum) {
            case D: {
                VectorCheckUtil.checkDsInput(batchInputData);
                StrUtil.split((CharSequence)inputName, (CharSequence)",").stream().map(datasetName -> new DataParam(inputDsKey, inputFilePath, datasetName)).forEach(inputData -> ToolHelper.callbackOne(inputData, inputData.clone(), param, oneDataCallback));
                break;
            }
            case F: {
                VectorCheckUtil.checkFileInput(batchInputData, true, inputFormat);
                File inputFile = new File(inputFilePath);
                if (VectorFileUtil.exactlyMatch((File)inputFile, (VectorFormatEnum)inputFormat)) {
                    ToolHelper.callbackOne(batchInputData, batchInputData.clone(), param, oneDataCallback);
                    if (!VectorFileUtil.exactlyMatch((File)inputFile, (VectorFormatEnum)VectorFormatEnum.Shapefile) || !inputFile.isDirectory()) break;
                    List vectorFiles = VectorFileUtil.getVectorFiles((File)inputFile, (int)1, (VectorFormatEnum)inputFormat);
                    for (File vectorFile2 : vectorFiles) {
                        if (VectorFileUtil.exactlyMatch((File)vectorFile2, (VectorFormatEnum)VectorFormatEnum.Shapefile)) continue;
                        DataParam dataParam = new DataParam();
                        dataParam.setFilePath(vectorFile2.getAbsolutePath());
                        dataParam.setName(inputName);
                        ToolHelper.callbackOne(dataParam, dataParam.clone(), param, oneDataCallback);
                    }
                    break;
                }
                Assert.state((boolean)inputFile.isDirectory(), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
                List vectorFiles = VectorFileUtil.getVectorFiles((File)inputFile, (int)1, (VectorFormatEnum)inputFormat);
                Assert.notEmpty((Collection)vectorFiles, (String)"\u672a\u627e\u5230\u8f93\u5165\u6570\u636e");
                vectorFiles.stream().map(vectorFile -> new DataParam(batchInputData.getDsKey(), vectorFile.getAbsolutePath(), inputName)).forEach(inputData -> ToolHelper.callbackOne(inputData, inputData.clone(), param, oneDataCallback));
                break;
            }
            case D2F: {
                VectorCheckUtil.checkDsInput(batchInputData);
                VectorCheckUtil.checkFileOutput(batchOutputData);
                if (outputFormat == null) {
                    outputFormat = VectorFormatEnum.FileGDB;
                }
                if (new File(outputFilePath).isDirectory()) {
                    batchOutputData.setFilePath(VectorPathUtil.getOutputFilePath((String)VectorDbUtil.dsName(inputDsKey), (String)outputFilePath, (VectorFormatEnum)outputFormat));
                } else {
                    Assert.state((boolean)VectorFileUtil.exactlyMatch((File)new File(outputFilePath), (VectorFormatEnum)outputFormat), (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
                break;
            }
            case F2D: {
                VectorCheckUtil.checkFileInput(batchInputData, true, inputFormat);
                VectorCheckUtil.checkDsOutput(batchOutputData);
                File inputDataFile = new File(inputFilePath);
                if (VectorFileUtil.exactlyMatch((File)inputDataFile, (VectorFormatEnum)inputFormat)) {
                    VectorCheckUtil.checkDsOutput(batchOutputData);
                    ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
                    if (!VectorFileUtil.exactlyMatch((File)inputDataFile, (VectorFormatEnum)VectorFormatEnum.Shapefile) || !inputDataFile.isDirectory()) break;
                    List vectorFiles = VectorFileUtil.getVectorFiles((File)inputDataFile, (int)1, (VectorFormatEnum)inputFormat);
                    vectorFiles.stream().filter(file -> VectorFileUtil.vectorFormat((File)file) != VectorFormatEnum.Shapefile).forEach(vectorFile -> {
                        DataParam inputData = new DataParam(inputDsKey, vectorFile.getAbsolutePath(), inputName);
                        DataParam outputData = new DataParam(outputDsKey, null, outputName);
                        ToolHelper.callbackOne(inputData, outputData, param, oneDataCallback);
                    });
                    break;
                }
                Assert.state((boolean)inputDataFile.isDirectory(), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef");
                List vectorFiles = VectorFileUtil.getVectorFiles((File)inputDataFile, (int)1, (VectorFormatEnum)inputFormat);
                Assert.notEmpty((Collection)vectorFiles, (String)"\u672a\u627e\u5230\u8f93\u5165\u6570\u636e");
                for (File vectorFile3 : vectorFiles) {
                    DataParam inputData2 = new DataParam(inputDsKey, vectorFile3.getAbsolutePath(), inputName);
                    DataParam outputData = new DataParam(outputDsKey, null, outputName);
                    ToolHelper.callbackOne(inputData2, outputData, param, oneDataCallback);
                }
                break;
            }
            case F2F: {
                VectorCheckUtil.checkFileInput(batchInputData, true, inputFormat);
                VectorCheckUtil.checkFileOutput(batchOutputData);
                File inFile = new File(inputFilePath);
                File outFile = new File(outputFilePath);
                if (VectorFileUtil.exactlyMatch((File)inFile, (VectorFormatEnum)inputFormat)) {
                    if (outFile.isDirectory()) {
                        if (VectorFormatEnum.Shapefile == outputFormat) {
                            ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
                        } else {
                            if (outputFormat == null) {
                                outputFormat = VectorFileUtil.vectorFormat((File)inFile);
                            }
                            outputFilePath = VectorPathUtil.getOutputFilePath((String)VectorFileUtil.mainName((File)inFile), (String)outputFilePath, (VectorFormatEnum)outputFormat);
                            batchOutputData.setFilePath(outputFilePath);
                        }
                    } else {
                        Assert.state((boolean)VectorPathUtil.exactlyMatch((String)outputFilePath, (VectorFormatEnum)outputFormat), (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u6709\u8bef");
                    }
                    ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
                    if (!VectorFileUtil.exactlyMatch((File)inFile, (VectorFormatEnum)VectorFormatEnum.Shapefile) || !inFile.isDirectory()) break;
                    List vectorFiles = VectorFileUtil.getVectorFiles((File)inFile, (int)1, (VectorFormatEnum)inputFormat);
                    for (File vectorFile4 : vectorFiles) {
                        if (VectorFileUtil.vectorFormat((File)vectorFile4) == VectorFormatEnum.Shapefile) continue;
                        DataParam inputData3 = new DataParam(inputDsKey, vectorFile4.getAbsolutePath(), inputName);
                        String outputPath = VectorPathUtil.getOutputFilePath((String)VectorFileUtil.mainName((File)vectorFile4), (String)outputFilePath, (VectorFormatEnum)VectorFileUtil.vectorFormat((File)vectorFile4));
                        DataParam outputData = new DataParam(outputDsKey, outputPath, outputName);
                        ToolHelper.callbackOne(inputData3, outputData, param, oneDataCallback);
                    }
                } else {
                    Assert.state((boolean)FileUtil.isDirectory((File)inFile), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef");
                    if (FileUtil.exist((File)outFile)) {
                        Assert.state((FileUtil.isDirectory((File)outFile) && !VectorFileUtil.exactlyMatchDir((File)outFile) ? 1 : 0) != 0, (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
                    } else {
                        FileUtil.mkdir((File)outFile);
                    }
                    List vectorFiles = VectorFileUtil.getVectorFiles((File)inFile, (int)1, (VectorFormatEnum)inputFormat);
                    Assert.notEmpty((Collection)vectorFiles, (String)"\u672a\u627e\u5230\u8f93\u5165\u6570\u636e");
                    for (File vectorFile5 : vectorFiles) {
                        DataParam inputData4 = new DataParam(inputDsKey, vectorFile5.getAbsolutePath(), inputName);
                        VectorFormatEnum format = outputFormat != null ? outputFormat : VectorFileUtil.vectorFormat((File)vectorFile5);
                        String outputFile = VectorPathUtil.getOutputFilePath((String)VectorFileUtil.mainName((File)vectorFile5), (String)outputFilePath, (VectorFormatEnum)format);
                        DataParam outputData = new DataParam(outputDsKey, outputFile, outputName);
                        ToolHelper.callbackOne(inputData4, outputData, param, oneDataCallback);
                    }
                }
                break;
            }
            case D2D: {
                VectorCheckUtil.checkDsInput(batchInputData);
                VectorCheckUtil.checkDsOutput(batchOutputData);
                ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
                break;
            }
            default: {
                throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
            }
        }
    }

    private static void completeOutputName(DataParam outputData, String inputName) {
        String outputName = outputData.getName();
        if (StrUtil.isNotEmpty((CharSequence)inputName) && StrUtil.isNotEmpty((CharSequence)outputName)) {
            Assert.state((StrUtil.split((CharSequence)inputName, (CharSequence)",").size() == StrUtil.split((CharSequence)outputName, (CharSequence)",").size() ? 1 : 0) != 0, (String)"\u8f93\u5165\u8f93\u51fa\u56fe\u5c42\u540d\u4e0d\u5339\u914d");
        }
        if (StrUtil.isEmpty((CharSequence)outputName)) {
            outputData.setName(inputName);
        }
    }

    public static void callbackOne(DataParam inputData, DataParam outputData, IToolParam param, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult dataStripingResult = new DataStripingResult();
        dataStripingResult.setName(VectorFileUtil.mainName((File)new File(inputData.getFilePath())));
        dataStripingResult.setInputData(new DataParam(inputData.getDsKey(), inputData.getFilePath(), inputData.getName()));
        dataStripingResult.setOutputData(new DataParam(outputData.getDsKey(), outputData.getFilePath(), outputData.getName()));
        dataStripingResult.setToolExecuteParam(param);
        oneDataCallback.accept(dataStripingResult);
    }

    public static void callbackDir(DataParam batchInputData, DataParam batchOutputData, Consumer<DataStripingResult> oneDataCallback, IToolParam toolParam, List<VectorFormatEnum> vectorFormatEnums) {
        File sourceFile = new File(batchInputData.getFilePath());
        Assert.state((sourceFile.exists() && sourceFile.isDirectory() ? 1 : 0) != 0, (String)"\u5143\u6570\u636e\u8def\u5f84\u6709\u8bef");
        List files = VectorFileUtil.getVectorFilesByEnums((File)sourceFile, (int)1, vectorFormatEnums);
        Assert.state((files.size() > 0 ? 1 : 0) != 0, (String)"\u65e0\u5339\u914d\u6570\u636e");
        files.stream().map(file -> new DataParam(batchInputData.getDsKey(), file.getAbsolutePath(), batchInputData.getName())).forEach(dataParam -> ToolHelper.callbackOne(dataParam, batchOutputData, toolParam, oneDataCallback));
    }

    public static ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam param, VectorReadWriteEnum vectorReadWriteEnum) {
        return ToolHelper.buildExecuteParam(inputData, outputData, param, vectorReadWriteEnum, null, null);
    }

    public static ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam param, VectorReadWriteEnum vectorReadWriteEnum, VectorFormatEnum inputFormat, VectorFormatEnum outputFormat) {
        String inputFilePath = inputData.getFilePath();
        String inputName = inputData.getName();
        String inputDsKey = inputData.getDsKey();
        String outputFilePath = outputData.getFilePath();
        ToolHelper.completeOutputName(outputData, inputName);
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(param);
        switch (vectorReadWriteEnum) {
            case D: {
                VectorCheckUtil.checkDsInput(inputData);
                if (!StrUtil.isNotEmpty((CharSequence)outputData.getDsKey())) break;
                VectorCheckUtil.checkDsOutput(outputData);
                break;
            }
            case F: {
                VectorCheckUtil.checkFileInput(inputData, false, inputFormat);
                if (!StrUtil.isNotEmpty((CharSequence)outputData.getFilePath())) break;
                VectorCheckUtil.checkFileOutput(outputData);
                break;
            }
            case D2F: {
                VectorCheckUtil.checkDsInput(inputData);
                VectorCheckUtil.checkFileOutput(outputData);
                if (outputFormat == null) {
                    outputFormat = VectorFormatEnum.FileGDB;
                }
                if (FileUtil.isDirectory((File)new File(outputFilePath))) {
                    outputData.setFilePath(VectorPathUtil.getOutputFilePath((String)VectorDbUtil.dsName(inputDsKey), (String)outputFilePath, (VectorFormatEnum)outputFormat));
                }
                executeParam.setOutputData(outputData);
                break;
            }
            case F2D: {
                VectorCheckUtil.checkFileInput(inputData, false, inputFormat);
                VectorCheckUtil.checkDsOutput(outputData);
                executeParam.setOutputData(outputData);
                break;
            }
            case F2F: {
                VectorCheckUtil.checkFileInput(inputData, false, inputFormat);
                VectorCheckUtil.checkFileOutput(outputData);
                if (outputFormat == null) {
                    outputFormat = VectorPathUtil.vectorFormat((String)inputFilePath);
                }
                if (FileUtil.isDirectory((File)new File(outputFilePath))) {
                    outputData.setFilePath(VectorPathUtil.getOutputFilePath((String)VectorFileUtil.mainName((File)new File(inputFilePath)), (String)outputFilePath, (VectorFormatEnum)outputFormat));
                }
                executeParam.setOutputData(outputData);
                break;
            }
            case D2D: {
                VectorCheckUtil.checkDsInput(inputData);
                VectorCheckUtil.checkDsOutput(outputData);
                executeParam.setOutputData(outputData);
                break;
            }
            default: {
                throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
            }
        }
        return executeParam;
    }

    public static ToolFeatureWorkspaceDTO getWorkspace(DataParam inputData, DataParam outputData, VectorReadWriteEnum vectorReadWriteEnum) {
        IFeatureWorkspace sourceWorkspace = null;
        IFeatureWorkspace targetWorkspace = null;
        GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
        switch (vectorReadWriteEnum) {
            case D: {
                sourceWorkspace = geoDatabaseService.openGeoWorkspace(inputData.getDsKey());
                break;
            }
            case F: {
                sourceWorkspace = ToolHelper.getFileWorkspace(inputData.getFilePath());
                break;
            }
            case D2F: {
                sourceWorkspace = geoDatabaseService.openGeoWorkspace(inputData.getDsKey());
                targetWorkspace = ToolHelper.getFileWorkspace(outputData.getFilePath());
                break;
            }
            case F2D: {
                sourceWorkspace = ToolHelper.getFileWorkspace(inputData.getFilePath());
                targetWorkspace = geoDatabaseService.openGeoWorkspace(outputData.getDsKey());
                break;
            }
            case F2F: {
                sourceWorkspace = ToolHelper.getFileWorkspace(inputData.getFilePath());
                targetWorkspace = ToolHelper.getFileWorkspace(outputData.getFilePath());
                break;
            }
            case D2D: {
                sourceWorkspace = geoDatabaseService.openGeoWorkspace(inputData.getDsKey());
                targetWorkspace = geoDatabaseService.openGeoWorkspace(outputData.getDsKey());
            }
        }
        ToolFeatureWorkspaceDTO workspaceDTO = new ToolFeatureWorkspaceDTO();
        workspaceDTO.setSourceWorkspace(sourceWorkspace);
        workspaceDTO.setTargetWorkspace(targetWorkspace);
        return workspaceDTO;
    }

    public static IFeatureWorkspace getFileWorkspace(String filePath) {
        IFeatureWorkspace workspace = FileUtil.exist((File)new File(filePath)) ? WorkspaceUtil.openLocalFileGeodatabase((String)filePath) : WorkspaceUtil.createLocalFileGeodatabase((String)filePath);
        return workspace;
    }

    public static void handleTable(String inputName, IToolParam param, IFeatureWorkspace sourceWorkspace, BiConsumer<IToolParam, ITable> tableHandler) {
        if (StrUtil.isEmpty((CharSequence)inputName)) {
            List datasets = sourceWorkspace.getDatasets();
            block4: for (IGeoDataset dataset : datasets) {
                GeoDatasetType geoDatasetType = dataset.getType();
                switch (geoDatasetType) {
                    case FeatureDataset: {
                        IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                        List subsets = featureDataset.getSubsets();
                        for (IGeoDataset subset : subsets) {
                            ITable table = (ITable)subset;
                            tableHandler.accept(param, table);
                        }
                        continue block4;
                    }
                    case FeatureClass: 
                    case Table: {
                        ITable table = (ITable)dataset;
                        tableHandler.accept(param, table);
                        break;
                    }
                }
            }
        } else {
            for (String datasetName : StrUtil.split((CharSequence)inputName, (CharSequence)",")) {
                ITable table = sourceWorkspace.openTable(datasetName);
                tableHandler.accept(param, table);
            }
        }
    }

    public static void handleFeatureClass(String inputName, IToolParam param, IFeatureWorkspace sourceWorkspace, BiConsumer<IToolParam, IFeatureClass> featureClassHandler) {
        if (StrUtil.isEmpty((CharSequence)inputName)) {
            List datasets = sourceWorkspace.getDatasets();
            block4: for (IGeoDataset dataset : datasets) {
                GeoDatasetType geoDatasetType = dataset.getType();
                switch (geoDatasetType) {
                    case FeatureDataset: {
                        IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                        List subsets = featureDataset.getSubsets();
                        for (IGeoDataset subset : subsets) {
                            IFeatureClass featureClass = (IFeatureClass)subset;
                            featureClassHandler.accept(param, featureClass);
                        }
                        continue block4;
                    }
                    case FeatureClass: {
                        IFeatureClass featureClass = (IFeatureClass)dataset;
                        featureClassHandler.accept(param, featureClass);
                        break;
                    }
                }
            }
        } else {
            for (String datasetName : StrUtil.split((CharSequence)inputName, (CharSequence)",")) {
                IFeatureClass featureClass = sourceWorkspace.openFeatureClass(datasetName);
                featureClassHandler.accept(param, featureClass);
            }
        }
    }

    public static void handleAndSaveFeatureClass(String inputName, String outputName, IToolParam param, IFeatureWorkspace sourceWorkspace, IFeatureWorkspace targetWorkspace, Supplier4<Boolean, IFeatureClass, FeatureClassMeta, IToolParam, String> featureClassTransfer) {
        if (StrUtil.isEmpty((CharSequence)inputName)) {
            List datasets = sourceWorkspace.getDatasets();
            block4: for (IGeoDataset dataset : datasets) {
                GeoDatasetType geoDatasetType = dataset.getType();
                switch (geoDatasetType) {
                    case FeatureDataset: {
                        IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                        List subsets = featureDataset.getSubsets();
                        for (IGeoDataset subset : subsets) {
                            IFeatureClass featureClass = (IFeatureClass)subset;
                            FeatureClassMeta featureClassMeta = new FeatureClassMeta(targetWorkspace, featureDataset.getName());
                            boolean success = (Boolean)featureClassTransfer.get((Object)featureClass, (Object)featureClassMeta, (Object)param, null);
                            Assert.state((boolean)success, (String)("\u5904\u7406\u8981\u7d20\u7c7b\u5931\u8d25 : " + featureClass.getName()));
                        }
                        continue block4;
                    }
                    case FeatureClass: {
                        IFeatureClass featureClass = (IFeatureClass)dataset;
                        FeatureClassMeta featureClassMeta = new FeatureClassMeta(targetWorkspace, null);
                        boolean success = (Boolean)featureClassTransfer.get((Object)featureClass, (Object)featureClassMeta, (Object)param, null);
                        Assert.state((boolean)success, (String)("\u5904\u7406\u8981\u7d20\u7c7b\u5931\u8d25 : " + featureClass.getName()));
                        break;
                    }
                }
            }
        } else {
            List inputNames = StrUtil.split((CharSequence)inputName, (CharSequence)",");
            ArrayList outputNames = StrUtil.isEmpty((CharSequence)outputName) ? new ArrayList(inputNames) : StrUtil.split((CharSequence)outputName, (CharSequence)",");
            for (int i = 0; i < inputNames.size(); ++i) {
                String datasetName = (String)inputNames.get(i);
                IFeatureClass featureClass = sourceWorkspace.openFeatureClass(datasetName);
                String parentDatasetName = featureClass.getParentDatasetName();
                FeatureClassMeta featureClassMeta = new FeatureClassMeta(targetWorkspace, parentDatasetName);
                boolean success = (Boolean)featureClassTransfer.get((Object)featureClass, (Object)featureClassMeta, (Object)param, outputNames.get(i));
                Assert.state((boolean)success, (String)("\u5904\u7406\u8981\u7d20\u7c7b\u5931\u8d25 : " + featureClass.getName()));
            }
        }
    }

    public static IFeatureClass getTargetFeatureClass(IFeatureClass sourceFeatureClass, FeatureClassMeta featureClassMeta, String outputName) {
        IFeatureWorkspace workspace;
        if (featureClassMeta.getSrs() == null) {
            featureClassMeta.setSrs(sourceFeatureClass.getSpatialReferenceSystem());
        }
        boolean isShpfile = (workspace = featureClassMeta.getWorkspace()).getWorkspaceFactory() instanceof OgrWorkspaceFactory && "ESRI Shapefile".equals(((OgrWorkspaceFactory)workspace.getWorkspaceFactory()).getDriverName());
        int suffix = 0;
        if (StrUtil.isEmpty((CharSequence)outputName)) {
            outputName = sourceFeatureClass.getName();
        }
        String name = outputName;
        Fields newFields = new Fields();
        int bound = sourceFeatureClass.getFields().getFieldCount();
        for (int i = 0; i < bound; ++i) {
            IField field = sourceFeatureClass.getFields().getField(i).clone();
            if (field.getFieldType() == FieldType.Shape) {
                field.setName(sourceFeatureClass.getShapeFieldName());
                ((GeometryField)field).setSpatialReferenceSystem(featureClassMeta.getSrs());
                if (featureClassMeta.getCoordinateType() != null) {
                    ((GeometryField)field).setCoordinateType(featureClassMeta.getCoordinateType());
                } else {
                    ((GeometryField)field).setCoordinateType(CoordinateType.XY);
                }
                newFields.addField(field);
                continue;
            }
            if (isShpfile && field.getFieldType() == FieldType.Blob) {
                log.error("shpfile\u4e0d\u652f\u6301\u5b57\u6bb5\u7c7b\u578b\uff1a" + field.getFieldType());
                continue;
            }
            newFields.addField(field);
        }
        while (workspace.datasetExist(name)) {
            name = outputName + "_" + ++suffix;
        }
        String featureDatasetName = featureClassMeta.getFeatureDatasetName();
        if (StrUtil.isNotEmpty((CharSequence)featureDatasetName)) {
            IFeatureDataset featureDataset = workspace.openFeatureDataset(featureDatasetName);
            if (featureDataset == null) {
                featureDataset = workspace.createFeatureDataset(featureDatasetName, sourceFeatureClass.getSpatialReferenceSystem());
            }
            IFeatureClass featureClass = featureDataset.createFeatureClass(name, (IFields)newFields, sourceFeatureClass.getFeatureType(), sourceFeatureClass.getShapeFieldName(), null);
            featureClass.alterAliasName(sourceFeatureClass.getAliasName());
            return featureClass;
        }
        IFeatureClass featureClass = featureClassMeta.getWorkspace().createFeatureClass(name, (IFields)newFields, sourceFeatureClass.getFeatureType(), sourceFeatureClass.getShapeFieldName(), null);
        featureClass.alterAliasName(sourceFeatureClass.getAliasName());
        return featureClass;
    }

    public static List<String> codes(String dictionaryKey) {
        DictionaryService dictionaryService = (DictionaryService)SpringContextUtil.getBean(DictionaryService.class);
        DmDictValueDTO dictionaryTree = dictionaryService.getDictionaryTree(dictionaryKey);
        if (dictionaryTree == null) {
            throw new RuntimeException(String.format("\u5b57\u5178\u503c\u57df[%d]\u4e0d\u5b58\u5728", dictionaryKey));
        }
        return ToolHelper.codes(dictionaryTree.getChildren());
    }

    private static List<String> codes(List<DmDictValueDTO> dmDictValueDTOS) {
        if (dmDictValueDTOS == null || dmDictValueDTOS.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (DmDictValueDTO dmDictValueDTO : dmDictValueDTOS) {
            list.add(dmDictValueDTO.getCode());
            list.addAll(ToolHelper.codes(dmDictValueDTO.getChildren()));
        }
        return list;
    }

    public static void copyWhenFlowLast(DataParam inputData, DataParam outputData) {
        String inputFilePath = inputData.getFilePath();
        String outputFilePath = outputData.getFilePath();
        if (outputFilePath != null && !StrUtil.equals((CharSequence)inputFilePath, (CharSequence)outputFilePath)) {
            FileUtil.copy((File)new File(inputFilePath), (File)new File(outputFilePath), (boolean)false);
        }
    }
}

