/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.extract;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.dgt.frame.dto.extract.ExtractSchemeDTO;
import com.geoway.dgt.frame.dto.extract.ExtractSchemeFieldDTO;
import com.geoway.dgt.frame.dto.extract.ExtractSchemeLayerDTO;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.extract.ExtractDataParam;
import com.geoway.dgt.geodata.extract.VectorDataTransfer2;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public class ExtractDataTool
extends ToolBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        ExtractDataParam extractDataParam = (ExtractDataParam)toolParam;
        ExtractSchemeDTO extractScheme = extractDataParam.getExtractScheme();
        Assert.notNull((Object)extractScheme, (String)"\u672a\u8bbe\u7f6e\u62bd\u53d6\u65b9\u6848\uff01");
        List layerList = extractScheme.getLayers();
        if (layerList == null || layerList.size() == 0) {
            throw new RuntimeException("\u65e0\u5f85\u63d0\u53d6\u56fe\u5c42\uff01");
        }
        layerList.forEach(layerItem -> {
            if (layerItem.getFieldsMapping() == null || layerItem.getFieldsMapping().size() == 0) {
                layerItem.setFieldsMapping(this.createDefaultSchemeField(layerItem.getDatasetId()));
            }
        });
        if (StringUtil.isNotEmpty((String)batchOutputData.getName())) {
            GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
            try (IFeatureWorkspace targetWorkspace = null;){
                targetWorkspace = geoDatabaseService.openGeoWorkspace(batchOutputData.getDsKey());
                if (!targetWorkspace.datasetExist(batchOutputData.getName())) {
                    ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
                    IFeatureDataset featureDataset = targetWorkspace.createFeatureDataset(batchOutputData.getName(), spatialReferenceSystem);
                    Assert.notNull((Object)featureDataset, (String)"\u8981\u7d20\u6570\u636e\u96c6\u521b\u5efa\u5931\u8d25\uff01");
                }
            }
        }
        layerList.forEach(layer -> {
            DataStripingResult taskItem = new DataStripingResult();
            taskItem.setName(layer.getSrcName());
            if (batchInputData.getFilePath() != null) {
                batchInputData.setName(layer.getSrcName());
                taskItem.setInputData(batchInputData);
            } else {
                DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)layer.getDatasetId());
                DataParam inputData = new DataParam();
                inputData.setDsKey(nameInfo.getDsKey());
                inputData.setName(nameInfo.getShortName());
                inputData.setFilePath(layer.getDatasetId());
                taskItem.setInputData(inputData);
            }
            taskItem.setOutputData(batchOutputData);
            taskItem.setToolExecuteParam((IToolParam)extractDataParam);
            taskItem.setPriority(50);
            oneDataCallback.accept(taskItem);
        });
    }

    private List<ExtractSchemeFieldDTO> createDefaultSchemeField(String datasetId) {
        ArrayList<ExtractSchemeFieldDTO> list = new ArrayList<ExtractSchemeFieldDTO>();
        DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
        DatasetDTO datasetDTO = dataSourceService.getDatasetDetail(datasetId);
        if (datasetDTO instanceof FeatureClassDTO) {
            List fields = ((FeatureClassDTO)datasetDTO).getFields();
            for (FieldDTO field : fields) {
                ExtractSchemeFieldDTO schemeFieldDTO = new ExtractSchemeFieldDTO();
                schemeFieldDTO.setSrcFieldName(field.getName());
                schemeFieldDTO.setTargetFieldName(field.getName());
                list.add(schemeFieldDTO);
            }
            return list;
        }
        throw new RuntimeException("\u6570\u636e\u96c6\u7684\u7c7b\u578b\u6709\u8bef\uff01");
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        DictionaryService dictionaryService = (DictionaryService)SpringContextUtil.getBean(DictionaryService.class);
        try (ToolFeatureWorkspaceDTO workspace = null;){
            ExtractDataParam extractDataParam = (ExtractDataParam)executeParam;
            ExtractSchemeLayerDTO schemeLayer = null;
            DatasetTypeEnum datasetTypeEnum = DatasetTypeEnum.FeatureClass;
            VectorReadWriteEnum vectorReadWriteEnum = null;
            if (inputDataParam.getDsKey() != null && !inputDataParam.getDsKey().isEmpty()) {
                String srcDatasetId = inputDataParam.getFilePath();
                DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)srcDatasetId);
                datasetTypeEnum = DatasetTypeEnum.getByValue((Integer)nameInfo.getType());
                schemeLayer = (ExtractSchemeLayerDTO)ListUtil.find((List)extractDataParam.getExtractScheme().getLayers(), f -> f.getDatasetId().equals(srcDatasetId));
                vectorReadWriteEnum = VectorReadWriteEnum.D2D;
            } else {
                vectorReadWriteEnum = VectorReadWriteEnum.F2F;
                schemeLayer = (ExtractSchemeLayerDTO)ListUtil.find((List)extractDataParam.getExtractScheme().getLayers(), f -> f.getSrcName().equals(inputDataParam.getName()));
            }
            workspace = ToolHelper.getWorkspace(inputDataParam, outputDataParam, vectorReadWriteEnum);
            IFeatureWorkspace inputWorkspace = workspace.getSourceWorkspace();
            IFeatureWorkspace outputWorkspace = workspace.getTargetWorkspace();
            IGeoDataset geoDataset = inputWorkspace.openGeoDataset(schemeLayer.getSrcName());
            LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>(0);
            HashMap<String, DmDictValueDTO> fieldsCodeMath = new HashMap<String, DmDictValueDTO>(0);
            LinkedHashMap<String, String> fieldsSQLMath = new LinkedHashMap<String, String>(0);
            IFields srcFields = ((ITable)geoDataset).getFields();
            for (IField field : srcFields) {
                ExtractSchemeFieldDTO schemeField = (ExtractSchemeFieldDTO)ListUtil.find((List)schemeLayer.getFieldsMapping(), f -> field.getName().equalsIgnoreCase(f.getSrcFieldName()));
                if (schemeField == null || StringUtil.isEmptyOrWhiteSpace((String)schemeField.getTargetFieldName())) continue;
                fieldMap.put(field.getName(), schemeField.getTargetFieldName());
                if (!StringUtil.isNotEmpty((String)schemeField.getMappingCode())) continue;
                if ("0".equals(schemeField.getMappingType())) {
                    DmDictValueDTO dmDictionary = null;
                    try {
                        dmDictionary = dictionaryService.getDictionaryTree(schemeField.getMappingCode());
                    }
                    catch (Exception e) {
                        this.invokeExcuteLog(schemeField.getMappingCode(), e);
                    }
                    if (dmDictionary == null || dmDictionary.getChildren() == null || dmDictionary.getChildren().size() <= 0) continue;
                    fieldsCodeMath.put(schemeField.getSrcFieldName(), dmDictionary);
                    continue;
                }
                if (!"1".equals(schemeField.getMappingType())) continue;
                fieldsSQLMath.put(field.getName(), schemeField.getMappingCode());
            }
            if (fieldMap.size() == 0) {
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog("\u672a\u627e\u5230\u63d0\u53d6\u5b57\u6bb5");
                Iterator iterator = executeResult;
                return iterator;
            }
            boolean datasetExist = outputWorkspace.datasetExist(schemeLayer.getTargetName());
            TransferResult transferResult = new TransferResult();
            switch (datasetTypeEnum) {
                case FeatureClass: {
                    String msg;
                    IFeatureClass targetFc;
                    IFeatureClass srcFc = (IFeatureClass)geoDataset;
                    if (datasetExist) {
                        targetFc = outputWorkspace.openFeatureClass(schemeLayer.getTargetName());
                        msg = "\u6253\u5f00";
                    } else {
                        targetFc = this.createFeatureClass(srcFc, outputWorkspace, schemeLayer.getTargetName(), null, srcFc.getOidFieldName(), srcFc.getShapeFieldName(), srcFc.getSpatialReferenceSystem(), outputDataParam.getName(), fieldMap);
                        msg = "\u521b\u5efa";
                    }
                    if (targetFc == null) {
                        executeResult.setSuccess(Boolean.valueOf(false));
                        this.invokeExcuteLog(String.format("\u76ee\u6807\u56fe\u5c42%s\u5931\u8d25", msg));
                        ExecuteResult executeResult2 = executeResult;
                        return executeResult2;
                    }
                    Boolean clip = extractDataParam.getClip() != null && extractDataParam.getClip() != false;
                    IQueryFilter filter = this.getFilter(srcFc, clip, extractDataParam.getRangeFile(), schemeLayer);
                    transferResult = this.extractFeatureClass(srcFc, targetFc, fieldsCodeMath, fieldsSQLMath, fieldMap, filter, clip);
                    break;
                }
                case Table: {
                    String msgTable;
                    ITable targetTable;
                    ITable srcTable = (ITable)geoDataset;
                    if (datasetExist) {
                        targetTable = outputWorkspace.openTable(schemeLayer.getTargetName());
                        msgTable = "\u6253\u5f00";
                    } else {
                        targetTable = this.createTable(srcTable, outputWorkspace, schemeLayer.getTargetName(), fieldMap);
                        msgTable = "\u521b\u5efa";
                    }
                    if (targetTable == null) {
                        executeResult.setSuccess(Boolean.valueOf(false));
                        this.invokeExcuteLog(String.format("\u76ee\u6807\u8868%s\u5931\u8d25", msgTable));
                        ExecuteResult executeResult3 = executeResult;
                        return executeResult3;
                    }
                    QueryFilter tableFilter = new QueryFilter();
                    tableFilter.setWhereClause(schemeLayer.getCondition());
                    transferResult = this.extractTable(srcTable, targetTable, fieldsCodeMath, fieldsSQLMath, fieldMap, (IQueryFilter)tableFilter);
                    break;
                }
            }
            executeResult.setSuccess(Boolean.valueOf(transferResult.getFailCount() == 0L && transferResult.getTotalCount() == transferResult.getSuccessCount()));
            executeResult.setOutDataParam(outputDataParam);
        }
        return executeResult;
    }

    protected IQueryFilter getFilter(IFeatureClass srcFc, Boolean clip, String rangeFile, ExtractSchemeLayerDTO schemeLayer) {
        if (StringUtil.isNotEmpty((String)rangeFile)) {
            IGeometry queryGeo = WorkspaceUtil.readLocalFileGeometry((String)rangeFile);
            if (queryGeo == null) {
                throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u9519\u8bef");
            }
            ISpatialReferenceSystem srcSpf = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
            if (srcSpf != null && (queryGeo = queryGeo.projectToCopy(srcSpf, srcFc.getSpatialReferenceSystem())) == null) {
                throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u6295\u5f71\u5931\u8d25");
            }
            SpatialQueryFilter filter = new SpatialQueryFilter();
            filter.setWhereClause(schemeLayer.getCondition() == null ? "" : schemeLayer.getCondition());
            filter.setGeometry(queryGeo);
            filter.setSpatialRel(SpatialRelationType.Intersects);
            filter.setGeometryField(srcFc.getShapeFieldName());
            if (Boolean.TRUE.equals(clip)) {
                filter.setSpatialRels(this.getSpatialRelationships(SpatialRelationType.Overlaps, queryGeo, srcFc.getFeatureType()));
            }
            return filter;
        }
        if (StringUtil.isNotEmpty((String)schemeLayer.getCondition())) {
            QueryFilter filter = new QueryFilter();
            filter.setWhereClause(schemeLayer.getCondition());
            return filter;
        }
        return null;
    }

    private IFeatureClass createFeatureClass(IFeatureClass srcFeatClass, IFeatureWorkspace tarWorkspace, String tarFCName, IFields pExFields, String oidFieldName, String shapeFieldName, ISpatialReferenceSystem tarSR, String parentDatasetName, Map<String, String> fieldMap) {
        int i;
        if (tarFCName.trim().length() == 0) {
            return null;
        }
        Fields newFields = new Fields();
        for (i = 0; i < srcFeatClass.getFields().getFieldCount(); ++i) {
            IField tempField = srcFeatClass.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.Shape) {
                if (fieldMap != null && fieldMap.containsKey(tempField.getName())) {
                    tempField.setName(fieldMap.get(tempField.getName()));
                } else {
                    tempField.setName(shapeFieldName);
                }
                ((GeometryField)tempField).setSpatialReferenceSystem(tarSR);
                ((GeometryField)tempField).setCoordinateType(CoordinateType.XY);
                newFields.addField(tempField);
                continue;
            }
            if (tempField.getFieldType() == FieldType.OID) {
                if (fieldMap != null && fieldMap.containsKey(tempField.getName())) {
                    tempField.setName(fieldMap.get(tempField.getName()));
                } else {
                    tempField.setName(oidFieldName);
                }
                newFields.addField(tempField);
                continue;
            }
            if (fieldMap != null) {
                if (!fieldMap.containsKey(tempField.getName())) continue;
                tempField.setName(fieldMap.get(tempField.getName()));
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        if (pExFields != null) {
            for (i = 0; i < pExFields.getFieldCount(); ++i) {
                if (pExFields.getField(i).getFieldType() == FieldType.OID || newFields.findFieldIndex(pExFields.getField(i).getName()) >= 0) continue;
                newFields.addField(pExFields.getField(i));
            }
        }
        IFeatureClass iFeatClass = null;
        if (parentDatasetName != null && parentDatasetName.length() > 0) {
            IFeatureDataset parentDataset = tarWorkspace.openFeatureDataset(parentDatasetName);
            if (parentDataset != null) {
                iFeatClass = parentDataset.createFeatureClass(tarFCName, (IFields)newFields, srcFeatClass.getFeatureType(), shapeFieldName, srcFeatClass.getSubTypeFieldName());
            }
        } else {
            iFeatClass = tarWorkspace.createFeatureClass(tarFCName, (IFields)newFields, srcFeatClass.getFeatureType(), shapeFieldName, srcFeatClass.getSubTypeFieldName());
        }
        if (iFeatClass != null) {
            iFeatClass.createSpatialIndex();
        }
        return iFeatClass;
    }

    private ITable createTable(ITable srcTable, IFeatureWorkspace tarWorkspace, String tarTableName, Map<String, String> fieldMap) {
        if (tarTableName.trim().length() == 0) {
            return null;
        }
        Fields newFields = new Fields();
        for (int i = 0; i < srcTable.getFields().getFieldCount(); ++i) {
            IField tempField = srcTable.getFields().getField(i).clone();
            if (fieldMap != null) {
                if (!fieldMap.containsKey(tempField.getName())) continue;
                tempField.setName(fieldMap.get(tempField.getName()));
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        return tarWorkspace.createTable(tarTableName, (IFields)newFields);
    }

    public TransferResult extractFeatureClass(IFeatureClass sourceFeatureClass, IFeatureClass targetFeatureClass, Map<String, DmDictValueDTO> fieldsCoedMath, Map<String, String> fieldsSQLMath, Map<String, String> fieldMap, IQueryFilter filter, Boolean clip) {
        Date startTime = new Date();
        VectorDataTransfer2 vectorDataTransfer = new VectorDataTransfer2();
        vectorDataTransfer.setFieldMap(fieldMap);
        vectorDataTransfer.setClip(clip);
        RefObject errorMsg = new RefObject();
        vectorDataTransfer.setErrorCallback(msg -> {
            this.log.error(msg);
            this.invokeExcuteLog((String)msg);
            errorMsg.set(msg);
        });
        vectorDataTransfer.setCancelCallback(() -> ((ExtractDataTool)this).isAborted());
        if (fieldsCoedMath.size() > 0 || fieldsSQLMath.size() > 0) {
            vectorDataTransfer.setPropertyValueSettingCallback((srcRow, tarRow) -> this.setValueByFieldCodeMap(fieldsCoedMath, fieldsSQLMath, fieldMap, (IRow)srcRow, (IRow)tarRow));
        }
        String otherQuery = this.getOtherQuery(fieldsSQLMath);
        RefObject extent = new RefObject();
        TransferResult result = vectorDataTransfer.copyFeature(sourceFeatureClass, targetFeatureClass, filter, otherQuery, (RefObject<IEnvelope>)extent);
        if (StringUtil.isNotEmpty((String)((String)errorMsg.get())) && StringUtil.isEmptyOrWhiteSpace((String)result.getErrorMessage())) {
            result.setErrorMessage((String)errorMsg.get());
        }
        targetFeatureClass.updateExtent();
        Date endTime = new Date();
        String text = DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)endTime);
        this.invokeExcuteLog(String.format("%s\u5165\u5e93[%s]%s\uff1a\u5171%s\u4e2a\uff0c\u6210\u529f%s\u4e2a\uff0c\u5931\u8d25%s\u4e2a\u3002\u603b\u8017\u65f6:%s", sourceFeatureClass.getName(), targetFeatureClass.getName(), result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", result.getTotalCount(), result.getSuccessCount(), result.getFailCount(), text));
        return result;
    }

    private String getOtherQuery(Map<String, String> fieldsSQLMath) {
        String otherQuery = "";
        if (fieldsSQLMath.size() > 0) {
            for (String key : fieldsSQLMath.keySet()) {
                otherQuery = otherQuery + "," + fieldsSQLMath.get(key) + " as \"__" + key + "\"";
            }
        }
        return otherQuery;
    }

    public TransferResult extractTable(ITable sourceTable, ITable targetTable, Map<String, DmDictValueDTO> fieldsCoedMath, Map<String, String> fieldsSQLMath, Map<String, String> fieldMap, IQueryFilter tableFilter) {
        Date startTime = new Date();
        VectorDataTransfer2 vectorDataTransfer = new VectorDataTransfer2();
        vectorDataTransfer.setFieldMap(fieldMap);
        RefObject errorMsg = new RefObject();
        vectorDataTransfer.setErrorCallback(msg -> {
            this.log.error(msg);
            this.invokeExcuteLog((String)msg);
            errorMsg.set(msg);
        });
        vectorDataTransfer.setCancelCallback(() -> ((ExtractDataTool)this).isAborted());
        if (fieldsCoedMath.size() > 0 || fieldsSQLMath.size() > 0) {
            vectorDataTransfer.setPropertyValueSettingCallback((srcRow, tarRow) -> this.setValueByFieldCodeMap(fieldsCoedMath, fieldsSQLMath, fieldMap, (IRow)srcRow, (IRow)tarRow));
        }
        String otherQuery = this.getOtherQuery(fieldsSQLMath);
        TransferResult result = vectorDataTransfer.copyTable(sourceTable, targetTable, tableFilter, otherQuery);
        if (StringUtil.isNotEmpty((String)((String)errorMsg.get())) && StringUtil.isEmptyOrWhiteSpace((String)result.getErrorMessage())) {
            result.setErrorMessage((String)errorMsg.get());
        }
        Date endTime = new Date();
        String text = DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)endTime);
        this.invokeExcuteLog(String.format("%s\u5165\u5e93[%s]%s\uff1a\u5171%s\u4e2a\uff0c\u6210\u529f%s\u4e2a\uff0c\u5931\u8d25%s\u4e2a\u3002\u603b\u8017\u65f6:%s", sourceTable.getName(), targetTable.getName(), result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", result.getTotalCount(), result.getSuccessCount(), result.getFailCount(), text));
        return result;
    }

    public void setValueByFieldCodeMap(Map<String, DmDictValueDTO> fieldsCodeMath, Map<String, String> fieldsSQLMath, Map<String, String> fieldMap, IRow srcRow, IRow tarRow) {
        String targetFieldName;
        for (String srcFieldName : fieldsSQLMath.keySet()) {
            targetFieldName = fieldMap.get(srcFieldName);
            int tarIndex = tarRow.getFields().findFieldIndex(targetFieldName);
            if (tarIndex <= -1) continue;
            tarRow.setValue(tarIndex, srcRow.getValue("__" + srcFieldName));
        }
        for (String srcFieldName : fieldsCodeMath.keySet()) {
            DmDictValueDTO mapping;
            Object srcValue;
            if (!fieldMap.containsKey(srcFieldName)) continue;
            targetFieldName = fieldMap.get(srcFieldName);
            int srcIndex = srcRow.getFields().findFieldIndex(srcFieldName);
            int tarIndex = tarRow.getFields().findFieldIndex(targetFieldName);
            if (srcIndex <= -1 || tarIndex <= -1 || (srcValue = srcRow.getValue(srcIndex)) == null || (mapping = (DmDictValueDTO)ListUtil.find((List)fieldsCodeMath.get(srcFieldName).getChildren(), f -> f.getCode().equals(srcValue.toString()))) == null) continue;
            tarRow.setValue(tarIndex, (Object)mapping.getName());
        }
    }

    public SpatialRelationType[] getSpatialRelationships(SpatialRelationType querySpatialRel, IGeometry queryGeometry, FeatureType targetFeatureType) {
        if (queryGeometry == null) {
            return null;
        }
        if (querySpatialRel == SpatialRelationType.Overlaps) {
            SpatialRelationType[] spatialRelationTypeArray;
            if (targetFeatureType == FeatureType.Polygon && FeatureType.getByGeometryType((GeometryType)queryGeometry.getType()) == FeatureType.Polygon) {
                SpatialRelationType[] spatialRelationTypeArray2 = new SpatialRelationType[4];
                spatialRelationTypeArray2[0] = SpatialRelationType.Overlaps;
                spatialRelationTypeArray2[1] = SpatialRelationType.Contains;
                spatialRelationTypeArray2[2] = SpatialRelationType.Within;
                spatialRelationTypeArray = spatialRelationTypeArray2;
                spatialRelationTypeArray2[3] = SpatialRelationType.Equals;
            } else {
                SpatialRelationType[] spatialRelationTypeArray3 = new SpatialRelationType[1];
                spatialRelationTypeArray = spatialRelationTypeArray3;
                spatialRelationTypeArray3[0] = SpatialRelationType.Intersects;
            }
            return spatialRelationTypeArray;
        }
        return new SpatialRelationType[]{querySpatialRel};
    }
}

