/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.vector;

import cn.hutool.core.lang.func.Supplier4;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.vector.ZmValueHandleParam;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public class ZmValueHandleTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        ZmValueHandleParam param = (ZmValueHandleParam)toolParam;
        boolean overwrite = !param.isRemoveM() && !param.isRemoveZ();
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(batchInputData, batchOutputData, overwrite);
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, param, vectorReadWriteEnum);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ZmValueHandleParam param = (ZmValueHandleParam)toolParam;
        boolean overwrite = !param.isRemoveM() && !param.isRemoveZ();
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, overwrite);
        return ToolHelper.buildExecuteParam(inputData, outputData, param, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            ZmValueHandleParam param = (ZmValueHandleParam)executeParam;
            boolean overwrite = !param.isRemoveM() && !param.isRemoveZ();
            VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, overwrite);
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, vectorReadWriteEnum);
            switch (vectorReadWriteEnum) {
                case F: 
                case D: {
                    ToolHelper.handleFeatureClass(inputData.getName(), param, workspaceDTO.getSourceWorkspace(), (p, f) -> this.handleZm((ZmValueHandleParam)p, (IFeatureClass)f));
                    break;
                }
                case D2F: 
                case F2D: 
                case F2F: 
                case D2D: {
                    ToolHelper.handleAndSaveFeatureClass(inputData.getName(), outputData.getName(), param, workspaceDTO.getSourceWorkspace(), workspaceDTO.getTargetWorkspace(), (Supplier4<Boolean, IFeatureClass, FeatureClassMeta, IToolParam, String>)((Supplier4)(f, m, p, n) -> this.handleZm((IFeatureClass)f, (FeatureClassMeta)m, (ZmValueHandleParam)p, (String)n)));
                    break;
                }
                default: {
                    throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
                }
            }
            executeResult.setSuccess(Boolean.valueOf(true));
            executeResult.setOutDataParam(outputData);
        }
        return executeResult;
    }

    private void handleZm(ZmValueHandleParam p, IFeatureClass featureClass) {
        CoordinateType coordinateType = featureClass.getCoordinateType();
        this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + " coordinateType \u4e3a" + coordinateType);
    }

    private Boolean handleZm(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, ZmValueHandleParam param, String outputName) {
        try {
            this.invokeExcuteLog("\u539f coordinateType \u4e3a" + srcFeatureClass.getCoordinateType());
            VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
            vectorDataTransfer.setCancelCallback(() -> ((ZmValueHandleTool)this).isAborted());
            CoordinateType coordinateType = param.isRemoveZ() ? (param.isRemoveM() ? CoordinateType.XY : CoordinateType.M) : (param.isRemoveM() ? CoordinateType.Z : CoordinateType.ZM);
            featureClassMeta.setCoordinateType(coordinateType);
            IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, outputName);
            TransferResult transferResult = vectorDataTransfer.copyFeature(srcFeatureClass, targetFeatureClass, null);
            Assert.state((boolean)transferResult.isSuccess(), (String)transferResult.getErrorMessage());
            return true;
        }
        catch (Exception e) {
            this.invokeExcuteLog("ZM\u503c\u5904\u7406\u8f6c\u6362\u5931\u8d25", e);
            return false;
        }
    }
}

