/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.spatialization;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.frame.util.VectorFileUtil;
import com.geoway.dgt.frame.util.VectorPathUtil;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.spatialization.RegionSpatializationParam;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.springframework.util.Assert;

public class RegionSpatializationTool
extends ToolBase {
    private static final String shapeFieldName = "shape";

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        RegionSpatializationTool.checkInput(batchInputData, true);
        String inputFileMainName = FileUtil.mainName((File)new File(batchInputData.getFilePath()));
        RegionSpatializationTool.checkOutput(batchOutputData, (RegionSpatializationParam)toolParam, inputFileMainName);
        ToolHelper.callbackOne(batchInputData, batchOutputData, toolParam, oneDataCallback);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        RegionSpatializationTool.checkInput(inputData, false);
        String inputFileMainName = FileUtil.mainName((File)new File(inputData.getFilePath()));
        RegionSpatializationTool.checkOutput(outputData, (RegionSpatializationParam)toolParam, inputFileMainName);
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        executeResult.setOutDataParam(outputData);
        try {
            this.csvOrXls2File(inputData, outputData, (RegionSpatializationParam)toolParam, executeResult);
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog("\u6570\u636e\u7a7a\u95f4\u5316\u5931\u8d25", e);
        }
        return executeResult;
    }

    private static void checkInput(DataParam batchInputData, boolean mustExist) {
        File inputFile = new File(batchInputData.getFilePath());
        if (mustExist) {
            Assert.state((boolean)FileUtil.isFile((File)inputFile), (String)"\u8f93\u5165\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String suffix = FileUtil.getSuffix((File)inputFile);
        Assert.state((boolean)StrUtil.equalsAnyIgnoreCase((CharSequence)suffix, (CharSequence[])new CharSequence[]{"csv", "xls", "xlsx"}), (String)("\u4e0d\u652f\u6301\u7684\u6570\u636e\u683c\u5f0f : " + suffix));
    }

    private static void checkOutput(DataParam batchOutputData, RegionSpatializationParam param, String inputFileMainName) {
        File outFile = new File(batchOutputData.getFilePath());
        if (!VectorFileUtil.exactlyMatchAny((File)outFile)) {
            if (outFile.exists()) {
                Assert.state((boolean)FileUtil.isDirectory((File)outFile), (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u6709\u8bef");
            }
            String outputFilePath = VectorPathUtil.getOutputFilePath((String)inputFileMainName, (String)batchOutputData.getFilePath(), (VectorFormatEnum)param.getTargetFormat());
            batchOutputData.setFilePath(outputFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void csvOrXls2File(DataParam inputData, DataParam outputData, RegionSpatializationParam toolParam, ExecuteResult executeResult) {
        DistrictService districtService = (DistrictService)SpringContextUtil.getBean(DistrictService.class);
        List districtItems = districtService.getDistrictItem(toolParam.getLocationSolution(), null, null, null, Boolean.valueOf(true), null);
        String matchField = toolParam.getMatchField();
        Boolean matchStrategy = toolParam.getMatchStrategy();
        ToolFeatureWorkspaceDTO workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, VectorReadWriteEnum.F2F);
        IFeatureWorkspace sourceWorkspace = workspaceDTO.getSourceWorkspace();
        IFeatureWorkspace targetWorkspace = workspaceDTO.getTargetWorkspace();
        int totalCount = 0;
        int successCount = 0;
        int failCount = 0;
        boolean success = true;
        Map<String, Long> allDistrictItems = this.readAllDictItem(districtItems, matchStrategy);
        try {
            List datasets = sourceWorkspace.getDatasets();
            for (IGeoDataset dataset : datasets) {
                GeoDatasetType geoDatasetType;
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                if (StrUtil.isNotEmpty((CharSequence)inputData.getName()) && !StrUtil.equals((CharSequence)dataset.getName(), (CharSequence)inputData.getName()) || (geoDatasetType = dataset.getType()) != GeoDatasetType.Table) continue;
                ITable table = (ITable)dataset;
                String datasetName = dataset.getName();
                if (datasetName == null) {
                    datasetName = FileUtil.mainName((String)inputData.getFilePath());
                }
                ++totalCount;
                int tCount = 0;
                int sCount = 0;
                int fCount = 0;
                ICursor searchCursor = null;
                IFeatureCursor featureCursor = null;
                this.invokeExcuteLog(datasetName + "\u5f00\u59cb\u7a7a\u95f4\u5316...");
                try {
                    IFeatureClass featureClass = this.createFeatureClass(datasetName, table, targetWorkspace, toolParam);
                    searchCursor = table.searchRow(null);
                    featureCursor = featureClass.batchInsertFeature();
                    IRow row = searchCursor.nextRow();
                    while (row != null) {
                        if (this.isAborted()) {
                            throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                        }
                        ++tCount;
                        IFeature newFeature = featureClass.createFeature();
                        for (int i = 0; i < row.getFields().getFieldCount(); ++i) {
                            Long districtItemId;
                            String fieldName = row.getFields().getField(i).getName();
                            int srcIndex = table.getFields().findFieldIndex(fieldName);
                            if (srcIndex < 0) continue;
                            Object value = row.getValue(srcIndex);
                            newFeature.setValue(fieldName, value);
                            if (!fieldName.equalsIgnoreCase(matchField) || null == value || null == (districtItemId = allDistrictItems.get(value.toString()))) continue;
                            IGeometry districtItemGeometry = districtService.getDistrictItemGeometry(districtItemId);
                            newFeature.setGeometry(districtItemGeometry);
                        }
                        if (newFeature.getGeometry() == null) {
                            ++fCount;
                        } else {
                            featureCursor.insertFeature(newFeature);
                            ++sCount;
                        }
                        row = searchCursor.nextRow();
                    }
                    this.invokeExcuteLog(datasetName + "\u7a7a\u95f4\u5316\u5b8c\u6210\uff01" + String.format("\u5171%d\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", tCount, sCount, fCount));
                    if (fCount > 0) {
                        ++failCount;
                        continue;
                    }
                    ++successCount;
                }
                catch (Exception e) {
                    this.invokeExcuteLog(datasetName + "\u7a7a\u95f4\u5316\u5931\u8d25\uff01" + e.getMessage(), e);
                    ++failCount;
                    success = false;
                }
                finally {
                    if (searchCursor != null) {
                        searchCursor.release();
                    }
                    if (featureCursor == null) continue;
                    featureCursor.release();
                }
            }
            executeResult.setSuccess(Boolean.valueOf(success));
            this.invokeExcuteLog(String.format("\u5171%d\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", totalCount, successCount, failCount));
            executeResult.setOutDataParam(outputData);
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog(String.format("\u5171%d\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", totalCount, successCount, failCount));
        }
        finally {
            workspaceDTO.close();
        }
    }

    private IFeatureClass createFeatureClass(String datasetName, ITable table, IFeatureWorkspace targetWorkspace, RegionSpatializationParam toolParam) {
        Fields newFields = new Fields();
        IntStream.range(0, table.getFields().getFieldCount()).mapToObj(i -> table.getFields().getField(i).clone()).forEach(arg_0 -> ((IFields)newFields).addField(arg_0));
        newFields.addField((IField)RegionSpatializationTool.buildGeometryField(toolParam));
        return targetWorkspace.createFeatureClass(datasetName, (IFields)newFields, FeatureType.Polygon, shapeFieldName, null);
    }

    private static GeometryField buildGeometryField(RegionSpatializationParam toolParam) {
        GeometryField geometryField = new GeometryField();
        geometryField.setName(shapeFieldName);
        geometryField.setCoordinateType(CoordinateType.XY);
        geometryField.setGeometryType(GeometryType.Polygon);
        ISpatialReferenceSystem srs = StrUtil.isNotEmpty((CharSequence)toolParam.getStrWKT()) ? SpatialReferenceSystemFunc.createSpatialReference((String)toolParam.getStrWKT()) : SpatialReferenceSystemFunc.createSpatialReference((int)toolParam.getSrid());
        geometryField.setSpatialReferenceSystem(srs);
        geometryField.setFieldType(FieldType.Shape);
        return geometryField;
    }

    private Map<String, Long> readAllDictItem(List<DistrictItemDTO> districtItems, boolean matchStrategy) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (DistrictItemDTO item : districtItems) {
            if (item.getChildren() != null && item.getChildren().size() > 0) {
                result.putAll(this.readAllDictItem(item.getChildren(), matchStrategy));
            }
            if (matchStrategy) {
                result.put(item.getCode(), item.getId());
                continue;
            }
            result.put(item.getName(), item.getId());
        }
        return result;
    }
}

