/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.attribute;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.frame.util.VectorFileUtil;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.attribute.RangeCheckParam;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public class RangeCheckTool
extends ToolBase {
    private boolean hasCheckError = false;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        RangeCheckParam param = (RangeCheckParam)toolParam;
        if (param.isBatch() && StrUtil.isEmpty((CharSequence)batchInputData.getDsKey())) {
            ToolHelper.callbackDir(batchInputData, batchOutputData, oneDataCallback, param, param.getVectorFormats());
        } else {
            Assert.state((boolean)VectorFileUtil.exactlyMatchAny((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef");
            ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, true);
        return ToolHelper.buildExecuteParam(inputData, outputData, toolParam, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            RangeCheckParam param = (RangeCheckParam)toolParam;
            this.invokeExcuteLog("\u6837\u4f8b\u6570\u636e\uff1a" + param.getSamplePath());
            VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, true);
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, vectorReadWriteEnum);
            IFeatureWorkspace sourceWorkspace = workspaceDTO.getSourceWorkspace();
            String layers = param.getLayers();
            JSONObject layersObj = JSONUtil.parseObj((String)param.getLayers());
            this.invokeExcuteLog("\u6570\u91cf\uff1a" + layersObj.size());
            for (String layer : layersObj.keySet()) {
                JSONObject fieldsDict = layersObj.getJSONObject((Object)layer);
                ITable table = sourceWorkspace.openTable(layer);
                if (table != null) {
                    this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + layer);
                    this.rangeCheck(param, table, fieldsDict);
                    continue;
                }
                this.invokeExcuteLog(sourceWorkspace.getConnectionString() + " \u65e0\u9009\u5b9a\u56fe\u5c42 : " + layer, TaskLogLevelEnum.Error);
            }
            executeResult.setSuccess(Boolean.valueOf(!this.hasCheckError));
            executeResult.setOutDataParam(outputData);
            ToolHelper.copyWhenFlowLast(inputData, outputData);
        }
        return executeResult;
    }

    private void rangeCheck(RangeCheckParam rangeCheckParam, ITable table, JSONObject fieldsDict) {
        HashMap fieldsDictValueMap = new HashMap();
        for (Map.Entry entry : fieldsDict.entrySet()) {
            fieldsDictValueMap.put(entry.getKey(), ToolHelper.codes(String.valueOf(entry.getValue())));
        }
        ICursor rowCursor = null;
        boolean invalid = false;
        try {
            rowCursor = table.searchRow(null);
            IRow row = rowCursor.nextRow();
            while (row != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IFields iFields = row.getFields();
                for (String fieldName : fieldsDictValueMap.keySet()) {
                    String value;
                    List dictValues = (List)fieldsDictValueMap.get(fieldName);
                    if (dictValues.isEmpty()) {
                        this.invokeExcuteLog("\u503c\u57df : [" + fieldsDict.get((Object)fieldName) + "] \u4e3a\u7a7a, \u7565\u8fc7", TaskLogLevelEnum.Warning);
                        continue;
                    }
                    IField field = iFields.findField(fieldName);
                    if (field == null) {
                        this.invokeExcuteLog("\u56fe\u5c42 " + table.getName() + " \u65e0\u9009\u5b9a\u5b57\u6bb5 : " + fieldName, TaskLogLevelEnum.Warning);
                        continue;
                    }
                    if (field.getFieldType() == FieldType.OID || field.getFieldType() == FieldType.Shape || field.getFieldType() == FieldType.Blob || dictValues.contains(value = String.valueOf(row.getValue(field.getName())))) continue;
                    invalid = true;
                    this.hasCheckError = true;
                    this.invokeExcuteLog("\u53d1\u73b0\u975e\u6cd5\u503c\u57df " + value + ", \u8bb0\u5f55 : " + table.getName() + ", \u5b57\u6bb5 : " + field.getName() + ", oid : " + row.getObjectId().toString(), TaskLogLevelEnum.Warning);
                }
                row = rowCursor.nextRow();
            }
            if (!invalid) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + table.getName() + " \u503c\u57df\u68c0\u67e5\u901a\u8fc7!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (rowCursor != null) {
                rowCursor.release();
            }
        }
    }
}

