/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.vector;

import cn.hutool.core.lang.func.Supplier4;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.vector.EmptyGeometryParam;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.util.function.Consumer;

public class EmptyGeometryTool
extends ToolBase {
    private boolean hasCheckError = false;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        EmptyGeometryParam param = (EmptyGeometryParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(batchInputData, batchOutputData, !param.isDeleteEmptyGeometry());
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, param, vectorReadWriteEnum);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        EmptyGeometryParam param = (EmptyGeometryParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isDeleteEmptyGeometry());
        return ToolHelper.buildExecuteParam(inputData, outputData, param, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            EmptyGeometryParam param = (EmptyGeometryParam)executeParam;
            VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isDeleteEmptyGeometry());
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, vectorReadWriteEnum);
            switch (vectorReadWriteEnum) {
                case D: 
                case F: {
                    ToolHelper.handleFeatureClass(inputData.getName(), param, workspaceDTO.getSourceWorkspace(), (p, f) -> this.checkFeatureClass((EmptyGeometryParam)p, (IFeatureClass)f));
                    ToolHelper.copyWhenFlowLast(inputData, outputData);
                    break;
                }
                case D2F: 
                case F2D: 
                case F2F: 
                case D2D: {
                    ToolHelper.handleAndSaveFeatureClass(inputData.getName(), outputData.getName(), param, workspaceDTO.getSourceWorkspace(), workspaceDTO.getTargetWorkspace(), (Supplier4<Boolean, IFeatureClass, FeatureClassMeta, IToolParam, String>)((Supplier4)(f, m, p, n) -> this.cleanAndCopyFeature((IFeatureClass)f, (FeatureClassMeta)m, (EmptyGeometryParam)p, (String)n)));
                    break;
                }
                default: {
                    throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
                }
            }
            executeResult.setSuccess(Boolean.valueOf(!this.hasCheckError));
            executeResult.setOutDataParam(outputData);
        }
        return executeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanAndCopyFeature(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, EmptyGeometryParam param, String outputName) {
        IFeatureWorkspace targetWorkspace = featureClassMeta.getWorkspace();
        IFeatureCursor insertCursor = null;
        IFeatureCursor searchCursor = null;
        try {
            IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, outputName);
            targetWorkspace.beginTransaction();
            insertCursor = targetFeatureClass.batchInsertFeature();
            searchCursor = srcFeatureClass.searchFeature(null);
            this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + srcFeatureClass.getName());
            IFeature feature = searchCursor.nextFeature();
            boolean hasEmpty = false;
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IGeometry geometry = feature.getGeometry();
                if (geometry == null || geometry.isEmpty()) {
                    hasEmpty = true;
                    if (param.isDeleteEmptyGeometry()) {
                        feature = searchCursor.nextFeature();
                        continue;
                    }
                    this.invokeExcuteLog("\u53d1\u73b0\u7a7a\u51e0\u4f55 , \u56fe\u5c42 : " + srcFeatureClass.getName() + ", oid : " + feature.getObjectId(), TaskLogLevelEnum.Warning);
                }
                IFeature newFeature = targetFeatureClass.createFeature();
                for (IField field : newFeature.getFields()) {
                    newFeature.setValue(field.getName(), feature.getValue(field.getName()));
                }
                newFeature.setGeometry(geometry);
                insertCursor.insertFeature(newFeature);
                feature = searchCursor.nextFeature();
            }
            if (!hasEmpty) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + srcFeatureClass.getName() + " \u65e0\u7a7a\u51e0\u4f55");
            }
            targetWorkspace.commitTransaction();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.invokeExcuteLog("\u62f7\u8d1d\u8981\u7d20\u5931\u8d25", e);
            targetWorkspace.rollbackTransaction();
            boolean bl = false;
            return bl;
        }
        finally {
            if (searchCursor != null) {
                searchCursor.release();
            }
            if (insertCursor != null) {
                insertCursor.release();
            }
        }
    }

    private void checkFeatureClass(EmptyGeometryParam param, IFeatureClass featureClass) {
        IFeatureCursor featureCursor = null;
        try {
            featureCursor = featureClass.searchFeature(null);
            IFeature feature = featureCursor.nextFeature();
            this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + featureClass.getName());
            boolean hasEmpty = false;
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IGeometry geometry = feature.getGeometry();
                if (geometry == null || geometry.isEmpty()) {
                    hasEmpty = true;
                    this.hasCheckError = true;
                    this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + " \u5b58\u5728\u8981\u7d20\u51e0\u4f55\u5b57\u6bb5\u4e3a\u7a7a, oid \u4e3a " + feature.getObjectId(), TaskLogLevelEnum.Warning);
                }
                feature = featureCursor.nextFeature();
            }
            if (!hasEmpty) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + featureClass.getName() + " \u65e0\u7a7a\u51e0\u4f55");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (featureCursor != null) {
                featureCursor.release();
            }
        }
    }
}

