/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify;

import com.geoway.dgt.geodata.annosimplify.config.AnnoVectorTileServer;
import com.geoway.dgt.geodata.annosimplify.exception.ParaException;
import com.geoway.dgt.geodata.annosimplify.grid.AnnoGrid;
import com.geoway.dgt.geodata.annosimplify.grid.extent.impl.GridExtentImpl;
import com.geoway.dgt.geodata.annosimplify.vectortile.tilecutter.scroll.Scroll;
import com.geoway.dgt.geodata.annosimplify.vectortile.tilecutter.scroll.impl.ExtentScroll;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnoParas {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public int beginLevel = 0;
    public int endLevel = 22;
    public int gridSize = 512;
    @Deprecated
    public String simplifyBox = "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
    @Deprecated
    public String[] simplifyBoxArr;
    public String mapUnit = "degrees";
    public String table;
    public double left = -180.0;
    public double bottom = -90.0;
    public double top = 180.0;
    public double right = 90.0;
    public String fields;
    public String idField;
    public String geoField;
    public String srid;
    public String outputFieldNames;
    public String sorted;
    public String newDsKey;
    public String newTableName;
    public String newFields;
    public String newIdField;
    public String newShapeField;
    public String newAnnoFild;
    public String newSort;
    public String newSrid;
    public String newBox;
    @Deprecated
    public String gridAtomMaxPoint = "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
    @Deprecated
    public String[] gridAtomMaxPointArr;
    public String annoFild;
    public String orderFild;
    public String order;
    public int thread = 2;
    public double[] expectation;
    public AnnoVectorTileServer avServer;
    public String updateSqlBase;
    public String updateMinSqlBase;
    public String getMathExpectationSql;
    public String getPointFromBoxSql;
    public Scroll scroll;
    public final AtomicLong nFinished = new AtomicLong(0L);
    public final AtomicLong per = new AtomicLong(0L);
    public final AtomicLong nDistribute = new AtomicLong(0L);
    public long needToProcessCount;
    public String uuid;
    public int status;
    private Boolean simplify = false;
    private Boolean statistics = false;

    public AnnoParas() {
    }

    public AnnoParas(List serverArr) {
        if (serverArr.size() <= 0) {
            throw new ParaException();
        }
        this.avServer = (AnnoVectorTileServer)serverArr.get(0);
        this.initParas();
    }

    public void initParas() {
        String[] bbox = this.avServer.getBbox().split(",");
        this.setBeginLevel(this.avServer.getLayerMap().get("annoLayer").getBeginLevel()).setEndLevel(this.avServer.getLayerMap().get("annoLayer").getEndLevel()).setGridSize(this.avServer.getGridBase().equals("base256") ? 256 : 512).setMapUnit(this.avServer.getGridUnit()).setTable(this.avServer.newTableName).setFields(this.avServer.newFields).setGeoField(this.avServer.newShapeField).setIdField(this.avServer.newIdField).setAnnoFild(this.avServer.newAnnoFild).setOrderFild(this.avServer.newSort).setSimplify(this.avServer.getSimplify()).setStatistics(this.avServer.getStatistics());
        if (!this.avServer.newSort.isEmpty()) {
            this.setOrder(this.avServer.newSort + " desc nulls last");
        } else {
            this.setOrder("");
        }
        if (bbox.length == 4) {
            this.setLeft(Double.valueOf(bbox[0])).setBottom(Double.valueOf(bbox[1])).setRight(Double.valueOf(bbox[2])).setTop(Double.valueOf(bbox[3]));
        }
        this.newDsKey = this.avServer.getNewDsKey();
        this.newTableName = this.avServer.getNewTableName();
        this.newFields = this.avServer.newFields;
        this.newIdField = this.avServer.newIdField;
        this.newShapeField = this.avServer.newShapeField;
        this.newAnnoFild = this.avServer.newAnnoFild;
        this.newSort = this.avServer.newSort;
        this.newSrid = this.avServer.newSrid;
        this.newBox = this.avServer.newBox;
        this.updateSqlBase = "UPDATE  " + this.table + " SET  " + this.annoFild + " = ?  where " + this.idField + " in (?) and  " + this.annoFild + " is null";
        this.updateMinSqlBase = "UPDATE  " + this.table + " SET  " + this.annoFild + " = ?  where " + this.annoFild + "  is null ";
        this.getMathExpectationSql = "select count(" + this.idField + ") count from " + this.table + " where  " + this.annoFild + " = ?";
        this.srid = String.valueOf(this.avServer.newSrid);
        this.outputFieldNames = this.avServer.newFields;
        this.sorted = !this.avServer.newSort.isEmpty() ? String.format(" order by  %s desc nulls last ", this.avServer.newSort) : "";
        this.getPointFromBoxSql = String.format("SELECT %s FROM %s WHERE ST_Within(%s, ST_GeomFromText('%s',%s)) %s %s", this.fields.replace(this.geoField, String.format("st_astext( %s ) as %s", this.geoField, this.geoField.toLowerCase())).replace(this.idField, String.format(" %s as %s ", this.idField, this.idField.toLowerCase())), this.newTableName, this.geoField, "%s", this.srid, "%s", this.sorted);
        this.expectation = new double[22];
    }

    public void setScorll(int level) {
        AnnoGrid grid = new AnnoGrid(this.gridSize, 1, this.mapUnit);
        int x = (int)Math.floor(Double.valueOf(this.left - -180.0) / (grid.getResolution(level) * (double)this.gridSize));
        int y = (int)Math.floor(Double.valueOf(90.0 - this.top) / (grid.getResolution(level) * (double)this.gridSize));
        GridExtentImpl extent = new GridExtentImpl(this.left, this.bottom, this.right, this.top, level, grid, x, y);
        this.scroll = new ExtentScroll(level, extent.getBBOX(), extent.getGrid());
    }

    public AnnoParas setOrderFild(String orderFild) {
        this.orderFild = orderFild;
        return this;
    }

    public AnnoParas setThread(int thread) {
        this.thread = thread;
        return this;
    }

    public AnnoParas setOrder(String order) {
        this.order = order;
        return this;
    }

    public AnnoParas setAnnoFild(String annoFild) {
        this.annoFild = annoFild;
        return this;
    }

    public AnnoParas setFields(String fields) {
        this.fields = fields;
        return this;
    }

    public AnnoParas setIdField(String idField) {
        this.idField = idField;
        return this;
    }

    public AnnoParas setGeoField(String geoField) {
        this.geoField = geoField;
        return this;
    }

    public AnnoParas setBeginLevel(int beginLevel) {
        this.beginLevel = beginLevel;
        return this;
    }

    @Deprecated
    public AnnoParas setGridAtomMaxPoint(String gridAtomMaxPoint) {
        this.gridAtomMaxPoint = gridAtomMaxPoint;
        this.gridAtomMaxPointArr = gridAtomMaxPoint.split(",");
        return this;
    }

    public AnnoParas setEndLevel(int endLevel) {
        this.endLevel = endLevel - 1;
        return this;
    }

    public AnnoParas setGridSize(int gridSize) {
        this.gridSize = gridSize;
        return this;
    }

    @Deprecated
    public AnnoParas setSimplifyBox(String simplifyBox) {
        this.simplifyBox = simplifyBox;
        this.simplifyBoxArr = simplifyBox.split(",");
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String[] getSimplifyBoxArr() {
        return this.simplifyBoxArr;
    }

    public void setSimplifyBoxArr(String[] simplifyBoxArr) {
        this.simplifyBoxArr = simplifyBoxArr;
    }

    public String[] getGridAtomMaxPointArr() {
        return this.gridAtomMaxPointArr;
    }

    public void setGridAtomMaxPointArr(String[] gridAtomMaxPointArr) {
        this.gridAtomMaxPointArr = gridAtomMaxPointArr;
    }

    public double[] getExpectation() {
        return this.expectation;
    }

    public void setExpectation(double[] expectation) {
        this.expectation = expectation;
    }

    public AnnoVectorTileServer getAvServer() {
        return this.avServer;
    }

    public void setAvServer(AnnoVectorTileServer avServer) {
        this.avServer = avServer;
    }

    public String getUpdateSqlBase() {
        return this.updateSqlBase;
    }

    public void setUpdateSqlBase(String updateSqlBase) {
        this.updateSqlBase = updateSqlBase;
    }

    public String getUpdateMinSqlBase() {
        return this.updateMinSqlBase;
    }

    public void setUpdateMinSqlBase(String updateMinSqlBase) {
        this.updateMinSqlBase = updateMinSqlBase;
    }

    public String getGetMathExpectationSql() {
        return this.getMathExpectationSql;
    }

    public void setGetMathExpectationSql(String getMathExpectationSql) {
        this.getMathExpectationSql = getMathExpectationSql;
    }

    public Scroll getScroll() {
        return this.scroll;
    }

    public void setScroll(Scroll scroll) {
        this.scroll = scroll;
    }

    public long getNeedToProcessCount() {
        return this.needToProcessCount;
    }

    public void setNeedToProcessCount(long needToProcessCount) {
        this.needToProcessCount = needToProcessCount;
    }

    public int getBeginLevel() {
        return this.beginLevel;
    }

    public int getEndLevel() {
        return this.endLevel;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public String getSimplifyBox() {
        return this.simplifyBox;
    }

    public String getMapUnit() {
        return this.mapUnit;
    }

    public String getTable() {
        return this.table;
    }

    public double getLeft() {
        return this.left;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getTop() {
        return this.top;
    }

    public double getRight() {
        return this.right;
    }

    public String getFields() {
        return this.fields;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getGeoField() {
        return this.geoField;
    }

    public String getGridAtomMaxPoint() {
        return this.gridAtomMaxPoint;
    }

    public String getAnnoFild() {
        return this.annoFild;
    }

    public String getOrderFild() {
        return this.orderFild;
    }

    public String getOrder() {
        return this.order;
    }

    public int getThread() {
        return this.thread;
    }

    public AtomicLong getnFinished() {
        return this.nFinished;
    }

    public AtomicLong getPer() {
        return this.per;
    }

    public AtomicLong getnDistribute() {
        return this.nDistribute;
    }

    public AnnoParas setMapUnit(String mapUnit) {
        this.mapUnit = mapUnit;
        return this;
    }

    public AnnoParas setTable(String table) {
        this.table = table;
        return this;
    }

    public AnnoParas setLeft(double left) {
        this.left = left;
        return this;
    }

    public AnnoParas setBottom(double bottom) {
        this.bottom = bottom;
        return this;
    }

    public AnnoParas setTop(double top) {
        this.top = top;
        return this;
    }

    public AnnoParas setRight(double right) {
        this.right = right;
        return this;
    }

    public Boolean getSimplify() {
        return this.simplify;
    }

    public AnnoParas setSimplify(Boolean simplify) {
        this.simplify = simplify;
        return this;
    }

    public Boolean getStatistics() {
        return this.statistics;
    }

    public AnnoParas setStatistics(Boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        return "beginLevel=" + this.beginLevel + "," + "endLevel=" + this.endLevel + "," + "gridSize=" + this.gridSize + "," + "simplifyBox=" + this.simplifyBox + "," + "mapUnit=" + this.mapUnit + "," + "table=" + this.table + "," + "left=" + this.left + "," + "bottom=" + this.bottom + "," + "top=" + this.top + "," + "right=" + this.right + "," + "fields=" + this.fields + "," + "idField=" + this.idField + "," + "geoField=" + this.geoField + "," + "gridAtomMaxPoint=" + this.gridAtomMaxPoint + "," + "annoFild=" + this.annoFild + ",";
    }
}

