/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.check;

import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultItemDTO;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.service.FileModelService;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.check.FileModelCheckParam;
import java.util.function.Consumer;

public class FileModelCheckTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName("\u683c\u5f0f\u4e00\u81f4\u6027\u68c0\u67e5");
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setPriority(100);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        FileModelCheckParam fileModelCheckParam = (FileModelCheckParam)executeParam;
        FileModelService fileModelService = (FileModelService)SpringContextUtil.getBean(FileModelService.class);
        DataPackage dataPackage = fileModelService.getDataPackage(fileModelCheckParam.getModelId());
        ScanResultDTO scanResult = dataPackage.scanFile(inputDataParam.getFilePath(), Boolean.valueOf(true));
        executeResult.setSuccess(Boolean.valueOf(scanResult.getDataCount() - scanResult.getInvalidCount() > 0L));
        this.invokeExcuteLog("\u626b\u63cf\u5230\u4ee5\u4e0b\u4e3b\u6570\u636e\uff1a");
        for (ScanResultItemDTO scanResultItem : scanResult.getScanResultItems()) {
            this.invokeExcuteLog(scanResultItem.getMainFilePath() + ";" + scanResultItem.getCheckStatus());
        }
        if (!executeResult.getSuccess().booleanValue()) {
            this.invokeExcuteLog("\u65e0\u7b26\u5408\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u7684\u6570\u636e\uff01", TaskLogLevelEnum.Error);
        }
        return executeResult;
    }
}

