/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.attribute;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDatasetDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateFieldDTO;
import com.geoway.adf.dms.config.service.GeoTemplateService;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.frame.util.VectorFileUtil;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.attribute.StructuralNormCheckParam;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class StructuralNormCheckTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        StructuralNormCheckParam param = (StructuralNormCheckParam)toolParam;
        if (param.isBatch() && StrUtil.isEmpty((CharSequence)batchInputData.getDsKey())) {
            ToolHelper.callbackDir(batchInputData, batchOutputData, oneDataCallback, param, param.getVectorFormats());
        } else {
            Assert.state((boolean)VectorFileUtil.exactlyMatchAny((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef");
            ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, true);
        return ToolHelper.buildExecuteParam(inputData, outputData, toolParam, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (IFeatureWorkspace iFeatureWorkspace = null;){
            StructuralNormCheckParam param = (StructuralNormCheckParam)toolParam;
            GeoTemplateService geoTemplateService = (GeoTemplateService)SpringContextUtil.getBean(GeoTemplateService.class);
            GeoTemplateDTO geoTemplate = geoTemplateService.getGeoTemplate(param.getTemplateId(), null);
            Assert.notNull((Object)geoTemplate, (String)("\u6a21\u677f\u4e0d\u5b58\u5728, id : " + param.getTemplateId()));
            this.invokeExcuteLog("\u6570\u636e\u6a21\u677f\uff1a" + geoTemplate.getName());
            iFeatureWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)inputData.getFilePath());
            List datasets = geoTemplate.getDatasets();
            datasets.forEach(item -> {
                if (StringUtil.isEmptyOrWhiteSpace((String)item.getSourceName())) {
                    item.setSourceName(item.getName());
                }
            });
            List templateDatasetNames = datasets.stream().map(GeoTemplateDatasetDTO::getSourceName).collect(Collectors.toList());
            List tableNames = iFeatureWorkspace.getDatasetNames(GeoDatasetType.Table);
            tableNames.addAll(iFeatureWorkspace.getDatasetNames(GeoDatasetType.FeatureClass));
            tableNames = tableNames.stream().distinct().collect(Collectors.toList());
            boolean standard = true;
            int diff = tableNames.size() - templateDatasetNames.size();
            if (diff < 0) {
                templateDatasetNames.removeAll(tableNames);
                this.invokeExcuteLog(FileUtil.mainName((String)inputData.getFilePath()) + " \u7f3a\u5c11\u6570\u636e\u96c6 : " + Arrays.toString(templateDatasetNames.toArray()), TaskLogLevelEnum.Warning);
                standard = false;
            } else if (diff > 0) {
                tableNames.removeAll(templateDatasetNames);
                this.invokeExcuteLog(FileUtil.mainName((String)inputData.getFilePath()) + " \u591a\u4f59\u6570\u636e\u96c6 : " + Arrays.toString(tableNames.toArray()), TaskLogLevelEnum.Warning);
                standard = false;
            }
            if (!standard) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setOutDataParam(outputData);
                ToolHelper.copyWhenFlowLast(inputData, outputData);
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            for (GeoTemplateDatasetDTO dataset : datasets) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                String sourceName = dataset.getSourceName();
                FeatureType datasetFeatureType = FeatureType.getByValue((Integer)dataset.getType());
                String typeStr = "\u56fe\u5c42";
                switch (datasetFeatureType) {
                    case Point: 
                    case Polyline: 
                    case Polygon: {
                        break;
                    }
                    default: {
                        typeStr = "\u8868";
                    }
                }
                if (!tableNames.contains(sourceName)) {
                    this.invokeExcuteLog("\u6e90" + typeStr + " : " + sourceName + " \u4e0d\u5b58\u5728", TaskLogLevelEnum.Warning);
                    standard = false;
                    continue;
                }
                ITable table = iFeatureWorkspace.openTable(sourceName);
                IFields featureClassFields = table.getFields();
                if (table instanceof IFeatureClass && ((IFeatureClass)table).getFeatureType() != datasetFeatureType) {
                    this.invokeExcuteLog("\u8981\u7d20\u7c7b\u578b\u4e0d\u5339\u914d! \u56fe\u5c42 : " + ((IFeatureClass)table).getFeatureType() + " , \u6a21\u677f : " + datasetFeatureType, TaskLogLevelEnum.Warning);
                    standard = false;
                    continue;
                }
                List fields = dataset.getFields();
                ArrayList<String> featureFieldNames = new ArrayList<String>();
                for (IField featureClassField : featureClassFields) {
                    FieldType fieldType = featureClassField.getFieldType();
                    if (fieldType == FieldType.Shape || fieldType == FieldType.OID) continue;
                    featureFieldNames.add(featureClassField.getName());
                }
                int fieldDiff = featureFieldNames.size() - fields.size();
                if (fieldDiff != 0) {
                    List templateFieldNames = fields.stream().map(FieldDTO::getName).collect(Collectors.toList());
                    if (fieldDiff < 0) {
                        templateFieldNames.removeAll(featureFieldNames);
                        this.invokeExcuteLog("" + typeStr + " " + sourceName + " \u5b57\u6bb5\u7f3a\u5c11\u5b57\u6bb5 " + Arrays.toString(templateFieldNames.toArray()), TaskLogLevelEnum.Warning);
                    } else {
                        featureFieldNames.removeAll(templateFieldNames);
                        this.invokeExcuteLog("" + typeStr + " " + sourceName + " \u5b57\u6bb5\u591a\u4f59\u5b57\u6bb5 " + Arrays.toString(featureFieldNames.toArray()), TaskLogLevelEnum.Warning);
                    }
                    standard = false;
                    continue;
                }
                for (GeoTemplateFieldDTO tField : fields) {
                    int fieldLengthDiff;
                    String fieldName = tField.getName();
                    IField iField = featureClassFields.findField(fieldName);
                    if (iField == null) {
                        this.invokeExcuteLog("\u6e90" + typeStr + " : " + sourceName + " \u4e0d\u5b58\u5728\u5b57\u6bb5 : " + fieldName, TaskLogLevelEnum.Warning);
                        standard = false;
                        continue;
                    }
                    FieldType templateFieldType = FieldType.getByValue((Integer)tField.getFieldType());
                    Integer fieldType = tField.getFieldType();
                    if (iField.getFieldType() != templateFieldType) {
                        standard = false;
                        this.invokeExcuteLog("\u6e90" + typeStr + " : " + sourceName + " \u5b57\u6bb5 " + fieldName + " \u7c7b\u578b\u4e0d\u5339\u914d", TaskLogLevelEnum.Warning);
                        this.invokeExcuteLog("\u6a21\u677f\u5b57\u6bb5\u7c7b\u578b : " + templateFieldType + " <>  \u6570\u636e\u5b57\u6bb5\u7c7b\u578b " + iField.getFieldType(), TaskLogLevelEnum.Warning);
                        continue;
                    }
                    Integer tLength = tField.getLength();
                    Integer iLength = iField.getLength();
                    if (iLength > 0 && (fieldLengthDiff = iLength - tLength) != 0) {
                        this.invokeExcuteLog(typeStr + " " + sourceName + " \u5b57\u6bb5 " + fieldName + " \u957f\u5ea6\u4e0d\u4e00\u81f4, \u76f8\u5dee " + fieldLengthDiff, TaskLogLevelEnum.Warning);
                        standard = false;
                        continue;
                    }
                    if (!StrUtil.equals((CharSequence)iField.getAliasName(), (CharSequence)iField.getAliasName())) {
                        this.invokeExcuteLog(typeStr + " " + sourceName + " \u5b57\u6bb5 " + fieldName + " \u522b\u540d\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                        standard = false;
                        continue;
                    }
                    if (!ObjectUtil.equals((Object)iField.getNullable(), (Object)iField.getNullable())) {
                        this.invokeExcuteLog(typeStr + " " + sourceName + " \u5b57\u6bb5 " + fieldName + " \u975e\u7a7a\u9650\u5236\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                        standard = false;
                        continue;
                    }
                    if (!ObjectUtil.equals((Object)iField.getScale(), (Object)iField.getScale())) {
                        this.invokeExcuteLog(typeStr + " " + sourceName + " \u5b57\u6bb5 " + fieldName + " \u7cbe\u5ea6\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                        standard = false;
                        continue;
                    }
                    if (ObjectUtil.equals((Object)iField.getDefaultValue(), (Object)iField.getDefaultValue())) continue;
                    this.invokeExcuteLog(typeStr + " " + sourceName + " \u5b57\u6bb5 " + fieldName + " \u9ed8\u8ba4\u503c\u4e0d\u4e00\u81f4", TaskLogLevelEnum.Warning);
                    standard = false;
                }
            }
            if (standard) {
                this.invokeExcuteLog(inputData.getFilePath() + " \u7b26\u5408\u6a21\u677f\u89c4\u8303");
            }
            executeResult.setSuccess(Boolean.valueOf(standard));
            executeResult.setOutDataParam(outputData);
            ToolHelper.copyWhenFlowLast(inputData, outputData);
        }
        return executeResult;
    }
}

