/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.dgt.frame.enums.RasterFormatEnum;
import com.github.pagehelper.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterImportScan {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String path;
    private List<RasterFormatEnum> formats;
    private Pattern fileNamePattern;

    public RasterImportScan(String path, List<RasterFormatEnum> formats, String namePattern) {
        this.path = path;
        this.formats = formats;
        if (StringUtil.isNotEmpty((String)namePattern)) {
            this.fileNamePattern = Pattern.compile(namePattern);
        }
    }

    public int scan(Consumer<String> scanedOneData) {
        File parentFolder = new File(this.path);
        block6: for (RasterFormatEnum rasterEnum : this.formats) {
            switch (rasterEnum) {
                case TIF: {
                    this.scanTif(parentFolder, scanedOneData);
                    continue block6;
                }
                case GRID: {
                    this.scanGrid(parentFolder, scanedOneData);
                    continue block6;
                }
                case IMG: {
                    this.scanImage(parentFolder, scanedOneData);
                    continue block6;
                }
                case NSDTFDEM: {
                    this.scanDem(parentFolder, scanedOneData);
                    continue block6;
                }
            }
            this.log.warn("\u4e0d\u652f\u6301\u626b\u63cf\u7684\u6805\u683c\u6570\u636e\u683c\u5f0f\uff1a" + rasterEnum.name());
        }
        return 1;
    }

    private void scanGrid(File path, Consumer<String> scanedOneData) {
        if (path.isDirectory() && new File(path, "w001001.adf").exists()) {
            if (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)path.getName())).matches()) {
                scanedOneData.accept(path.getAbsolutePath());
            }
        } else {
            File[] subFiles = path.listFiles();
            if (subFiles == null) {
                return;
            }
            for (File file : subFiles) {
                if (file.isFile()) continue;
                this.scanGrid(file, scanedOneData);
            }
        }
    }

    private void scanTif(File path, Consumer<String> scanedOneData) {
        if (path.isFile()) {
            if ((".tif".equalsIgnoreCase(FileUtil.getExtension((String)path.getName())) || ".tiff".equalsIgnoreCase(FileUtil.getExtension((String)path.getName()))) && (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)path.getName())).matches())) {
                scanedOneData.accept(path.getAbsolutePath());
            }
        } else {
            File[] subFiles = path.listFiles();
            if (subFiles == null) {
                return;
            }
            for (File file : subFiles) {
                this.scanTif(file, scanedOneData);
            }
        }
    }

    private void scanImage(File path, Consumer<String> scanedOneData) {
        if (path.isFile()) {
            if (".img".equalsIgnoreCase(FileUtil.getExtension((String)path.getName())) && (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)path.getName())).matches())) {
                scanedOneData.accept(path.getAbsolutePath());
            }
        } else {
            File[] subFiles = path.listFiles();
            if (subFiles == null) {
                return;
            }
            for (File file : subFiles) {
                this.scanImage(file, scanedOneData);
            }
        }
    }

    private void scanDem(File path, Consumer<String> scanedOneData) {
        if (path.isFile()) {
            if (".dem".equalsIgnoreCase(FileUtil.getExtension((String)path.getName())) && (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)path.getName())).matches())) {
                scanedOneData.accept(path.getAbsolutePath());
            }
        } else {
            File[] subFiles = path.listFiles();
            if (subFiles == null) {
                return;
            }
            for (File file : subFiles) {
                this.scanDem(file, scanedOneData);
            }
        }
    }
}

