/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.supplier;

import com.geoway.dgt.geodata.annosimplify.AnnoBase;
import com.geoway.dgt.geodata.annosimplify.AnnoLog;
import com.geoway.dgt.geodata.annosimplify.AnnoSimplify;
import com.geoway.dgt.geodata.annosimplify.AnnoType;
import com.geoway.dgt.geodata.annosimplify.config.AnnoAfterSubtract;
import com.geoway.dgt.geodata.annosimplify.config.AnnoLayerLevel;
import com.geoway.dgt.geodata.annosimplify.dao.PoiOperation;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class AnnoSupplier<T, K> {
    protected static final AnnoLog logger = new AnnoLog(AnnoSupplier.class);
    protected AnnoType at;

    public Consumer<T> logSupplier() {
        Consumer<Object> logSupplier = result -> {
            long num = AnnoSimplify.annoParas.nFinished.incrementAndGet();
            if (AnnoSimplify.annoParas.per.incrementAndGet() > AnnoSimplify.annoParas.needToProcessCount / 500L) {
                logger.info(this.at.getName() + "-\u6267\u884c\u67e5\u8be2 \uff1a \u7b2c" + AnnoSimplify.annoParas.scroll.getLevel() + "\u5c42\uff1a " + num + "/" + AnnoSimplify.annoParas.needToProcessCount);
                AnnoSimplify.annoParas.per.set(0L);
            }
        };
        return logSupplier;
    }

    public Supplier<T> supplier(GridExtent extent) {
        Supplier<Object> simSupp = () -> {
            if (extent != null) {
                try {
                    List pois = PoiOperation.getPoiByBox(this.at, extent);
                    if (pois == null) {
                        return null;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u6267\u884c\u67e5\u8be2 \uff1a\u67e5\u8be2\u5230  " + String.valueOf(pois.size()) + " \u6761\u8bb0\u5f55");
                    }
                    if (logger.isWarnEnabled() && pois.size() > 10000) {
                        logger.warn("\u6267\u884c\u67e5\u8be2 \uff1a\u4e00\u6b21\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc71W\u6761, \u8bf7\u7ba1\u7406\u5458\u6ce8\u610f, \u53ef\u80fd\u9700\u8981\u63a7\u5236\u67e5\u8be2\u7ed3\u679c\u9650\u989d, \u67e5\u8be2\u5230 " + String.valueOf(pois.size()) + " \u6761\u8bb0\u5f55");
                    }
                    if (this.at == AnnoType.STATISTICS) {
                        return this.circulateFeatures(pois, extent);
                    }
                    if (!pois.isEmpty() && this.at == AnnoType.SIMPLIFY) {
                        return this.circulateFeatures(pois, extent);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        };
        return simSupp;
    }

    protected abstract K handleFeature(int var1, int[][] var2, int var3, int var4, Map var5, StringBuffer var6);

    protected abstract T endCirculateFeatures(int[][] var1, StringBuffer var2, GridExtent var3, int var4);

    protected abstract Boolean handlerK(K var1);

    protected T circulateFeatures(List iList, GridExtent extent) throws Exception {
        int simplifyBox = ((AnnoLayerLevel)AnnoSimplify.annoParas.avServer.getLayerMap().get("annoLayer").getLevelMap().get(extent.getLevel())).getGridAtom();
        int gridAtomMaxPoint = ((AnnoLayerLevel)AnnoSimplify.annoParas.avServer.getLayerMap().get("annoLayer").getLevelMap().get(extent.getLevel())).getGridAtomMaxPoint();
        List<AnnoAfterSubtract> subtractLst = ((AnnoLayerLevel)AnnoSimplify.annoParas.avServer.getLayerMap().get("annoLayer").getLevelMap().get(extent.getLevel())).getSubtractLst();
        double expectation = AnnoSimplify.annoParas.expectation[extent.getLevel()];
        int[][] simplifiedGridNum = new int[AnnoSimplify.annoParas.gridSize / simplifyBox][AnnoSimplify.annoParas.gridSize / simplifyBox];
        StringBuffer sb = new StringBuffer();
        double atomGridWidth = (extent.getRight() - extent.getLeft()) / (double)simplifiedGridNum.length;
        double atomGridHeight = (extent.getTop() - extent.getBottom()) / (double)simplifiedGridNum.length;
        K returnvalue = null;
        int size = iList.size();
        for (int i = 0; i < size; ++i) {
            Map m = (Map)iList.get(i);
            if (i == 0 && subtractLst != null && !subtractLst.isEmpty() && subtractLst.size() > 0) {
                int sizej = subtractLst.size();
                for (int j = 0; j < sizej; ++j) {
                    String subFeild = subtractLst.get(j).getField();
                    if (!m.containsKey(subFeild)) {
                        logger.error("\u3010level>after>subtrace>key\u3011\uff1a " + subFeild + "\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4poi\u8868\u4e2d\u6709\u6b64\u5b57\u6bb5 ");
                        logger.error("\u7a0b\u5e8f\u5c06\u7ec8\u6b62\uff01");
                        AnnoBase.annoSimplifyTool.abort();
                        break;
                    }
                    if (!String.valueOf(m.get(subFeild)).equals(subtractLst.get(j).getValue())) continue;
                    if ((gridAtomMaxPoint -= subtractLst.get(j).getSubtract().intValue()) <= 0) {
                        logger.error("\u3010level>after>subtrace\u3011: " + subtractLst.get(j).getSubtract() + "; gridAtomMaxPoint\u503c\u4e0d\u80fd<=0: " + gridAtomMaxPoint + " <=0");
                        logger.error("\u7a0b\u5e8f\u5c06\u7ec8\u6b62\uff01");
                        AnnoBase.annoSimplifyTool.abort();
                    }
                    if (!logger.isInfoEnabled()) break;
                    logger.info("\u672c\u74e6\u7247\u5df2\u5f00\u542fsubtrace, \u5f53\u524dgridAtomMaxPoint : " + gridAtomMaxPoint + " ; \u5df2\u51cf\u53bbsubtractLst : " + subtractLst.get(j).getSubtract());
                    break;
                }
            }
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            String shape = (String)m.get(AnnoSimplify.annoParas.geoField.toLowerCase());
            String[] s = shape.substring(6, shape.length() - 1).split(" ");
            double[] t = new double[]{Double.valueOf(s[0]), Double.valueOf(s[1])};
            int leftNum = (int)((t[0] - extent.getLeft()) / atomGridWidth);
            int rightNum = (int)((extent.getTop() - t[1]) / atomGridHeight);
            if (leftNum >= simplifiedGridNum.length) {
                if (logger.isTraceEnabled()) {
                    logger.trace(this.at.getName() + "-\u6570\u7ec4\u7d22\u5f15\u6ea2\u51fa  : simplifiedGridNum.length :" + simplifiedGridNum.length + " leftNum :" + (t[0] - extent.getLeft()) / atomGridWidth);
                }
                int n = leftNum = simplifiedGridNum.length - 1 >= 0 ? simplifiedGridNum.length - 1 : 0;
            }
            if (rightNum >= simplifiedGridNum.length) {
                if (logger.isTraceEnabled()) {
                    logger.trace(this.at.getName() + "-\u6570\u7ec4\u7d22\u5f15\u6ea2\u51fa  : simplifiedGridNum.length :" + simplifiedGridNum.length + " rightNum :" + (extent.getTop() - t[1]) / atomGridHeight);
                }
                int n = rightNum = simplifiedGridNum.length - 1 >= 0 ? simplifiedGridNum.length - 1 : 0;
            }
            if (!this.handlerK(returnvalue = (K)this.handleFeature(gridAtomMaxPoint, simplifiedGridNum, leftNum, rightNum, m, sb)).booleanValue()) continue;
            return (T)sb.toString();
        }
        return this.endCirculateFeatures(simplifiedGridNum, sb, extent, gridAtomMaxPoint);
    }

    public AnnoType getAt() {
        return this.at;
    }

    public void setAt(AnnoType at) {
        this.at = at;
    }
}

