/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.grid.impl;

import com.geoway.dgt.geodata.annosimplify.grid.GridUnitManager;
import com.geoway.dgt.geodata.annosimplify.grid.QuadtreeGrid;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import com.geoway.dgt.geodata.annosimplify.grid.impl.AbstractGrid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class QuadtreeImpl
extends AbstractGrid
implements QuadtreeGrid {
    protected void init(Integer base, int beginLevel, GridUnitManager.GridUnit unit) {
        this.base = base;
        this.unit = unit;
        switch (unit) {
            case degrees: {
                this.minX = -180;
                this.minY = -90;
                this.maxX = 180;
                this.maxY = 90;
                break;
            }
            case meters: {
                this.minX = -20037508;
                this.minY = -20037508;
                this.maxX = 20037508;
                this.maxY = 20037508;
            }
        }
        this.beginLevel = beginLevel;
        int unitpixel = this.maxY - this.minY;
        this.resolutionLevelBegin = (double)unitpixel / (double)this.base;
    }

    @Override
    public double getResolution(int level) {
        return this.resolutionLevelBegin / Math.pow(2.0, level - this.beginLevel);
    }

    public GridExtent isGridExtent(String bbox) {
        return null;
    }

    public String toJson() {
        return null;
    }

    @Override
    public GridExtent getPointToTile(double x, double y, int level) {
        double resolution = this.getResolution(level);
        Double _x = Double.valueOf(x - (double)this.minX) / (resolution * (double)this.base);
        Double _y = Double.valueOf((double)this.maxY - y) / (resolution * (double)this.base);
        return this.getExtent(level, _x.intValue(), _y.intValue());
    }

    @Override
    public String getPointToTileString(double x, double y, int level) {
        double resolution = this.getResolution(level);
        Double _x = Double.valueOf(x - (double)this.minX) / (resolution * (double)this.base);
        Double _y = Double.valueOf((double)this.maxY - y) / (resolution * (double)this.base);
        return _x.intValue() + "_" + _y.intValue() + "_" + level;
    }

    @Override
    public Set<Integer[]> scanline(double[][] points, int type, int level) {
        return type == 2 ? this.polyRingCover(points, level) : null;
    }

    private Set<Integer[]> polyRingCover(double[][] points, int level) {
        int scanlineY;
        HashMap<String, Integer[]> tileHash = new HashMap<String, Integer[]>();
        double resolution = this.getResolution(level);
        Double minY = null;
        Double maxY = null;
        for (int pathIndex = 0; pathIndex < points.length; ++pathIndex) {
            double[] subPoints = points[pathIndex];
            for (scanlineY = 0; scanlineY < subPoints.length / 2; ++scanlineY) {
                double y = subPoints[scanlineY * 2 + 1];
                if (minY == null) {
                    minY = y;
                }
                if (maxY == null) {
                    maxY = y;
                }
                if (y >= maxY) {
                    maxY = y;
                }
                if (!(y < minY)) continue;
                minY = y;
            }
        }
        Double gridExtendMaxYD = ((double)this.maxY - minY) / (resolution * (double)this.base);
        Double gridExtendMinYD = ((double)this.maxY - maxY) / (resolution * (double)this.base);
        int gridExtendMaxY = gridExtendMaxYD.intValue();
        for (scanlineY = gridExtendMinYD.intValue(); scanlineY <= gridExtendMaxY; ++scanlineY) {
            int mark = 0;
            GridExtent extent = this.getExtent(level, 0, scanlineY);
            int step = 8;
            double stepLength = (extent.getTop() - extent.getBottom()) / (double)step;
            while (mark <= step) {
                int intersectionsIndex;
                double scanlineYDouble = extent.getTop() - (double)mark * stepLength;
                ArrayList<Double> scanlineXDoubleArray = new ArrayList<Double>();
                double[][] scanline = new double[][]{{this.minX, scanlineYDouble}, {this.maxX, scanlineYDouble}};
                for (intersectionsIndex = 0; intersectionsIndex < points.length; ++intersectionsIndex) {
                    double[] subPoints = points[intersectionsIndex];
                    for (int i = 0; i < subPoints.length / 2 - 1; ++i) {
                        double point1x = subPoints[i * 2];
                        double point1y = subPoints[i * 2 + 1];
                        double point2x = subPoints[i * 2 + 2];
                        double point2y = subPoints[i * 2 + 3];
                        double[] intersection = QuadtreeImpl.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], point1x, point1y, point2x, point2y);
                        if (intersection == null) continue;
                        scanlineXDoubleArray.add(intersection[0]);
                    }
                    double point1x = subPoints[subPoints.length - 2];
                    double point1y = subPoints[subPoints.length - 1];
                    double point2x = subPoints[0];
                    double point2y = subPoints[1];
                    double[] intersection = QuadtreeImpl.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], point1x, point1y, point2x, point2y);
                    if (intersection == null) continue;
                    scanlineXDoubleArray.add(intersection[0]);
                }
                ++mark;
                Collections.sort(scanlineXDoubleArray, new Comparator<Double>(){

                    @Override
                    public int compare(Double o1, Double o2) {
                        return o1.compareTo(o2);
                    }
                });
                for (intersectionsIndex = 0; intersectionsIndex < scanlineXDoubleArray.size() - 1; ++intersectionsIndex) {
                    if (intersectionsIndex % 2 != 0) continue;
                    Double intersectionXEnter = (Double)scanlineXDoubleArray.get(intersectionsIndex);
                    Double intersectionXExit = (Double)scanlineXDoubleArray.get(intersectionsIndex + 1);
                    Double enterXD = (intersectionXEnter - (double)this.minX) / (resolution * (double)this.base);
                    Double exitXD = (intersectionXExit - (double)this.minX) / (resolution * (double)this.base);
                    int exitX = exitXD.intValue();
                    for (int enterX = enterXD.intValue(); enterX <= exitX; ++enterX) {
                        Integer[] extentint = new Integer[]{enterX, scanlineY, level};
                        String key = enterX + "_" + scanlineY + "_" + level;
                        tileHash.put(key, extentint);
                    }
                }
            }
        }
        return new HashSet<Integer[]>(tileHash.values());
    }

    public static double[] LINEINTERSECTS(double line1StartX, double line1StartY, double line1EndX, double line1EndY, double line2StartX, double line2StartY, double line2EndX, double line2EndY) {
        double[] res = new double[]{9.9999999999E10, 9.9999999999E10};
        double denominator = (line2EndY - line2StartY) * (line1EndX - line1StartX) - (line2EndX - line2StartX) * (line1EndY - line1StartY);
        if (denominator == 0.0) {
            return res[0] != 9.9999999999E10 && res[1] != 9.9999999999E10 ? res : null;
        }
        double a = line1StartY - line2StartY;
        double b = line1StartX - line2StartX;
        double numerator1 = (line2EndX - line2StartX) * a - (line2EndY - line2StartY) * b;
        double numerator2 = (line1EndX - line1StartX) * a - (line1EndY - line1StartY) * b;
        a = numerator1 / denominator;
        b = numerator2 / denominator;
        if (b >= 0.0 && b <= 1.0) {
            res[0] = line1StartX + a * (line1EndX - line1StartX);
            res[1] = line1StartY + a * (line1EndY - line1StartY);
            return res;
        }
        return null;
    }
}

