/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.vectortile.tilecutter.scroll.impl;

import com.geoway.dgt.geodata.annosimplify.grid.Grid;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import com.geoway.dgt.geodata.annosimplify.vectortile.tilecutter.scroll.Scroll;
import java.util.Map;

public class ExtentScroll
implements Scroll {
    private int beginX;
    private int endX;
    private int beginY;
    private int endY;
    private Grid grid;
    private int currentX;
    private int currentY;
    private int level;
    private String bbox;

    public ExtentScroll(int level, String bbox, Grid grid) {
        this.grid = grid;
        this.currentX = this.beginX;
        this.currentY = this.beginY;
        this.level = level;
        this.bbox = bbox;
        this.init();
    }

    private void init() {
        double beginResolution = this.grid.getResolution(this.level);
        if (this.bbox != null) {
            String[] boxs = this.bbox.split(",");
            double left = Double.valueOf(boxs[0]);
            double bottom = Double.valueOf(boxs[1]);
            double right = Double.valueOf(boxs[2]);
            double top = Double.valueOf(boxs[3]);
            this.beginX = (int)this.grid.calculateX(beginResolution, left);
            this.beginY = (int)this.grid.calculateY(beginResolution, top);
            this.endX = (int)this.grid.calculateX(beginResolution, right);
            this.endY = (int)this.grid.calculateY(beginResolution, bottom);
            this.currentX = this.beginX;
            this.currentY = this.beginY;
        } else {
            this.beginX = (int)this.grid.calculateX(beginResolution, this.grid.getMinX());
            this.beginY = (int)this.grid.calculateY(beginResolution, this.grid.getMaxY());
            this.endX = (int)this.grid.calculateX(beginResolution, this.grid.getMaxX());
            this.endY = (int)this.grid.calculateY(beginResolution, this.grid.getMinY());
        }
    }

    @Override
    public synchronized boolean hasNext(boolean loged, Map<String, Integer> batchSize) {
        return this.currentX <= this.endX && this.currentY <= this.endY;
    }

    @Override
    public synchronized GridExtent next() {
        GridExtent gridExtent = this.grid.getExtent(this.level, this.currentX, this.currentY);
        ++this.currentX;
        if (this.currentX > this.endX) {
            this.goNextRow();
        }
        return gridExtent;
    }

    private void goNextRow() {
        this.currentX = this.beginX;
        ++this.currentY;
    }

    @Override
    public Long getCount() {
        return ((long)this.endY - (long)this.beginY + 1L) * ((long)this.endX - (long)this.beginX + 1L);
    }

    @Override
    public String toLog() {
        return "level=" + this.level + "bbox=" + this.bbox;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setBatch(int begin, int end) {
    }
}

