/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.transfer;

import cn.hutool.core.io.FileUtil;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.transfer.VectorFormatTransferParam;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.springframework.util.Assert;

public class VectorFormatTransferTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        VectorFormatTransferParam param = (VectorFormatTransferParam)toolParam;
        if (StringUtil.isEmpty((String)batchInputData.getDsKey())) {
            ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, toolParam, VectorReadWriteEnum.F2F, param.getSourceFormat(), param.getTargetFormat());
        } else {
            ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, toolParam, VectorReadWriteEnum.D2F, param.getSourceFormat(), param.getTargetFormat());
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        VectorFormatTransferParam param = (VectorFormatTransferParam)toolParam;
        return ToolHelper.buildExecuteParam(inputData, outputData, param, VectorReadWriteEnum.F2F, param.getSourceFormat(), param.getTargetFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        ToolFeatureWorkspaceDTO workspace = null;
        int totalCount = 0;
        int successCount = 0;
        int failCount = 0;
        boolean success = true;
        try {
            ArrayList<IGeoDataset> srcDatasets;
            IFeatureWorkspace outputWorkspace;
            IFeatureWorkspace inputWorkspace;
            FileUtil.mkParentDirs((String)outputDataParam.getFilePath());
            if (StringUtil.isEmpty((String)inputDataParam.getDsKey())) {
                workspace = ToolHelper.getWorkspace(inputDataParam, outputDataParam, VectorReadWriteEnum.F2F);
                inputWorkspace = workspace.getSourceWorkspace();
                outputWorkspace = workspace.getTargetWorkspace();
                srcDatasets = inputWorkspace.getDatasets();
            } else {
                String[] datasetNames;
                workspace = ToolHelper.getWorkspace(inputDataParam, outputDataParam, VectorReadWriteEnum.D2F);
                inputWorkspace = workspace.getSourceWorkspace();
                outputWorkspace = workspace.getTargetWorkspace();
                srcDatasets = new ArrayList<IGeoDataset>();
                for (String datasetName : datasetNames = inputDataParam.getName().split(",")) {
                    IGeoDataset geoDataset = inputWorkspace.openGeoDataset(datasetName);
                    srcDatasets.add(geoDataset);
                }
            }
            block11: for (IGeoDataset dataset : srcDatasets) {
                GeoDatasetType geoDatasetType = dataset.getType();
                Fields newFields = new Fields();
                switch (geoDatasetType) {
                    case FeatureClass: {
                        IFeatureClass srcFeatureClass = (IFeatureClass)dataset;
                        FeatureClassMeta featureClassMeta = new FeatureClassMeta(outputWorkspace, null);
                        ++totalCount;
                        TransferResult transferResult = this.transFerFeatureClass(srcFeatureClass, featureClassMeta, () -> ((VectorFormatTransferTool)this).isAborted());
                        if (transferResult.isSuccess()) {
                            this.invokeExcuteLog(srcFeatureClass.getName() + "\u8f6c\u6362\u6210\u529f\uff01");
                            ++successCount;
                            break;
                        }
                        this.invokeExcuteLog(srcFeatureClass.getName() + "\u8f6c\u6362\u5931\u8d25\uff01" + transferResult.getErrorMessage());
                        ++failCount;
                        break;
                    }
                    case FeatureDataset: {
                        TransferResult transferResult;
                        IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                        List subsets = featureDataset.getSubsets();
                        for (IGeoDataset subset : subsets) {
                            IFeatureClass subFeatureClass = (IFeatureClass)subset;
                            FeatureClassMeta position = new FeatureClassMeta(outputWorkspace, featureDataset.getName());
                            ++totalCount;
                            transferResult = this.transFerFeatureClass(subFeatureClass, position, () -> ((VectorFormatTransferTool)this).isAborted());
                            if (transferResult.isSuccess()) {
                                this.invokeExcuteLog(subFeatureClass.getName() + "\u8f6c\u6362\u6210\u529f\uff01");
                                ++successCount;
                                continue;
                            }
                            this.invokeExcuteLog(subFeatureClass.getName() + "\u8f6c\u6362\u5931\u8d25\uff01" + transferResult.getErrorMessage());
                            ++failCount;
                        }
                        continue block11;
                    }
                    case Table: {
                        ITable srcTable = (ITable)dataset;
                        IntStream.range(0, srcTable.getFields().getFieldCount()).mapToObj(i -> srcTable.getFields().getField(i).clone()).forEach(arg_0 -> ((IFields)newFields).addField(arg_0));
                        ITable targetTable = outputWorkspace.createTable(srcTable.getName(), (IFields)newFields);
                        if (targetTable == null) {
                            this.invokeExcuteLog(srcTable.getName() + "\u521b\u5efa\u8868\u5931\u8d25\uff01");
                            ++failCount;
                            continue block11;
                        }
                        this.invokeExcuteLog("\u5f00\u59cb\u8f6c\u6362" + srcTable.getName());
                        ++totalCount;
                        VectorDataTransfer vt = new VectorDataTransfer();
                        vt.setCancelCallback(() -> ((VectorFormatTransferTool)this).isAborted());
                        TransferResult transferResult = vt.copyTable(srcTable, targetTable, null);
                        if (transferResult.isSuccess()) {
                            this.invokeExcuteLog(srcTable.getName() + "\u8f6c\u6362\u6210\u529f\uff01");
                            ++successCount;
                            break;
                        }
                        this.invokeExcuteLog(srcTable.getName() + "\u8f6c\u6362\u5931\u8d25\uff01" + transferResult.getErrorMessage());
                        ++failCount;
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b : " + geoDatasetType);
                    }
                }
            }
            executeResult.setSuccess(Boolean.valueOf(failCount == 0 && totalCount == successCount));
            executeResult.setOutDataParam(outputDataParam);
            this.invokeExcuteLog(String.format("\u5171%d\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", totalCount, successCount, failCount));
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog(String.format("\u5171%d\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", totalCount, successCount, failCount));
        }
        finally {
            if (workspace != null) {
                workspace.close();
            }
        }
        return executeResult;
    }

    private TransferResult transFerFeatureClass(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, Supplier<Boolean> cancelCallback) {
        this.invokeExcuteLog("\u5f00\u59cb\u8f6c\u6362" + srcFeatureClass.getName());
        VectorDataTransfer vt = new VectorDataTransfer();
        vt.setCancelCallback(cancelCallback);
        IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, null);
        Assert.notNull((Object)targetFeatureClass, (String)"\u521b\u5efa\u8981\u7d20\u7c7b\u5931\u8d25!");
        Assert.state((boolean)targetFeatureClass.createSpatialIndex(), (String)"\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15\u5931\u8d25");
        return vt.copyFeature(srcFeatureClass, targetFeatureClass, null);
    }
}

