/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify;

import com.geoway.dgt.geodata.annosimplify.AnnoLog;
import com.geoway.dgt.geodata.annosimplify.AnnoParas;
import com.geoway.dgt.geodata.annosimplify.AnnoSimplifyTool;
import com.geoway.dgt.geodata.annosimplify.AnnoType;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import com.geoway.dgt.geodata.annosimplify.supplier.ISupplier;
import com.geoway.dgt.geodata.annosimplify.vectortile.tilecutter.scroll.Scroll;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AnnoBase<T> {
    protected final AnnoLog logger = new AnnoLog(this.getClass());
    public static AnnoParas annoParas;
    public static AnnoSimplifyTool annoSimplifyTool;
    protected String operType;
    protected AnnoType at;
    protected ISupplier<T> supplier;

    protected void execute(AnnoParas annoParas) throws Exception {
        AnnoBase.annoParas = annoParas;
        this.pretreatment();
        this.scorllLevel(annoParas);
    }

    protected abstract void pretreatment();

    private void scorllLevel(AnnoParas annoParas) {
        long c1 = System.currentTimeMillis();
        String info = "";
        for (int i = annoParas.beginLevel; i <= annoParas.endLevel + 1; ++i) {
            info = this.at.getName() + "--\u5f00\u59cb\u5904\u7406\u7b2c " + i + " \u7ea7";
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(info);
            }
            long c2 = System.currentTimeMillis();
            annoParas.setScorll(i);
            AnnoBase.annoParas.needToProcessCount = annoParas.scroll.getCount();
            AnnoBase.annoParas.per.set(0L);
            AnnoBase.annoParas.nFinished.set(0L);
            AnnoBase.annoParas.nDistribute.set(0L);
            info = this.at.getName() + "--\u6267\u884c\u67e5\u8be2 \uff1a \u7ea7\u522b [ " + i + " ]  \u672c\u7ea7\u522b\u5171 " + AnnoBase.annoParas.needToProcessCount + "\u5f20\u74e6\u7247\u8303\u56f4\u7684\u6ce8\u8bb0\u9700\u8981\u5904\u7406";
            if (this.logger.isInfoEnabled()) {
                this.logger.info(info);
            }
            CompletableFuture<T> cfBase = null;
            this.beginExecute(annoParas.scroll, cfBase);
            cfBase = this.scorllExecute(annoParas.scroll, cfBase);
            if (annoSimplifyTool.isAborted()) {
                this.logger.info("\u62bd\u7a00\u4efb\u52a1\u88ab\u5916\u90e8\u505c\u6b62\uff0c\u4efb\u52a1\u505c\u6b62\uff01");
                cfBase.cancel(true);
                return;
            }
            this.endExecute(annoParas.scroll, cfBase);
            if (annoSimplifyTool.isAborted()) {
                this.logger.info("\u62bd\u7a00\u4efb\u52a1\u88ab\u5916\u90e8\u505c\u6b62\uff0c\u4efb\u52a1\u505c\u6b62\uff01");
                cfBase.cancel(true);
                return;
            }
            info = this.at.getName() + "--\u6267\u884c\u67e5\u8be2 \uff1a\u5b8c\u6210\u7b2c" + annoParas.scroll.getLevel() + "\u5c42 \uff0c\u8017\u65f6: " + (System.currentTimeMillis() - c2) + "ms";
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info(info);
        }
        annoParas.setStatus(1);
        info = this.at.getName() + "--\u5168\u90e8\u5904\u7406\u5b8c\u6bd5\uff0c\u5171\u8017\u65f6\u79d2\u6570\uff1a" + (System.currentTimeMillis() - c1) / 1000L;
        if (this.logger.isInfoEnabled()) {
            this.logger.info(info);
        }
    }

    private CompletableFuture<T> scorllExecute(Scroll scroll, CompletableFuture<T> cfBase) {
        AnnoBase.annoParas.needToProcessCount = scroll.getCount();
        ExecutorService searchExecutor = Executors.newFixedThreadPool((int)Math.floor(Runtime.getRuntime().availableProcessors() * 5), new NamedThreadFactory());
        long taskNum = 0L;
        while (scroll.hasNext(true, null)) {
            GridExtent extent = scroll.next();
            AnnoBase.annoParas.nDistribute.incrementAndGet();
            taskNum = AnnoBase.annoParas.nDistribute.get() - AnnoBase.annoParas.nFinished.get();
            if (taskNum > 100000L) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("\u4e3b\u7ebf\u7a0b\u505c\u987f10\u79d2\uff0c\u4ee5\u4fbf\u5de5\u4f5c\u7ebf\u7a0b\u5904\u7406\u5806\u79ef\u7684\u4efb\u52a1");
                    }
                    Thread.currentThread();
                    Thread.sleep(10000L);
                    taskNum = AnnoBase.annoParas.nDistribute.get() - AnnoBase.annoParas.nFinished.get();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("\u4e3b\u7ebf\u7a0b\u505c\u987f\u7ed3\u675f\uff0c\u5269\u4f59\u4efb\u52a1\u6570\u91cf\uff1a" + taskNum);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            cfBase = this.taskExcute(extent, searchExecutor, cfBase);
            if (!annoSimplifyTool.isAborted()) continue;
            this.logger.info("\u62bd\u7a00\u4efb\u52a1\u88ab\u5916\u90e8\u505c\u6b62\uff0c\u4efb\u52a1\u505c\u6b62\uff01");
            return cfBase;
        }
        return cfBase;
    }

    protected CompletableFuture<T> taskExcute(GridExtent extent, ExecutorService searchExecutor, CompletableFuture<T> cfBase) {
        CompletionStage cf = CompletableFuture.supplyAsync(this.supplier.supplier(extent), searchExecutor).exceptionally(throwable -> {
            this.logger.error("CompletableFuture.supplyAsync error");
            this.logger.error(throwable.toString());
            annoSimplifyTool.abort();
            return null;
        });
        ((CompletableFuture)((CompletableFuture)cf).thenAccept(this.supplier.logSupplier())).exceptionally(throwable -> {
            this.logger.error("CompletableFuture.thenAccept error");
            this.logger.error(throwable.toString());
            annoSimplifyTool.abort();
            return null;
        });
        if (cfBase == null) {
            cfBase = cf;
            return cfBase;
        }
        cfBase = ((CompletableFuture)cfBase.thenCombine(cf, this.supplier.combineSupplier())).exceptionally(throwable -> {
            this.logger.error("CompletableFuture.thenCombine error");
            this.logger.error(throwable.toString());
            annoSimplifyTool.abort();
            return null;
        });
        return cfBase;
    }

    protected abstract void beginExecute(Scroll var1, CompletableFuture<T> var2);

    private void endExecute(Scroll scroll, CompletableFuture<T> cfBase) {
        T sbouter = null;
        try {
            sbouter = cfBase.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (sbouter != null) {
            this.executeEndValue(scroll.getLevel(), sbouter);
        }
    }

    protected abstract void executeEndValue(int var1, T var2);

    class NamedThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(100);

        NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("\u6ce8\u8bb0\u5904\u7406\u7ebf\u7a0b-" + this.tag.getAndIncrement());
            return thread;
        }
    }
}

