/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.vector;

import cn.hutool.core.lang.func.Supplier4;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.vector.TopologyCheckParam;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.util.function.Consumer;

public class TopologyCheckTool
extends ToolBase {
    private boolean hasCheckError = false;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        TopologyCheckParam param = (TopologyCheckParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(batchInputData, batchOutputData, !param.isRepair());
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, param, vectorReadWriteEnum);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        TopologyCheckParam param = (TopologyCheckParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isRepair());
        return ToolHelper.buildExecuteParam(inputData, outputData, param, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            TopologyCheckParam param = (TopologyCheckParam)executeParam;
            VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isRepair());
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, vectorReadWriteEnum);
            switch (vectorReadWriteEnum) {
                case D: 
                case F: {
                    ToolHelper.handleFeatureClass(inputData.getName(), param, workspaceDTO.getSourceWorkspace(), (p, f) -> this.checkFeatureClass((TopologyCheckParam)p, (IFeatureClass)f));
                    ToolHelper.copyWhenFlowLast(inputData, outputData);
                    break;
                }
                case D2F: 
                case F2D: 
                case F2F: 
                case D2D: {
                    ToolHelper.handleAndSaveFeatureClass(inputData.getName(), outputData.getName(), param, workspaceDTO.getSourceWorkspace(), workspaceDTO.getTargetWorkspace(), (Supplier4<Boolean, IFeatureClass, FeatureClassMeta, IToolParam, String>)((Supplier4)(f, m, p, n) -> this.checkAndCopyFeature((IFeatureClass)f, (FeatureClassMeta)m, (TopologyCheckParam)p, (String)n)));
                    break;
                }
                default: {
                    throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
                }
            }
            executeResult.setSuccess(Boolean.valueOf(!this.hasCheckError));
            executeResult.setOutDataParam(outputData);
        }
        return executeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndCopyFeature(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, TopologyCheckParam param, String outputName) {
        IFeatureWorkspace targetWorkspace = featureClassMeta.getWorkspace();
        IFeatureCursor insertCursor = null;
        IFeatureCursor searchCursor = null;
        try {
            IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, outputName);
            targetWorkspace.beginTransaction();
            insertCursor = targetFeatureClass.batchInsertFeature();
            searchCursor = srcFeatureClass.searchFeature(null);
            this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + srcFeatureClass.getName());
            IFeature feature = searchCursor.nextFeature();
            boolean hasInvalid = false;
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IGeometry geometry = feature.getGeometry();
                if (geometry == null) {
                    this.invokeExcuteLog("\u56fe\u5c42 : " + srcFeatureClass.getName() + "\u5b58\u5728\u8981\u7d20\u51e0\u4f55\u5b57\u6bb5\u4e3a\u7a7a, oid : " + feature.getObjectId(), TaskLogLevelEnum.Warning);
                    feature = searchCursor.nextFeature();
                    continue;
                }
                if (!geometry.isValid()) {
                    this.invokeExcuteLog("\u56fe\u5c42 " + srcFeatureClass.getName() + " \u53d1\u73b0\u62d3\u6251\u9519\u8bef, oid \u4e3a " + feature.getObjectId());
                    hasInvalid = true;
                    if (param.isRepair()) {
                        this.invokeExcuteLog("\u56fe\u5c42 " + srcFeatureClass.getName() + " \u4fee\u590d\u62d3\u6251\u9519\u8bef, oid \u4e3a " + feature.getObjectId());
                        geometry = geometry.makeValid();
                    }
                }
                IFeature newFeature = targetFeatureClass.createFeature();
                newFeature.setGeometry(geometry);
                for (IField field : newFeature.getFields()) {
                    newFeature.setValue(field.getName(), feature.getValue(field.getName()));
                }
                insertCursor.insertFeature(newFeature);
                feature = searchCursor.nextFeature();
            }
            if (!hasInvalid) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + srcFeatureClass.getName() + " \u65e0\u62d3\u6251\u9519\u8bef");
            }
            targetWorkspace.commitTransaction();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.invokeExcuteLog("\u62f7\u8d1d\u8981\u7d20\u5931\u8d25", e);
            targetWorkspace.rollbackTransaction();
            boolean bl = false;
            return bl;
        }
        finally {
            if (searchCursor != null) {
                searchCursor.release();
            }
            if (insertCursor != null) {
                insertCursor.release();
            }
        }
    }

    private void checkFeatureClass(TopologyCheckParam param, IFeatureClass featureClass) {
        featureClass.getWorkspace().beginTransaction();
        IFeatureCursor featureCursor = null;
        try {
            featureCursor = featureClass.searchFeature(null);
            this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + featureClass.getName());
            IFeature feature = featureCursor.nextFeature();
            boolean hasInvalid = false;
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IGeometry geometry = feature.getGeometry();
                if (geometry == null) {
                    this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + " \u5b58\u5728\u8981\u7d20\u51e0\u4f55\u5b57\u6bb5\u4e3a\u7a7a, oid \u4e3a " + feature.getObjectId(), TaskLogLevelEnum.Warning);
                    feature = featureCursor.nextFeature();
                    continue;
                }
                if (!geometry.isValid()) {
                    hasInvalid = true;
                    this.hasCheckError = true;
                    if (param.isRepair()) {
                        IGeometry newGeometry = geometry.makeValid();
                        feature.setGeometry(newGeometry);
                        this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + " \u62d3\u6251\u4fee\u590d, oid \u4e3a " + feature.getObjectId());
                    } else {
                        this.invokeExcuteLog("\u56fe\u5c42 " + featureClass.getName() + " \u53d1\u73b0\u62d3\u6251\u9519\u8bef, oid \u4e3a " + feature.getObjectId());
                    }
                }
                feature = featureCursor.nextFeature();
            }
            if (!hasInvalid) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + featureClass.getName() + " \u65e0\u62d3\u6251\u9519\u8bef");
            }
            featureClass.getWorkspace().commitTransaction();
        }
        catch (Exception e) {
            featureClass.getWorkspace().rollbackTransaction();
            throw new RuntimeException(e);
        }
        finally {
            if (featureCursor != null) {
                featureCursor.release();
            }
        }
    }
}

