/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.raster;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.NumberUtil;
import com.geoway.adf.gis.basic.gdalFunc;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.RasterFormatEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.raster.RasterFormatTransferParam;
import com.geoway.dgt.geodata.util.RasterImportScan;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.springframework.util.Assert;

public class RasterFormatTransferTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        RasterFormatTransferParam rasterParam = (RasterFormatTransferParam)toolParam;
        if (StringUtils.isNotBlank((CharSequence)batchInputData.getName())) {
            String[] nameArray;
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchOutputData.getFilePath())), (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            for (String name : nameArray = batchInputData.getName().split(",")) {
                batchInputData.setName(null);
                batchInputData.setFilePath(new File(batchInputData.getFilePath(), name).getAbsolutePath());
                ToolHelper.callbackOne(batchInputData, batchOutputData, toolParam, oneDataCallback);
            }
        } else {
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchOutputData.getFilePath())), (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            RasterImportScan rasterImportScan = new RasterImportScan(batchInputData.getFilePath(), Collections.singletonList(rasterParam.getSourceFormat()), null);
            rasterImportScan.scan(data -> {
                DataParam dataParam = new DataParam();
                dataParam.setFilePath(new File((String)data).getAbsolutePath());
                dataParam.setName(FileUtil.getName((String)data));
                ToolHelper.callbackOne(dataParam, batchOutputData, toolParam, oneDataCallback);
            });
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        RasterFormatTransferParam rasterFormatTransferParam = (RasterFormatTransferParam)executeParam;
        RasterFormatEnum targetFormat = rasterFormatTransferParam.getTargetFormat();
        String outputFilePath = outputDataParam.getFilePath() + File.separator + FileUtil.mainName((String)inputDataParam.getName());
        switch (targetFormat) {
            case TIF: {
                outputFilePath = outputFilePath + ".tif";
                break;
            }
            case IMG: {
                outputFilePath = outputFilePath + ".img";
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8f6c\u6362\u7c7b\u578b : " + targetFormat.name());
            }
        }
        boolean success = rasterFormatTransferParam.getSourceFormat() == RasterFormatEnum.NSDTFDEM ? this.transformDem(inputDataParam.getFilePath(), outputFilePath, targetFormat) : this.transform(inputDataParam, outputFilePath);
        if (!success) {
            executeResult.setSuccess(Boolean.valueOf(false));
        }
        return executeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transform(DataParam inputDataParam, String outputFilePath) {
        boolean success;
        String inputFilePath = inputDataParam.getFilePath();
        this.invokeExcuteLog("\u5f00\u59cb\u8f6c\u6362\uff1a" + inputFilePath);
        RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(inputFilePath);
        IRasterDataset rasterDataset = null;
        try {
            rasterDataset = rasterWorkspace.openRasterDataset(inputFilePath);
            success = rasterDataset.saveAs(outputFilePath);
        }
        catch (Exception e) {
            success = false;
            this.invokeExcuteLog(e.getMessage(), e);
        }
        finally {
            if (rasterDataset != null) {
                rasterDataset.closeRaster();
            }
        }
        if (success) {
            this.invokeExcuteLog(inputFilePath + "\u683c\u5f0f\u8f6c\u6362\u6210\u529f\uff01");
        } else {
            this.invokeExcuteLog(inputFilePath + "\u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff01");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transformDem(String inputFile, String outputFile, RasterFormatEnum targetFormat) {
        this.invokeExcuteLog("\u5f00\u59cb\u8f6c\u6362\uff1a" + inputFile);
        DemFileHeader demFileHeader = RasterFormatTransferTool.parseDemFileHeader(inputFile);
        boolean isInteger = demFileHeader.valueType.equalsIgnoreCase("Integer");
        if (demFileHeader.hzoom != null && demFileHeader.hzoom > 1) {
            isInteger = false;
        }
        String driverName = "GTiff";
        switch (targetFormat) {
            case TIF: {
                driverName = "GTiff";
                break;
            }
            case IMG: {
                driverName = "HFA";
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8f6c\u6362\u7c7b\u578b : " + targetFormat.name());
            }
        }
        gdalFunc.isAvailable();
        Driver driver = gdal.GetDriverByName((String)driverName);
        String[] createOptions = new String[]{"COMPRESS=DEFLATE", "TILED=YES", "BLOCKXSIZE=256", "BLOCKYSIZE=256"};
        Dataset dataset = driver.Create(outputFile, demFileHeader.cols.intValue(), demFileHeader.rows.intValue(), 1, isInteger ? gdalconstConstants.GDT_Int32 : gdalconstConstants.GDT_Float32, createOptions);
        if (dataset == null) {
            this.invokeExcuteLog(outputFile + "\u521b\u5efa\u5931\u8d25\uff01", TaskLogLevelEnum.Error);
            return false;
        }
        try {
            double[] geoTransform = new double[]{demFileHeader.x0, demFileHeader.dx, 0.0, demFileHeader.y0 + (double)demFileHeader.rows.intValue() * demFileHeader.dy, 0.0, -demFileHeader.dy.doubleValue()};
            dataset.SetGeoTransform(geoTransform);
            dataset.GetRasterBand(1).SetNoDataValue(-99999.0);
            try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
                String line;
                int currentLineNumber = 0;
                int currentRow = 0;
                int currentCol = 0;
                Object[] buffer = isInteger ? new int[demFileHeader.cols.intValue()] : (Object[])new float[demFileHeader.cols.intValue()];
                block20: while ((line = reader.readLine()) != null && currentRow < demFileHeader.rows) {
                    String[] values;
                    if (++currentLineNumber <= demFileHeader.dataLineNumber || (line = line.trim()).isEmpty()) continue;
                    for (String valueStr : values = line.split("\\s+")) {
                        if (currentCol >= demFileHeader.cols) {
                            if (isInteger) {
                                dataset.GetRasterBand(1).WriteRaster(0, currentRow, demFileHeader.cols.intValue(), 1, buffer);
                            } else {
                                dataset.GetRasterBand(1).WriteRaster(0, currentRow, demFileHeader.cols.intValue(), 1, (float[])buffer);
                            }
                            currentCol = 0;
                            buffer = isInteger ? new int[demFileHeader.cols.intValue()] : (Object[])new float[demFileHeader.cols.intValue()];
                            if (++currentRow >= demFileHeader.rows) continue block20;
                        }
                        try {
                            if (isInteger) {
                                Object[] intBuffer = buffer;
                                intBuffer[currentCol] = NumberUtil.parseInt((String)valueStr);
                            } else {
                                float[] floatBuffer = buffer;
                                if (valueStr.equals("-99999")) {
                                    floatBuffer[currentCol] = -99999.0f;
                                } else {
                                    float value = Float.parseFloat(valueStr);
                                    if (demFileHeader.hzoom != null && demFileHeader.hzoom > 1) {
                                        value /= (float)demFileHeader.hzoom.intValue();
                                    }
                                    floatBuffer[currentCol] = value;
                                }
                            }
                            ++currentCol;
                        }
                        catch (NumberFormatException e) {
                            throw new IOException(String.format("\u7b2c%d\u884c\u7b2c%d\u5217\u6570\u636e\u683c\u5f0f\u9519\u8bef: %s", currentLineNumber, currentCol + 1, valueStr));
                        }
                    }
                }
                if (currentCol > 0 && currentRow < demFileHeader.rows) {
                    if (isInteger) {
                        dataset.GetRasterBand(1).WriteRaster(0, currentRow, demFileHeader.cols.intValue(), 1, buffer);
                    } else {
                        dataset.GetRasterBand(1).WriteRaster(0, currentRow, demFileHeader.cols.intValue(), 1, (float[])buffer);
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.invokeExcuteLog(e);
            boolean bl = false;
            return bl;
        }
        finally {
            dataset.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DemFileHeader parseDemFileHeader(String filePath) {
        DemFileHeader demFile = new DemFileHeader();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            int number = -1;
            while ((line = reader.readLine()) != null) {
                ++number;
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith("DataMark")) {
                    demFile.dataMark = RasterFormatTransferTool.getValue(line);
                    continue;
                }
                if (line.startsWith("Version")) {
                    demFile.version = RasterFormatTransferTool.getValue(line);
                    continue;
                }
                if (line.startsWith("Alpha")) {
                    demFile.alpha = Float.valueOf(Float.parseFloat(RasterFormatTransferTool.getValue(line)));
                    continue;
                }
                if (line.startsWith("Compress")) {
                    demFile.compress = NumberUtil.parseInt((String)RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("X0")) {
                    demFile.x0 = Double.parseDouble(RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("Y0")) {
                    demFile.y0 = Double.parseDouble(RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("DX")) {
                    demFile.dx = Double.parseDouble(RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("DY")) {
                    demFile.dy = Double.parseDouble(RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("Row")) {
                    demFile.rows = NumberUtil.parseInt((String)RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("Col")) {
                    demFile.cols = NumberUtil.parseInt((String)RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("ValueType")) {
                    demFile.valueType = RasterFormatTransferTool.getValue(line);
                    continue;
                }
                if (line.startsWith("Hzoom")) {
                    demFile.hzoom = NumberUtil.parseInt((String)RasterFormatTransferTool.getValue(line));
                    continue;
                }
                if (line.startsWith("XYUnit")) {
                    demFile.xyUnit = RasterFormatTransferTool.getValue(line);
                    continue;
                }
                if (line.startsWith("ZUnit")) {
                    demFile.zUnit = RasterFormatTransferTool.getValue(line);
                    continue;
                }
                if (!line.matches("^[\uff0d\\-\\d].*")) continue;
                demFile.dataLineNumber = number;
                break;
            }
            DemFileHeader demFileHeader = demFile;
            return demFileHeader;
        }
        catch (Exception e) {
            throw new RuntimeException("dem\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage(), e);
        }
    }

    private static String getValue(String line) {
        int colonIndex = line.indexOf("\uff1a");
        if (colonIndex == -1) {
            colonIndex = line.indexOf(":");
        }
        return line.substring(colonIndex + 1).trim();
    }

    static class DemFileHeader {
        String dataMark;
        String version;
        Float alpha;
        Integer compress;
        Double x0;
        Double y0;
        Double dx;
        Double dy;
        Integer rows;
        Integer cols;
        String valueType;
        Integer hzoom;
        String xyUnit;
        String zUnit;
        int dataLineNumber;

        DemFileHeader() {
        }
    }
}

